/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.BaseFont;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.layout.pdf.font.FontConfigReader;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManager;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.w3c.dom.css.CSSValueList;

public class FontHandler {
    private static FontMappingManager formatUnrelatedManager;
    private static Map formatRelatedManagers;
    private CSSValueList fontFamilies = null;
    private int fontStyle = 0;
    private float fontSize = 0.0f;
    private BaseFont bf = null;
    private boolean isFontChanged = false;
    private boolean simulation = false;
    private static boolean prepared;
    private static FontConfigReader fontConfigReader;
    private FontMappingManager fontManager = null;
    private static boolean needDefaultConfig;
    private Map fonts = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.layout.pdf.font.FontHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        formatUnrelatedManager = null;
        formatRelatedManagers = new HashMap();
        prepared = false;
        needDefaultConfig = true;
    }

    FontHandler() {
    }

    public FontHandler(ITextContent textContent, boolean fontSubstitution, String format) {
        IStyle style = textContent.getComputedStyle();
        this.fontFamilies = (CSSValueList)style.getProperty(49);
        if ("oblique".equals(style.getFontStyle()) || "italic".equals(style.getFontStyle())) {
            this.fontStyle |= 2;
        }
        if (PropertyUtil.isBoldFont(style.getProperty(27))) {
            this.fontStyle |= 1;
        }
        this.fontSize = (float)PropertyUtil.getDimensionValue(style.getProperty(38)) / 1000.0f;
        this.setFormat(format);
        if (!fontSubstitution) {
            int i = 0;
            while (i < this.fontFamilies.getLength()) {
                String fontName = this.fontManager.getLogicalFont(this.fontFamilies.item(i).getCssText());
                this.bf = this.fontManager.createFont(fontName, this.fontStyle);
                if (this.bf != null) {
                    return;
                }
                ++i;
            }
            this.bf = this.fontManager.createFont("Times-Roman", this.fontStyle);
        }
    }

    private static void registerDirectories() {
        FontFactory.registerDirectory((String)"C:/windows/fonts");
        FontFactory.registerDirectory((String)"d:/windows/fonts");
        FontFactory.registerDirectory((String)"e:/windows/fonts");
        FontFactory.registerDirectory((String)"f:/windows/fonts");
        FontFactory.registerDirectory((String)"g:/windows/fonts");
        FontFactory.registerDirectory((String)"C:/WINNT/fonts");
        FontFactory.registerDirectory((String)"d:/WINNT/fonts");
        FontFactory.registerDirectory((String)"e:/WINNT/fonts");
        FontFactory.registerDirectory((String)"f:/WINNT/fonts");
        FontFactory.registerDirectory((String)"g:/WINNT/fonts");
        FontFactory.registerDirectory((String)"/usr/X/lib/X11/fonts/TrueType");
        FontFactory.registerDirectory((String)"/usr/share/fonts/default/TrueType");
        FontFactory.registerDirectory((String)"/usr/openwin/lib/X11/fonts/TrueType");
        FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/euro_fonts/X11/fonts/TrueType");
        FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/iso_8859_2/X11/fonts/TrueType");
        FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/iso_8859_5/X11/fonts/TrueType");
        FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/iso_8859_7/X11/fonts/TrueType");
        FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/iso_8859_8/X11/fonts/TrueType");
        FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/iso_8859_9/X11/fonts/TrueType");
        FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/iso_8859_13/X11/fonts/TrueType");
        FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/iso_8859_15/X11/fonts/TrueType");
        FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/ar/X11/fonts/TrueType");
        FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/hi_IN.UTF-8/X11/fonts/TrueType");
        FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/ja/X11/fonts/TT");
        FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/ko/X11/fonts/TrueType");
        FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/ko.UTF-8/X11/fonts/TrueType");
        FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/KOI8-R/X11/fonts/TrueType");
        FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/ru.ansi-1251/X11/fonts/TrueType");
        FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/th_TH/X11/fonts/TrueType");
        FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/zh_TW/X11/fonts/TrueType");
        FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/zh_TW.BIG5/X11/fonts/TT");
        FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/zh_HK.BIG5HK/X11/fonts/TT");
        FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/zh_CN.GB18030/X11/fonts/TrueType");
        FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/zh/X11/fonts/TrueType");
        FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/zh.GBK/X11/fonts/TrueType");
        FontFactory.registerDirectory((String)"/usr/X11R6/lib/X11/fonts/TrueType");
        FontFactory.registerDirectory((String)"/usr/X11R6/lib/X11/fonts/truetype");
        FontFactory.registerDirectory((String)"/usr/X11R6/lib/X11/fonts/tt");
        FontFactory.registerDirectory((String)"/usr/X11R6/lib/X11/fonts/TTF");
        FontFactory.registerDirectory((String)"/usr/X11R6/lib/X11/fonts/OTF");
        FontFactory.registerDirectory((String)"/usr/share/fonts/ja/TrueType");
        FontFactory.registerDirectory((String)"/usr/share/fonts/truetype");
        FontFactory.registerDirectory((String)"/usr/share/fonts/ko/TrueType");
        FontFactory.registerDirectory((String)"/usr/share/fonts/zh_CN/TrueType");
        FontFactory.registerDirectory((String)"/usr/share/fonts/zh_TW/TrueType");
        FontFactory.registerDirectory((String)"/var/lib/defoma/x-ttcidfont-conf.d/dirs/TrueType");
    }

    public static synchronized void prepareFonts() {
        if (prepared) {
            return;
        }
        fontConfigReader = new FontConfigReader();
        fontConfigReader.initialize();
        formatUnrelatedManager = fontConfigReader.getFontMappingManager();
        Set fontPaths = formatUnrelatedManager.getFontPaths();
        if (!fontPaths.isEmpty()) {
            FontHandler.registerPaths(fontPaths);
            needDefaultConfig = false;
        }
        fontConfigReader.reset();
        prepared = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontMappingManager getFontManager(String format) {
        if (format == null) {
            return formatUnrelatedManager;
        }
        FontMappingManager result = null;
        result = (FontMappingManager)formatRelatedManagers.get(format);
        if (result != null) {
            return result;
        }
        Map map = formatRelatedManagers;
        synchronized (map) {
            result = (FontMappingManager)formatRelatedManagers.get(format);
            if (result == null) {
                if (fontConfigReader.parseFormatRelatedConfigFile(format)) {
                    FontMappingManager fontManager = fontConfigReader.getFontMappingManager();
                    result = formatUnrelatedManager.merge(fontManager);
                    this.registerPaths(fontManager);
                } else {
                    result = formatUnrelatedManager;
                }
                formatRelatedManagers.put(format, result);
                fontConfigReader.reset();
            }
        }
        return result;
    }

    public FontInfo getFontInfo() {
        this.checkFontAvailability();
        return new FontInfo(this.bf, this.fontSize, this.fontStyle, this.simulation);
    }

    private void setFormat(String format) {
        this.fontManager = format != null ? this.getFontManager(format.toLowerCase()) : null;
    }

    public boolean selectFont(char character) {
        if (!$assertionsDisabled && this.fontManager == null) {
            throw new AssertionError();
        }
        BaseFont candidateFont = this.getMappedFont(character);
        if (!$assertionsDisabled && candidateFont == null) {
            throw new AssertionError();
        }
        this.checkFontStatus(candidateFont);
        return candidateFont.charExists(character);
    }

    public BaseFont getMappedFont(char c) {
        return this.getMappedFont(c, this.fontManager, this.fontFamilies, this.fontStyle);
    }

    BaseFont getMappedFont(char c, FontMappingManager fontManager, CSSValueList fontFamilies, int fontStyle) {
        int i = 0;
        while (i < fontFamilies.getLength()) {
            String fontFamilyName = fontFamilies.item(i).getCssText();
            String logicalFont = fontManager.getLogicalFont(fontFamilyName);
            String physicalFont = fontManager.getPhysicalFont(c, logicalFont, logicalFont);
            BaseFont font = this.getPhysicalFont(fontManager, physicalFont, fontStyle);
            if (this.isCharDefinedInFont(c, font)) {
                return font;
            }
            ++i;
        }
        String physicalFont = fontManager.getDefaultPhysicalFont(c);
        BaseFont defaultFont = this.getPhysicalFont(fontManager, physicalFont, fontStyle);
        if (defaultFont == null) {
            defaultFont = fontManager.createFont("Times-Roman", fontStyle);
        }
        return defaultFont;
    }

    private BaseFont getPhysicalFont(FontMappingManager fontManager, String physicalFont, int fontStyle) {
        BaseFont font = (BaseFont)this.fonts.get(physicalFont);
        if (font == null && (font = fontManager.createFont(physicalFont, fontStyle)) != null) {
            this.fonts.put(physicalFont, font);
        }
        return font;
    }

    private boolean isCharDefinedInFont(char c, BaseFont bf) {
        return bf != null && bf.charExists(c);
    }

    private void registerPaths(FontMappingManager fontManager) {
        Set fontPaths = fontManager.getFontPaths();
        if (fontPaths.isEmpty()) {
            if (needDefaultConfig) {
                FontHandler.registerDirectories();
                needDefaultConfig = false;
            }
        } else {
            FontHandler.registerPaths(fontPaths);
        }
    }

    private static void registerPaths(Set fontPaths) {
        Iterator i = fontPaths.iterator();
        while (i.hasNext()) {
            String fontPath = (String)i.next();
            File file = new File(fontPath);
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                FontFactory.registerDirectory((String)fontPath);
                continue;
            }
            FontFactory.register((String)fontPath);
        }
    }

    private void checkFontStatus(BaseFont candidateFont) {
        if (!$assertionsDisabled && candidateFont == null) {
            throw new AssertionError();
        }
        if (this.bf == candidateFont) {
            this.isFontChanged = false;
        } else {
            this.isFontChanged = true;
            this.bf = candidateFont;
        }
    }

    public boolean isFontChanged() {
        return this.isFontChanged;
    }

    private String getEnglishName(String[][] names) {
        String tmp = null;
        int i = 0;
        while (i < names.length) {
            if ("0".equals(names[i][2])) {
                return names[i][3];
            }
            if ("1033".equals(names[i][2])) {
                tmp = names[i][3];
            }
            if ("".equals(names[i][2])) {
                tmp = names[i][3];
            }
            ++i;
        }
        return tmp;
    }

    private void checkFontAvailability() {
        this.simulation = this.fontStyle == 0 ? false : this.getEnglishName(this.bf.getFamilyFontName()).equals(this.getEnglishName(this.bf.getFullFontName()));
    }
}

