/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.tidy.Tidy;

public class HTMLTextParser {
    protected static Logger logger;
    protected static HashSet supportedTags;
    protected Tidy tidy = new Tidy();
    protected static Properties props;
    private static Pattern hn;
    private boolean supportAllTags = true;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.parser.HTMLTextParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.report.engine.parser.HTMLTextParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
        supportedTags = new HashSet();
        supportedTags.add("a");
        supportedTags.add("b");
        supportedTags.add("br");
        supportedTags.add("center");
        supportedTags.add("code");
        supportedTags.add("dd");
        supportedTags.add("del");
        supportedTags.add("div");
        supportedTags.add("dl");
        supportedTags.add("dt");
        supportedTags.add("font");
        supportedTags.add("em");
        supportedTags.add("hr");
        supportedTags.add("i");
        supportedTags.add("img");
        supportedTags.add("ins");
        supportedTags.add("li");
        supportedTags.add("ol");
        supportedTags.add("pre");
        supportedTags.add("p");
        supportedTags.add("span");
        supportedTags.add("strong");
        supportedTags.add("sub");
        supportedTags.add("sup");
        supportedTags.add("ul");
        supportedTags.add("tt");
        supportedTags.add("u");
        props = new Properties();
        try {
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("org.eclipse.birt.report.engine.parser.HTMLTextParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            props.load(clazz3.getResourceAsStream("htmlparser.properties"));
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        hn = Pattern.compile("h[\\d]");
    }

    public HTMLTextParser() {
        this.tidy.setConfigurationFromProps(props);
        this.supportAllTags = true;
    }

    public Document parseHTML(InputStream in) {
        if (!$assertionsDisabled && in == null) {
            throw new AssertionError();
        }
        Document doc = this.tidy.parseDOM(in, null);
        try {
            Document desDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element desBody = desDoc.createElement("body");
            desDoc.appendChild(desBody);
            Node html = this.getNodeByName(doc, "html");
            if (html != null) {
                Node body;
                Node head = this.getNodeByName(html, "head");
                if (head != null) {
                    Node child = head.getFirstChild();
                    while (child != null) {
                        if (child.getNodeType() == 1 && "script".equalsIgnoreCase(child.getNodeName())) {
                            Element ele = null;
                            ele = desBody.getOwnerDocument().createElement(child.getNodeName());
                            int i = 0;
                            while (i < child.getAttributes().getLength()) {
                                Node attr = child.getAttributes().item(i);
                                ele.setAttribute(attr.getNodeName(), attr.getNodeValue());
                                ++i;
                            }
                            desBody.appendChild(ele);
                            this.copyNode(child, ele);
                        }
                        child = child.getNextSibling();
                    }
                }
                if ((body = this.getNodeByName(html, "body")) != null) {
                    this.copyNode(body, desBody);
                }
            }
            return desDoc;
        }
        catch (ParserConfigurationException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    private Node getNodeByName(Node parent, String childName) {
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1 && childName.equals(child.getNodeName())) {
                return child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    private void copyNode(Node srcNode, Node desNode) {
        if (!($assertionsDisabled || srcNode != null && desNode != null)) {
            throw new AssertionError();
        }
        Node child = srcNode.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 3 || child.getNodeType() == 4) {
                Text txtNode = desNode.getOwnerDocument().createTextNode(child.getNodeValue());
                desNode.appendChild(txtNode);
            } else if (child.getNodeType() == 1) {
                boolean bSupported = true;
                if (!(this.supportAllTags || supportedTags.contains(child.getNodeName()) || hn.matcher(child.getNodeName()).matches())) {
                    bSupported = false;
                }
                if (bSupported) {
                    Element ele = null;
                    ele = desNode.getOwnerDocument().createElement(child.getNodeName());
                    int i = 0;
                    while (i < child.getAttributes().getLength()) {
                        Node attr = child.getAttributes().item(i);
                        ele.setAttribute(attr.getNodeName(), attr.getNodeValue());
                        ++i;
                    }
                    desNode.appendChild(ele);
                    this.copyNode(child, ele);
                } else {
                    this.copyNode(child, desNode);
                }
            }
            child = child.getNextSibling();
        }
    }
}

