/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Stack;
import org.eclipse.birt.report.model.api.CSSLengthValueHandler;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.FactoryPropertyHandle;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.DimensionUtil;

final class FontSizeValueHandler
extends CSSLengthValueHandler {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.api.FontSizeValueHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    FontSizeValueHandler(DimensionHandle dimensionHandle) {
        super(dimensionHandle);
    }

    DimensionValue convertFontSizeConstant(String fontSizeConstant) {
        if (DimensionUtil.isAbsoluteFontSize(fontSizeConstant)) {
            return this.provider.getValueOf(fontSizeConstant);
        }
        if (DimensionUtil.isRelativeFontSize(fontSizeConstant)) {
            return this.getAbsoluteFontSizeValue();
        }
        return null;
    }

    private DimensionValue getAbsoluteFontSizeValue() {
        Stack<Object> stack = new Stack<Object>();
        boolean absoluteConstantFound = false;
        DesignElementHandle e = this.dimensionHandle.getElementHandle();
        while (e != null) {
            DimensionHandle fontSizeHandle = e.getDimensionProperty("fontSize");
            if (fontSizeHandle == null) break;
            Object value = fontSizeHandle.getValue();
            if (value instanceof DimensionValue) {
                return (DimensionValue)value;
            }
            String fontSizeConstant = (String)value;
            stack.push(fontSizeConstant);
            if (DimensionUtil.isAbsoluteFontSize(fontSizeConstant)) {
                absoluteConstantFound = true;
                break;
            }
            e = e.getContainer();
        }
        if (!absoluteConstantFound) {
            Object defaultValue = this.dimensionHandle.getDefn().getDefault();
            if (defaultValue instanceof DimensionValue) {
                return (DimensionValue)defaultValue;
            }
            stack.push(defaultValue);
        }
        if (!$assertionsDisabled && stack.isEmpty()) {
            throw new AssertionError();
        }
        String absoluteFontSizeConstant = (String)stack.pop();
        while (!stack.isEmpty()) {
            String constant = (String)stack.pop();
            absoluteFontSizeConstant = this.convertRelativeConstantToAbsolute(constant, absoluteFontSizeConstant);
        }
        return this.provider.getValueOf(absoluteFontSizeConstant);
    }

    private String convertRelativeConstantToAbsolute(String relativeConstant, String baseConstant) {
        int i = 0;
        while (i < ABSOLUTE_FONT_SIZE_CONSTANTS.length) {
            if (ABSOLUTE_FONT_SIZE_CONSTANTS[i].equals(baseConstant)) {
                if ("larger".equals(relativeConstant)) {
                    if (i == ABSOLUTE_FONT_SIZE_CONSTANTS.length - 1) {
                        return ABSOLUTE_FONT_SIZE_CONSTANTS[i];
                    }
                    return ABSOLUTE_FONT_SIZE_CONSTANTS[i + 1];
                }
                if ("smaller".equals(relativeConstant)) {
                    if (i == 0) {
                        return ABSOLUTE_FONT_SIZE_CONSTANTS[i];
                    }
                    return ABSOLUTE_FONT_SIZE_CONSTANTS[i - 1];
                }
            }
            ++i;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    DimensionValue getAbsoluteValueForFontSize(DimensionValue relativeDimensionValue) {
        DimensionValue absoluteDimensionValue;
        if (!$assertionsDisabled && relativeDimensionValue != null && CSSLengthValueHandler.isAbsoluteUnit(relativeDimensionValue.getUnits())) {
            throw new AssertionError();
        }
        FactoryPropertyHandle fontSizeFactoryHandle = this.dimensionHandle.getElementHandle().getFactoryPropertyHandle(this.dimensionHandle.getPropertyDefn().getName());
        DesignElementHandle containerHandle = this.dimensionHandle.getElementHandle().getContainer();
        DimensionHandle dimensionHandleFromContainer = containerHandle.getDimensionProperty(this.dimensionHandle.getPropertyDefn().getName());
        DimensionValue absoluteValueFromContainer = null;
        if (dimensionHandleFromContainer != null) {
            absoluteValueFromContainer = dimensionHandleFromContainer.getAbsoluteValue();
            if (!$assertionsDisabled && absoluteValueFromContainer == null) {
                throw new AssertionError();
            }
        } else {
            absoluteValueFromContainer = this.getDefaultFontSizeValue();
        }
        DimensionValue dimensionValue = absoluteDimensionValue = fontSizeFactoryHandle == null ? absoluteValueFromContainer : this.computeRelativeValue(absoluteValueFromContainer, relativeDimensionValue);
        if (!$assertionsDisabled && !FontSizeValueHandler.isAbsoluteUnit(absoluteDimensionValue.getUnits())) {
            throw new AssertionError();
        }
        return absoluteDimensionValue;
    }
}

