/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.structures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.util.DataTypeConversionUtil;

public class DataSetParameter
extends Structure {
    public static final String STRUCT_NAME = "DataSetParam";
    public static final String POSITION_MEMBER = "position";
    public static final String NAME_MEMBER = "name";
    public static final String DATA_TYPE_MEMBER = "dataType";
    public static final String IS_OPTIONAL_MEMBER = "isOptional";
    public static final String DEFAULT_VALUE_MEMBER = "defaultValue";
    public static final String IS_NULLABLE_MEMBER = "isNullable";
    public static final String ALLOW_NULL_MEMBER = "allowNull";
    public static final String IS_INPUT_MEMBER = "isInput";
    public static final String IS_OUTPUT_MEMBER = "isOutput";
    public static final String NATIVE_DATA_TYPE_MEMBER = "nativeDataType";
    private Integer position = null;
    private String name = null;
    private String dataType = null;
    private Boolean isOptional;
    private Boolean allowNull;
    private Boolean isInput;
    private Boolean isOutput;
    private String defaultValue;
    private Integer nativeDataType;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.api.elements.structures.DataSetParameter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public String getStructName() {
        return STRUCT_NAME;
    }

    protected Object getIntrinsicProperty(String propName) {
        if (POSITION_MEMBER.equals(propName)) {
            return this.position;
        }
        if (NAME_MEMBER.equals(propName)) {
            return this.name;
        }
        if (DATA_TYPE_MEMBER.equals(propName)) {
            return this.dataType;
        }
        if (IS_OPTIONAL_MEMBER.equals(propName)) {
            return this.isOptional;
        }
        if (DEFAULT_VALUE_MEMBER.equals(propName)) {
            return this.defaultValue;
        }
        if (IS_NULLABLE_MEMBER.equals(propName) || ALLOW_NULL_MEMBER.equals(propName)) {
            return this.allowNull;
        }
        if (IS_INPUT_MEMBER.equals(propName)) {
            return this.isInput;
        }
        if (IS_OUTPUT_MEMBER.equals(propName)) {
            return this.isOutput;
        }
        if (NATIVE_DATA_TYPE_MEMBER.equals(propName)) {
            return this.nativeDataType;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    protected void setIntrinsicProperty(String propName, Object value) {
        if (POSITION_MEMBER.equals(propName)) {
            this.position = (Integer)value;
        } else if (NAME_MEMBER.equals(propName)) {
            this.name = (String)value;
        } else if (DATA_TYPE_MEMBER.equals(propName)) {
            this.dataType = (String)value;
        } else if (IS_OPTIONAL_MEMBER.equals(propName)) {
            this.isOptional = (Boolean)value;
        } else if (DEFAULT_VALUE_MEMBER.equals(propName)) {
            this.defaultValue = (String)value;
        } else if (IS_NULLABLE_MEMBER.equals(propName) || ALLOW_NULL_MEMBER.equals(propName)) {
            this.allowNull = (Boolean)value;
        } else if (IS_INPUT_MEMBER.equals(propName)) {
            this.isInput = (Boolean)value;
        } else if (IS_OUTPUT_MEMBER.equals(propName)) {
            this.isOutput = (Boolean)value;
        } else if (NATIVE_DATA_TYPE_MEMBER.equals(propName)) {
            this.nativeDataType = (Integer)value;
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public boolean isOptional() {
        return (Boolean)this.getProperty(null, IS_OPTIONAL_MEMBER);
    }

    public void setIsOptional(boolean value) {
        this.setProperty(IS_OPTIONAL_MEMBER, (Object)value);
    }

    public void setDefaultValue(String expr) {
        this.setProperty(DEFAULT_VALUE_MEMBER, (Object)expr);
    }

    public String getDefaultValue() {
        return (String)this.getProperty(null, DEFAULT_VALUE_MEMBER);
    }

    public boolean isInput() {
        return (Boolean)this.getProperty(null, IS_INPUT_MEMBER);
    }

    public void setIsInput(boolean isInput) {
        this.setProperty(IS_INPUT_MEMBER, (Object)isInput);
    }

    public boolean isNullable() {
        return this.allowNull();
    }

    public void setIsNullable(boolean isNullable) {
        this.setAllowNull(isNullable);
    }

    public boolean allowNull() {
        return (Boolean)this.getProperty(null, ALLOW_NULL_MEMBER);
    }

    public void setAllowNull(boolean allowNull) {
        this.setProperty(ALLOW_NULL_MEMBER, (Object)allowNull);
    }

    public boolean isOutput() {
        return (Boolean)this.getProperty(null, IS_OUTPUT_MEMBER);
    }

    public void setIsOutput(boolean isOutput) {
        this.setProperty(IS_OUTPUT_MEMBER, (Object)isOutput);
    }

    public String getDataType() {
        String paramType = (String)this.getProperty(null, DATA_TYPE_MEMBER);
        return DataTypeConversionUtil.converToColumnDataType(paramType);
    }

    public void setDataType(String dataType) {
        String paramType = DataTypeConversionUtil.converToParamType(dataType);
        this.setProperty(DATA_TYPE_MEMBER, (Object)paramType);
    }

    public String getName() {
        return (String)this.getProperty(null, NAME_MEMBER);
    }

    public void setName(String name) {
        this.setProperty(NAME_MEMBER, (Object)name);
    }

    public Integer getPosition() {
        return (Integer)this.getProperty(null, POSITION_MEMBER);
    }

    public void setPosition(Integer position) {
        this.setProperty(POSITION_MEMBER, (Object)position);
    }

    public StructureHandle handle(SimpleValueHandle valueHandle, int index) {
        return new DataSetParameterHandle(valueHandle, index);
    }

    public List validate(Module module, DesignElement element) {
        ArrayList<PropertyValueException> list = new ArrayList<PropertyValueException>();
        if (StringUtil.isBlank(this.getName())) {
            list.add(new PropertyValueException(element, this.getDefn().getMember(NAME_MEMBER), (Object)this.getName(), "Error.PropertyValueException.VALUE_REQUIRED"));
        }
        return list;
    }

    public Integer getNativeDataType() {
        return (Integer)this.getProperty(null, NATIVE_DATA_TYPE_MEMBER);
    }

    public void setNativeDataType(Integer dataType) {
        this.setProperty(NATIVE_DATA_TYPE_MEMBER, (Object)dataType);
    }

    public String getParameterDataType() {
        return (String)this.getProperty(null, DATA_TYPE_MEMBER);
    }

    public void setParameterDataType(String dataType) {
        this.setProperty(DATA_TYPE_MEMBER, (Object)dataType);
    }
}

