/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.birt.report.model.util.ModelUtil;

public class URIUtil {
    public static final String FILE_SCHEMA = "file";
    public static final String JAR_SCHEMA = "jar";
    public static final String HTTP_SCHEMA = "http";
    public static final String FTP_SCHEMA = "ftp";
    public static final String BUNDLE_RESOURCE_SCHEMA = "bundle";
    public static final String JAR_EXTENTION = ".jar";
    private static final String URL_SEPARATOR = "/";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.api.util.URIUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static String getLocalPath(String uri) {
        if (uri == null) {
            return null;
        }
        URI objURI = null;
        try {
            objURI = new URI(uri);
        }
        catch (URISyntaxException uRISyntaxException) {
            return URIUtil.getLocalFileOfFailedURI(uri);
        }
        if (objURI.getScheme() == null) {
            if (URIUtil.isFileProtocol(uri)) {
                return uri;
            }
        } else {
            if (objURI.getScheme().equalsIgnoreCase(FILE_SCHEMA)) {
                return objURI.getSchemeSpecificPart();
            }
            if (objURI.getScheme().length() == 1 || objURI.getScheme().equalsIgnoreCase(JAR_SCHEMA)) {
                return uri;
            }
        }
        return null;
    }

    private static boolean isFileProtocol(String filePath) {
        try {
            URL fileUrl = new URL(filePath);
            return FILE_SCHEMA.equalsIgnoreCase(fileUrl.getProtocol());
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(filePath);
            return file.toURI().getScheme().equalsIgnoreCase(FILE_SCHEMA);
        }
    }

    private static String getLocalFileOfFailedURI(String uri) {
        URL objURI = null;
        try {
            objURI = new URL(uri);
            if (objURI.getProtocol().equalsIgnoreCase(FILE_SCHEMA)) {
                return objURI.getAuthority() == null ? objURI.getPath() : String.valueOf(objURI.getAuthority()) + objURI.getPath();
            }
            if (objURI.getProtocol().equalsIgnoreCase(JAR_SCHEMA)) {
                return uri;
            }
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(uri);
            if (uri.indexOf(JAR_EXTENTION) > -1) {
                return "jar:file:" + file.getAbsolutePath();
            }
            if (uri.startsWith(FILE_SCHEMA)) {
                return file.toURI().getSchemeSpecificPart();
            }
            return uri;
        }
    }

    public static String convertFileNameToURLString(String filePath) {
        StringBuffer buffer = new StringBuffer();
        String path = filePath;
        path = ModelUtil.toUniversalFileFormat(path);
        int i = 0;
        while (i < path.length()) {
            char c = path.charAt(i);
            if (c < '\u001f' || c == '\u007f') {
                buffer.append("%" + Character.toString(c));
            } else if (c == '#') {
                buffer.append("%23");
            } else if (c == '%') {
                buffer.append("%25");
            } else if (c == '<') {
                buffer.append("%3C");
            } else if (c == '>') {
                buffer.append("%3E");
            } else if (c == '\"') {
                buffer.append("%22");
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static URL getDirectory(String filePath) {
        if (filePath == null) {
            return null;
        }
        URL url = null;
        try {
            url = new URL(URIUtil.convertFileNameToURLString(filePath));
        }
        catch (MalformedURLException malformedURLException) {
            url = filePath.indexOf(JAR_EXTENTION) > -1 ? URIUtil.getJarDirectory(filePath) : URIUtil.getFileDirectory(filePath);
            return url;
        }
        if (FILE_SCHEMA.equalsIgnoreCase(url.getProtocol())) {
            return URIUtil.getFileDirectory(url.getPath());
        }
        if (JAR_SCHEMA.equalsIgnoreCase(url.getProtocol()) && !url.getPath().toLowerCase().startsWith(HTTP_SCHEMA)) {
            return URIUtil.getJarDirectory(url.getPath());
        }
        return URIUtil.getNetDirectory(url);
    }

    private static URL getNetDirectory(URL filePath) {
        if (!$assertionsDisabled && filePath == null) {
            throw new AssertionError();
        }
        String path = filePath.getFile();
        int index = path.lastIndexOf(47);
        if (index != -1 && index != path.length() - 1) {
            path = path.substring(0, index + 1);
        }
        try {
            return new URL(filePath.getProtocol(), filePath.getHost(), filePath.getPort(), path);
        }
        catch (MalformedURLException malformedURLException) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    private static URL getFileDirectory(String filePath) {
        File file = new File(filePath);
        file = file.getAbsoluteFile();
        if ((file = file.getParentFile()) == null) {
            return null;
        }
        try {
            return file.getCanonicalFile().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    private static URL getJarDirectory(String filePath) {
        block4: {
            URL url;
            if (filePath.startsWith(FILE_SCHEMA)) {
                filePath = filePath.substring(5);
            }
            if ((url = URIUtil.getFileDirectory(filePath)) != null) {
                try {
                    return new URL("jar:file:" + url.getPath() + '/');
                }
                catch (MalformedURLException malformedURLException) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError();
                }
            }
        }
        return null;
    }

    public static String getRelativePath(String base, String resource) {
        if (base == null || resource == null) {
            return resource;
        }
        if (URIUtil.isFileProtocol(resource) && URIUtil.isFileProtocol(base)) {
            return URIUtil.createRelativePathFromFilePath(base, resource);
        }
        return URIUtil.createRelativePathFromString(base, resource, URL_SEPARATOR);
    }

    private static String createRelativePathFromFilePath(String base, String resource) {
        String baseDir = URIUtil.getLocalPath(base);
        String resourceDir = URIUtil.getLocalPath(resource);
        if (baseDir == null || resourceDir == null) {
            return resource;
        }
        File baseFile = new File(baseDir);
        File resourceFile = new File(resourceDir);
        baseDir = baseFile.getAbsolutePath();
        resourceDir = resourceFile.getAbsolutePath();
        return URIUtil.createRelativePathFromString(baseDir, resourceDir, File.separator);
    }

    private static String createRelativePathFromString(String baseDir, String resourceDir, String separator) {
        char lastChar;
        int len;
        String newBaseDir = baseDir;
        if (newBaseDir.endsWith(URL_SEPARATOR) || newBaseDir.endsWith(separator)) {
            newBaseDir = newBaseDir.substring(0, newBaseDir.length() - 1);
        }
        int matchedPos = 0;
        matchedPos = 0;
        while (matchedPos < newBaseDir.length() && matchedPos < resourceDir.length()) {
            if (newBaseDir.charAt(matchedPos) != resourceDir.charAt(matchedPos)) break;
            ++matchedPos;
        }
        if (!URIUtil.isLastDirectoryMatched(newBaseDir, resourceDir, matchedPos) && !URIUtil.isLastDirectoryMatched(resourceDir, newBaseDir, matchedPos)) {
            int oldMatchedPos = matchedPos;
            matchedPos = newBaseDir.lastIndexOf(separator, oldMatchedPos);
        }
        int samePrefixPos = matchedPos;
        int upDirs = 0;
        while (matchedPos < newBaseDir.length() && matchedPos >= 0) {
            matchedPos = newBaseDir.indexOf(separator, matchedPos + 1);
            ++upDirs;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < upDirs) {
            sb.append("../");
            ++i;
        }
        if (samePrefixPos < resourceDir.length()) {
            String remainPath = resourceDir.substring(samePrefixPos + 1);
            remainPath = remainPath.replace('\\', '/');
            sb.append(remainPath);
        }
        if ((len = sb.length()) > 0 && (lastChar = sb.charAt(len - 1)) == '/') {
            sb.deleteCharAt(len - 1);
        }
        return sb.toString();
    }

    public static String resolveAbsolutePath(String base, String relativePath) {
        if (base == null || relativePath == null) {
            return relativePath;
        }
        if (URIUtil.isFileProtocol(base) && URIUtil.isFileProtocol(relativePath)) {
            return URIUtil.resolveAbsolutePathFromFilePath(base, relativePath);
        }
        return URIUtil.resolveAbsolutePathFromString(base, relativePath);
    }

    private static String resolveAbsolutePathFromFilePath(String base, String relativePath) {
        File file = new File(relativePath);
        if (file.isAbsolute()) {
            return relativePath;
        }
        String baseDir = URIUtil.getLocalPath(base);
        String relativeDir = URIUtil.getLocalPath(relativePath);
        if (baseDir == null || relativeDir == null) {
            return relativePath;
        }
        File baseFile = new File(baseDir);
        File resourceFile = new File(baseFile, relativeDir);
        return resourceFile.getPath();
    }

    private static String resolveAbsolutePathFromString(String base, String relativePath) {
        if (base == null || relativePath == null) {
            return relativePath;
        }
        boolean appendDirectorySeparator = false;
        if (base.length() > 0 && relativePath.length() > 0) {
            char lastBaseChar = base.charAt(base.length() - 1);
            char firstRelativeChar = relativePath.charAt(0);
            if (lastBaseChar != '/' && lastBaseChar != File.separatorChar && firstRelativeChar != '/' && firstRelativeChar != File.separatorChar) {
                appendDirectorySeparator = true;
            }
        }
        if (appendDirectorySeparator) {
            return String.valueOf(base) + '/' + relativePath;
        }
        return String.valueOf(base) + relativePath;
    }

    private static boolean isLastDirectoryMatched(String baseDir, String resourceDir, int matchedPos) {
        return matchedPos == baseDir.length() && (matchedPos < resourceDir.length() && (resourceDir.charAt(matchedPos) == File.separatorChar || resourceDir.charAt(matchedPos) == '/') || matchedPos == resourceDir.length());
    }

    public static boolean isValidResourcePath(String resourceDir) {
        if (resourceDir == null) {
            return false;
        }
        File f = new File(resourceDir);
        return f.isAbsolute() && f.exists() && f.isDirectory();
    }
}

