/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ElementLocalizeEvent;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.ModelUtil;

public class ElementLocalizeRecord
extends SimpleRecord {
    private Module module = null;
    private DesignElement element = null;
    private DesignElement parent = null;
    private long baseId;
    private Map propValues = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.command.ElementLocalizeRecord");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ElementLocalizeRecord(Module module, DesignElement virtualChild, DesignElement virtualParent) {
        if (!$assertionsDisabled && !virtualChild.isVirtualElement()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && virtualChild.getBaseId() != virtualParent.getID()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && virtualChild.getDefn() != virtualParent.getDefn()) {
            throw new AssertionError();
        }
        this.module = module;
        this.element = virtualChild;
        this.parent = virtualParent;
        this.baseId = virtualChild.getBaseId();
        this.collectOverriddenProperties();
    }

    private void collectOverriddenProperties() {
        if (!$assertionsDisabled && this.element == null) {
            throw new AssertionError();
        }
        Iterator iter = this.element.getPropertyDefns().iterator();
        while (iter.hasNext()) {
            Object value;
            PropertyDefn propDefn = (PropertyDefn)iter.next();
            if ("extends".equals(propDefn.getName()) || (value = this.element.getLocalProperty(this.module, propDefn.getName())) == null) continue;
            this.propValues.put(propDefn.getName(), value);
        }
    }

    private void localizeElement(DesignElement from, DesignElement to) {
        Iterator iter = from.getDefn().getProperties().iterator();
        while (iter.hasNext()) {
            ElementPropertyDefn propDefn = (ElementPropertyDefn)iter.next();
            String propName = propDefn.getName();
            if (!propDefn.canInherit() || "style".equals(propName) || "extends".equals(propName) || "userProperties".equals(propName)) continue;
            Object localValue = to.getLocalProperty(this.module, propDefn);
            Object parentValue = from.getStrategy().getPropertyFromElement(this.module, from, propDefn);
            if (localValue != null || parentValue == null) continue;
            Object valueToSet = ModelUtil.copyValue(propDefn, parentValue);
            to.setProperty(propDefn, valueToSet);
        }
    }

    private void recoverProperties(DesignElement obj) {
        obj.clearAllProperties();
        Iterator propNames = this.propValues.keySet().iterator();
        while (propNames.hasNext()) {
            String propName = (String)propNames.next();
            if (!$assertionsDisabled && "extends".equals(propName)) {
                throw new AssertionError();
            }
            if ("style".equals(propName)) {
                ElementRefValue refValue = (ElementRefValue)this.propValues.get(propName);
                if (refValue == null) continue;
                if (refValue.isResolved()) {
                    ((StyledElement)obj).setStyle((Style)refValue.getElement());
                    continue;
                }
                ((StyledElement)obj).setStyleName(refValue.getName());
                continue;
            }
            obj.setProperty(propName, this.propValues.get(propName));
        }
    }

    protected void perform(boolean undo) {
        if (undo) {
            this.recoverProperties(this.element);
            this.element.setBaseId(this.baseId);
        } else {
            this.localizeElement(this.parent, this.element);
            this.element.setBaseId(-1L);
        }
    }

    public DesignElement getTarget() {
        return this.element;
    }

    public NotificationEvent getEvent() {
        return new ElementLocalizeEvent(this.element);
    }
}

