/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.event;

import java.util.Collections;
import java.util.List;
import org.eclipse.birt.chart.event.IRenderInstruction;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.WrappedInstruction;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.render.DeferredCache;

public class MarkerInstruction
implements IRenderInstruction {
    private final DeferredCache dc;
    private final int iInstruction;
    private final double iMarkerSize;
    private final PrimitiveRenderEvent pre;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.chart.event.MarkerInstruction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public MarkerInstruction(DeferredCache dc, PrimitiveRenderEvent pre, int iInstruction, double iMarkerSize) {
        this.dc = dc;
        this.pre = pre;
        this.iInstruction = iInstruction;
        this.iMarkerSize = iMarkerSize;
    }

    public int compareTo(Object o) {
        if (o instanceof MarkerInstruction) {
            return (int)(((MarkerInstruction)o).getMarkerSize() - this.iMarkerSize);
        }
        Bounds bo = null;
        if (o instanceof PrimitiveRenderEvent) {
            try {
                bo = ((PrimitiveRenderEvent)o).getBounds();
            }
            catch (ChartException chartException) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return -1;
            }
        } else if (o instanceof WrappedInstruction) {
            bo = ((WrappedInstruction)o).getBounds();
        }
        return this.dc != null && this.dc.isTransposed() ? PrimitiveRenderEvent.compareTransposed(this.getBounds(), bo) : PrimitiveRenderEvent.compareRegular(this.getBounds(), bo);
    }

    public final PrimitiveRenderEvent getEvent() {
        return this.pre;
    }

    public final int getInstruction() {
        return this.iInstruction;
    }

    public final double getMarkerSize() {
        return this.iMarkerSize;
    }

    public final Bounds getBounds() {
        try {
            return this.pre.getBounds();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public List getModel() {
        return Collections.EMPTY_LIST;
    }

    public boolean isModel() {
        return false;
    }
}

