/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.LegendEntryRenderingHints;
import org.eclipse.birt.chart.computation.LegendItemHints;
import org.eclipse.birt.chart.computation.LegendItemRenderingHints;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.withaxes.PlotWithAxes;
import org.eclipse.birt.chart.computation.withoutaxes.Coordinates;
import org.eclipse.birt.chart.computation.withoutaxes.PlotWithoutAxes;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.event.BlockGenerationEvent;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.InteractionEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.Polygon3DRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.RectangleRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.StructureType;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.event.WrappedInstruction;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.DialChart;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.HorizontalAlignment;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Location3D;
import org.eclipse.birt.chart.model.attribute.MultipleFill;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.Size;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.attribute.VerticalAlignment;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.attribute.impl.SeriesValueImpl;
import org.eclipse.birt.chart.model.attribute.impl.SizeImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextAlignmentImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextImpl;
import org.eclipse.birt.chart.model.attribute.impl.URLValueImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.ActionImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.ClientArea;
import org.eclipse.birt.chart.model.layout.LabelBlock;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.layout.TitleBlock;
import org.eclipse.birt.chart.render.AxesRenderer;
import org.eclipse.birt.chart.render.DeferredCache;
import org.eclipse.birt.chart.render.DeferredCacheManager;
import org.eclipse.birt.chart.render.EmptyWithAxes;
import org.eclipse.birt.chart.render.EmptyWithoutAxes;
import org.eclipse.birt.chart.render.IActionRenderer;
import org.eclipse.birt.chart.render.ISeriesRenderer;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.emf.common.util.EList;

public abstract class BaseRenderer
implements ISeriesRenderer {
    protected static final String STACKED_SERIES_LOCATION_KEY = "stacked_series_location_key";
    protected static final String FIXED_STACKED_SERIES_LOCATION_KEY = "fixed_stacked_series_location_key";
    protected static final String FIXED_STACKED_SERIES_INDEX_KEY = "fixed_stacked_series_index_key";
    protected static final String STACKED_SERIES_SIZE_KEY = "stacked_series_size_key";
    protected static final String TIMER = "T";
    protected ISeriesRenderingHints srh;
    protected IDisplayServer xs;
    protected IDeviceRenderer ir;
    protected DeferredCache dc;
    protected Chart cm;
    protected Object oComputations;
    protected Series se;
    protected SeriesDefinition sd;
    protected BaseRenderer[] brna;
    protected transient int iSeriesIndex = -1;
    protected transient int iSeriesCount = 1;
    public static final ColorDefinition SHADOW = ColorDefinitionImpl.create(64, 64, 64, 127);
    protected static final ColorDefinition DARK_GLASS = ColorDefinitionImpl.create(64, 64, 64, 127);
    protected static final ColorDefinition LIGHT_GLASS = ColorDefinitionImpl.create(196, 196, 196, 127);
    protected static double OVERRIDE_TRANSPARENCY = 50.0;
    protected transient RunTimeContext rtc = null;
    protected DeferredCacheManager fDeferredCacheManager;
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/render");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public void set(Chart _cm, Object _oComputation, Series _se, SeriesDefinition _sd) {
        this.cm = _cm;
        this.oComputations = _oComputation;
        this.se = _se;
        this.sd = _sd;
    }

    public final void set(DeferredCache _dc) {
        this.dc = _dc;
    }

    public final void set(IDeviceRenderer _ir) {
        this.ir = _ir;
    }

    public final void set(IDisplayServer _xs) {
        this.xs = _xs;
    }

    public final void set(ISeriesRenderingHints _srh) {
        this.srh = _srh;
    }

    public final void set(BaseRenderer[] _brna) {
        this.brna = _brna;
    }

    public final void set(RunTimeContext _rtc) {
        this.rtc = _rtc;
    }

    public final ISeriesRenderingHints getSeriesRenderingHints() {
        return this.srh;
    }

    public final IDisplayServer getXServer() {
        return this.xs;
    }

    public final double getDeviceScale() {
        return (double)this.xs.getDpiResolution() / 72.0;
    }

    public final SeriesDefinition getSeriesDefinition() {
        return this.sd;
    }

    public final int getSeriesIndex() {
        return this.iSeriesIndex;
    }

    public final int getSeriesCount() {
        return this.iSeriesCount;
    }

    public final DeferredCache getDeferredCache() {
        return this.dc;
    }

    public final BaseRenderer getRenderer(int iIndex) {
        return this.brna[iIndex];
    }

    public final RunTimeContext getRunTimeContext() {
        return this.rtc;
    }

    public void render(Map htRenderers, Bounds bo) throws ChartException {
        boolean bFirstInSequence = this.iSeriesIndex == 0;
        boolean bLastInSequence = this.iSeriesIndex == this.iSeriesCount - 1;
        boolean bStarted = bFirstInSequence;
        long lTimer = System.currentTimeMillis();
        Block bl = this.cm.getBlock();
        Enumeration e = bl.children(true);
        BlockGenerationEvent bge = new BlockGenerationEvent(this);
        IDeviceRenderer idr = this.getDevice();
        ScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        if (bFirstInSequence) {
            ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
            bge.updateBlock(bl);
            this.renderChartBlock(idr, bl, StructureSource.createChartBlock(bl));
            ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
        }
        while (e.hasMoreElements()) {
            bl = (Block)e.nextElement();
            bge.updateBlock(bl);
            if (bl instanceof Plot) {
                ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                this.renderPlot(this.ir, (Plot)bl);
                ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                if (bFirstInSequence && !bLastInSequence) break;
                if (bStarted) continue;
                bStarted = true;
                continue;
            }
            if (bl instanceof TitleBlock && bStarted) {
                ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                this.renderTitle(this.ir, (TitleBlock)bl);
                ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                continue;
            }
            if (bl instanceof LabelBlock && bStarted) {
                ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                this.renderLabel(this.ir, bl, StructureSource.createUnknown(bl));
                ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                continue;
            }
            if (bl instanceof Legend && bStarted && bLastInSequence) {
                ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                this.renderLegend(idr, (Legend)bl, htRenderers);
                ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                continue;
            }
            if (!bStarted) continue;
            ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
            this.renderBlock(this.ir, bl, StructureSource.createUnknown(bl));
            ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
        }
        lTimer = System.currentTimeMillis() - lTimer;
        if (htRenderers.containsKey(TIMER)) {
            Long l = (Long)htRenderers.get(TIMER);
            htRenderers.put(TIMER, new Long(l + lTimer));
        } else {
            htRenderers.put(TIMER, new Long(lTimer));
        }
        if (bLastInSequence) {
            try {
                this.fDeferredCacheManager.flushAll();
            }
            catch (ChartException ex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 11, (Throwable)((Object)ex));
            }
            logger.log(1, Messages.getString("info.elapsed.render.time", new Object[]{new Long(lTimer)}, this.rtc.getULocale()));
            htRenderers.remove(TIMER);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void renderLegend(IPrimitiveRenderer ipr, Legend lg, Map htRenderers) throws ChartException {
        if (!lg.isVisible()) {
            return;
        }
        this.renderBlock(ipr, lg, StructureSource.createLegend(lg));
        xs = this.getDevice().getDisplayServer();
        dScale = this.getDeviceScale();
        bo = lg.getBounds().scaledInstance(dScale);
        sz = null;
        if (lg.getPosition() != Position.INSIDE_LITERAL) {
            try {
                sz = lg.getPreferredSize(xs, this.cm, this.rtc);
            }
            catch (Exception ex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 11, ex);
            }
            sz.scale(dScale);
            dX = bo.getLeft() + (bo.getWidth() - sz.getWidth()) / 2.0;
            dY = 0.0;
            if (lg.isSetAnchor()) {
                iAnchor = lg.getAnchor().getValue();
                if (this.isRightToLeft()) {
                    if (iAnchor == 2) {
                        iAnchor = 6;
                    } else if (iAnchor == 1) {
                        iAnchor = 7;
                    } else if (iAnchor == 3) {
                        iAnchor = 5;
                    } else if (iAnchor == 6) {
                        iAnchor = 2;
                    } else if (iAnchor == 7) {
                        iAnchor = 1;
                    } else if (iAnchor == 5) {
                        iAnchor = 3;
                    }
                }
                switch (iAnchor) {
                    case 0: 
                    case 1: 
                    case 7: {
                        dY = bo.getTop();
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        dY = bo.getTop() + bo.getHeight() - sz.getHeight();
                        break;
                    }
                    default: {
                        dY = bo.getTop() + (bo.getHeight() - sz.getHeight()) / 2.0;
                    }
                }
                switch (iAnchor) {
                    case 5: 
                    case 6: 
                    case 7: {
                        dX = bo.getLeft();
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        dX = bo.getLeft() + bo.getWidth() - sz.getWidth();
                        break;
                    }
                    default: {
                        dX = bo.getLeft() + (bo.getWidth() - sz.getWidth()) / 2.0;
                        break;
                    }
                }
            } else {
                dX = bo.getLeft() + (bo.getWidth() - sz.getWidth()) / 2.0;
                dY = bo.getTop() + (bo.getHeight() - sz.getHeight()) / 2.0;
            }
        } else {
            dX = bo.getLeft();
            dY = bo.getTop();
            sz = SizeImpl.create(bo.getWidth(), bo.getHeight());
        }
        lilh = this.rtc.getLegendLayoutHints();
        if (lilh == null) {
            throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.null.legend.layout.hints", Messages.getResourceBundle(this.rtc.getULocale()));
        }
        lgTitle = lg.getTitle();
        lgTitleWidth = 0.0;
        lgTitleHeight = 0.0;
        yOffset = 0.0;
        xOffset = 0.0;
        wOffset = 0.0;
        hOffset = 0.0;
        bRenderLegendTitle = lgTitle != null && lgTitle.isSetVisible() != false && lgTitle.isVisible() != false;
        iTitlePos = 0;
        if (bRenderLegendTitle) {
            lgTitle = LabelImpl.copyInstance(lgTitle);
            sPreviousValue = lgTitle.getCaption().getValue();
            lgTitle.getCaption().setValue(this.rtc.externalizedMessage(sPreviousValue));
            titleSize = lilh.getTitleSize();
            lgTitleWidth = titleSize.getWidth();
            lgTitleHeight = titleSize.getHeight();
            iTitlePos = lg.getTitlePosition().getValue();
            if (this.isRightToLeft()) {
                if (iTitlePos == 2) {
                    iTitlePos = 3;
                } else if (iTitlePos == 3) {
                    iTitlePos = 2;
                }
            }
            switch (iTitlePos) {
                case 0: {
                    yOffset = lgTitleHeight;
                    hOffset = -yOffset;
                    break;
                }
                case 1: {
                    hOffset = -lgTitleHeight;
                    break;
                }
                case 2: {
                    xOffset = lgTitleWidth;
                    wOffset = -xOffset;
                    break;
                }
                case 3: {
                    wOffset = -lgTitleWidth;
                    break;
                }
            }
        }
        ca = lg.getClientArea();
        lgIns = lg.getInsets().scaledInstance(dScale);
        lia = ca.getOutline();
        bo = BoundsImpl.create(dX, dY, sz.getWidth(), sz.getHeight());
        bo = bo.adjustedInstance(lgIns);
        dX = bo.getLeft();
        dY = bo.getTop();
        bo.delta(xOffset, yOffset, wOffset, hOffset);
        dX = bo.getLeft();
        dY = bo.getTop();
        dBaseX = dX;
        dBaseY = dY;
        v0 = (EventObjectCache)this.ir;
        v1 = StructureSource.createLegend(lg);
        v2 = BaseRenderer.class$0;
        if (v2 == null) {
            try {
                v3 = Class.forName("org.eclipse.birt.chart.event.RectangleRenderEvent");
            }
            catch (ClassNotFoundException v4) {
                throw new NoClassDefFoundError(v4.getMessage());
            }
            v2 = BaseRenderer.class$0 = v3;
        }
        rre = (RectangleRenderEvent)v0.getEventObject(v1, v2);
        if (ca.getShadowColor() != null) {
            rre.setBounds(bo.translateInstance(3.0, 3.0));
            rre.setBackground(ca.getShadowColor());
            ipr.fillRectangle(rre);
        }
        rre.setBounds(bo);
        rre.setOutline(lia);
        rre.setBackground(ca.getBackground());
        ipr.fillRectangle(rre);
        ipr.drawRectangle(rre);
        lia = LineAttributesImpl.copyInstance(lia);
        lia.setVisible(true);
        liSep = lg.getSeparator() == null ? lia : lg.getSeparator();
        seda = this.cm.getSeriesForLegend();
        o = lg.getOrientation();
        d = lg.getDirection();
        la = LabelImpl.create();
        la.setCaption(TextImpl.copyInstance(lg.getText()));
        la.getCaption().setValue("X");
        itm = xs.getTextMetrics(la);
        try {
            block108: {
                block113: {
                    block115: {
                        block114: {
                            block109: {
                                block110: {
                                    block112: {
                                        block111: {
                                            dItemHeight = itm.getFullHeight();
                                            insCA = ca.getInsets().scaledInstance(dScale);
                                            v5 = bPaletteByCategory = this.cm.getLegend().getItemType().getValue() == 1;
                                            if (o.getValue() != 1) break block109;
                                            if (!bPaletteByCategory) break block110;
                                            sdBase = null;
                                            if (!(this.cm instanceof ChartWithAxes)) break block111;
                                            axPrimaryBase = ((ChartWithAxes)this.cm).getBaseAxes()[0];
                                            if (axPrimaryBase.getSeriesDefinitions().isEmpty()) {
lbl158:
                                                // 4 sources

                                                while (true) {
                                                    var64_45 = null;
                                                    itm.dispose();
                                                    return;
                                                }
                                            }
                                            sdBase = (SeriesDefinition)axPrimaryBase.getSeriesDefinitions().get(0);
                                            break block112;
                                        }
                                        if (!(this.cm instanceof ChartWithoutAxes)) break block112;
                                        if (((ChartWithoutAxes)this.cm).getSeriesDefinitions().isEmpty()) ** GOTO lbl158
                                        sdBase = (SeriesDefinition)((ChartWithoutAxes)this.cm).getSeriesDefinitions().get(0);
                                    }
                                    seBase = (Series)sdBase.getRunTimeSeries().get(0);
                                    pa = sdBase.getSeriesPalette();
                                    elPaletteEntries = pa.getEntries();
                                    iPaletteCount = elPaletteEntries.size();
                                    if (lilh.getLegendItemHints() == null) {
                                        throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.null.legend.item.hints", Messages.getResourceBundle(this.rtc.getULocale()));
                                    }
                                    liha = lilh.getLegendItemHints();
                                    columnCache = this.searchMaxColumnWidth(liha);
                                    i = 0;
                                    while (i < liha.length) {
                                        lih = liha[i];
                                        if ((lih.getType() & 1) == 1) {
                                            la.getCaption().setValue(lih.getText());
                                            fPaletteEntry = (Fill)elPaletteEntries.get(lih.getCategoryIndex() % iPaletteCount);
                                            lirh = (LegendItemRenderingHints)htRenderers.get(seBase);
                                            columnWidth = bo.getWidth();
                                            cachedWidth = (Double)columnCache.get(lih);
                                            if (cachedWidth != null) {
                                                columnWidth = cachedWidth + 3.0 * dItemHeight / 2.0 + 2.0 * insCA.getLeft();
                                            }
                                            this.renderLegendItem(ipr, lg, la, null, dBaseX + lih.getLeft(), dBaseY + lih.getTop() + insCA.getTop(), lih.getWidth(), dItemHeight, lih.getHeight(), 0.0, columnWidth, insCA.getLeft(), 4.0, seBase, fPaletteEntry, lirh, lih.getCategoryIndex(), dScale);
                                        }
                                        ++i;
                                    }
                                    break block108;
                                }
                                if (d.getValue() == 1) {
                                    if (lilh.getLegendItemHints() == null) {
                                        throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.null.legend.item.hints", Messages.getResourceBundle(this.rtc.getULocale()));
                                    }
                                    liha = lilh.getLegendItemHints();
                                    k = 0;
                                    columnCache = this.searchMaxColumnWidth(liha);
                                    j = 0;
                                    block31: while (j < seda.length) {
                                        al = seda[j].getRunTimeSeries();
                                        pa = seda[j].getSeriesPalette();
                                        elPaletteEntries = pa.getEntries();
                                        iPaletteCount = elPaletteEntries.size();
                                        i = 0;
                                        while (true) {
                                            if (i >= al.size()) {
                                                if (j < seda.length - 1 && k < liha.length && (lih = liha[k]).getType() == 2) {
                                                    ++k;
                                                    BaseRenderer.renderSeparator(ipr, lg, liSep, dBaseX + lih.getLeft(), dBaseY + lih.getTop(), lih.getWidth(), Orientation.HORIZONTAL_LITERAL);
                                                }
                                                ++j;
                                                continue block31;
                                            }
                                            seBase = (Series)al.get(i);
                                            if (seBase.isVisible()) {
                                                lirh = (LegendItemRenderingHints)htRenderers.get(seBase);
                                                if (k < liha.length && (lih = liha[k++]).getType() == 1) {
                                                    la.getCaption().setValue(lih.getText());
                                                    valueLa = null;
                                                    if (lg.isShowValue()) {
                                                        valueLa = LabelImpl.copyInstance(seBase.getLabel());
                                                        valueLa.getCaption().setValue(lih.getExtraText());
                                                        valueLa.setVisible(true);
                                                    }
                                                    fPaletteEntry = (Fill)elPaletteEntries.get(i % iPaletteCount);
                                                    columnWidth = bo.getWidth();
                                                    cachedWidth = (Double)columnCache.get(lih);
                                                    if (cachedWidth != null) {
                                                        columnWidth = cachedWidth + 3.0 * dItemHeight / 2.0 + 2.0 * insCA.getLeft();
                                                    }
                                                    this.renderLegendItem(ipr, lg, la, valueLa, dBaseX + lih.getLeft(), dBaseY + lih.getTop() + insCA.getTop(), lih.getWidth(), dItemHeight, lih.getHeight(), lih.getExtraHeight(), columnWidth, insCA.getLeft(), 4.0, seBase, fPaletteEntry, lirh, i, dScale);
                                                }
                                            }
                                            ++i;
                                        }
                                    }
                                    break block108;
                                } else {
                                    if (d.getValue() != 0) {
                                        throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.illegal.legend.direction", new Object[]{d.getName()}, Messages.getResourceBundle(this.rtc.getULocale()));
                                    }
                                    if (lilh.getLegendItemHints() == null) {
                                        throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.null.legend.item.hints", Messages.getResourceBundle(this.rtc.getULocale()));
                                    }
                                    liha = lilh.getLegendItemHints();
                                    k = 0;
                                    columnCache = this.searchMaxColumnWidth(liha);
                                    j = 0;
                                    block33: while (j < seda.length) {
                                        al = seda[j].getRunTimeSeries();
                                        pa = seda[j].getSeriesPalette();
                                        elPaletteEntries = pa.getEntries();
                                        iPaletteCount = elPaletteEntries.size();
                                        i = 0;
                                        while (true) {
                                            if (i >= al.size()) {
                                                if (j < seda.length - 1 && k < liha.length && (lih = liha[k]).getType() == 2) {
                                                    ++k;
                                                    BaseRenderer.renderSeparator(ipr, lg, liSep, dBaseX + lih.getLeft(), dBaseY + lih.getTop(), bo.getHeight(), Orientation.VERTICAL_LITERAL);
                                                }
                                                ++j;
                                                continue block33;
                                            }
                                            seBase = (Series)al.get(i);
                                            if (seBase.isVisible()) {
                                                lirh = (LegendItemRenderingHints)htRenderers.get(seBase);
                                                if (k < liha.length && (lih = liha[k++]).getType() == 1) {
                                                    la.getCaption().setValue(lih.getText());
                                                    valueLa = null;
                                                    if (lg.isShowValue()) {
                                                        valueLa = LabelImpl.copyInstance(seBase.getLabel());
                                                        valueLa.getCaption().setValue(lih.getExtraText());
                                                        valueLa.setVisible(true);
                                                    }
                                                    fPaletteEntry = (Fill)elPaletteEntries.get(i % iPaletteCount);
                                                    columnWidth = bo.getWidth();
                                                    cachedWidth = (Double)columnCache.get(lih);
                                                    if (cachedWidth != null) {
                                                        columnWidth = cachedWidth + 3.0 * dItemHeight / 2.0 + 2.0 * insCA.getLeft();
                                                    }
                                                    this.renderLegendItem(ipr, lg, la, valueLa, dBaseX + lih.getLeft(), dBaseY + lih.getTop() + insCA.getTop(), lih.getWidth(), dItemHeight, lih.getHeight(), lih.getExtraHeight(), columnWidth, insCA.getLeft(), 4.0, seBase, fPaletteEntry, lirh, i, dScale);
                                                }
                                            }
                                            ++i;
                                        }
                                    }
                                }
                                break block108;
                            }
                            if (o.getValue() != 0) {
                                throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.illegal.legend.orientation", new Object[]{o.getName()}, Messages.getResourceBundle(this.rtc.getULocale()));
                            }
                            if (!bPaletteByCategory) break block113;
                            sdBase = null;
                            if (!(this.cm instanceof ChartWithAxes)) break block114;
                            axPrimaryBase = ((ChartWithAxes)this.cm).getBaseAxes()[0];
                            if (axPrimaryBase.getSeriesDefinitions().isEmpty()) ** GOTO lbl158
                            sdBase = (SeriesDefinition)axPrimaryBase.getSeriesDefinitions().get(0);
                            break block115;
                        }
                        if (this.cm instanceof ChartWithoutAxes) {
                            if (!((ChartWithoutAxes)this.cm).getSeriesDefinitions().isEmpty()) ** break;
                            ** continue;
                            sdBase = (SeriesDefinition)((ChartWithoutAxes)this.cm).getSeriesDefinitions().get(0);
                        }
                    }
                    seBase = (Series)sdBase.getRunTimeSeries().get(0);
                    pa = sdBase.getSeriesPalette();
                    elPaletteEntries = pa.getEntries();
                    iPaletteCount = elPaletteEntries.size();
                    if (lilh.getLegendItemHints() == null) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.null.legend.item.hints", Messages.getResourceBundle(this.rtc.getULocale()));
                    }
                    liha = lilh.getLegendItemHints();
                    i = 0;
                    while (i < liha.length) {
                        lih = liha[i];
                        if ((lih.getType() & 1) == 1) {
                            la.getCaption().setValue(lih.getText());
                            fPaletteEntry = (Fill)elPaletteEntries.get(lih.getCategoryIndex() % iPaletteCount);
                            lirh = (LegendItemRenderingHints)htRenderers.get(seBase);
                            this.renderLegendItem(ipr, lg, la, null, dBaseX + lih.getLeft(), dBaseY + lih.getTop() + insCA.getTop(), lih.getWidth(), dItemHeight, lih.getHeight(), 0.0, lih.getWidth() + 3.0 * dItemHeight / 2.0 + 2.0 * insCA.getLeft(), insCA.getLeft(), 4.0, seBase, fPaletteEntry, lirh, i, dScale);
                        }
                        ++i;
                    }
                    break block108;
                }
                if (d.getValue() == 1) {
                    if (lilh.getLegendItemHints() == null) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.null.legend.item.hints", Messages.getResourceBundle(this.rtc.getULocale()));
                    }
                    liha = lilh.getLegendItemHints();
                    k = 0;
                    j = 0;
                    block36: while (j < seda.length) {
                        al = seda[j].getRunTimeSeries();
                        pa = seda[j].getSeriesPalette();
                        elPaletteEntries = pa.getEntries();
                        iPaletteCount = elPaletteEntries.size();
                        i = 0;
                        while (true) {
                            if (i >= al.size()) {
                                if (j < seda.length - 1 && k < liha.length && (lih = liha[k]).getType() == 2) {
                                    ++k;
                                    BaseRenderer.renderSeparator(ipr, lg, liSep, dBaseX + lih.getLeft(), dBaseY + lih.getTop(), bo.getWidth(), Orientation.HORIZONTAL_LITERAL);
                                }
                                ++j;
                                continue block36;
                            }
                            seBase = (Series)al.get(i);
                            if (seBase.isVisible()) {
                                lirh = (LegendItemRenderingHints)htRenderers.get(seBase);
                                if (k < liha.length && (lih = liha[k++]).getType() == 1) {
                                    la.getCaption().setValue(lih.getText());
                                    valueLa = null;
                                    if (lg.isShowValue()) {
                                        valueLa = LabelImpl.copyInstance(seBase.getLabel());
                                        valueLa.getCaption().setValue(lih.getExtraText());
                                        valueLa.setVisible(true);
                                    }
                                    fPaletteEntry = (Fill)elPaletteEntries.get(i % iPaletteCount);
                                    this.renderLegendItem(ipr, lg, la, valueLa, dBaseX + lih.getLeft(), dBaseY + lih.getTop() + insCA.getTop(), lih.getWidth(), dItemHeight, lih.getHeight(), lih.getExtraHeight(), lih.getWidth() + 3.0 * dItemHeight / 2.0 + 2.0 * insCA.getLeft(), insCA.getLeft(), 4.0, seBase, fPaletteEntry, lirh, i, dScale);
                                }
                            }
                            ++i;
                        }
                    }
                } else {
                    if (d.getValue() != 0) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.illegal.legend.direction", new Object[]{d.getName()}, Messages.getResourceBundle(this.rtc.getULocale()));
                    }
                    if (lilh.getLegendItemHints() == null) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.null.legend.item.hints", Messages.getResourceBundle(this.rtc.getULocale()));
                    }
                    liha = lilh.getLegendItemHints();
                    k = 0;
                    j = 0;
                    block38: while (j < seda.length) {
                        al = seda[j].getRunTimeSeries();
                        pa = seda[j].getSeriesPalette();
                        elPaletteEntries = pa.getEntries();
                        iPaletteCount = elPaletteEntries.size();
                        i = 0;
                        while (true) {
                            if (i >= al.size()) {
                                if (j < seda.length - 1 && k < liha.length && (lih = liha[k]).getType() == 2) {
                                    ++k;
                                    BaseRenderer.renderSeparator(ipr, lg, liSep, dBaseX + lih.getLeft(), dBaseY + lih.getTop(), lih.getHeight(), Orientation.VERTICAL_LITERAL);
                                }
                                ++j;
                                continue block38;
                            }
                            seBase = (Series)al.get(i);
                            if (seBase.isVisible()) {
                                lirh = (LegendItemRenderingHints)htRenderers.get(seBase);
                                if (k < liha.length && (lih = liha[k++]).getType() == 1) {
                                    la.getCaption().setValue(lih.getText());
                                    valueLa = null;
                                    if (lg.isShowValue()) {
                                        valueLa = LabelImpl.copyInstance(seBase.getLabel());
                                        valueLa.getCaption().setValue(lih.getExtraText());
                                        valueLa.setVisible(true);
                                    }
                                    fPaletteEntry = (Fill)elPaletteEntries.get(i % iPaletteCount);
                                    this.renderLegendItem(ipr, lg, la, valueLa, dBaseX + lih.getLeft(), dBaseY + lih.getTop() + insCA.getTop(), lih.getWidth(), dItemHeight, lih.getHeight(), lih.getExtraHeight(), lih.getWidth() + 3.0 * dItemHeight / 2.0 + 2.0 * insCA.getLeft(), insCA.getLeft(), 4.0, seBase, fPaletteEntry, lirh, i, dScale);
                                }
                            }
                            ++i;
                        }
                    }
                }
            }
            if (bRenderLegendTitle) {
                lX = bo.getLeft();
                lY = bo.getTop();
                switch (iTitlePos) {
                    case 0: {
                        lX = bo.getLeft() + (bo.getWidth() - lgTitleWidth) / 2.0;
                        lY = bo.getTop() - lgTitleHeight;
                        break;
                    }
                    case 1: {
                        lX = bo.getLeft() + (bo.getWidth() - lgTitleWidth) / 2.0;
                        lY = bo.getTop() + bo.getHeight();
                        break;
                    }
                    case 2: {
                        lX = bo.getLeft() - lgTitleWidth;
                        lY = bo.getTop() + (bo.getHeight() - lgTitleHeight) / 2.0;
                        break;
                    }
                    case 3: {
                        lX = bo.getLeft() + bo.getWidth();
                        lY = bo.getTop() + (bo.getHeight() - lgTitleHeight) / 2.0;
                        break;
                    }
                }
                v6 = (EventObjectCache)this.ir;
                v7 = WrappedStructureSource.createLegendTitle(lg, lgTitle);
                v8 = BaseRenderer.class$1;
                if (v8 == null) {
                    try {
                        v9 = Class.forName("org.eclipse.birt.chart.event.TextRenderEvent");
                    }
                    catch (ClassNotFoundException v10) {
                        throw new NoClassDefFoundError(v10.getMessage());
                    }
                    v8 = BaseRenderer.class$1 = v9;
                }
                tre = (TextRenderEvent)v6.getEventObject(v7, v8);
                tre.setBlockBounds(BoundsImpl.create(lX, lY, lgTitleWidth, lgTitleHeight));
                ta = TextAlignmentImpl.create();
                ta.setHorizontalAlignment(HorizontalAlignment.CENTER_LITERAL);
                ta.setVerticalAlignment(VerticalAlignment.CENTER_LITERAL);
                tre.setBlockAlignment(ta);
                tre.setLabel(lgTitle);
                tre.setAction(3);
                ipr.drawText(tre);
            }
        }
        catch (Throwable var65_117) {
            var64_46 = null;
            itm.dispose();
            throw var65_117;
        }
        {
            var64_47 = null;
            itm.dispose();
            return;
        }
    }

    protected static final void renderSeparator(IPrimitiveRenderer ipr, Legend lg, LineAttributes lia, double dX, double dY, double dLength, Orientation o) throws ChartException {
        if (o.getValue() == 0) {
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            StructureSource structureSource = StructureSource.createLegend(lg);
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LineRenderEvent lre = (LineRenderEvent)eventObjectCache.getEventObject(structureSource, clazz);
            lre.setLineAttributes(lia);
            lre.setStart(LocationImpl.create(dX, dY));
            lre.setEnd(LocationImpl.create(dX + dLength, dY));
            ipr.drawLine(lre);
        } else if (o.getValue() == 1) {
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            StructureSource structureSource = StructureSource.createLegend(lg);
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LineRenderEvent lre = (LineRenderEvent)eventObjectCache.getEventObject(structureSource, clazz);
            lre.setLineAttributes(lia);
            lre.setStart(LocationImpl.create(dX, dY));
            lre.setEnd(LocationImpl.create(dX, dY + dLength));
            ipr.drawLine(lre);
        }
    }

    protected Map searchMaxColumnWidth(LegendItemHints[] liha) {
        HashMap<LegendItemHints, Double> rt = new HashMap<LegendItemHints, Double>();
        int start = -1;
        double x = 0.0;
        double maxWidth = 0.0;
        int i = 0;
        while (i < liha.length) {
            if (liha[i].getType() != 2) {
                if (start < 0) {
                    start = i;
                    x = liha[i].getLeft();
                    maxWidth = liha[i].getWidth();
                } else if (liha[i].getLeft() != x) {
                    int j = start;
                    while (j < i) {
                        rt.put(liha[j], new Double(maxWidth));
                        ++j;
                    }
                    start = i;
                    x = liha[i].getLeft();
                    maxWidth = liha[i].getWidth();
                } else {
                    maxWidth = Math.max(maxWidth, liha[i].getWidth());
                }
            }
            ++i;
        }
        int j = Math.max(start, 0);
        while (j < liha.length) {
            rt.put(liha[j], new Double(maxWidth));
            ++j;
        }
        return rt;
    }

    protected final void renderLegendItem(IPrimitiveRenderer ipr, Legend lg, Label la, Label valueLa, double dX, double dY, double dW, double dItemHeight, double dFullHeight, double dExtraHeight, double dColumnWidth, double dLeftInset, double dHorizontalSpacing, Series se, Fill fPaletteEntry, LegendItemRenderingHints lirh, int dataIndex, double dScale) throws ChartException {
        if (la != null && la.getCaption() != null && valueLa != null && valueLa.getCaption() != null) {
            valueLa.getCaption().setFont(la.getCaption().getFont());
            valueLa.getCaption().setColor(la.getCaption().getColor());
        }
        LegendEntryRenderingHints lerh = new LegendEntryRenderingHints(la, valueLa, dataIndex, fPaletteEntry);
        ScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        ScriptHandler.callFunction(sh, "beforeDrawLegendEntry", la, this.getRunTimeContext().getScriptContext());
        this.getRunTimeContext().notifyStructureChange("beforeDrawLegendEntry", la);
        Bounds bo = lirh.getLegendGraphicBounds();
        if (this.isRightToLeft()) {
            bo.setLeft((dX + dColumnWidth - dLeftInset - 1.0 - 3.0 * dItemHeight / 2.0) / dScale);
        } else {
            bo.setLeft((dX + dLeftInset + 1.0) / dScale);
        }
        bo.setTop((dY + 1.0 + (dFullHeight - dItemHeight) / 2.0) / dScale);
        bo.setWidth(3.0 * dItemHeight / 2.0 / dScale);
        bo.setHeight((dItemHeight - 2.0) / dScale);
        ScriptHandler.callFunction(sh, "beforeDrawLegendItem", lerh, bo, this.getRunTimeContext().getScriptContext());
        this.getRunTimeContext().notifyStructureChange("beforeDrawLegendItem", lerh);
        bo.setLeft(bo.getLeft() * dScale);
        bo.setTop(bo.getTop() * dScale);
        bo.setWidth(bo.getWidth() * dScale);
        bo.setHeight(bo.getHeight() * dScale);
        BaseRenderer br = lirh.getRenderer();
        br.renderLegendGraphic(ipr, lg, fPaletteEntry, bo);
        EventObjectCache eventObjectCache = (EventObjectCache)((Object)this.ir);
        StructureSource structureSource = StructureSource.createLegend(lg);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.birt.chart.event.TextRenderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TextRenderEvent tre = (TextRenderEvent)eventObjectCache.getEventObject(structureSource, clazz);
        double dLaAngle = la.getCaption().getFont().getRotation();
        if (this.isRightToLeft()) {
            dLaAngle = -dLaAngle;
        }
        double dDeltaHeight = 0.0;
        if (dLaAngle > 0.0 && dLaAngle < 90.0) {
            dDeltaHeight = (bo.getHeight() + dFullHeight - dItemHeight) / 2.0;
        } else if (dLaAngle < 0.0 && dLaAngle > -90.0) {
            dDeltaHeight = (bo.getHeight() - dFullHeight + dItemHeight) / 2.0;
        } else if (dLaAngle == 0.0 || dLaAngle == 90.0 || dLaAngle == -90.0) {
            dDeltaHeight = bo.getHeight() / 2.0;
        }
        if (this.isRightToLeft()) {
            tre.setLocation(LocationImpl.create(dX + dColumnWidth - dLeftInset - 3.0 * dItemHeight / 2.0 - dHorizontalSpacing, bo.getTop() + dDeltaHeight));
            tre.setTextPosition(1);
        } else {
            tre.setLocation(LocationImpl.create(dX + dLeftInset + 3.0 * dItemHeight / 2.0 + dHorizontalSpacing, bo.getTop() + dDeltaHeight));
            tre.setTextPosition(2);
        }
        if (la.isVisible()) {
            tre.setLabel(la);
            tre.setAction(2);
            ipr.drawText(tre);
        }
        if (valueLa != null) {
            double dValueWidth = dColumnWidth - 2.0 * dLeftInset;
            Label tmpLa = LabelImpl.copyInstance(valueLa);
            TextAlignment ta = TextAlignmentImpl.create();
            ta.setHorizontalAlignment(HorizontalAlignment.CENTER_LITERAL);
            ta.setVerticalAlignment(VerticalAlignment.CENTER_LITERAL);
            tre.setBlockAlignment(ta);
            tre.setBlockBounds(BoundsImpl.create(dX + dLeftInset + 1.0, dY + dFullHeight + 1.0, dValueWidth - 2.0, dExtraHeight - 1.0));
            tre.setLabel(tmpLa);
            tre.setAction(3);
            ipr.drawText(tre);
        }
        if (this.isInteractivityEnabled()) {
            EList elTriggers = lg.getTriggers();
            Location[] loaHotspot = new Location[]{LocationImpl.create(dX + 1.0, dY + 1.0), LocationImpl.create(dX + dColumnWidth - 1.0, dY + 1.0), LocationImpl.create(dX + dColumnWidth - 1.0, dY + dFullHeight + dExtraHeight - 1.0), LocationImpl.create(dX + 1.0, dY + dFullHeight + dExtraHeight - 1.0)};
            Trigger buildinTg = null;
            if (this.cm.getInteractivity() != null) {
                boolean customed = false;
                switch (this.cm.getInteractivity().getLegendBehavior().getValue()) {
                    case 2: {
                        Iterator itr = elTriggers.iterator();
                        while (itr.hasNext()) {
                            Trigger tg = (Trigger)itr.next();
                            if (tg.getCondition() != TriggerCondition.ONCLICK_LITERAL && tg.getAction().getType() != ActionType.HIGHLIGHT_LITERAL) continue;
                            customed = true;
                        }
                        if (customed) break;
                        buildinTg = TriggerImpl.create(TriggerCondition.ONCLICK_LITERAL, ActionImpl.create(ActionType.HIGHLIGHT_LITERAL, SeriesValueImpl.create(String.valueOf(se.getSeriesIdentifier()))));
                        break;
                    }
                    case 1: {
                        Iterator itr = elTriggers.iterator();
                        while (itr.hasNext()) {
                            Trigger tg = (Trigger)itr.next();
                            if (tg.getCondition() != TriggerCondition.ONCLICK_LITERAL && tg.getAction().getType() != ActionType.TOGGLE_VISIBILITY_LITERAL) continue;
                            customed = true;
                        }
                        if (customed) break;
                        buildinTg = TriggerImpl.create(TriggerCondition.ONCLICK_LITERAL, ActionImpl.create(ActionType.TOGGLE_VISIBILITY_LITERAL, SeriesValueImpl.create(String.valueOf(se.getSeriesIdentifier()))));
                        break;
                    }
                }
            }
            if (!elTriggers.isEmpty() || buildinTg != null) {
                StructureSource source;
                if (this.cm.getLegend().getItemType() == LegendItemType.CATEGORIES_LITERAL) {
                    DataPointHints dph = new DataPointHints((Object)la, null, null, null, null, null, null, null, null, dataIndex, null, 0.0, null);
                    source = WrappedStructureSource.createSeriesDataPoint(se, dph);
                } else {
                    source = StructureSource.createSeries(se);
                }
                EventObjectCache eventObjectCache2 = (EventObjectCache)((Object)ipr);
                Class<?> clazz2 = class$3;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$3 = Class.forName("org.eclipse.birt.chart.event.InteractionEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                InteractionEvent iev = (InteractionEvent)eventObjectCache2.getEventObject(source, clazz2);
                int t = 0;
                while (t < elTriggers.size()) {
                    Trigger tg = TriggerImpl.copyInstance((Trigger)elTriggers.get(t));
                    this.processTrigger(tg, WrappedStructureSource.createLegendEntry(lg, lerh));
                    iev.addTrigger(tg);
                    ++t;
                }
                if (buildinTg != null) {
                    this.processTrigger(buildinTg, WrappedStructureSource.createLegendEntry(lg, lerh));
                    iev.addTrigger(buildinTg);
                }
                EventObjectCache eventObjectCache3 = (EventObjectCache)((Object)ipr);
                Class<?> clazz3 = class$4;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$4 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache3.getEventObject(source, clazz3);
                pre.setPoints(loaHotspot);
                iev.setHotSpot(pre);
                ipr.enableInteraction(iev);
            }
        }
        ScriptHandler.callFunction(sh, "afterDrawLegendItem", lerh, bo, this.getRunTimeContext().getScriptContext());
        this.getRunTimeContext().notifyStructureChange("afterDrawLegendItem", lerh);
        ScriptHandler.callFunction(sh, "afterDrawLegendEntry", la, this.getRunTimeContext().getScriptContext());
        this.getRunTimeContext().notifyStructureChange("afterDrawLegendEntry", la);
    }

    public void renderPlot(IPrimitiveRenderer ipr, Plot p) throws ChartException {
        boolean bLastInSequence;
        if (!p.isVisible()) {
            return;
        }
        boolean bFirstInSequence = this.iSeriesIndex == 0;
        boolean bl = bLastInSequence = this.iSeriesIndex == this.iSeriesCount - 1;
        if (bFirstInSequence) {
            this.renderBackground(ipr, p);
        }
        if (this.getSeries() != null) {
            ScriptHandler.callFunction(this.getRunTimeContext().getScriptHandler(), "beforeDrawSeries", this.getSeries(), this, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("beforeDrawSeries", this.getSeries());
            this.renderSeries(ipr, p, this.srh);
            ScriptHandler.callFunction(this.getRunTimeContext().getScriptHandler(), "afterDrawSeries", this.getSeries(), this, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("afterDrawSeries", this.getSeries());
        }
    }

    protected void renderBackground(IPrimitiveRenderer ipr, Plot p) throws ChartException {
        double dScale = this.getDeviceScale();
        EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
        StructureSource structureSource = StructureSource.createPlot(p);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.chart.event.RectangleRenderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RectangleRenderEvent rre = (RectangleRenderEvent)eventObjectCache.getEventObject(structureSource, clazz);
        rre.updateFrom(p, dScale);
        ipr.fillRectangle(rre);
        ipr.drawRectangle(rre);
        Object oComputations = this.getComputations();
        if (oComputations instanceof PlotWithoutAxes) {
            ClientArea ca = p.getClientArea();
            Bounds cbo = rre.getBounds();
            if (ca.getShadowColor() != null) {
                rre.setBounds(cbo.translateInstance(3.0, 3.0));
                rre.setBackground(ca.getShadowColor());
                ipr.fillRectangle(rre);
            }
            rre.setBounds(cbo);
            rre.setBackground(ca.getBackground());
            ipr.fillRectangle(rre);
            ipr.drawRectangle(rre);
            if (!ca.getOutline().isSetVisible()) {
                throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.client.area.outline.visibility", Messages.getResourceBundle(this.rtc.getULocale()));
            }
            if (ca.getOutline().isVisible()) {
                Bounds bo = p.getBounds().scaledInstance(dScale);
                PlotWithoutAxes pwoa = (PlotWithoutAxes)oComputations;
                Size sz = SizeImpl.create(bo.getWidth() / (double)pwoa.getColumnCount(), bo.getHeight() / (double)pwoa.getRowCount());
                EventObjectCache eventObjectCache2 = (EventObjectCache)((Object)ipr);
                StructureSource structureSource2 = StructureSource.createPlot(p);
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                LineRenderEvent lre = (LineRenderEvent)eventObjectCache2.getEventObject(structureSource2, clazz2);
                lre.setLineAttributes(ca.getOutline());
                int colCount = pwoa.getColumnCount();
                int rowCount = pwoa.getRowCount();
                ChartWithoutAxes cwoa = pwoa.getModel();
                if (cwoa instanceof DialChart && ((DialChart)cwoa).isDialSuperimposition()) {
                    colCount = 1;
                    rowCount = 1;
                }
                int i = 1;
                while (i < colCount) {
                    lre.setStart(LocationImpl.create(bo.getLeft() + (double)i * sz.getWidth(), bo.getTop()));
                    lre.setEnd(LocationImpl.create(bo.getLeft() + (double)i * sz.getWidth(), bo.getTop() + bo.getHeight()));
                    ipr.drawLine(lre);
                    ++i;
                }
                int j = 1;
                while (j < rowCount) {
                    lre.setStart(LocationImpl.create(bo.getLeft(), bo.getTop() + (double)j * sz.getHeight()));
                    lre.setEnd(LocationImpl.create(bo.getLeft() + bo.getWidth(), bo.getTop() + (double)j * sz.getHeight()));
                    ipr.drawLine(lre);
                    ++j;
                }
            }
        }
    }

    protected void renderBlock(IPrimitiveRenderer ipr, Block b, Object oSource) throws ChartException {
        double dScale = this.getDeviceScale();
        EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.chart.event.RectangleRenderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RectangleRenderEvent rre = (RectangleRenderEvent)eventObjectCache.getEventObject(oSource, clazz);
        rre.updateFrom(b, dScale);
        ipr.fillRectangle(rre);
        ipr.drawRectangle(rre);
    }

    protected void renderChartBlock(IPrimitiveRenderer ipr, Block b, Object oSource) throws ChartException {
        double dScale = this.getDeviceScale();
        EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.chart.event.RectangleRenderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RectangleRenderEvent rre = (RectangleRenderEvent)eventObjectCache.getEventObject(oSource, clazz);
        rre.updateFrom(b, dScale);
        ipr.fillRectangle(rre);
        ipr.drawRectangle(rre);
        if (this.isInteractivityEnabled()) {
            EList elTriggers = b.getTriggers();
            Location[] loaHotspot = new Location[4];
            Bounds bo = b.getBounds().scaledInstance(dScale);
            double dLeft = bo.getLeft();
            double dTop = bo.getTop();
            double dWidth = bo.getWidth();
            double dHeight = bo.getHeight();
            loaHotspot[0] = LocationImpl.create(dLeft, dTop);
            loaHotspot[1] = LocationImpl.create(dLeft + dWidth, dTop);
            loaHotspot[2] = LocationImpl.create(dLeft + dWidth, dTop + dHeight);
            loaHotspot[3] = LocationImpl.create(dLeft, dTop + dHeight);
            if (!elTriggers.isEmpty()) {
                EventObjectCache eventObjectCache2 = (EventObjectCache)((Object)ipr);
                StructureSource structureSource = StructureSource.createChartBlock(b);
                Class<?> clazz2 = class$3;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$3 = Class.forName("org.eclipse.birt.chart.event.InteractionEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                InteractionEvent iev = (InteractionEvent)eventObjectCache2.getEventObject(structureSource, clazz2);
                int t = 0;
                while (t < elTriggers.size()) {
                    Trigger tg = TriggerImpl.copyInstance((Trigger)elTriggers.get(t));
                    this.processTrigger(tg, StructureSource.createChartBlock(b));
                    iev.addTrigger(tg);
                    ++t;
                }
                EventObjectCache eventObjectCache3 = (EventObjectCache)((Object)ipr);
                StructureSource structureSource2 = StructureSource.createChartBlock(b);
                Class<?> clazz3 = class$4;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$4 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache3.getEventObject(structureSource2, clazz3);
                pre.setPoints(loaHotspot);
                iev.setHotSpot(pre);
                ipr.enableInteraction(iev);
            }
        }
    }

    public void renderLabel(IPrimitiveRenderer ipr, Block b, Object oSource) throws ChartException {
        if (!b.isVisible()) {
            return;
        }
        this.renderBlock(ipr, b, oSource);
        double dScale = this.getDeviceScale();
        LabelBlock lb = (LabelBlock)b;
        EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.birt.chart.event.TextRenderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TextRenderEvent tre = (TextRenderEvent)eventObjectCache.getEventObject(oSource, clazz);
        String sRestoreValue = tre.updateFrom(lb, dScale, this.rtc);
        if (lb.getLabel().isVisible()) {
            ipr.drawText(tre);
        }
        lb.getLabel().getCaption().setValue(sRestoreValue);
    }

    public void renderTitle(IPrimitiveRenderer ipr, TitleBlock b) throws ChartException {
        TextAlignment restoreValue = b.getLabel().getCaption().getFont().getAlignment();
        b.getLabel().getCaption().getFont().setAlignment(this.switchTextAlignment(restoreValue));
        this.renderLabel(ipr, b, StructureSource.createTitle(b));
        b.getLabel().getCaption().getFont().setAlignment(restoreValue);
        if (this.isInteractivityEnabled()) {
            EList elTriggers = b.getTriggers();
            Location[] loaHotspot = new Location[4];
            double dScale = this.getDeviceScale();
            Bounds bo = b.getBounds().scaledInstance(dScale);
            double dLeft = bo.getLeft();
            double dTop = bo.getTop();
            double dWidth = bo.getWidth();
            double dHeight = bo.getHeight();
            loaHotspot[0] = LocationImpl.create(dLeft, dTop);
            loaHotspot[1] = LocationImpl.create(dLeft + dWidth, dTop);
            loaHotspot[2] = LocationImpl.create(dLeft + dWidth, dTop + dHeight);
            loaHotspot[3] = LocationImpl.create(dLeft, dTop + dHeight);
            if (!elTriggers.isEmpty()) {
                EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
                StructureSource structureSource = StructureSource.createTitle(b);
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("org.eclipse.birt.chart.event.InteractionEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                InteractionEvent iev = (InteractionEvent)eventObjectCache.getEventObject(structureSource, clazz);
                int t = 0;
                while (t < elTriggers.size()) {
                    Trigger tg = TriggerImpl.copyInstance((Trigger)elTriggers.get(t));
                    this.processTrigger(tg, StructureSource.createTitle(b));
                    iev.addTrigger(tg);
                    ++t;
                }
                EventObjectCache eventObjectCache2 = (EventObjectCache)((Object)ipr);
                StructureSource structureSource2 = StructureSource.createTitle(b);
                Class<?> clazz2 = class$4;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$4 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache2.getEventObject(structureSource2, clazz2);
                pre.setPoints(loaHotspot);
                iev.setHotSpot(pre);
                ipr.enableInteraction(iev);
            }
        }
    }

    private static final BaseRenderer[] createEmptyInstance(Chart cm, RunTimeContext rtc, Object oComputations) {
        BaseRenderer[] brna = new BaseRenderer[1];
        EmptyWithAxes ar = new EmptyWithAxes();
        ar.iSeriesIndex = 0;
        ar.set(cm, oComputations, null, null, null);
        ar.set(rtc);
        brna[0] = ar;
        return brna;
    }

    public static final BaseRenderer[] instances(Chart cm, RunTimeContext rtc, Object oComputations) throws ChartException {
        BaseRenderer[] brna;
        block25: {
            boolean bPaletteByCategory;
            PluginSettings ps;
            block24: {
                ps = PluginSettings.instance();
                brna = null;
                boolean bl = bPaletteByCategory = cm.getLegend().getItemType().getValue() == 1;
                if (!(cm instanceof ChartWithAxes)) break block24;
                ChartWithAxes cwa = (ChartWithAxes)cm;
                Axis[] axa = cwa.getPrimaryBaseAxes();
                Axis axPrimaryBase = axa[0];
                AxesRenderer ar = null;
                ArrayList<AxesRenderer> al = new ArrayList<AxesRenderer>();
                SeriesDefinition sd = null;
                int iSI = 0;
                EList elBase = axPrimaryBase.getSeriesDefinitions();
                if (elBase.isEmpty()) {
                    return BaseRenderer.createEmptyInstance(cm, rtc, oComputations);
                }
                SeriesDefinition sdBase = (SeriesDefinition)elBase.get(0);
                List alRunTimeSeries = sdBase.getRunTimeSeries();
                if (alRunTimeSeries.isEmpty()) {
                    return BaseRenderer.createEmptyInstance(cm, rtc, oComputations);
                }
                Series se = (Series)alRunTimeSeries.get(0);
                Class<?> clazz = se.getClass();
                Class<?> clazz2 = class$5;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$5 = Class.forName("org.eclipse.birt.chart.model.component.impl.SeriesImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ar = clazz == clazz2 ? new EmptyWithAxes() : (AxesRenderer)ps.getRenderer(se.getClass());
                ar.set(cm, oComputations, se, axPrimaryBase, sdBase);
                ar.set(rtc);
                ar.iSeriesIndex = iSI++;
                al.add(ar);
                Axis[] axaOrthogonal = cwa.getOrthogonalAxes(axPrimaryBase, true);
                int i = 0;
                while (i < axaOrthogonal.length) {
                    EList elOrthogonal = axaOrthogonal[i].getSeriesDefinitions();
                    int j = 0;
                    while (j < elOrthogonal.size()) {
                        sd = (SeriesDefinition)elOrthogonal.get(j);
                        alRunTimeSeries = sd.getRunTimeSeries();
                        int k = 0;
                        while (k < alRunTimeSeries.size()) {
                            se = (Series)alRunTimeSeries.get(k);
                            Class<?> clazz3 = se.getClass();
                            Class<?> clazz4 = class$5;
                            if (clazz4 == null) {
                                try {
                                    clazz4 = Class.forName("org.eclipse.birt.chart.model.component.impl.SeriesImpl");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            ar = clazz3 == clazz4 ? new EmptyWithAxes() : (AxesRenderer)ps.getRenderer(se.getClass());
                            ar.set(cm, oComputations, se, axaOrthogonal[i], bPaletteByCategory ? sdBase : sd);
                            ar.iSeriesIndex = iSI++;
                            al.add(ar);
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                brna = new BaseRenderer[iSI];
                i = 0;
                while (i < iSI) {
                    ar = (AxesRenderer)al.get(i);
                    ar.iSeriesCount = iSI;
                    brna[i] = ar;
                    ++i;
                }
                break block25;
            }
            if (!(cm instanceof ChartWithoutAxes)) break block25;
            ChartWithoutAxes cwoa = (ChartWithoutAxes)cm;
            EList elBase = cwoa.getSeriesDefinitions();
            Series[] sea = cwoa.getRunTimeSeries();
            int iSeriesCount = sea.length;
            brna = new BaseRenderer[iSeriesCount];
            int iSI = 0;
            int i = 0;
            while (i < elBase.size()) {
                SeriesDefinition sdBase = (SeriesDefinition)elBase.get(i);
                List alRuntimeSeries = sdBase.getRunTimeSeries();
                if (alRuntimeSeries.size() != 1) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 10, "exception.illegal.base.runtime.series.count", new Object[]{new Integer(alRuntimeSeries.size())}, Messages.getResourceBundle(rtc.getULocale()));
                }
                Series se = (Series)alRuntimeSeries.get(0);
                Class<?> clazz = se.getClass();
                Class<?> clazz5 = class$5;
                if (clazz5 == null) {
                    try {
                        clazz5 = Class.forName("org.eclipse.birt.chart.model.component.impl.SeriesImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                brna[iSI] = clazz == clazz5 ? new EmptyWithoutAxes() : ps.getRenderer(se.getClass());
                brna[iSI].set(cm, oComputations, se, sdBase);
                brna[iSI].set(rtc);
                brna[iSI].iSeriesIndex = iSI++;
                EList elOrthogonal = ((SeriesDefinition)elBase.get(i)).getSeriesDefinitions();
                int j = 0;
                while (j < elOrthogonal.size()) {
                    SeriesDefinition sd = (SeriesDefinition)elOrthogonal.get(j);
                    alRuntimeSeries = sd.getRunTimeSeries();
                    int k = 0;
                    while (k < alRuntimeSeries.size()) {
                        se = (Series)alRuntimeSeries.get(k);
                        Class<?> clazz6 = se.getClass();
                        Class<?> clazz7 = class$5;
                        if (clazz7 == null) {
                            try {
                                clazz7 = Class.forName("org.eclipse.birt.chart.model.component.impl.SeriesImpl");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        brna[iSI] = clazz6 == clazz7 ? new EmptyWithoutAxes() : ps.getRenderer(se.getClass());
                        brna[iSI].set(cm, oComputations, se, bPaletteByCategory ? sdBase : sd);
                        brna[iSI].iSeriesIndex = iSI++;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            int k = 0;
            while (k < iSI) {
                brna[k].iSeriesCount = iSI;
                ++k;
            }
        }
        return brna;
    }

    public final Series getSeries() {
        return this.se;
    }

    public final Chart getModel() {
        return this.cm;
    }

    public final Object getComputations() {
        return this.oComputations;
    }

    public final IDeviceRenderer getDevice() {
        return this.ir;
    }

    protected final void renderPlane(IPrimitiveRenderer ipr, Object oSource, Location[] loaFront, Fill f, LineAttributes lia, ChartDimension cd, double dSeriesThickness, boolean bDeferred) throws ChartException {
        if (cd.getValue() == 0) {
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache.getEventObject(oSource, clazz);
            pre.setPoints(loaFront);
            pre.setBackground(f);
            pre.setOutline(lia);
            if (bDeferred) {
                this.dc.addPlane(pre, 3);
            } else {
                ipr.fillPolygon(pre);
                ipr.drawPolygon(pre);
            }
            return;
        }
        boolean bSolidColor = f instanceof ColorDefinition;
        Fill fDarker = null;
        Fill fBrighter = null;
        if (cd.getValue() == 1 || cd.getValue() == 2) {
            fDarker = f;
            if (fDarker instanceof ColorDefinition) {
                fDarker = ((ColorDefinition)fDarker).darker();
            }
            if ((fBrighter = f) instanceof ColorDefinition) {
                fBrighter = ((ColorDefinition)fBrighter).brighter();
            }
        }
        int nSides = loaFront.length;
        Location[][] loaa = new Location[nSides + 1][];
        double dSmallestY = 0.0;
        int i = 0;
        while (i < nSides) {
            int j = i + 1;
            if (j >= loaFront.length) {
                j = 0;
            }
            Location[] loa = new Location[]{LocationImpl.create(loaFront[i].getX(), loaFront[i].getY()), LocationImpl.create(loaFront[j].getX(), loaFront[j].getY()), LocationImpl.create(loaFront[j].getX() + dSeriesThickness, loaFront[j].getY() - dSeriesThickness), LocationImpl.create(loaFront[i].getX() + dSeriesThickness, loaFront[i].getY() - dSeriesThickness)};
            loaa[i] = loa;
            ++i;
        }
        loaa[nSides] = loaFront;
        int i2 = 0;
        while (i2 < nSides - 1) {
            Location[] loaI = loaa[i2];
            int j = i2 + 1;
            while (j < nSides) {
                Location[] loaJ = loaa[j];
                double dI = BaseRenderer.getY(loaI, 4);
                double dJ = BaseRenderer.getY(loaJ, 4);
                if (ChartUtil.mathGT(dJ, dI)) {
                    loaa[i2] = loaJ;
                    loaa[j] = loaI;
                    loaI = loaJ;
                } else if (ChartUtil.mathEqual(dJ, dI) && ChartUtil.mathGT(dI = BaseRenderer.getX(loaI, 4), dJ = BaseRenderer.getX(loaJ, 4))) {
                    loaa[i2] = loaJ;
                    loaa[j] = loaI;
                    loaI = loaJ;
                }
                ++j;
            }
            ++i2;
        }
        int iSmallestYIndex = 0;
        int i3 = 0;
        while (i3 < nSides) {
            double dY = BaseRenderer.getY(loaa[i3], 4);
            if (i3 == 0) {
                dSmallestY = dY;
            } else if (ChartUtil.mathGT(dSmallestY, dY)) {
                dSmallestY = dY;
                iSmallestYIndex = i3;
            }
            ++i3;
        }
        ArrayList<PrimitiveRenderEvent> alModel = new ArrayList<PrimitiveRenderEvent>(nSides + 1);
        int i4 = 0;
        while (i4 <= nSides) {
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache.getEventObject(oSource, clazz);
            pre.setOutline(lia);
            pre.setPoints(loaa[i4]);
            if (i4 < nSides) {
                pre.setDepth(-dSeriesThickness);
            } else {
                pre.setDepth(0.0);
            }
            Fill fP = i4 == nSides ? f : (i4 == iSmallestYIndex ? fBrighter : fDarker);
            pre.setBackground(fP);
            if (bDeferred) {
                alModel.add(pre.copy());
            } else {
                ipr.fillPolygon(pre);
            }
            if (i4 != nSides) {
                if (i4 == iSmallestYIndex) {
                    if (!bSolidColor) {
                        pre.setBackground(LIGHT_GLASS);
                    }
                    if (bDeferred) {
                        alModel.add(pre.copy());
                    } else {
                        ipr.fillPolygon(pre);
                    }
                } else {
                    if (!bSolidColor) {
                        pre.setBackground(DARK_GLASS);
                    }
                    if (bDeferred) {
                        alModel.add(pre.copy());
                    } else {
                        ipr.fillPolygon(pre);
                    }
                }
            }
            if (!bDeferred) {
                ipr.drawPolygon(pre);
            }
            ++i4;
        }
        if (!alModel.isEmpty()) {
            this.dc.addModel(new WrappedInstruction(this.getDeferredCache(), alModel, 2));
        }
    }

    protected final void render3DPlane(IPrimitiveRenderer ipr, Object oSource, List loaFace, Fill f, LineAttributes lia) throws ChartException {
        EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("org.eclipse.birt.chart.event.Polygon3DRenderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Polygon3DRenderEvent pre = (Polygon3DRenderEvent)eventObjectCache.getEventObject(oSource, clazz);
        pre.setDoubleSided(false);
        int nSides = loaFace.size();
        int i = 0;
        while (i < nSides) {
            pre.setOutline(lia);
            pre.setPoints3D((Location3D[])loaFace.get(i));
            pre.setBackground(f);
            this.dc.addPlane(pre, 3);
            ++i;
        }
    }

    public static final double getY(Location[] loa, int iProperty) {
        int iCount = loa.length;
        double dY = 0.0;
        if (iProperty == 2) {
            dY = loa[0].getY();
            int i = 1;
            while (i < iCount) {
                dY = Math.min(dY, loa[i].getY());
                ++i;
            }
        } else if (iProperty == 1) {
            dY = loa[0].getY();
            int i = 1;
            while (i < iCount) {
                dY = Math.max(dY, loa[i].getY());
                ++i;
            }
        } else if (iProperty == 4) {
            int i = 0;
            while (i < iCount) {
                dY += loa[i].getY();
                ++i;
            }
            dY /= (double)iCount;
        }
        return dY;
    }

    public static final double getX(Location[] loa, int iProperty) {
        int iCount = loa.length;
        double dX = 0.0;
        if (iProperty == 2) {
            dX = loa[0].getX();
            int i = 1;
            while (i < iCount) {
                dX = Math.min(dX, loa[i].getX());
                ++i;
            }
        } else if (iProperty == 1) {
            dX = loa[0].getX();
            int i = 1;
            while (i < iCount) {
                dX = Math.max(dX, loa[i].getX());
                ++i;
            }
        } else if (iProperty == 4) {
            int i = 0;
            while (i < iCount) {
                dX += loa[i].getX();
                ++i;
            }
            dX /= (double)iCount;
        }
        return dX;
    }

    public void processTrigger(Trigger tg, StructureSource source) {
        IActionRenderer iar = this.getRunTimeContext().getActionRenderer();
        if (iar != null) {
            iar.processAction(tg.getAction(), source);
        }
        if (StructureType.SERIES_DATA_POINT.equals(source.getType())) {
            DataPointHints dph = (DataPointHints)source.getSource();
            if (tg.getAction().getType() == ActionType.SHOW_TOOLTIP_LITERAL) {
                String toolText = ((TooltipValue)tg.getAction().getValue()).getText();
                if (toolText == null) {
                    ((TooltipValue)tg.getAction().getValue()).setText(dph.getDisplayValue());
                }
            } else if (tg.getAction().getType() == ActionType.URL_REDIRECT_LITERAL) {
                URLValue uv = (URLValue)tg.getAction().getValue();
                String sBaseURL = uv.getBaseUrl();
                if (sBaseURL == null) {
                    sBaseURL = "";
                }
                StringBuffer sb = new StringBuffer(sBaseURL);
                int c = 63;
                if (sBaseURL.indexOf(c) != -1) {
                    c = 38;
                }
                if (uv.getBaseParameterName() != null && uv.getBaseParameterName().length() > 0) {
                    sb.append((char)c);
                    c = 38;
                    sb.append(URLValueImpl.encode(uv.getBaseParameterName()));
                    sb.append('=');
                    sb.append(URLValueImpl.encode(dph.getBaseDisplayValue()));
                }
                if (uv.getValueParameterName() != null && uv.getValueParameterName().length() > 0) {
                    sb.append((char)c);
                    c = 38;
                    sb.append(URLValueImpl.encode(uv.getValueParameterName()));
                    sb.append('=');
                    sb.append(URLValueImpl.encode(dph.getOrthogonalDisplayValue()));
                }
                if (uv.getSeriesParameterName() != null && uv.getSeriesParameterName().length() > 0) {
                    sb.append((char)c);
                    c = 38;
                    sb.append(URLValueImpl.encode(uv.getSeriesParameterName()));
                    sb.append('=');
                    sb.append(URLValueImpl.encode(dph.getSeriesDisplayValue()));
                }
                uv.setBaseUrl(sb.toString());
            }
        }
    }

    protected final Bounds getCellBounds() {
        return this.getCellBounds(this.iSeriesIndex);
    }

    protected final Bounds getCellBounds(int seriesIndex) {
        Object obj = this.getComputations();
        Bounds bo = null;
        if (obj instanceof PlotWithoutAxes) {
            PlotWithoutAxes pwoa = (PlotWithoutAxes)obj;
            Coordinates co = pwoa.getCellCoordinates(seriesIndex - 1);
            Size sz = pwoa.getCellSize();
            bo = BoundsImpl.copyInstance(pwoa.getBounds());
            bo.setLeft(bo.getLeft() + (double)co.getColumn() * sz.getWidth());
            bo.setTop(bo.getTop() + (double)co.getRow() * sz.getHeight());
            bo.setWidth(sz.getWidth());
            bo.setHeight(sz.getHeight());
            bo = bo.adjustedInstance(pwoa.getCellInsets());
        } else if (obj instanceof PlotWithAxes) {
            PlotWithAxes pwa = (PlotWithAxes)obj;
            bo = BoundsImpl.copyInstance(pwa.getPlotBounds());
            bo = bo.adjustedInstance(pwa.getPlotInsets());
        }
        return bo;
    }

    protected final Bounds getPlotBounds() {
        Object obj = this.getComputations();
        Bounds bo = null;
        if (obj instanceof PlotWithoutAxes) {
            PlotWithoutAxes pwoa = (PlotWithoutAxes)obj;
            bo = BoundsImpl.copyInstance(pwoa.getBounds());
            bo = bo.adjustedInstance(pwoa.getCellInsets());
        } else if (obj instanceof PlotWithAxes) {
            PlotWithAxes pwa = (PlotWithAxes)obj;
            bo = BoundsImpl.copyInstance(pwa.getPlotBounds());
            bo = bo.adjustedInstance(pwa.getPlotInsets());
        }
        return bo;
    }

    public final void renderLabel(Object oSource, int iTextRenderType, Label laDataPoint, Position lp, Location lo, Bounds bo) throws ChartException {
        this.renderLabel(oSource, iTextRenderType, laDataPoint, lp, lo, bo, this.dc);
    }

    public final void renderLabel(Object oSource, int iTextRenderType, Label laDataPoint, Position lp, Location lo, Bounds bo, DeferredCache _dc) throws ChartException {
        IDeviceRenderer idr = this.getDevice();
        EventObjectCache eventObjectCache = (EventObjectCache)((Object)idr);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.birt.chart.event.TextRenderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TextRenderEvent tre = (TextRenderEvent)eventObjectCache.getEventObject(oSource, clazz);
        if (iTextRenderType != 3) {
            tre.setTextPosition(Methods.getLabelPosition(lp));
            tre.setLocation(lo);
        } else {
            tre.setBlockBounds(bo);
            tre.setBlockAlignment(null);
        }
        tre.setLabel(laDataPoint);
        tre.setAction(iTextRenderType);
        if (_dc == null) {
            this.dc.addLabel(tre);
        } else {
            _dc.addLabel(tre);
        }
    }

    protected void validateNullDatapoint(DataPointHints[] dphs) throws ChartException {
        if (dphs == null) {
            throw new ChartException("org.eclipse.birt.chart.engine", 30, "exception.base.orthogonal.null.datapoint", Messages.getResourceBundle(this.rtc.getULocale()));
        }
    }

    protected void validateDataSetCount(ISeriesRenderingHints isrh) throws ChartException {
        if ((isrh.getDataSetStructure() & 2) == 2) {
            throw new ChartException("org.eclipse.birt.chart.engine", 30, "exception.base.orthogonal.inconsistent.count", new Object[]{new Integer(isrh.getBaseDataSet().size()), new Integer(isrh.getOrthogonalDataSet().size())}, Messages.getResourceBundle(this.rtc.getULocale()));
        }
    }

    protected List filterNull(List ll) {
        ArrayList<double[]> al = new ArrayList<double[]>();
        int i = 0;
        while (i < ll.size()) {
            double[] obj = (double[])ll.get(i);
            if (obj != null && !Double.isNaN(obj[0]) && !Double.isNaN(obj[1])) {
                al.add(obj);
            }
            ++i;
        }
        return al;
    }

    protected Location[] filterNull(Location[] ll) {
        ArrayList<Location> al = new ArrayList<Location>();
        int i = 0;
        while (i < ll.length) {
            if (!Double.isNaN(ll[i].getX()) && !Double.isNaN(ll[i].getY())) {
                al.add(ll[i]);
            }
            ++i;
        }
        if (ll instanceof Location3D[]) {
            return al.toArray(new Location3D[al.size()]);
        }
        return al.toArray(new Location[al.size()]);
    }

    protected static boolean isNaN(Object value) {
        return value == null || value instanceof Number && Double.isNaN(((Number)value).doubleValue());
    }

    public boolean isRightToLeft() {
        if (this.rtc == null) {
            return false;
        }
        return this.rtc.isRightToLeft();
    }

    protected boolean isPaletteByCategory() {
        return this.cm.getLegend().getItemType().getValue() == 1;
    }

    public Anchor switchAnchor(Anchor anchor) {
        if (anchor != null && this.isRightToLeft()) {
            switch (anchor.getValue()) {
                case 2: {
                    anchor = Anchor.WEST_LITERAL;
                    break;
                }
                case 1: {
                    anchor = Anchor.NORTH_WEST_LITERAL;
                    break;
                }
                case 3: {
                    anchor = Anchor.SOUTH_WEST_LITERAL;
                    break;
                }
                case 6: {
                    anchor = Anchor.EAST_LITERAL;
                    break;
                }
                case 7: {
                    anchor = Anchor.NORTH_EAST_LITERAL;
                    break;
                }
                case 5: {
                    anchor = Anchor.SOUTH_EAST_LITERAL;
                }
            }
        }
        return anchor;
    }

    public Position switchPosition(Position po) {
        if (po != null && this.isRightToLeft()) {
            if (po == Position.RIGHT_LITERAL) {
                po = Position.LEFT_LITERAL;
            } else if (po == Position.LEFT_LITERAL) {
                po = Position.RIGHT_LITERAL;
            }
        }
        return po;
    }

    public TextAlignment switchTextAlignment(TextAlignment ta) {
        if (ta != null && this.isRightToLeft()) {
            if (ta.getHorizontalAlignment() == HorizontalAlignment.LEFT_LITERAL) {
                ta.setHorizontalAlignment(HorizontalAlignment.RIGHT_LITERAL);
            } else if (ta.getHorizontalAlignment() == HorizontalAlignment.RIGHT_LITERAL) {
                ta.setHorizontalAlignment(HorizontalAlignment.LEFT_LITERAL);
            }
        }
        return ta;
    }

    public boolean isInteractivityEnabled() {
        return this.cm.getInteractivity() == null || this.cm.getInteractivity().isEnable();
    }

    public int[] getFilteredMinSliceEntry(DataSetIterator dsi) {
        return null;
    }

    public void updateTranslucency(Fill fill, Series se) {
        if (se != null && se.isTranslucent()) {
            if (fill instanceof ColorDefinition) {
                ((ColorDefinition)fill).setTransparency((int)(OVERRIDE_TRANSPARENCY * 255.0 / 100.0));
            } else if (fill instanceof MultipleFill) {
                int i = 0;
                while (i < ((MultipleFill)fill).getFills().size()) {
                    this.updateTranslucency((Fill)((MultipleFill)fill).getFills().get(i), se);
                    ++i;
                }
            }
        }
    }

    public void setDeferredCacheManager(DeferredCacheManager dcm) {
        this.fDeferredCacheManager = dcm;
    }

    public DeferredCacheManager getDeferredCacheManager() {
        return this.fDeferredCacheManager;
    }

    protected final InteractionEvent createEvent(StructureSource iSource, List elTriggers, IPrimitiveRenderer ipr) {
        InteractionEvent iev = new InteractionEvent(iSource);
        int t = 0;
        while (t < elTriggers.size()) {
            Trigger tg = TriggerImpl.copyInstance((Trigger)elTriggers.get(t));
            this.processTrigger(tg, iSource);
            iev.addTrigger(tg);
            ++t;
        }
        return iev;
    }

    protected final void renderInteractivity(IPrimitiveRenderer ipr, DataPointHints dph, PrimitiveRenderEvent pre) throws ChartException {
        EList elTriggers;
        if (this.isInteractivityEnabled() && dph != null && !(elTriggers = this.getSeries().getTriggers()).isEmpty()) {
            StructureSource iSource = WrappedStructureSource.createSeriesDataPoint(this.getSeries(), dph);
            InteractionEvent iev = this.createEvent(iSource, (List)elTriggers, ipr);
            iev.setHotSpot(pre);
            ipr.enableInteraction(iev);
        }
    }

    protected final boolean isFirstVisibleSeries() {
        if (this.iSeriesIndex == 0) {
            return false;
        }
        int i = 1;
        while (i < this.iSeriesCount) {
            BaseRenderer renderer = this.getRenderer(i);
            if (renderer.getSeries().isVisible()) {
                return i == this.iSeriesIndex;
            }
            ++i;
        }
        return false;
    }

    protected final boolean isLastVisibleSeries() {
        if (this.iSeriesIndex == 0) {
            return false;
        }
        int i = this.iSeriesCount - 1;
        while (i > 0) {
            BaseRenderer renderer = this.getRenderer(i);
            if (renderer.getSeries().isVisible()) {
                return i == this.iSeriesIndex;
            }
            --i;
        }
        return false;
    }
}

