/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.group;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.data.engine.cache.CachedList;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.cache.SortSpec;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.group.GroupBoundaryInfo;
import org.eclipse.birt.data.engine.executor.transform.group.GroupBoundaryInfoComparator;
import org.eclipse.birt.data.engine.executor.transform.group.GroupBy;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInformationUtil;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultClass;

public class GroupCalculationUtil {
    private BaseQuery query;
    private IResultClass rsMeta;
    private GroupBy[] groupDefs;
    private ResultSetCache smartCache;
    private GroupInformationUtil groupInformationUtil;
    private ResultSetPopulator resultPopoulator;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.executor.transform.group.GroupCalculationUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    GroupCalculationUtil(BaseQuery query, IResultClass rsMeta, ResultSetPopulator resultPopoulator) throws DataException {
        this.query = query;
        this.rsMeta = rsMeta;
        this.groupInformationUtil = new GroupInformationUtil(this);
        this.resultPopoulator = resultPopoulator;
        this.initGroupSpec();
    }

    GroupCalculationUtil(InputStream inputStream, IResultClass rsMeta, ResultSetCache rsCache) throws DataException {
        try {
            this.groupInformationUtil.readGroupsFromStream(inputStream);
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Group Info");
        }
        this.rsMeta = rsMeta;
        this.smartCache = rsCache;
        this.initGroupSpec();
    }

    public GroupInformationUtil getGroupInformationUtil() {
        return this.groupInformationUtil;
    }

    public void doSave(OutputStream outputStream) throws DataException {
        try {
            this.groupInformationUtil.saveGroupsToStream(outputStream);
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, "Group Information");
        }
    }

    public void setResultSetCache(ResultSetCache rsc) {
        this.smartCache = rsc;
    }

    int getGroupCount() {
        return this.groupDefs.length;
    }

    void sortGroupBoundaryInfos(List[] groupArray) {
        int i = 0;
        while (i < groupArray.length) {
            Object[] toBeSorted = new Object[groupArray[i].size()];
            int j = 0;
            while (j < toBeSorted.length) {
                toBeSorted[j] = groupArray[i].get(j);
                ++j;
            }
            Arrays.sort(toBeSorted, new GroupBoundaryInfoComparator());
            groupArray[i].clear();
            j = 0;
            while (j < toBeSorted.length) {
                groupArray[i].add(toBeSorted[j]);
                ++j;
            }
            ++i;
        }
    }

    public BaseQuery getQuery() {
        return this.query;
    }

    List[] filterGroupBoundaryInfos(List[] groupArray) {
        List[] result = new List[groupArray.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new CachedList(GroupBoundaryInfo.getCreator());
            ++i;
        }
        i = 0;
        while (i < groupArray.length) {
            int j = 0;
            while (j < groupArray[i].size()) {
                if (((GroupBoundaryInfo)groupArray[i].get(j)).isAccpted()) {
                    result[i].add(groupArray[i].get(j));
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    GroupBy[] getGroupDefn() {
        return this.groupDefs;
    }

    ResultSetCache getResultSetCache() {
        return this.smartCache;
    }

    private void initGroupSpec() throws DataException {
        IQuery.GroupSpec[] groupSpecs = this.query.getGrouping();
        if (groupSpecs != null) {
            this.groupDefs = new GroupBy[groupSpecs.length];
            int i = 0;
            while (i < groupSpecs.length) {
                int keyIndex = groupSpecs[i].getKeyIndex();
                String keyColumn = groupSpecs[i].getKeyColumn();
                if (this.resultPopoulator.getEventHandler() != null && this.resultPopoulator.getEventHandler().isRowID(keyIndex, keyColumn)) {
                    this.groupDefs[i] = GroupBy.newInstanceForRowID(groupSpecs[i]);
                } else {
                    if (keyColumn != null) {
                        keyIndex = this.rsMeta.getFieldIndex(keyColumn);
                    }
                    if (keyIndex < 1 || keyIndex > this.rsMeta.getFieldCount()) {
                        throw new DataException("data.engine.InvalidGroupKeyName", keyColumn);
                    }
                    this.groupDefs[i] = GroupBy.newInstance(groupSpecs[i], keyIndex, keyColumn, this.rsMeta.getFieldValueClass(keyIndex));
                }
                ++i;
            }
        } else {
            this.groupDefs = new GroupBy[0];
        }
    }

    public SortSpec getSortSpec() throws DataException {
        if (!$assertionsDisabled && this.groupDefs == null) {
            throw new AssertionError();
        }
        int groupCount = 0;
        int sortCount = 0;
        int i = 0;
        while (i < this.groupDefs.length) {
            if (this.groupDefs[i].getColumnIndex() >= 0) {
                ++groupCount;
            }
            ++i;
        }
        if (this.query.getOrdering() != null) {
            sortCount = this.query.getOrdering().length;
        }
        int[] sortKeyIndexes = new int[groupCount + sortCount];
        String[] sortKeyColumns = new String[groupCount + sortCount];
        boolean[] sortAscending = new boolean[groupCount + sortCount];
        int i2 = 0;
        while (i2 < groupCount) {
            int index = this.groupDefs[i2].getColumnIndex();
            if (index >= 0) {
                sortKeyIndexes[i2] = this.groupDefs[i2].getColumnIndex();
                sortKeyColumns[i2] = this.groupDefs[i2].getColumnName();
                sortAscending[i2] = this.groupDefs[i2].getGroupSpec().getSortDirection() != 1;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < sortCount) {
            int keyIndex = this.query.getOrdering()[i2].getIndex();
            String keyName = this.query.getOrdering()[i2].getField();
            if (keyName != null) {
                keyIndex = this.rsMeta.getFieldIndex(keyName);
            }
            sortKeyIndexes[groupCount + i2] = keyIndex;
            sortKeyColumns[groupCount + i2] = keyName;
            sortAscending[groupCount + i2] = this.query.getOrdering()[i2].isAscendingOrder();
            ++i2;
        }
        return new SortSpec(sortKeyIndexes, sortKeyColumns, sortAscending);
    }
}

