/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.GroupComputedColumn;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Context;

class ComputedColumnHelperInstance {
    private DataSetRuntime dataSet;
    private List ccList = new ArrayList();
    private IComputedColumn[] computedColumn;
    private int[] columnIndexArray;
    private boolean isPrepared;
    protected static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.birt.data.engine.impl.ComputedColumnHelperInstance");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.ComputedColumnHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    public ComputedColumnHelperInstance(DataSetRuntime dataSet, List computedColumns) {
        int i = 0;
        while (i < computedColumns.size()) {
            this.ccList.add(computedColumns.get(i));
            ++i;
        }
        this.isPrepared = false;
        this.dataSet = dataSet;
    }

    public List getComputedColumnList() {
        return this.ccList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean process(IResultObject resultObject, int rowIndex) throws DataException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.birt.data.engine.impl.ComputedColumnHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        logger.entering(clazz.getName(), "process");
        if (!$assertionsDisabled && resultObject == null) {
            throw new AssertionError();
        }
        IResultClass resultClass = resultObject.getResultClass();
        if (!this.isPrepared) {
            this.prepare(resultClass);
        }
        if (this.computedColumn.length == 0) {
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("org.eclipse.birt.data.engine.impl.ComputedColumnHelper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz3 = class$0 = clazz4;
            }
            logger.exiting(clazz3.getName(), "process");
            return true;
        }
        this.dataSet.setRowObject(resultObject, true);
        this.dataSet.setCurrentRowIndex(rowIndex);
        Context cx = Context.enter();
        try {
            int i = 0;
            while (i < this.computedColumn.length) {
                if (this.computedColumn[i].getExpression() == null) {
                    throw new DataException("data.engine.BadCompColExpr", resultObject.getResultClass().getFieldName(this.columnIndexArray[i]));
                }
                Object value = null;
                try {
                    if (this.computedColumn[i].getExpression().getHandle() != null) {
                        value = ((CompiledExpression)this.computedColumn[i].getExpression().getHandle()).evaluate(cx, this.dataSet.getScriptScope());
                    } else {
                        String exprText = ((IScriptExpression)this.computedColumn[i].getExpression()).getText();
                        if (exprText != null) {
                            value = ScriptEvalUtil.evaluateJSAsExpr(cx, this.dataSet.getJSDataSetObject(), exprText, "ComputedColumn", 0);
                        }
                    }
                    if (this.computedColumn[i] instanceof GroupComputedColumn) {
                        try {
                            value = ((GroupComputedColumn)this.computedColumn[i]).calculate(value);
                        }
                        catch (BirtException e) {
                            throw DataException.wrap(e);
                        }
                    }
                    value = DataTypeUtil.convert((Object)value, (Class)resultClass.getFieldValueClass(this.columnIndexArray[i]));
                }
                catch (BirtException birtException) {
                    if (resultClass.wasAnyType(this.columnIndexArray[i])) {
                        throw new DataException("data.engine.possibleMixedDataTypeInColumn");
                    }
                    String fieldName = resultClass.getFieldName(this.columnIndexArray[i]);
                    if (fieldName != null && fieldName.startsWith("_{$TEMP_")) {
                        throw new DataException("data.engine.ScriptResult.WrongDataType", new Object[]{resultClass.getFieldValueClass(this.columnIndexArray[i]).getName(), value == null ? value : value.toString()});
                    }
                    throw new DataException("data.engine.CompCol.WrongDataType", new Object[]{resultClass.getFieldName(this.columnIndexArray[i]), resultClass.getFieldValueClass(this.columnIndexArray[i]).getName(), value == null ? value : value.toString()});
                }
                resultObject.setCustomFieldValue(this.columnIndexArray[i], value);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            Context.exit();
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        Context.exit();
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            Class<?> clazz6;
            try {
                clazz6 = Class.forName("org.eclipse.birt.data.engine.impl.ComputedColumnHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz5 = class$0 = clazz6;
        }
        logger.exiting(clazz5.getName(), "process");
        return true;
    }

    public void setRePrepare(boolean rePrepare) {
        this.isPrepared = !rePrepare;
    }

    private void prepare(IResultClass resultClass) throws DataException {
        if (!$assertionsDisabled && resultClass == null) {
            throw new AssertionError();
        }
        ArrayList<Integer> cmptList = new ArrayList<Integer>();
        int i = 0;
        while (i < this.ccList.size()) {
            IComputedColumn cmptdColumn = (IComputedColumn)this.ccList.get(i);
            int cmptdColumnIdx = resultClass.getFieldIndex(cmptdColumn.getName());
            if (cmptdColumnIdx >= 1 && resultClass.isCustomField(cmptdColumnIdx)) {
                cmptList.add(new Integer(i));
            }
            ++i;
        }
        int size = cmptList.size();
        this.columnIndexArray = new int[size];
        this.computedColumn = new IComputedColumn[size];
        int i2 = 0;
        while (i2 < size) {
            IComputedColumn cmptdColumn;
            int pos = (Integer)cmptList.get(i2);
            this.computedColumn[i2] = cmptdColumn = (IComputedColumn)this.ccList.get(pos);
            this.columnIndexArray[i2] = resultClass.getFieldIndex(cmptdColumn.getName());
            ++i2;
        }
        this.isPrepared = true;
    }
}

