/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.group;

import com.ibm.icu.util.Calendar;
import java.util.Date;

class DateTimeUtil {
    private static final long serialVersionUID = 1L;

    DateTimeUtil() {
    }

    private static int year(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        return DateTimeUtil.getCalendar(d).get(1);
    }

    private static int quarter(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        int month = DateTimeUtil.getCalendar(d).get(2);
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                return 1;
            }
            case 3: 
            case 4: 
            case 5: {
                return 2;
            }
            case 6: 
            case 7: 
            case 8: {
                return 3;
            }
            case 9: 
            case 10: 
            case 11: {
                return 4;
            }
        }
        return -1;
    }

    private static int month(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        return DateTimeUtil.getCalendar(d).get(2) + 1;
    }

    private static String weekDay(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        return String.valueOf(DateTimeUtil.getCalendar(d).get(7));
    }

    static int diffYear(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        int startYear = DateTimeUtil.year(d1);
        int endYear = DateTimeUtil.year(d2);
        return endYear - startYear;
    }

    static int diffMonth(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        int startMonth = DateTimeUtil.year(d1) * 12 + DateTimeUtil.month(d1);
        int endMonth = DateTimeUtil.year(d2) * 12 + DateTimeUtil.month(d2);
        return endMonth - startMonth;
    }

    static int diffQuarter(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        int startQuter = DateTimeUtil.year(d1) * 4 + DateTimeUtil.quarter(d1);
        int endQuter = DateTimeUtil.year(d2) * 4 + DateTimeUtil.quarter(d2);
        return endQuter - startQuter;
    }

    static long diffWeek(Date d1, Date d2) {
        Calendar c = DateTimeUtil.getClearedCalendarInstance(0, 0, 7);
        Date baseDay = new Date(c.getTimeInMillis());
        int diffDay = 1 - Integer.valueOf(DateTimeUtil.weekDay(baseDay));
        baseDay = DateTimeUtil.addDay(baseDay, diffDay);
        return (DateTimeUtil.diffSecond(baseDay, d2) + 1814400000L) / 604800L - (DateTimeUtil.diffSecond(baseDay, d1) + 1814400000L) / 604800L;
    }

    static long diffDay(Date d1, Date d2) {
        Calendar c = DateTimeUtil.getClearedCalendarInstance(0, 0, 1);
        return (DateTimeUtil.diffSecond(new Date(c.getTimeInMillis()), d2) + 1814400000L) / 86400L - (DateTimeUtil.diffSecond(new Date(c.getTimeInMillis()), d1) + 1814400000L) / 86400L;
    }

    private static Calendar getClearedCalendarInstance(int year, int month, int date) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(year, month, date);
        return c;
    }

    static long diffHour(Date d1, Date d2) {
        Calendar c = DateTimeUtil.getClearedCalendarInstance(0, 0, 1);
        return (DateTimeUtil.diffSecond(new Date(c.getTimeInMillis()), d2) + 1814400000L) / 3600L - (DateTimeUtil.diffSecond(new Date(c.getTimeInMillis()), d1) + 1814400000L) / 3600L;
    }

    static long diffMinute(Date d1, Date d2) {
        Calendar c = DateTimeUtil.getClearedCalendarInstance(0, 0, 1);
        return (DateTimeUtil.diffSecond(new Date(c.getTimeInMillis()), d2) + 1814400000L) / 60L - (DateTimeUtil.diffSecond(new Date(c.getTimeInMillis()), d1) + 1814400000L) / 60L;
    }

    static long diffSecond(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        long diff = d2.getTime() - d1.getTime();
        return new Long(diff / 1000L);
    }

    private static Date addDay(Date date, int num) {
        Calendar startCal = DateTimeUtil.getCalendar(date);
        startCal.add(5, num);
        return startCal.getTime();
    }

    private static Calendar getCalendar(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c;
    }
}

