/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.document;

import java.io.File;
import java.io.IOException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.document.BufferedRandomDataAccessObject;
import org.eclipse.birt.data.engine.olap.data.document.DocumentObject;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentObject;
import org.eclipse.birt.data.engine.olap.data.document.SimpleRandomAccessObject;

public class DirectoryDocumentManager
implements IDocumentManager {
    private String documentDir = null;

    public DirectoryDocumentManager(String documentDir, boolean deleteOld) throws DataException {
        this.documentDir = documentDir;
        File dir = new File(documentDir);
        if (!(dir.exists() && dir.isDirectory() || dir.mkdir())) {
            throw new DataException("data.olap.OlapDirCreateFail", documentDir);
        }
        if (deleteOld) {
            File[] oldFiles = dir.listFiles();
            int i = 0;
            while (i < oldFiles.length) {
                oldFiles[i].delete();
                ++i;
            }
        }
    }

    public void close() throws IOException {
    }

    public IDocumentObject createDocumentObject(String documentObjectName) throws IOException {
        File file = new File(String.valueOf(this.documentDir) + File.separatorChar + documentObjectName);
        if (file.exists()) {
            return null;
        }
        if (!file.createNewFile()) {
            return null;
        }
        return new DocumentObject(new BufferedRandomDataAccessObject(new SimpleRandomAccessObject(file, "rw"), 1024));
    }

    public IDocumentObject openDocumentObject(String documentObjectName) throws IOException {
        File file = new File(String.valueOf(this.documentDir) + File.separatorChar + documentObjectName);
        if (!file.exists()) {
            return null;
        }
        return new DocumentObject(new BufferedRandomDataAccessObject(new SimpleRandomAccessObject(file, "rw"), 1024));
    }

    public boolean exist(String documentObjectName) {
        File file = new File(String.valueOf(this.documentDir) + File.separatorChar + documentObjectName);
        return file.exists();
    }

    public void flush() throws IOException {
    }
}

