/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.impl.query;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IMeasureDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.EdgeDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.MeasureDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.NamedObject;

public class CubeQueryDefinition
extends NamedObject
implements ICubeQueryDefinition {
    private IEdgeDefinition columnEdge;
    private IEdgeDefinition rowEdge;
    private List measureList;
    private List bindingList = new ArrayList();
    private List filterList;
    private List sortList;
    private String queryResultsID;
    private boolean cacheQueryResults = false;
    private int breakHierarchyOption = 0;

    public CubeQueryDefinition(String name) {
        super(name);
        this.measureList = new ArrayList();
        this.filterList = new ArrayList();
        this.sortList = new ArrayList();
    }

    public void addBinding(IBinding binding) {
        this.bindingList.add(binding);
    }

    public void addFilter(IFilterDefinition filterDefn) {
        this.filterList.add(filterDefn);
    }

    public void addSort(ISortDefinition sortDefn) {
        this.sortList.add(sortDefn);
    }

    public IEdgeDefinition createEdge(int type) {
        if (type == 2) {
            this.columnEdge = new EdgeDefinition("COLUMN_EDGE");
            return this.columnEdge;
        }
        if (type == 1) {
            this.rowEdge = new EdgeDefinition("ROW_EDGE");
            return this.rowEdge;
        }
        return null;
    }

    public IMeasureDefinition createMeasure(String name) {
        MeasureDefinition measureDfn = new MeasureDefinition(name);
        this.measureList.add(measureDfn);
        return measureDfn;
    }

    public List getBindings() {
        return this.bindingList;
    }

    public IEdgeDefinition getEdge(int type) {
        if (type == 2) {
            return this.columnEdge;
        }
        if (type == 1) {
            return this.rowEdge;
        }
        return null;
    }

    public List getFilters() {
        return this.filterList;
    }

    public List getMeasures() {
        return this.measureList;
    }

    public List getSorts() {
        return this.sortList;
    }

    public String getQueryResultsID() {
        return this.queryResultsID;
    }

    public void setQueryResultsID(String queryResultsID) {
        this.queryResultsID = queryResultsID;
    }

    public boolean cacheQueryResults() {
        return this.cacheQueryResults;
    }

    public void setCacheQueryResults(boolean cacheQueryResults) {
        this.cacheQueryResults = cacheQueryResults;
    }

    public int getFilterOption() {
        return this.breakHierarchyOption;
    }

    public void setFilterOption(int breakHierarchyOption) {
        this.breakHierarchyOption = breakHierarchyOption;
    }
}

