/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.impl.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeSortDefinition;
import org.eclipse.birt.data.engine.olap.util.filter.BaseDimensionFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IJSFilterHelper;
import org.mozilla.javascript.Scriptable;

public class CubeQueryExecutor {
    private ICubeQueryDefinition defn;
    private Scriptable scope;
    private DataEngineSession session;
    private DataEngineContext context;
    private String queryResultsId;

    public CubeQueryExecutor(ICubeQueryDefinition defn, DataEngineSession session, Scriptable scope, DataEngineContext context) {
        this.defn = defn;
        this.scope = scope;
        this.context = context;
        this.session = session;
    }

    public List getDimensionFilterEvalHelpers() throws DataException {
        List filters = this.defn.getFilters();
        ArrayList<IJSFilterHelper> results = new ArrayList<IJSFilterHelper>();
        int i = 0;
        while (i < filters.size()) {
            results.add(BaseDimensionFilterEvalHelper.createFilterHelper(this.scope, this.defn, (IFilterDefinition)filters.get(i)));
            ++i;
        }
        return results;
    }

    public ICubeQueryDefinition getCubeQueryDefinition() {
        return this.defn;
    }

    public DataEngineSession getSession() {
        return this.session;
    }

    public DataEngineContext getContext() {
        return this.context;
    }

    public List getColumnEdgeSort() {
        return this.getEdgeSort(2);
    }

    public List getRowEdgeSort() {
        return this.getEdgeSort(1);
    }

    public String getQueryResultsId() {
        return this.queryResultsId;
    }

    public void setQueryResultsId(String id) {
        this.queryResultsId = id;
    }

    private List getEdgeSort(int edgeType) {
        List l = this.defn.getSorts();
        ArrayList<ICubeSortDefinition> result = new ArrayList<ICubeSortDefinition>();
        int i = 0;
        while (i < l.size()) {
            ICubeSortDefinition sort = (ICubeSortDefinition)l.get(i);
            if (this.defn.getEdge(edgeType) != null && this.defn.getEdge(edgeType).getDimensions().contains(sort.getTargetLevel().getHierarchy().getDimension())) {
                result.add(sort);
            }
            ++i;
        }
        Collections.sort(result, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                int level2;
                int level1 = ((ICubeSortDefinition)arg0).getTargetLevel().getHierarchy().getLevels().indexOf(((ICubeSortDefinition)arg0).getTargetLevel());
                if (level1 == (level2 = ((ICubeSortDefinition)arg1).getTargetLevel().getHierarchy().getLevels().indexOf(((ICubeSortDefinition)arg1).getTargetLevel()))) {
                    return 0;
                }
                if (level1 < level2) {
                    return -1;
                }
                return 1;
            }
        });
        return result;
    }
}

