/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IMeasureDefinition;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionCompiler;

public class OlapQueryUtil {
    public static List validateBinding(ICubeQueryDefinition queryDefn, boolean suppressException) throws DataException {
        ArrayList<IBinding> result = new ArrayList<IBinding>();
        HashSet<String> validMeasures = new HashSet<String>();
        int i = 0;
        while (i < queryDefn.getMeasures().size()) {
            IMeasureDefinition measure = (IMeasureDefinition)queryDefn.getMeasures().get(i);
            validMeasures.add(measure.getName());
            ++i;
        }
        HashSet validDimLevels = new HashSet();
        OlapQueryUtil.populateLevel(queryDefn, validDimLevels, 2);
        OlapQueryUtil.populateLevel(queryDefn, validDimLevels, 1);
        int i2 = 0;
        while (i2 < queryDefn.getBindings().size()) {
            String measureName;
            boolean isValid = true;
            IBinding binding = (IBinding)queryDefn.getBindings().get(i2);
            Set levels = OlapExpressionCompiler.getReferencedDimLevel(binding.getExpression(), queryDefn.getBindings());
            if (!validDimLevels.containsAll(levels)) {
                isValid = false;
                if (!suppressException) {
                    throw new DataException("data.olap.invalidBindingReferToInexitDim", binding.getBindingName());
                }
            }
            if ((measureName = OlapExpressionCompiler.getReferencedScriptObject(binding.getExpression(), "measure")) != null && !validMeasures.contains(measureName)) {
                isValid = false;
                if (!suppressException) {
                    throw new DataException("data.olap.invalidBindingReferToInexitMeasure", binding.getBindingName());
                }
            }
            if (binding.getAggregatOns().size() > 0 && binding.getAggrFunction() == null) {
                isValid = false;
                if (!suppressException) {
                    throw new DataException("data.olap.invalidBindingMissingAggrFunc", binding.getBindingName());
                }
            }
            if (!isValid) {
                result.add(binding);
            }
            ++i2;
        }
        return result;
    }

    private static void populateLevel(ICubeQueryDefinition queryDefn, Set validDimLevels, int edgeType) {
        if (queryDefn.getEdge(edgeType) == null) {
            return;
        }
        int i = 0;
        while (i < queryDefn.getEdge(edgeType).getDimensions().size()) {
            int j = 0;
            while (j < OlapQueryUtil.getHierarchy(queryDefn, edgeType, i).getLevels().size()) {
                ILevelDefinition level = (ILevelDefinition)OlapQueryUtil.getHierarchy(queryDefn, edgeType, i).getLevels().get(j);
                validDimLevels.add(new DimLevel(OlapQueryUtil.getDimension(queryDefn, edgeType, i).getName(), level.getName()));
                ++j;
            }
            ++i;
        }
    }

    private static IHierarchyDefinition getHierarchy(ICubeQueryDefinition queryDefn, int edgeType, int i) {
        return (IHierarchyDefinition)OlapQueryUtil.getDimension(queryDefn, edgeType, i).getHierarchy().get(0);
    }

    private static IDimensionDefinition getDimension(ICubeQueryDefinition queryDefn, int edgeType, int i) {
        return (IDimensionDefinition)queryDefn.getEdge(edgeType).getDimensions().get(i);
    }
}

