/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util.filter;

import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.script.OLAPExpressionCompiler;
import org.eclipse.birt.data.engine.olap.util.filter.IFacttableRow;
import org.eclipse.birt.data.engine.olap.util.filter.IJSMeasureFilterEvalHelper;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JSMeasureFilterEvalHelper
implements IJSMeasureFilterEvalHelper {
    private ScriptableObject scope;
    private DummyMeasureObject dataObj;
    private IBaseExpression expr;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.util.filter.JSMeasureFilterEvalHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSMeasureFilterEvalHelper(Scriptable parentScope, IFilterDefinition cubeFilter) throws DataException {
        if (!$assertionsDisabled && cubeFilter == null) {
            throw new AssertionError();
        }
        Context cx = Context.enter();
        try {
            this.initialize(parentScope, cubeFilter, cx);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            Context.exit();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        Context.exit();
    }

    private void initialize(Scriptable parentScope, IFilterDefinition cubeFilter, Context cx) {
        this.scope = cx.initStandardObjects();
        this.scope.setParentScope(parentScope);
        this.dataObj = new DummyMeasureObject();
        this.expr = cubeFilter.getExpression();
        OLAPExpressionCompiler.compile(cx, this.expr);
        this.scope.put("measure", (Scriptable)this.scope, (Object)this.dataObj);
    }

    public boolean evaluateFilter(IFacttableRow facttableRow) throws DataException {
        boolean bl;
        this.dataObj.setCurrentRow(facttableRow);
        Context cx = Context.enter();
        try {
            Object result = ScriptEvalUtil.evalExpr(this.expr, cx, (Scriptable)this.scope, null, 0);
            bl = DataTypeUtil.toBoolean((Object)result);
            Object var4_6 = null;
        }
        catch (BirtException e) {
            try {
                throw DataException.wrap(e);
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                Context.exit();
                throw throwable;
            }
        }
        Context.exit();
        return bl;
    }

    private class DummyMeasureObject
    extends ScriptableObject {
        private IFacttableRow row;

        private DummyMeasureObject() {
        }

        public String getClassName() {
            return "DummyMeasureObject";
        }

        public void setCurrentRow(IFacttableRow row) {
            this.row = row;
        }

        public Object get(String measureName, Scriptable scope) {
            try {
                return this.row.getMeasureValue(measureName);
            }
            catch (DataException dataException) {
                return null;
            }
        }
    }
}

