/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.FilterConditionElementHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.olap.HierarchyHandle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.elements.ImageItem;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.parser.ActionStructureState;
import org.eclipse.birt.report.model.parser.DesignReader;
import org.eclipse.birt.report.model.parser.GenericModuleReader;
import org.eclipse.birt.report.model.parser.LibraryReader;
import org.eclipse.birt.report.model.parser.ModuleParserErrorHandler;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.DataTypeConversionUtil;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.VersionInfo;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.eclipse.birt.report.model.util.XMLParserHandler;
import org.eclipse.birt.report.model.writer.IndentableXMLWriter;
import org.eclipse.birt.report.model.writer.ModuleWriter;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ModuleUtil {
    public static final int LIBRARY = 0;
    public static final int REPORT_DESIGN = 1;
    public static final int INVALID_MODULE = 2;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.api.ModuleUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static ActionHandle deserializeAction(InputStream streamData) throws DesignFileException {
        return ModuleUtil.deserializeAction(streamData, null);
    }

    public static ActionHandle deserializeAction(InputStream streamData, DesignElementHandle element) throws DesignFileException {
        Module module;
        ImageItem image = new ImageItem();
        DesignElement e = element == null ? image : element.getElement();
        ActionParserHandler handler = new ActionParserHandler(image);
        Module module2 = module = element == null ? handler.getModule() : element.getModule();
        if (streamData == null) {
            Action action = StructureFactory.createAction();
            e.setProperty("action", (Object)action);
            action.setContext(new StructureContext(e, "action"));
            return ModuleUtil.getActionHandle(e.getHandle(module));
        }
        if (!streamData.markSupported()) {
            streamData = new BufferedInputStream(streamData);
        }
        if (!$assertionsDisabled && !streamData.markSupported()) {
            throw new AssertionError();
        }
        ModuleUtil.parse(handler, streamData, "");
        if (element != null) {
            Action action = (Action)image.getProperty(handler.getModule(), "action");
            e.setProperty("action", (Object)action);
            action.setContext(new StructureContext(e, "action"));
        }
        return ModuleUtil.getActionHandle(e.getHandle(module));
    }

    private static ActionHandle getActionHandle(DesignElementHandle element) {
        PropertyHandle propHandle = element.getPropertyHandle("action");
        Action action = (Action)propHandle.getValue();
        if (action == null) {
            return null;
        }
        return (ActionHandle)action.getHandle(propHandle);
    }

    private static void parse(XMLParserHandler handler, InputStream streamData, String filename) throws DesignFileException {
        try {
            ModelUtil.checkUTFSignature(streamData, filename);
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            SAXParser parser = saxParserFactory.newSAXParser();
            InputSource inputSource = new InputSource(streamData);
            inputSource.setEncoding("UTF-8");
            parser.parse(inputSource, (DefaultHandler)handler);
        }
        catch (SAXException e) {
            List errors = handler.getErrorHandler().getErrors();
            if (e.getException() instanceof DesignFileException) {
                throw (DesignFileException)((Object)e.getException());
            }
            throw new DesignFileException(null, errors, e);
        }
        catch (ParserConfigurationException e) {
            throw new DesignFileException(null, handler.getErrorHandler().getErrors(), e);
        }
        catch (IOException e) {
            throw new DesignFileException(null, handler.getErrorHandler().getErrors(), e);
        }
    }

    public static ActionHandle deserializeAction(String strData) throws DesignFileException {
        return ModuleUtil.deserializeAction(strData, null);
    }

    public static ActionHandle deserializeAction(String strData, DesignElementHandle element) throws DesignFileException {
        ByteArrayInputStream is;
        block3: {
            is = null;
            String streamToOpen = StringUtil.trimString(strData);
            if (streamToOpen != null) {
                try {
                    is = new ByteArrayInputStream(streamToOpen.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
        return ModuleUtil.deserializeAction(is, element);
    }

    public static String serializeAction(ActionHandle action) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ActionWriter writer = new ActionWriter();
        writer.write(os, (Action)action.getStructure());
        try {
            return os.toString("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return os.toString();
        }
    }

    public static boolean isValidDesign(SessionHandle sessionHandle, String fileName, InputStream is) {
        ReportDesign design = null;
        try {
            ModuleOption options = new ModuleOption();
            options.setSemanticCheck(false);
            design = DesignReader.getInstance().read(sessionHandle.getSession(), fileName, is, options);
            return design != null;
        }
        catch (DesignFileException designFileException) {
            return false;
        }
    }

    public static boolean isValidLibrary(SessionHandle sessionHandle, String fileName, InputStream is) {
        Library lib = null;
        try {
            ModuleOption options = new ModuleOption();
            options.setSemanticCheck(false);
            lib = LibraryReader.getInstance().read(sessionHandle.getSession(), fileName, is, options);
            return lib != null;
        }
        catch (DesignFileException designFileException) {
            return false;
        }
    }

    public static int checkModule(SessionHandle sessionHandle, String fileName, InputStream is) {
        Module rtnModule = null;
        try {
            ModuleOption options = new ModuleOption();
            options.setSemanticCheck(false);
            rtnModule = GenericModuleReader.getInstance().read(sessionHandle.getSession(), fileName, is, options);
        }
        catch (DesignFileException designFileException) {
            return 2;
        }
        return rtnModule instanceof Library ? 0 : 1;
    }

    private static List checkVersion(InputStream streamData, String filename) throws DesignFileException {
        VersionParserHandler handler = new VersionParserHandler();
        InputStream inputStreamToParse = streamData;
        if (!inputStreamToParse.markSupported()) {
            inputStreamToParse = new BufferedInputStream(streamData);
        }
        ModuleUtil.parse(handler, inputStreamToParse, filename);
        return ModelUtil.checkVersion(handler.version);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List checkVersion(String fileName) {
        ArrayList<VersionInfo> rtnList = new ArrayList<VersionInfo>();
        InputStream inputStream = null;
        try {
            URL url = new URL(fileName);
            inputStream = url.openStream();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            rtnList.add(new VersionInfo(null, 0));
            return rtnList;
        }
        if (inputStream == null) {
            try {
                inputStream = new FileInputStream(fileName);
            }
            catch (FileNotFoundException fileNotFoundException) {
                rtnList.add(new VersionInfo(null, 0));
                return rtnList;
            }
        }
        try {
            try {
                inputStream = new BufferedInputStream(inputStream);
                rtnList.addAll(ModuleUtil.checkVersion(inputStream, fileName));
            }
            catch (DesignFileException designFileException) {
                rtnList.add(new VersionInfo(null, 0));
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (IOException iOException) {
            return rtnList;
        }
        inputStream.close();
        return rtnList;
    }

    public static String getExternalizedValue(DesignElementHandle element, String key, String value, ULocale locale) {
        if (element == null) {
            return value;
        }
        DesignElement tmpElement = element.getElement();
        while (tmpElement != null) {
            Module root = tmpElement.getRoot();
            if (root == null) break;
            String externalizedText = root.getMessage(key, locale);
            if (externalizedText != null) {
                return externalizedText;
            }
            tmpElement = !tmpElement.isVirtualElement() ? tmpElement.getExtendsElement() : tmpElement.getVirtualParent();
        }
        return value;
    }

    public static boolean isEqualHierarchiesForJointCondition(HierarchyHandle conditionHierarchy, HierarchyHandle cubeHierarchy) {
        if (conditionHierarchy == cubeHierarchy) {
            return true;
        }
        if (conditionHierarchy != null && cubeHierarchy != null) {
            if (conditionHierarchy.equals(cubeHierarchy)) {
                return true;
            }
            DesignElement virtualParent = cubeHierarchy.getElement().getVirtualParent();
            if (virtualParent == null) {
                return false;
            }
            return conditionHierarchy.getElement().equals(virtualParent);
        }
        return false;
    }

    public static boolean isValidElementName(DesignElementHandle elementHandle, String propName, String nameValue) {
        ModuleHandle module = elementHandle.getModuleHandle();
        PropertyDefn propDefn = (PropertyDefn)((Object)elementHandle.getPropertyDefn(propName));
        if (propDefn == null) {
            return false;
        }
        PropertyType propType = propDefn.getType();
        if (propType.getTypeCode() != 13) {
            return false;
        }
        ElementDefn metaData = (ElementDefn)elementHandle.getDefn();
        if ((nameValue == null || StringUtil.isEmpty(nameValue)) && metaData.getNameOption() == 2) {
            return false;
        }
        try {
            propType.validateValue(module.getModule(), propDefn, nameValue);
            DesignElement existedElement = new NameExecutor(elementHandle.getElement()).getNameSpace(elementHandle.module).getElement(nameValue);
            return existedElement == null;
        }
        catch (PropertyValueException propertyValueException) {
            return false;
        }
    }

    public static boolean isValidElementName(DesignElementHandle elementHandle) {
        return ModuleUtil.isValidElementName(elementHandle, "name", elementHandle.getName());
    }

    public static boolean isListFilterValue(FilterConditionHandle filter) {
        if (filter == null) {
            return false;
        }
        return "in".equals(filter.getOperator());
    }

    public static boolean isListFilterValue(FilterConditionElementHandle filter) {
        if (filter == null) {
            return false;
        }
        return "in".equals(filter.getOperator());
    }

    public static String convertParamTypeToColumnType(String type) {
        return DataTypeConversionUtil.converToColumnDataType(type);
    }

    public static String convertColumnTypeToParamType(String type) {
        return DataTypeConversionUtil.converToParamType(type);
    }

    private static class ActionParserHandler
    extends ModuleParserHandler {
        DesignElement element = null;

        public ActionParserHandler(DesignElement element) {
            super(null, null);
            this.element = element;
            this.module = new ReportDesign(null);
            this.setVersionNumber(3021500);
        }

        public AbstractParseState createStartState() {
            return new StartState();
        }

        class StartState
        extends XMLParserHandler.InnerParseState {
            StartState() {
                super(ActionParserHandler.this);
            }

            public AbstractParseState startElement(String tagName) {
                if ("structure".equalsIgnoreCase(tagName)) {
                    return new ActionStructureState(ActionParserHandler.this, ActionParserHandler.this.element);
                }
                return super.startElement(tagName);
            }
        }
    }

    private static class ActionWriter
    extends ModuleWriter {
        private ActionWriter() {
        }

        public void write(OutputStream os, Action action) throws IOException {
            this.writer = new SectionXMLWriter(os, "UTF-8");
            this.writeAction(action, "action");
        }

        protected Module getModule() {
            return null;
        }
    }

    private static class SectionXMLWriter
    extends IndentableXMLWriter {
        public SectionXMLWriter(OutputStream os, String signature) throws IOException {
            this.out = new PrintStream(os, false, "UTF-8");
        }
    }

    private static class VersionParserHandler
    extends XMLParserHandler {
        private String version = null;

        public VersionParserHandler() {
            super(new ModuleParserErrorHandler());
        }

        public AbstractParseState createStartState() {
            return new StartState();
        }

        class StartState
        extends XMLParserHandler.InnerParseState {
            StartState() {
                super(VersionParserHandler.this);
            }

            public AbstractParseState startElement(String tagName) {
                if ("report".equalsIgnoreCase(tagName) || "library".equalsIgnoreCase(tagName)) {
                    return new VersionState();
                }
                return super.startElement(tagName);
            }
        }

        class VersionState
        extends XMLParserHandler.InnerParseState {
            VersionState() {
                super(VersionParserHandler.this);
            }

            public void parseAttrs(Attributes attrs) throws XMLParserException {
                String version = attrs.getValue("version");
                VersionParserHandler.this.version = version;
            }

            public void end() throws SAXException {
            }
        }
    }
}

