/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.BitField;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class AxisOptionsRecord
extends Record {
    public static final short sid = 4194;
    private short field_1_minimumCategory;
    private short field_2_maximumCategory;
    private short field_3_majorUnitValue;
    private short field_4_majorUnit;
    private short field_5_minorUnitValue;
    private short field_6_minorUnit;
    private short field_7_baseUnit;
    private short field_8_crossingPoint;
    private short field_9_options;
    private BitField defaultMinimum = new BitField(1);
    private BitField defaultMaximum = new BitField(2);
    private BitField defaultMajor = new BitField(4);
    private BitField defaultMinorUnit = new BitField(8);
    private BitField isDate = new BitField(16);
    private BitField defaultBase = new BitField(32);
    private BitField defaultCross = new BitField(64);
    private BitField defaultDateSettings = new BitField(128);

    public AxisOptionsRecord() {
    }

    public AxisOptionsRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public AxisOptionsRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 4194) {
            throw new RecordFormatException("Not a AxisOptions record");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        int pos = 0;
        this.field_1_minimumCategory = LittleEndian.getShort(data, pos + 0 + offset);
        this.field_2_maximumCategory = LittleEndian.getShort(data, pos + 2 + offset);
        this.field_3_majorUnitValue = LittleEndian.getShort(data, pos + 4 + offset);
        this.field_4_majorUnit = LittleEndian.getShort(data, pos + 6 + offset);
        this.field_5_minorUnitValue = LittleEndian.getShort(data, pos + 8 + offset);
        this.field_6_minorUnit = LittleEndian.getShort(data, pos + 10 + offset);
        this.field_7_baseUnit = LittleEndian.getShort(data, pos + 12 + offset);
        this.field_8_crossingPoint = LittleEndian.getShort(data, pos + 14 + offset);
        this.field_9_options = LittleEndian.getShort(data, pos + 16 + offset);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[AXCEXT]\n");
        buffer.append("    .minimumCategory      = ").append("0x").append(HexDump.toHex(this.getMinimumCategory())).append(" (").append(this.getMinimumCategory()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .maximumCategory      = ").append("0x").append(HexDump.toHex(this.getMaximumCategory())).append(" (").append(this.getMaximumCategory()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .majorUnitValue       = ").append("0x").append(HexDump.toHex(this.getMajorUnitValue())).append(" (").append(this.getMajorUnitValue()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .majorUnit            = ").append("0x").append(HexDump.toHex(this.getMajorUnit())).append(" (").append(this.getMajorUnit()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .minorUnitValue       = ").append("0x").append(HexDump.toHex(this.getMinorUnitValue())).append(" (").append(this.getMinorUnitValue()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .minorUnit            = ").append("0x").append(HexDump.toHex(this.getMinorUnit())).append(" (").append(this.getMinorUnit()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .baseUnit             = ").append("0x").append(HexDump.toHex(this.getBaseUnit())).append(" (").append(this.getBaseUnit()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .crossingPoint        = ").append("0x").append(HexDump.toHex(this.getCrossingPoint())).append(" (").append(this.getCrossingPoint()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .options              = ").append("0x").append(HexDump.toHex(this.getOptions())).append(" (").append(this.getOptions()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("         .defaultMinimum           = ").append(this.isDefaultMinimum()).append('\n');
        buffer.append("         .defaultMaximum           = ").append(this.isDefaultMaximum()).append('\n');
        buffer.append("         .defaultMajor             = ").append(this.isDefaultMajor()).append('\n');
        buffer.append("         .defaultMinorUnit         = ").append(this.isDefaultMinorUnit()).append('\n');
        buffer.append("         .isDate                   = ").append(this.isIsDate()).append('\n');
        buffer.append("         .defaultBase              = ").append(this.isDefaultBase()).append('\n');
        buffer.append("         .defaultCross             = ").append(this.isDefaultCross()).append('\n');
        buffer.append("         .defaultDateSettings      = ").append(this.isDefaultDateSettings()).append('\n');
        buffer.append("[/AXCEXT]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)4194);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset + pos, this.field_1_minimumCategory);
        LittleEndian.putShort(data, 6 + offset + pos, this.field_2_maximumCategory);
        LittleEndian.putShort(data, 8 + offset + pos, this.field_3_majorUnitValue);
        LittleEndian.putShort(data, 10 + offset + pos, this.field_4_majorUnit);
        LittleEndian.putShort(data, 12 + offset + pos, this.field_5_minorUnitValue);
        LittleEndian.putShort(data, 14 + offset + pos, this.field_6_minorUnit);
        LittleEndian.putShort(data, 16 + offset + pos, this.field_7_baseUnit);
        LittleEndian.putShort(data, 18 + offset + pos, this.field_8_crossingPoint);
        LittleEndian.putShort(data, 20 + offset + pos, this.field_9_options);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 22;
    }

    public short getSid() {
        return 4194;
    }

    public Object clone() {
        AxisOptionsRecord rec = new AxisOptionsRecord();
        rec.field_1_minimumCategory = this.field_1_minimumCategory;
        rec.field_2_maximumCategory = this.field_2_maximumCategory;
        rec.field_3_majorUnitValue = this.field_3_majorUnitValue;
        rec.field_4_majorUnit = this.field_4_majorUnit;
        rec.field_5_minorUnitValue = this.field_5_minorUnitValue;
        rec.field_6_minorUnit = this.field_6_minorUnit;
        rec.field_7_baseUnit = this.field_7_baseUnit;
        rec.field_8_crossingPoint = this.field_8_crossingPoint;
        rec.field_9_options = this.field_9_options;
        return rec;
    }

    public short getMinimumCategory() {
        return this.field_1_minimumCategory;
    }

    public void setMinimumCategory(short field_1_minimumCategory) {
        this.field_1_minimumCategory = field_1_minimumCategory;
    }

    public short getMaximumCategory() {
        return this.field_2_maximumCategory;
    }

    public void setMaximumCategory(short field_2_maximumCategory) {
        this.field_2_maximumCategory = field_2_maximumCategory;
    }

    public short getMajorUnitValue() {
        return this.field_3_majorUnitValue;
    }

    public void setMajorUnitValue(short field_3_majorUnitValue) {
        this.field_3_majorUnitValue = field_3_majorUnitValue;
    }

    public short getMajorUnit() {
        return this.field_4_majorUnit;
    }

    public void setMajorUnit(short field_4_majorUnit) {
        this.field_4_majorUnit = field_4_majorUnit;
    }

    public short getMinorUnitValue() {
        return this.field_5_minorUnitValue;
    }

    public void setMinorUnitValue(short field_5_minorUnitValue) {
        this.field_5_minorUnitValue = field_5_minorUnitValue;
    }

    public short getMinorUnit() {
        return this.field_6_minorUnit;
    }

    public void setMinorUnit(short field_6_minorUnit) {
        this.field_6_minorUnit = field_6_minorUnit;
    }

    public short getBaseUnit() {
        return this.field_7_baseUnit;
    }

    public void setBaseUnit(short field_7_baseUnit) {
        this.field_7_baseUnit = field_7_baseUnit;
    }

    public short getCrossingPoint() {
        return this.field_8_crossingPoint;
    }

    public void setCrossingPoint(short field_8_crossingPoint) {
        this.field_8_crossingPoint = field_8_crossingPoint;
    }

    public short getOptions() {
        return this.field_9_options;
    }

    public void setOptions(short field_9_options) {
        this.field_9_options = field_9_options;
    }

    public void setDefaultMinimum(boolean value) {
        this.field_9_options = this.defaultMinimum.setShortBoolean(this.field_9_options, value);
    }

    public boolean isDefaultMinimum() {
        return this.defaultMinimum.isSet(this.field_9_options);
    }

    public void setDefaultMaximum(boolean value) {
        this.field_9_options = this.defaultMaximum.setShortBoolean(this.field_9_options, value);
    }

    public boolean isDefaultMaximum() {
        return this.defaultMaximum.isSet(this.field_9_options);
    }

    public void setDefaultMajor(boolean value) {
        this.field_9_options = this.defaultMajor.setShortBoolean(this.field_9_options, value);
    }

    public boolean isDefaultMajor() {
        return this.defaultMajor.isSet(this.field_9_options);
    }

    public void setDefaultMinorUnit(boolean value) {
        this.field_9_options = this.defaultMinorUnit.setShortBoolean(this.field_9_options, value);
    }

    public boolean isDefaultMinorUnit() {
        return this.defaultMinorUnit.isSet(this.field_9_options);
    }

    public void setIsDate(boolean value) {
        this.field_9_options = this.isDate.setShortBoolean(this.field_9_options, value);
    }

    public boolean isIsDate() {
        return this.isDate.isSet(this.field_9_options);
    }

    public void setDefaultBase(boolean value) {
        this.field_9_options = this.defaultBase.setShortBoolean(this.field_9_options, value);
    }

    public boolean isDefaultBase() {
        return this.defaultBase.isSet(this.field_9_options);
    }

    public void setDefaultCross(boolean value) {
        this.field_9_options = this.defaultCross.setShortBoolean(this.field_9_options, value);
    }

    public boolean isDefaultCross() {
        return this.defaultCross.isSet(this.field_9_options);
    }

    public void setDefaultDateSettings(boolean value) {
        this.field_9_options = this.defaultDateSettings.setShortBoolean(this.field_9_options, value);
    }

    public boolean isDefaultDateSettings() {
        return this.defaultDateSettings.isSet(this.field_9_options);
    }
}

