/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.helper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaObject;

class ClobReader
extends OdaObject {
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private static final String EMPTY_STR = "";
    private static final String COMMA_SEPARATOR = ", ";
    private static String sm_className;
    private IClob m_odaClob;
    private int m_defaultBufferSize;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ClobReader(IClob odaClob) {
        this.init(odaClob, 2048);
    }

    protected ClobReader(IClob odaClob, int defaultBufferSize) {
        this.init(odaClob, defaultBufferSize);
    }

    private void init(IClob odaClob, int defaultBufferSize) {
        if (!$assertionsDisabled && odaClob == null) {
            throw new AssertionError();
        }
        this.m_odaClob = odaClob;
        int n = this.m_defaultBufferSize = defaultBufferSize >= 0 ? defaultBufferSize : 2048;
        if (sm_className == null) {
            sm_className = this.getClassName();
        }
    }

    private int getDefaultBufferSize() {
        return this.m_defaultBufferSize;
    }

    String getSubString(long startPos, int length) throws IOException, OdaException {
        long numSkipped;
        String context = sm_className + ".getSubString( " + startPos + COMMA_SEPARATOR + length + " )\t";
        this.logMethodCalled(context);
        Reader driverReader = null;
        try {
            driverReader = this.m_odaClob.getCharacterStream();
        }
        catch (OdaException e1) {
            this.log(context, e1.toString());
        }
        if (driverReader == null) {
            this.logMethodExitWithReturn(context, null);
            return null;
        }
        BufferedReader bufferedStream = new BufferedReader(driverReader);
        long numToSkip = 0L;
        if (startPos > 1L && (numSkipped = bufferedStream.skip(numToSkip = startPos - 1L)) != numToSkip) {
            bufferedStream.close();
            this.logMethodExitWithReturn(context, null);
            return null;
        }
        int numToRead = length;
        long streamLen = this.getStreamLength();
        if (streamLen >= 0L) {
            int numAvailable;
            int n = numAvailable = streamLen > numToSkip ? new Long(streamLen - numToSkip).intValue() : 0;
            if (length < 0 || length > numAvailable) {
                numToRead = numAvailable;
            }
        }
        if (numToRead >= 0) {
            char[] readData = this.readCharsFromStream(bufferedStream, numToRead);
            bufferedStream.close();
            String readString = new String(readData);
            this.logMethodExitWithReturnLen(context, readString);
            return readString;
        }
        String remainingStream = null;
        try {
            remainingStream = this.readRemainingString(bufferedStream);
        }
        catch (OutOfMemoryError err) {
            err.printStackTrace();
        }
        bufferedStream.close();
        this.logMethodExitWithReturnLen(context, remainingStream);
        return remainingStream;
    }

    private char[] readCharsFromStream(Reader stream, int maxBufSize) throws IOException {
        String context = sm_className + ".readCharsFromStream( " + stream + COMMA_SEPARATOR + maxBufSize + " )\t";
        if (!$assertionsDisabled && maxBufSize < 0) {
            throw new AssertionError();
        }
        char[] outBuffer = new char[maxBufSize];
        if (maxBufSize == 0) {
            this.log(context, "Returns an empty char array.");
            return outBuffer;
        }
        int numRead = stream.read(outBuffer, 0, outBuffer.length);
        if (numRead == maxBufSize) {
            this.log(context, "Returns a char array of requested size: " + outBuffer.length);
            return outBuffer;
        }
        if (numRead < 0) {
            this.log(context, "Returns a null char array for end of stream.");
            return null;
        }
        char[] resizedBuf = new char[numRead];
        System.arraycopy(outBuffer, 0, resizedBuf, 0, numRead);
        this.log(context, "Returns a char array of size: " + resizedBuf.length);
        return resizedBuf;
    }

    private String readRemainingString(Reader stream) throws IOException {
        String context = sm_className + ".readRemainingString( " + stream + " )\t";
        ArrayList<char[]> bufferList = new ArrayList<char[]>();
        int bufferSize = this.getDefaultBufferSize();
        this.log(context, "Default buffer size: " + bufferSize);
        boolean endOfStream = false;
        char[] aChunk = null;
        while (!endOfStream) {
            aChunk = this.readCharsFromStream(stream, bufferSize);
            if (aChunk != null) {
                bufferList.add(aChunk);
            }
            endOfStream = aChunk == null || aChunk.length < bufferSize || bufferSize == 0;
        }
        if (bufferList.isEmpty()) {
            this.log(context, "Returns an empty String.");
            return EMPTY_STR;
        }
        int totalChars = 0;
        Iterator bufferIter = bufferList.iterator();
        while (bufferIter.hasNext()) {
            aChunk = (char[])bufferIter.next();
            if (!$assertionsDisabled && aChunk == null) {
                throw new AssertionError();
            }
            totalChars += aChunk.length;
        }
        if (totalChars <= 0) {
            this.log(context, "Returns an empty String.");
            return EMPTY_STR;
        }
        StringBuffer remainingString = new StringBuffer(totalChars);
        bufferIter = bufferList.iterator();
        while (bufferIter.hasNext()) {
            aChunk = (char[])bufferIter.next();
            remainingString = remainingString.append(aChunk);
        }
        this.log(context, "Returns a String of size: " + remainingString.length());
        return remainingString.toString();
    }

    private long getStreamLength() {
        long len = -1L;
        try {
            len = this.m_odaClob.length();
        }
        catch (OdaException odaException) {
        }
        catch (UnsupportedOperationException uoException) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return len;
    }

    static {
        $assertionsDisabled = !ClobReader.class.desiredAssertionStatus();
        sm_className = null;
    }
}

