/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.metadata;

import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.regex.Pattern;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.i18n.ThreadResources;

public class DimensionValue {
    protected final double measure;
    protected final String units;
    public static final String DEFAULT_UNIT = "";
    private static final String DOT_SEPARATOR_EXPRESSION = "[\\s]*[-]?[\\d]*([\\d]+[,]?[\\d]+)*[./]?[\\d]*([\\d]+[,]?[\\d]+)*[\\s]*";
    private static final String COMMA_SEPARATOR_EXPRESSION = "[\\s]*[-]?[\\d]*([\\d]+[.]?[\\d]+)*[,]?[\\d]*([\\d]+[.]?[\\d]+)*[\\s]*";
    private static Pattern dotSeparatorPattern;
    private static Pattern commaSeparatorPattern;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.api.metadata.DimensionValue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        dotSeparatorPattern = Pattern.compile(DOT_SEPARATOR_EXPRESSION);
        commaSeparatorPattern = Pattern.compile(COMMA_SEPARATOR_EXPRESSION);
    }

    public DimensionValue(double theMeasure, String theUnits) {
        this.measure = theMeasure;
        if (StringUtil.isBlank(theUnits)) {
            this.units = DEFAULT_UNIT;
        } else if (DimensionValue.isValidUnit(theUnits)) {
            this.units = theUnits;
        } else {
            throw new IllegalArgumentException("The unit " + theUnits + " is not supported.");
        }
    }

    public double getMeasure() {
        return this.measure;
    }

    public String getUnits() {
        return this.units;
    }

    public static DimensionValue parse(String value) throws PropertyValueException {
        return DimensionValue.doParse(value, false);
    }

    public static DimensionValue parseInput(String value) throws PropertyValueException {
        return DimensionValue.doParse(value, true);
    }

    private static DimensionValue doParse(String value, boolean localeDependent) throws PropertyValueException {
        if ((value = StringUtil.trimString(value)) == null) {
            return null;
        }
        String units = DimensionValue.validateUnit(value);
        int indexOfFirstLetter = DimensionValue.indexOfUnitLetter(value);
        if (indexOfFirstLetter != -1 && (value = StringUtil.trimString(value.substring(0, indexOfFirstLetter))) == null) {
            return null;
        }
        double measure = 0.0;
        try {
            if (localeDependent) {
                DimensionValue.validateDecimalValue(value);
                Number number = NumberFormat.getNumberInstance(ThreadResources.getLocale().toLocale()).parse(value);
                measure = number.doubleValue();
            } else {
                measure = Double.parseDouble(value);
            }
        }
        catch (Exception exception) {
            throw new PropertyValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", 3);
        }
        return new DimensionValue(measure, units);
    }

    private static void validateDecimalValue(String value) throws PropertyValueException {
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        char separator = new DecimalFormatSymbols(ThreadResources.getLocale().toLocale()).getDecimalSeparator();
        if (separator == '.') {
            if (!dotSeparatorPattern.matcher(value).matches()) {
                throw new PropertyValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", 3);
            }
        } else if (separator == ',') {
            if (!commaSeparatorPattern.matcher(value).matches()) {
                throw new PropertyValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", 3);
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    private static String validateUnit(String value) throws PropertyValueException {
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        int indexOfFirstLetter = DimensionValue.indexOfUnitLetter(value);
        if (indexOfFirstLetter == -1) {
            return DEFAULT_UNIT;
        }
        String suffix = value.substring(indexOfFirstLetter).trim();
        if (suffix.equalsIgnoreCase("in")) {
            return "in";
        }
        if (suffix.equalsIgnoreCase("cm")) {
            return "cm";
        }
        if (suffix.equalsIgnoreCase("mm")) {
            return "mm";
        }
        if (suffix.equalsIgnoreCase("pt")) {
            return "pt";
        }
        if (suffix.equalsIgnoreCase("pc")) {
            return "pc";
        }
        if (suffix.equalsIgnoreCase("em")) {
            return "em";
        }
        if (suffix.equalsIgnoreCase("ex")) {
            return "ex";
        }
        if (suffix.equalsIgnoreCase("px")) {
            return "px";
        }
        if (suffix.equalsIgnoreCase("%")) {
            return "%";
        }
        throw new PropertyValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", 3);
    }

    private static boolean isValidUnit(String unit) {
        return "in".equalsIgnoreCase(unit) || "cm".equalsIgnoreCase(unit) || "mm".equalsIgnoreCase(unit) || "pt".equalsIgnoreCase(unit) || "pc".equalsIgnoreCase(unit) || "em".equalsIgnoreCase(unit) || "ex".equalsIgnoreCase(unit) || "px".equalsIgnoreCase(unit) || "%".equalsIgnoreCase(unit);
    }

    public String toString() {
        String value = StringUtil.doubleToString(this.measure, 10);
        return String.valueOf(value) + this.units;
    }

    public String toDisplayString() {
        NumberFormat nf = NumberFormat.getNumberInstance(ThreadResources.getLocale().toLocale());
        String value = nf.format(this.measure);
        return String.valueOf(value) + this.units;
    }

    private static int indexOfUnitLetter(String value) {
        char[] ch = value.toCharArray();
        int i = 0;
        while (i < ch.length) {
            if (Character.isLetter(ch[i]) || ch[i] == '%') {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DimensionValue dv = (DimensionValue)obj;
        return Double.doubleToLongBits(this.measure) == Double.doubleToLongBits(dv.measure) && (this.units == dv.units || this.units != null && this.units.equalsIgnoreCase(dv.units));
    }

    public int hashCode() {
        int result = 17;
        long m = Double.doubleToLongBits(this.getMeasure());
        result = 37 * result + (int)(m ^ m >>> 32);
        if (this.getUnits() != null) {
            int u = this.getUnits().toLowerCase().hashCode();
            result = 37 * result + u;
        }
        return result;
    }
}

