/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.elements.table.LayoutHelper;
import org.eclipse.birt.report.model.api.elements.table.LayoutTable;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.validators.InconsistentColumnsValidator;
import org.eclipse.birt.report.model.api.validators.TableHeaderContextContainmentValidator;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.TableColumn;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.elements.interfaces.ITableItemModel;
import org.eclipse.birt.report.model.elements.strategy.CopyPolicy;

public class TableItem
extends ListingElement
implements ITableItemModel {
    private LayoutTable table = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.elements.TableItem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public TableItem() {
    }

    public TableItem(String theName) {
        super(theName);
    }

    public void apply(ElementVisitor visitor) {
        visitor.visitTable(this);
    }

    public String getElementName() {
        return "Table";
    }

    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }

    public TableHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new TableHandle(module, this);
        }
        return (TableHandle)this.handle;
    }

    public int getColumnCount(Module module) {
        int colCount = this.getColDefnCount(module);
        if (colCount != 0) {
            return colCount;
        }
        return this.findMaxCols(module);
    }

    public int findMaxCols(Module module) {
        if (this.table == null) {
            this.refreshRenderModel(module);
        }
        return this.table.getColumnCount();
    }

    public int getColDefnCount(Module module) {
        int colCount = 0;
        ContainerSlot cols = this.getSlot(4);
        int colDefnCount = cols.getCount();
        int i = 0;
        while (i < colDefnCount) {
            TableColumn col = (TableColumn)cols.getContent(i);
            colCount += col.getIntProperty(module, "repeat");
            ++i;
        }
        return colCount;
    }

    public int getColumnPosition4Cell(Module module, Cell target) {
        if (target == null) {
            return 0;
        }
        if (this.table == null) {
            this.refreshRenderModel(module);
        }
        int slotId = target.getContainer().getContainerInfo().getSlotID();
        TableRow row = (TableRow)target.getContainer();
        DesignElement grandPa = row.getContainer();
        int rowId = grandPa.getSlot(slotId).findPosn(row);
        if (grandPa instanceof TableItem) {
            if (!$assertionsDisabled && grandPa != this) {
                throw new AssertionError();
            }
            return this.table.getColumnPos(slotId, rowId, target);
        }
        return this.table.getColumnPos(((TableGroup)grandPa).getGroupLevel(), slotId, rowId, target);
    }

    public List validate(Module module) {
        List list = super.validate(module);
        list.addAll(InconsistentColumnsValidator.getInstance().validate(module, this));
        list.addAll(TableHeaderContextContainmentValidator.getInstance().validate(module, this));
        return list;
    }

    public LayoutTable getLayoutModel(Module module) {
        if (this.table == null) {
            this.refreshRenderModel(module);
        }
        return this.table;
    }

    public void refreshRenderModel(Module module) {
        this.table = LayoutHelper.applyLayout(module, this);
    }

    public List checkContent(Module module, ContainerContext containerInfo, DesignElement content) {
        List errors = super.checkContent(module, containerInfo, content);
        if (!errors.isEmpty()) {
            return errors;
        }
        errors.addAll(TableHeaderContextContainmentValidator.getInstance().validateForAdding(module, containerInfo, content));
        return errors;
    }

    public List checkContent(Module module, ContainerContext containerInfo, IElementDefn defn) {
        List errors = super.checkContent(module, containerInfo, defn);
        if (!errors.isEmpty()) {
            return errors;
        }
        errors.addAll(TableHeaderContextContainmentValidator.getInstance().validateForAdding(module, containerInfo.getElement(), defn));
        return errors;
    }

    public Object doClone(CopyPolicy policy) throws CloneNotSupportedException {
        TableItem clonedTable = (TableItem)super.doClone(policy);
        clonedTable.refreshRenderModel(this.table.getTable().getModule());
        return clonedTable;
    }
}

