/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.plugin;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.command.WrongTypeException;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.OdaDataSet;
import org.eclipse.birt.report.model.elements.OdaDataSource;
import org.eclipse.birt.report.model.extension.ExtensibilityProvider;
import org.eclipse.birt.report.model.extension.oda.ODAProvider;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.ODAExtensionElementDefn;
import org.eclipse.birt.report.model.plugin.ODAManifestUtil;
import org.eclipse.birt.report.model.plugin.ODAPropertyDefn;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataSetType;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.Property;

public class OdaExtensibilityProvider
extends ExtensibilityProvider
implements ODAProvider {
    String extensionID = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.plugin.OdaExtensibilityProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public OdaExtensibilityProvider(DesignElement element, String extensionID) {
        super(element);
        this.extensionID = extensionID;
    }

    public List getPropertyDefns() {
        if (this.getExtDefn() == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getExtDefn().getProperties();
    }

    public IPropertyDefn getPropertyDefn(String propName) {
        if (this.getExtDefn() == null) {
            return null;
        }
        return this.getExtDefn().getProperty(propName);
    }

    public void checkExtends(DesignElement parent) throws ExtendsException {
        String parentExt = (String)parent.getProperty(null, "extensionID");
        if (!$assertionsDisabled && this.extensionID == null) {
            throw new AssertionError();
        }
        if (!this.extensionID.equalsIgnoreCase(parentExt)) {
            throw new WrongTypeException(this.element, parent, "Error.WrongTypeException.WRONG_EXTENSION_TYPE");
        }
    }

    public ExtensionElementDefn getExtDefn() {
        if (this.extensionID == null) {
            return null;
        }
        if (this.cachedExtDefn == null) {
            this.cachedExtDefn = new ODAExtensionElementDefn(this.element.getDefn());
            try {
                DataSetType dataSetType;
                Property[] properties = null;
                Properties visibilities = null;
                if (this.element instanceof OdaDataSource) {
                    ExtensionManifest manifest = ODAManifestUtil.getDataSourceExtension(this.extensionID);
                    if (manifest != null) {
                        properties = manifest.getProperties();
                        visibilities = manifest.getPropertiesVisibility();
                    }
                } else if (this.element instanceof OdaDataSet && (dataSetType = ODAManifestUtil.getDataSetExtension(this.extensionID)) != null) {
                    properties = ODAManifestUtil.getDataSetExtension(this.extensionID).getProperties();
                    visibilities = ODAManifestUtil.getDataSetExtension(this.extensionID).getPropertiesVisibility();
                }
                if (properties != null) {
                    int i = 0;
                    while (i < properties.length) {
                        ODAPropertyDefn propDefn = new ODAPropertyDefn(properties[i]);
                        this.cachedExtDefn.addProperty(propDefn);
                        ++i;
                    }
                    if (visibilities != null) {
                        Iterator<Object> iter = visibilities.keySet().iterator();
                        while (iter.hasNext()) {
                            String key = (String)iter.next();
                            this.cachedExtDefn.addPropertyVisibility(key, visibilities.getProperty(key));
                        }
                    }
                }
                ((ODAExtensionElementDefn)this.cachedExtDefn).buildDefinition();
            }
            catch (MetaDataException metaDataException) {
                return null;
            }
        }
        return this.cachedExtDefn;
    }

    public String convertDataSourceExtensionID(String extensionID) {
        ExtensionManifest manifest = ODAManifestUtil.getDataSourceExtension(extensionID);
        if (manifest != null && manifest.isDeprecated()) {
            extensionID = manifest.getRelatedDataSourceId();
        }
        return extensionID;
    }

    public String convertDataSetExtensionID(String extensionID) {
        DataSetType type = ODAManifestUtil.getDataSetExtension(extensionID);
        if (type != null && type.isDeprecated()) {
            extensionID = type.getRelatedDataSetId();
        }
        return extensionID;
    }

    public boolean isValidODADataSetExtensionID(String extensionID) {
        return ODAManifestUtil.getDataSetExtension(extensionID) != null;
    }

    public boolean isValidODADataSourceExtensionID(String extensionID) {
        return ODAManifestUtil.getDataSourceExtension(extensionID) != null;
    }
}

