/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.List;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.xml.sax.SAXException;

public class XMLParserException
extends SAXException {
    private static final long serialVersionUID = -6489371474593098521L;
    protected int lineNo = 0;
    protected String errorCode = null;
    protected String tag = null;
    protected SAXException saxException = null;
    protected List errorList = null;
    public static final String DESIGN_EXCEPTION_UNKNOWN_TAG = "Error.XMLParserException.UNKNOWN_TAG";
    public static final String DESIGN_EXCEPTION_SAX_ERROR = "Error.XMLParserException.SAX_ERROR";
    public static final String DESIGN_EXCEPTION_INVALID_BOOLEAN = "Error.XMLParserException.INVALID_BOOLEAN";
    public static final String DESIGN_EXCEPTION_WARNINGS_FOUND = "Error.XMLParserException.WARNINGS_FOUND";
    public static final String DESIGN_EXCEPTION_EXCEPTION = "Error.XMLParserException.EXCEPTION";
    public static final String DESIGN_EXCEPTION_INVALID_INTEGER = "Error.XMLParserException.INVALID_INTEGER";

    public XMLParserException(String errCode) {
        super((String)null);
        this.errorCode = errCode;
    }

    public XMLParserException(SAXException e) {
        super(e);
        this.saxException = e;
        this.errorCode = DESIGN_EXCEPTION_SAX_ERROR;
    }

    public XMLParserException(Exception e) {
        super(e);
        this.errorCode = DESIGN_EXCEPTION_EXCEPTION;
    }

    public XMLParserException(Exception e, String errCode) {
        super(e);
        this.errorCode = errCode;
    }

    public XMLParserException(List errors) {
        super((String)null);
        this.errorCode = DESIGN_EXCEPTION_WARNINGS_FOUND;
        this.errorList = errors;
    }

    public void setLineNumber(int n) {
        this.lineNo = n;
    }

    public void setTag(String theTag) {
        this.tag = theTag;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getTag() {
        return this.tag;
    }

    public int getLineNumber() {
        return this.lineNo;
    }

    public String getLocalizedMessage() {
        StringBuffer sb = new StringBuffer();
        String SEPARATOR = " ";
        sb.append("Line Number:").append(this.getLineNumber()).append(SEPARATOR);
        sb.append("Error Code:").append(this.errorCode).append(SEPARATOR);
        if (this.getException() != null) {
            sb.append("Exception:").append(this.getException()).append(SEPARATOR);
        }
        sb.append("Message:").append(ModelMessages.getMessage(this.errorCode)).append(SEPARATOR);
        return sb.toString();
    }

    public String getMessage() {
        return this.getLocalizedMessage();
    }

    public List getErrorList() {
        return this.errorList;
    }
}

