/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.birt.chart.device.DisplayAdapter;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.ITextMetrics;
import org.eclipse.birt.chart.device.extension.i18n.Messages;
import org.eclipse.birt.chart.device.swing.SwingImageCache;
import org.eclipse.birt.chart.device.swing.SwingTextMetrics;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.Size;
import org.eclipse.birt.chart.model.attribute.impl.SizeImpl;
import org.eclipse.birt.chart.model.component.Label;

public class SwingDisplayServer
extends DisplayAdapter {
    private transient BufferedImage _bi = new BufferedImage(1, 1, 2);
    private transient Graphics2D _g2d = (Graphics2D)this._bi.getGraphics();
    private transient SwingImageCache _simc = null;
    private int iDpiResolution = 0;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.device.extension/swing");

    public SwingDisplayServer() {
        this._g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this._g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this._g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        logger.log(1, Messages.getString("SwingDisplayServer.info.display.server", new Object[]{System.getProperty("java.vendor"), System.getProperty("java.version")}, this.getULocale()));
        this._simc = new SwingImageCache((IDisplayServer)this);
    }

    public void dispose() {
        this._g2d.dispose();
        super.dispose();
    }

    public final Object createFont(FontDefinition fd) {
        HashMap<TextAttribute, Object> m = new HashMap<TextAttribute, Object>();
        m.put(TextAttribute.FAMILY, fd.getName());
        m.put(TextAttribute.SIZE, new Float(this.pointsToPixels(fd.getSize())));
        if (fd.isItalic()) {
            m.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if (fd.isBold()) {
            m.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (fd.isUnderline()) {
            m.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (fd.isStrikethrough()) {
            m.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        return new Font(m);
    }

    public final Object getColor(ColorDefinition cd) {
        return new Color(cd.getRed(), cd.getGreen(), cd.getBlue(), cd.getTransparency());
    }

    public final Object getMetrics(FontDefinition fd) {
        return this._g2d.getFontMetrics((Font)this.createFont(fd));
    }

    public final int getDpiResolution() {
        if (this.iDpiResolution == 0) {
            this.iDpiResolution = GraphicsEnvironment.isHeadless() ? super.getDpiResolution() : Toolkit.getDefaultToolkit().getScreenResolution();
        }
        return this.iDpiResolution;
    }

    public final void setDpiResolution(int dpi) {
        this.iDpiResolution = dpi;
    }

    public Object loadImage(URL url) throws ChartException {
        return this._simc.loadImage(url);
    }

    public final Size getSize(Object oImage) {
        Image img = (Image)oImage;
        ImageObserver io = (ImageObserver)this._simc.getObserver();
        return SizeImpl.create((double)img.getWidth(io), (double)img.getHeight(io));
    }

    public final Object getObserver() {
        return this._simc.getObserver();
    }

    public ITextMetrics getTextMetrics(Label la) {
        return new SwingTextMetrics((IDisplayServer)this, la);
    }

    final SwingImageCache getImageCache() {
        return this._simc;
    }

    final double pointsToPixels(double dPoints) {
        return dPoints * (double)this.getDpiResolution() / 72.0;
    }
}

