/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.jdbc.CallStatement;
import org.eclipse.birt.report.data.oda.jdbc.DataSourceMetaData;
import org.eclipse.birt.report.data.oda.jdbc.JDBCDriverManager;
import org.eclipse.birt.report.data.oda.jdbc.JDBCException;
import org.eclipse.birt.report.data.oda.jdbc.Statement;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class Connection
implements IConnection {
    protected java.sql.Connection jdbcConn = null;
    private static Logger logger;
    private static final String advancedDataType = "org.eclipse.birt.report.data.oda.jdbc.SPSelectDataSet";
    private Map appContext;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Connection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Connection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    public boolean isOpen() throws OdaException {
        return this.jdbcConn != null;
    }

    public void open(Properties connProperties) throws OdaException {
        if (connProperties == null) {
            IllegalArgumentException e = new IllegalArgumentException("connProperties cannot be null");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Connection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.logp(Level.FINE, clazz.getName(), "open", e.getMessage(), e);
            throw e;
        }
        if (logger.isLoggable(Level.INFO)) {
            String logMsg = "Connection.open(Properties). connProperties = ";
            Enumeration<?> enumeration = connProperties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String propName = (String)enumeration.nextElement();
                String lcPropName = propName.toLowerCase();
                String propVal = lcPropName.indexOf("password") >= 0 || lcPropName.indexOf("pwd") >= 0 ? "***" : connProperties.getProperty(propName);
                logMsg = String.valueOf(logMsg) + propName + "=" + propVal + ";";
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Connection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.logp(Level.FINE, clazz.getName(), "open", logMsg);
        }
        this.close();
        String dataSource = connProperties.getProperty("odaDataSource");
        if (dataSource != null) {
            UnsupportedOperationException e = new UnsupportedOperationException("Oda-jdbc:connect by data source");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Connection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.logp(Level.FINE, clazz.getName(), "open", e.getMessage(), e);
            throw e;
        }
        String url = connProperties.getProperty("odaURL");
        String jndiName = connProperties.getProperty("odaJndiName");
        if (!(url != null && url.length() != 0 || jndiName != null && jndiName.length() != 0)) {
            throw new JDBCException("odajdbc.driver.DriverMissingProperties", 112);
        }
        this.connectByUrl(url, connProperties);
    }

    private void connectByUrl(String url, Properties connProperties) throws OdaException {
        if (!$assertionsDisabled && connProperties == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && url == null) {
            throw new AssertionError();
        }
        Properties props = new Properties();
        Enumeration<?> enumeration = connProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propName = (String)enumeration.nextElement();
            if (propName.startsWith("oda") || propName.startsWith("Oda")) continue;
            props.setProperty(propName, connProperties.getProperty(propName));
        }
        String user = connProperties.getProperty("odaUser");
        String pwd = connProperties.getProperty("odaPassword");
        props = JDBCDriverManager.addUserAuthenticationProperties(props, user, pwd);
        String driverClass = connProperties.getProperty("odaDriverClass");
        String jndiNameUrl = connProperties.getProperty("odaJndiName");
        try {
            this.jdbcConn = JDBCDriverManager.getInstance().getConnection(driverClass, url, jndiNameUrl, props, this.getDriverClassPath());
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotGetConn", e);
        }
    }

    private String getDriverClassPath() {
        return this.appContext != null && this.appContext.get("OdaJDBCDriverClassPath") != null ? this.appContext.get("OdaJDBCDriverClassPath").toString() : null;
    }

    public IDataSetMetaData getMetaData(String dataSetType) throws OdaException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Connection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "getMetaData", "Connection.getMetaData(" + dataSetType + ")");
        DatabaseMetaData dbMetadata = null;
        if (this.jdbcConn != null) {
            try {
                dbMetadata = this.jdbcConn.getMetaData();
            }
            catch (SQLException e) {
                throw new JDBCException("odajdbc.CannotGetConnMetaData", e);
            }
        }
        return new DataSourceMetaData(this, dbMetadata);
    }

    public IQuery newQuery(String dataSourceType) throws OdaException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Connection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "createStatement", "Connection.createStatement(" + dataSourceType + ")");
        this.assertOpened();
        if (dataSourceType != null && dataSourceType.equalsIgnoreCase(advancedDataType)) {
            return new CallStatement(this.jdbcConn);
        }
        return new Statement(this.jdbcConn);
    }

    public void commit() throws OdaException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Connection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "commit", "Connection.commit()");
        this.assertOpened();
        try {
            this.jdbcConn.commit();
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ConnCommitError", e);
        }
    }

    public void rollback() throws OdaException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Connection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "rollback", "Connection.rollback()");
        this.assertOpened();
        try {
            this.jdbcConn.rollback();
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ConnRollbackError", e);
        }
    }

    public int getMaxQueries() throws OdaException {
        if (this.jdbcConn != null) {
            try {
                DatabaseMetaData dbMetadata = this.jdbcConn.getMetaData();
                return dbMetadata.getMaxStatements();
            }
            catch (SQLException e) {
                throw new JDBCException("odajdbc.CannotGetMaxQuerie", e);
            }
        }
        return 0;
    }

    public void close() throws OdaException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.oda.jdbc.Connection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "close", "Connection closed.");
        if (this.jdbcConn == null) {
            return;
        }
        try {
            if (!this.jdbcConn.isClosed()) {
                this.jdbcConn.close();
            }
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotCloseConn", e);
        }
        this.jdbcConn = null;
    }

    public void setAppContext(Object context) throws OdaException {
        if (context instanceof Map) {
            this.appContext = (Map)context;
        }
    }

    private void assertOpened() throws OdaException {
        if (this.jdbcConn == null) {
            throw new JDBCException("odajdbc.driver.ConnNotOpen", 111);
        }
    }

    public static class Constants {
        public static final String ODAURL = "odaURL";
        public static final String ODAPassword = "odaPassword";
        public static final String ODAUser = "odaUser";
        public static final String ODADriverClass = "odaDriverClass";
        public static final String ODADataSource = "odaDataSource";
        public static final String ODAJndiName = "odaJndiName";
    }
}

