/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor.template;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.core.template.TextTemplate;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.util.FileUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;

public class TemplateExecutor
implements TextTemplate.Visitor {
    protected static Logger logger;
    protected StringBuffer buffer;
    protected HashMap values;
    protected ExecutionContext context;
    protected File imageFolder;
    protected HashMap imageCaches = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.executor.template.TemplateExecutor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public TemplateExecutor(ExecutionContext context) {
        EngineConfig config;
        IReportEngine engine;
        this.context = context;
        String tmpDir = null;
        if (context != null && (engine = context.getEngine()) != null && (config = engine.getConfig()) != null) {
            tmpDir = config.getTempDir();
        }
        if (tmpDir == null) {
            tmpDir = System.getProperty("java.io.tmpdir");
        }
        if (tmpDir == null) {
            tmpDir = ".";
        }
        this.imageFolder = new File(tmpDir);
    }

    public String execute(TextTemplate template, HashMap values) {
        this.buffer = new StringBuffer();
        this.values = values;
        if (template == null) {
            return "";
        }
        ArrayList nodes = template.getNodes();
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            TextTemplate.Node node = (TextTemplate.Node)iter.next();
            node.accept((TextTemplate.Visitor)this, null);
        }
        return this.buffer.toString();
    }

    public Object visitNode(TextTemplate.Node node, Object value) {
        return value;
    }

    public Object visitText(TextTemplate.TextNode node, Object value) {
        this.buffer.append(node.getContent());
        return value;
    }

    public Object visitValue(TextTemplate.ValueNode node, Object value) {
        String text = "";
        String format = node.getFormat();
        Object result = null;
        if (this.values != null) {
            result = this.values.get(node.getValue());
        }
        if ("html".equalsIgnoreCase(format)) {
            if (result != null) {
                text = result.toString();
            }
        } else {
            if (result != null) {
                if (result instanceof Number) {
                    NumberFormatter fmt = this.context.getNumberFormatter(format);
                    text = fmt.format((Number)result);
                } else if (result instanceof String) {
                    StringFormatter fmt = this.context.getStringFormatter(format);
                    text = fmt.format((String)result);
                } else if (result instanceof Date) {
                    DateFormatter fmt = this.context.getDateFormatter(format);
                    text = fmt.format((Date)result);
                } else {
                    text = result.toString();
                }
            }
            text = this.encodeHtmlText(text);
        }
        this.buffer.append(text);
        return value;
    }

    protected String encodeHtmlText(String text) {
        return text.replaceAll("<", "&lt;");
    }

    public Object visitImage(TextTemplate.ImageNode node, Object value) {
        String src;
        String imageName = null;
        String imageExt = null;
        byte[] imageContent = null;
        if ("expr" == node.getType()) {
            imageContent = (byte[])this.values.get(node.getExpr());
        } else {
            EmbeddedImage image;
            ReportDesignHandle report;
            imageName = node.getImageName();
            if (this.context != null && (report = this.context.getDesign()) != null && (image = report.findImage(imageName)) != null) {
                imageContent = image.getData(report.getModule());
                imageExt = FileUtil.getExtFromFileName(imageName);
            }
        }
        if (imageContent instanceof byte[] && (src = this.saveToFile(imageName, imageExt, imageContent)) != null) {
            this.buffer.append("<img src=\"");
            this.buffer.append(src);
            this.buffer.append("\" ");
            Iterator iter = node.getAttributes().entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object attrName = entry.getKey();
                Object attrValue = entry.getValue();
                if (attrName == null || attrValue == null) continue;
                this.buffer.append(attrName.toString());
                this.buffer.append("=\"");
                this.buffer.append(attrValue.toString());
                this.buffer.append("\" ");
            }
            this.buffer.append(">");
        }
        return value;
    }

    protected String saveToFile(String name, String ext, byte[] content) {
        String file;
        if (name != null && (file = (String)this.imageCaches.get(name)) != null) {
            return file;
        }
        try {
            File imageFile = File.createTempFile("img", ext, this.imageFolder);
            FileOutputStream out = new FileOutputStream(imageFile);
            ((OutputStream)out).write(content);
            ((OutputStream)out).close();
            String fileName = imageFile.toURL().toExternalForm();
            this.imageCaches.put(name, fileName);
            return fileName;
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
            this.context.addException(new EngineException(ex.getLocalizedMessage()));
            return null;
        }
    }
}

