/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OffsetIndexReader {
    protected static Logger logger;
    protected String indexFile;
    protected RandomAccessFile index;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.internal.document.OffsetIndexReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public OffsetIndexReader(String indexFile) {
        this.indexFile = indexFile;
    }

    public void open() throws IOException {
        File file = new File(this.indexFile);
        this.index = new RandomAccessFile(file, "r");
    }

    public void close() {
        if (this.index != null) {
            try {
                this.index.close();
            }
            catch (Exception exception) {}
        }
    }

    public long find(long target) {
        long length;
        block7: {
            length = this.index.length();
            if (length >= 16L) break block7;
            return -1L;
        }
        try {
            if (target == 0L) {
                this.index.seek(8L);
                return this.index.readLong();
            }
            long min = 1L;
            long max = length / 16L - 1L;
            long ref = (min + max) / 2L;
            do {
                this.index.seek(16L * ref);
                long offset = this.index.readLong();
                if (target == offset) {
                    return this.index.readLong();
                }
                if (target > offset) {
                    min = ref + 1L;
                    ref = (min + max) / 2L;
                    continue;
                }
                max = ref - 1L;
                ref = (min + max) / 2L;
            } while (min <= max);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
        return -1L;
    }
}

