/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.HashMap;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.w3c.dom.css.CSSValue;

public class BorderConflictResolver {
    static final int POSITION_LEFT = 0;
    static final int POSITION_TOP = 1;
    static final int POSITION_RIGHT = 2;
    static final int POSITION_BOTTOM = 3;
    static HashMap styleMap = null;
    static /* synthetic */ Class class$0;

    static {
        styleMap = new HashMap();
        styleMap.put(IStyle.NONE_VALUE, new Integer(0));
        styleMap.put(IStyle.INSET_VALUE, new Integer(1));
        styleMap.put(IStyle.GROOVE_VALUE, new Integer(2));
        styleMap.put(IStyle.OUTSET_VALUE, new Integer(3));
        styleMap.put(IStyle.RIDGE_VALUE, new Integer(4));
        styleMap.put(IStyle.DOTTED_VALUE, new Integer(5));
        styleMap.put(IStyle.DASHED_VALUE, new Integer(6));
        styleMap.put(IStyle.SOLID_VALUE, new Integer(7));
        styleMap.put(IStyle.DOUBLE_VALUE, new Integer(8));
    }

    public void resolveTableLeftBorder(IStyle tableLeft, IStyle rowLeft, IStyle columnLeft, IStyle cellLeft, IStyle usedStyle) {
        this.resolveBorder(new BorderStyleInfo[]{new BorderStyleInfo(cellLeft, 0), new BorderStyleInfo(columnLeft, 0), new BorderStyleInfo(rowLeft, 0), new BorderStyleInfo(tableLeft, 0)}, new BorderStyleInfo(usedStyle, 0));
    }

    public void resolveTableTopBorder(IStyle tableTop, IStyle rowTop, IStyle columnTop, IStyle cellTop, IStyle usedStyle) {
        this.resolveBorder(new BorderStyleInfo[]{new BorderStyleInfo(cellTop, 1), new BorderStyleInfo(rowTop, 1), new BorderStyleInfo(columnTop, 1), new BorderStyleInfo(tableTop, 1)}, new BorderStyleInfo(usedStyle, 1));
    }

    public void resolveTableBottomBorder(IStyle tableBottom, IStyle rowBottom, IStyle columnBottom, IStyle cellBottom, IStyle usedStyle) {
        this.resolveBorder(new BorderStyleInfo[]{new BorderStyleInfo(cellBottom, 3), new BorderStyleInfo(rowBottom, 3), new BorderStyleInfo(columnBottom, 3), new BorderStyleInfo(tableBottom, 3)}, new BorderStyleInfo(usedStyle, 3));
    }

    public void resolvePagenatedTableTopBorder(IStyle rowTop, IStyle cellTop, IStyle usedStyle) {
        this.resolveBorder(new BorderStyleInfo[]{new BorderStyleInfo(cellTop, 1), new BorderStyleInfo(rowTop, 1)}, new BorderStyleInfo(usedStyle, 1));
    }

    public void resolvePagenatedTableBottomBorder(IStyle rowBottom, IStyle cellBottom, IStyle usedStyle) {
        this.resolveBorder(new BorderStyleInfo[]{new BorderStyleInfo(cellBottom, 3), new BorderStyleInfo(rowBottom, 3)}, new BorderStyleInfo(usedStyle, 3));
    }

    public void resolveTableRightBorder(IStyle tableRight, IStyle rowRight, IStyle columnRight, IStyle cellRight, IStyle usedStyle) {
        this.resolveBorder(new BorderStyleInfo[]{new BorderStyleInfo(cellRight, 2), new BorderStyleInfo(columnRight, 2), new BorderStyleInfo(rowRight, 2), new BorderStyleInfo(tableRight, 2)}, new BorderStyleInfo(usedStyle, 2));
    }

    public void resolveCellLeftBorder(IStyle preColumnRight, IStyle columnLeft, IStyle preCellRight, IStyle cellLeft, IStyle usedStyle) {
        this.resolveBorder(new BorderStyleInfo[]{new BorderStyleInfo(preCellRight, 2), new BorderStyleInfo(cellLeft, 0), new BorderStyleInfo(preColumnRight, 2), new BorderStyleInfo(columnLeft, 0)}, new BorderStyleInfo(usedStyle, 0));
    }

    public void resolveCellTopBorder(IStyle preRowBottom, IStyle rowTop, IStyle preCellBottom, IStyle cellTop, IStyle usedStyle) {
        this.resolveBorder(new BorderStyleInfo[]{new BorderStyleInfo(preCellBottom, 3), new BorderStyleInfo(cellTop, 1), new BorderStyleInfo(preRowBottom, 3), new BorderStyleInfo(rowTop, 1)}, new BorderStyleInfo(usedStyle, 1));
    }

    private void resolveBorder(BorderStyleInfo[] styles, BorderStyleInfo usedStyle) {
        CSSValue[] borderStyles = new CSSValue[styles.length];
        int i = 0;
        while (i < styles.length) {
            borderStyles[i] = styles[i].getBorderStyle();
            if (IStyle.HIDDEN_VALUE.equals(borderStyles[i])) {
                usedStyle.setBorderStyle(IStyle.HIDDEN_VALUE);
                return;
            }
            ++i;
        }
        int maxWidth = 0;
        int maxCount = 1;
        int maxFirstIndex = 0;
        int[] ws = new int[styles.length];
        CSSValue[] borderWidths = new CSSValue[styles.length];
        int i2 = 0;
        while (i2 < styles.length) {
            borderWidths[i2] = styles[i2].getBorderWidth();
            ws[i2] = PropertyUtil.getDimensionValue(styles[i2].getBorderWidth());
            if (ws[i2] > maxWidth) {
                maxWidth = ws[i2];
                maxCount = 1;
                maxFirstIndex = i2;
            } else if (ws[i2] == maxWidth) {
                ++maxCount;
            }
            ++i2;
        }
        if (maxCount == 1) {
            usedStyle.setBorder(borderStyles[maxFirstIndex], borderWidths[maxFirstIndex], styles[maxFirstIndex].getBorderColor());
            return;
        }
        int max = 0;
        int maxStyleIndex = 0;
        int[] ss = new int[styles.length];
        int i3 = 0;
        while (i3 < styles.length) {
            if (ws[i3] == maxWidth) {
                ss[i3] = (Integer)styleMap.get(styles[i3].getBorderStyle());
                if (ss[i3] > max) {
                    max = ss[i3];
                    maxStyleIndex = i3;
                }
            }
            ++i3;
        }
        usedStyle.setBorder(borderStyles[maxStyleIndex], borderWidths[maxStyleIndex] != null ? borderWidths[maxStyleIndex] : IStyle.NUMBER_0, styles[maxStyleIndex].getBorderColor());
    }

    protected class BorderStyleInfo {
        private int position;
        private IStyle style;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.layout.pdf.BorderConflictResolver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public BorderStyleInfo(IStyle style, int position) {
            this.style = style;
            this.position = position;
        }

        public void setBorderColor(CSSValue value) {
            if (!$assertionsDisabled && this.style == null) {
                throw new AssertionError();
            }
            switch (this.position) {
                case 0: {
                    this.style.setProperty(22, value);
                    break;
                }
                case 2: {
                    this.style.setProperty(23, value);
                    break;
                }
                case 1: {
                    this.style.setProperty(21, value);
                    break;
                }
                case 3: {
                    this.style.setProperty(24, value);
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }

        public CSSValue getBorderColor() {
            if (this.style == null) {
                return IStyle.BLACK_RGB_VALUE;
            }
            switch (this.position) {
                case 0: {
                    return this.style.getProperty(22);
                }
                case 2: {
                    return this.style.getProperty(23);
                }
                case 1: {
                    return this.style.getProperty(21);
                }
                case 3: {
                    return this.style.getProperty(24);
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return IStyle.BLACK_RGB_VALUE;
        }

        public CSSValue getBorderStyle() {
            if (this.style == null) {
                return IStyle.NONE_VALUE;
            }
            switch (this.position) {
                case 0: {
                    return this.style.getProperty(11);
                }
                case 2: {
                    return this.style.getProperty(12);
                }
                case 1: {
                    return this.style.getProperty(10);
                }
                case 3: {
                    return this.style.getProperty(13);
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return IStyle.NONE_VALUE;
        }

        public CSSValue getBorderWidth() {
            if (this.style == null) {
                return null;
            }
            switch (this.position) {
                case 0: {
                    return this.style.getProperty(17);
                }
                case 2: {
                    return this.style.getProperty(18);
                }
                case 1: {
                    return this.style.getProperty(15);
                }
                case 3: {
                    return this.style.getProperty(19);
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }

        private void setBorderStyle(CSSValue value) {
            switch (this.position) {
                case 0: {
                    this.style.setProperty(11, value);
                    break;
                }
                case 2: {
                    this.style.setProperty(12, value);
                    break;
                }
                case 1: {
                    this.style.setProperty(10, value);
                    break;
                }
                case 3: {
                    this.style.setProperty(13, value);
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }

        private void setBorderWidth(CSSValue value) {
            switch (this.position) {
                case 0: {
                    this.style.setProperty(17, value);
                    break;
                }
                case 2: {
                    this.style.setProperty(18, value);
                    break;
                }
                case 1: {
                    this.style.setProperty(15, value);
                    break;
                }
                case 3: {
                    this.style.setProperty(19, value);
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }

        public void setBorder(CSSValue style, CSSValue width, CSSValue color) {
            this.setBorderStyle(style);
            this.setBorderWidth(width);
            this.setBorderColor(color);
        }
    }
}

