/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.presentation.aggregation.layout;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis.AxisFault;
import org.eclipse.birt.report.context.BaseAttributeBean;
import org.eclipse.birt.report.context.BirtContext;
import org.eclipse.birt.report.presentation.aggregation.BirtBaseFragment;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.ReportEngineService;
import org.eclipse.birt.report.service.actionhandler.AbstractBaseActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtExtractDataActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtGetReportletActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtRenderImageActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtRenderReportActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtRunAndRenderActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtRunReportActionHandler;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.utility.BirtUtility;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class EngineFragment
extends BirtBaseFragment {
    protected void doPreService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = ParameterAccessor.getFormat(httpServletRequest);
        String string2 = ParameterAccessor.getOpenType(httpServletRequest);
        if ("/download".equalsIgnoreCase(httpServletRequest.getServletPath())) {
            httpServletResponse.setContentType("text/plain; charset=utf-8");
            httpServletResponse.setHeader("Content-Disposition", "attachment; filename=exportdata.csv");
        } else if ("/document".equalsIgnoreCase(httpServletRequest.getServletPath())) {
            BaseAttributeBean baseAttributeBean = (BaseAttributeBean)httpServletRequest.getAttribute("attributeBean");
            String string3 = baseAttributeBean.getReportDocumentName();
            if (string3 == null || string3.length() <= 0) {
                String string4 = ParameterAccessor.generateFileNameWithoutExtension(baseAttributeBean.getReportDesignName()) + "." + "rptdocument";
                httpServletResponse.setContentType("application/octet-stream");
                httpServletResponse.setHeader("Content-Disposition", "attachment; filename=" + string4);
            } else {
                httpServletResponse.setContentType("text/html; charset=utf-8");
            }
        } else {
            String string5;
            if ("pdf".equalsIgnoreCase(string)) {
                httpServletResponse.setContentType("application/pdf");
            } else {
                string5 = ReportEngineService.getInstance().getMIMEType(string);
                if (string5 != null && string5.length() > 0) {
                    httpServletResponse.setContentType(string5);
                } else {
                    httpServletResponse.setContentType("application/octet-stream");
                }
            }
            if (!ParameterAccessor.isGetImageOperator(httpServletRequest)) {
                string5 = ParameterAccessor.generateFileName(httpServletRequest, string);
                httpServletResponse.setHeader("Content-Disposition", string2 + "; filename=\"" + string5 + "\"");
            }
        }
    }

    protected void doService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block20: {
            BaseAttributeBean baseAttributeBean = (BaseAttributeBean)httpServletRequest.getAttribute("attributeBean");
            Object object = httpServletResponse.getOutputStream();
            GetUpdatedObjectsResponse getUpdatedObjectsResponse = new GetUpdatedObjectsResponse();
            BirtContext birtContext = new BirtContext(httpServletRequest, httpServletResponse);
            Operation operation = null;
            try {
                if ("/download".equalsIgnoreCase(httpServletRequest.getServletPath())) {
                    BirtExtractDataActionHandler birtExtractDataActionHandler = new BirtExtractDataActionHandler(birtContext, operation, getUpdatedObjectsResponse);
                    birtExtractDataActionHandler.execute();
                } else if ("/document".equalsIgnoreCase(httpServletRequest.getServletPath())) {
                    String string = baseAttributeBean.getReportDocumentName();
                    if (string == null || string.length() <= 0) {
                        string = ParameterAccessor.getReportDocument(httpServletRequest, "", true);
                        baseAttributeBean.setReportDocumentName(string);
                        BirtRunReportActionHandler birtRunReportActionHandler = new BirtRunReportActionHandler(birtContext, operation, getUpdatedObjectsResponse);
                        birtRunReportActionHandler.execute();
                        BirtUtility.outputFile(string, (OutputStream)object, true);
                    } else {
                        BirtRunReportActionHandler birtRunReportActionHandler = new BirtRunReportActionHandler(birtContext, operation, getUpdatedObjectsResponse);
                        birtRunReportActionHandler.execute();
                        BirtUtility.writeMessage((OutputStream)object, BirtResources.getMessage("birt.viewer.message.document.successful"), "complete");
                    }
                } else if (ParameterAccessor.isGetImageOperator(httpServletRequest)) {
                    BirtRenderImageActionHandler birtRenderImageActionHandler = new BirtRenderImageActionHandler(birtContext, operation, getUpdatedObjectsResponse);
                    birtRenderImageActionHandler.execute();
                } else {
                    Object object2;
                    if ("/output".equalsIgnoreCase(httpServletRequest.getServletPath())) {
                        File file = new File(baseAttributeBean.getReportDocumentName());
                        if (!file.exists()) {
                            object2 = new BirtRunReportActionHandler(birtContext, operation, getUpdatedObjectsResponse);
                            ((AbstractBaseActionHandler)object2).execute();
                        }
                        if (!(file = new File(baseAttributeBean.getReportDocumentName())).exists()) {
                            object2 = new AxisFault();
                            object2.setFaultReason(BirtResources.getMessage("birt.viewer.actionException.NO_REPORT_DOCUMENT"));
                            throw object2;
                        }
                        if (baseAttributeBean.isDocumentProcessing()) {
                            object2 = new AxisFault();
                            object2.setFaultReason(BirtResources.getMessage("birt.viewer.generalException.DOCUMENT_FILE_PROCESSING"));
                            throw object2;
                        }
                        baseAttributeBean.setDocumentInUrl(true);
                    }
                    boolean bl = false;
                    if ("print".equalsIgnoreCase(baseAttributeBean.getAction())) {
                        bl = true;
                        object = new ByteArrayOutputStream();
                    }
                    if (ParameterAccessor.isGetReportlet(httpServletRequest)) {
                        object2 = new BirtGetReportletActionHandler(birtContext, operation, getUpdatedObjectsResponse, (OutputStream)object);
                        ((AbstractBaseActionHandler)object2).execute();
                    } else if (baseAttributeBean.isDocumentInUrl()) {
                        object2 = new BirtRenderReportActionHandler(birtContext, operation, getUpdatedObjectsResponse, (OutputStream)object);
                        ((AbstractBaseActionHandler)object2).execute();
                    } else {
                        object2 = new BirtRunAndRenderActionHandler(birtContext, operation, getUpdatedObjectsResponse, (OutputStream)object);
                        ((AbstractBaseActionHandler)object2).execute();
                    }
                    if (bl) {
                        object2 = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
                        BirtUtility.doPrintAction((InputStream)object2, httpServletRequest, httpServletResponse);
                    }
                }
            }
            catch (RemoteException remoteException) {
                if (ParameterAccessor.isGetImageOperator(httpServletRequest)) break block20;
                httpServletResponse.setContentType("text/html; charset=utf-8");
                BirtUtility.appendErrorMessage((OutputStream)httpServletResponse.getOutputStream(), remoteException);
            }
        }
    }

    protected String doPostService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        return null;
    }
}

