/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service.actionhandler;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.eclipse.birt.report.context.BaseAttributeBean;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.actionhandler.IActionHandler;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.OutputOptions;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.soapengine.api.Data;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.soapengine.api.Oprand;
import org.eclipse.birt.report.soapengine.api.ReportId;
import org.eclipse.birt.report.soapengine.api.ReportIdType;
import org.eclipse.birt.report.soapengine.api.Update;
import org.eclipse.birt.report.soapengine.api.UpdateData;
import org.eclipse.birt.report.utility.ParameterAccessor;

public abstract class AbstractBaseActionHandler
implements IActionHandler {
    protected IContext context = null;
    protected Operation operation = null;
    protected GetUpdatedObjectsResponse response = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected abstract void __execute() throws Exception;

    public AbstractBaseActionHandler(IContext iContext, Operation operation, GetUpdatedObjectsResponse getUpdatedObjectsResponse) {
        this.context = iContext;
        this.operation = operation;
        this.response = getUpdatedObjectsResponse;
        this.updateTaskId();
    }

    public void execute() throws RemoteException {
        try {
            this.__execute();
        }
        catch (Exception exception) {
            this.throwAxisFault(exception);
        }
    }

    protected boolean isValidPageNumber(HttpServletRequest httpServletRequest, long l, String string) throws RemoteException, ReportServiceException {
        InputOptions inputOptions = new InputOptions();
        inputOptions.setOption("request", httpServletRequest);
        return l > 0L && l <= this.getReportService().getPageCount(string, inputOptions, new OutputOptions());
    }

    protected long getPageNumber(HttpServletRequest httpServletRequest, Oprand[] oprandArray, String string) throws RemoteException, ReportServiceException {
        long l = -1L;
        if (oprandArray != null && oprandArray.length > 0) {
            for (int i = 0; i < oprandArray.length; ++i) {
                if (!"__page".equalsIgnoreCase(oprandArray[i].getName())) continue;
                try {
                    l = Integer.parseInt(oprandArray[i].getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    l = -1L;
                }
                InputOptions inputOptions = new InputOptions();
                inputOptions.setOption("request", httpServletRequest);
                long l2 = this.getReportService().getPageCount(string, inputOptions, new OutputOptions());
                if (l > 0L && l <= l2) break;
                AxisFault axisFault = new AxisFault();
                axisFault.setFaultCode(new QName("DocumentProcessor.getPageNumber( )"));
                axisFault.setFaultString(BirtResources.getMessage("birt.viewer.actionException.INVALID_PAGE_NUMBER", new Object[]{new Long(l), new Long(l2)}));
                throw axisFault;
            }
        }
        return l;
    }

    protected String getBookmark(Oprand[] oprandArray, BaseAttributeBean baseAttributeBean) {
        if (!$assertionsDisabled && baseAttributeBean == null) {
            throw new AssertionError();
        }
        String string = null;
        if (oprandArray != null && oprandArray.length > 0) {
            for (int i = 0; i < oprandArray.length; ++i) {
                if (!"__bookmark".equalsIgnoreCase(oprandArray[i].getName())) continue;
                string = ParameterAccessor.htmlDecode(oprandArray[i].getValue());
                break;
            }
        }
        if (string == null || string.length() <= 0) {
            string = baseAttributeBean.getBookmark();
        }
        return string;
    }

    protected boolean isToc(Oprand[] oprandArray, BaseAttributeBean baseAttributeBean) {
        if (!$assertionsDisabled && baseAttributeBean == null) {
            throw new AssertionError();
        }
        String string = null;
        if (oprandArray != null && oprandArray.length > 0) {
            for (int i = 0; i < oprandArray.length; ++i) {
                if (!"__istoc".equalsIgnoreCase(oprandArray[i].getName())) continue;
                string = ParameterAccessor.htmlDecode(oprandArray[i].getValue());
                break;
            }
        }
        if (string == null || string.length() <= 0) {
            return baseAttributeBean.isToc();
        }
        return "true".equalsIgnoreCase(string);
    }

    protected ReportId[] parseReportId(ArrayList arrayList) throws RemoteException {
        if (arrayList == null || arrayList.size() <= 0) {
            return null;
        }
        Vector<ReportId> vector = new Vector<ReportId>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string;
            String string2 = (String)arrayList.get(i);
            int n = string2.indexOf(44);
            if (string2 == null || n == -1) {
                AxisFault axisFault = new AxisFault();
                axisFault.setFaultCode(new QName("DocumentProcessor.parseReportId( )"));
                axisFault.setFaultString(BirtResources.getMessage("birt.viewer.actionException.INVALID_ID_FORMAT", new String[]{string2}));
                throw axisFault;
            }
            int n2 = string2.indexOf(44, n + 1);
            if (n2 == -1) {
                n2 = string2.length();
            }
            if (!"Document".equalsIgnoreCase(string = string2.substring(n + 1, n2)) && !"Table".equalsIgnoreCase(string) && !"Chart".equalsIgnoreCase(string) && !"Extended".equalsIgnoreCase(string) && !"Label".equalsIgnoreCase(string) && !"Group".equalsIgnoreCase(string) && !"ColoumnInfo".equalsIgnoreCase(string)) continue;
            ReportId reportId = new ReportId();
            reportId.setId(string2.substring(0, string2.indexOf(44)));
            if ("Document".equalsIgnoreCase(string)) {
                reportId.setType(ReportIdType.Document);
            } else if ("Table".equalsIgnoreCase(string)) {
                reportId.setType(ReportIdType.Table);
            } else if ("Chart".equalsIgnoreCase(string) || "Extended".equalsIgnoreCase(string)) {
                reportId.setType(ReportIdType.Chart);
            } else if ("Label".equalsIgnoreCase(string)) {
                reportId.setType(ReportIdType.Label);
            } else if ("Group".equalsIgnoreCase(string)) {
                reportId.setType(ReportIdType.Group);
            } else if ("ColoumnInfo".equalsIgnoreCase(string)) {
                reportId.setType(ReportIdType.ColumnInfo);
            }
            try {
                reportId.setRptElementId(new Long(Long.parseLong(string2.substring(n2 + 1))));
            }
            catch (Exception exception) {
                reportId.setRptElementId(null);
            }
            vector.add(reportId);
        }
        ReportId[] reportIdArray = new ReportId[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            reportIdArray[i] = (ReportId)vector.get(i);
        }
        return reportIdArray;
    }

    public boolean canExecute() {
        return true;
    }

    public boolean canUndo() {
        return false;
    }

    public boolean canRedo() {
        return false;
    }

    public void undo() {
    }

    public void redo() {
    }

    public boolean prepare() {
        return true;
    }

    protected abstract IViewerReportService getReportService();

    protected void appendUpdate(GetUpdatedObjectsResponse getUpdatedObjectsResponse, Update update) {
        Update[] updateArray = getUpdatedObjectsResponse.getUpdate();
        if (updateArray == null || updateArray.length == 0) {
            getUpdatedObjectsResponse.setUpdate(new Update[]{update});
        } else {
            Update[] updateArray2 = new Update[updateArray.length + 1];
            for (int i = 0; i < updateArray.length; ++i) {
                updateArray2[i] = updateArray[i];
            }
            updateArray2[updateArray.length] = update;
            getUpdatedObjectsResponse.setUpdate(updateArray2);
        }
    }

    protected Update createUpdateData(String string, Data data) {
        UpdateData updateData = new UpdateData();
        updateData.setTarget(string);
        updateData.setData(data);
        Update update = new Update();
        update.setUpdateData(updateData);
        return update;
    }

    protected void throwAxisFault(Exception exception) throws RemoteException {
        AxisFault axisFault = AxisFault.makeFault((Exception)exception);
        if (exception.getCause() != null) {
            axisFault.setStackTrace(exception.getCause().getStackTrace());
        } else {
            axisFault.setStackTrace(exception.getStackTrace());
        }
        throw axisFault;
    }

    protected boolean getSVGFlag(Oprand[] oprandArray) {
        boolean bl = false;
        HttpServletRequest httpServletRequest = this.context.getRequest();
        if (ParameterAccessor.isReportParameterExist(httpServletRequest, "__svg")) {
            return ParameterAccessor.getSVGFlag(httpServletRequest);
        }
        if (oprandArray != null && oprandArray.length > 0) {
            for (int i = 0; i < oprandArray.length; ++i) {
                if (!"__svg".equalsIgnoreCase(oprandArray[i].getName())) continue;
                bl = "true".equalsIgnoreCase(oprandArray[i].getValue());
                break;
            }
        }
        return bl;
    }

    protected void updateTaskId() {
        if (this.operation == null) {
            return;
        }
        Oprand[] oprandArray = this.operation.getOprand();
        if (oprandArray == null) {
            return;
        }
        for (int i = 0; i < oprandArray.length; ++i) {
            String string = oprandArray[i].getName();
            String string2 = oprandArray[i].getValue();
            if (!"__taskid".equalsIgnoreCase(string)) continue;
            this.context.getBean().setTaskId(string2);
            break;
        }
    }

    static {
        $assertionsDisabled = !AbstractBaseActionHandler.class.desiredAssertionStatus();
    }
}

