/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.servlet;

import java.io.IOException;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis.transport.http.AxisServlet;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.presentation.aggregation.IFragment;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.utility.ParameterAccessor;

public abstract class BirtSoapMessageDispatcherServlet
extends AxisServlet {
    private static final long serialVersionUID = 1L;
    protected static boolean openSource = true;
    protected IFragment viewer = null;
    protected IFragment run = null;

    protected abstract void __init(ServletConfig var1);

    protected abstract boolean __authenticate(HttpServletRequest var1, HttpServletResponse var2);

    protected abstract IContext __getContext(HttpServletRequest var1, HttpServletResponse var2) throws BirtException;

    protected abstract void __doGet(IContext var1) throws ServletException, IOException, BirtException;

    protected abstract void __doPost(IContext var1) throws ServletException, IOException, BirtException;

    protected abstract void __handleNonSoapException(HttpServletRequest var1, HttpServletResponse var2, Exception var3) throws ServletException, IOException;

    public static boolean isOpenSource() {
        return openSource;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        ParameterAccessor.initParameters(servletConfig);
        BirtResources.setLocale(ParameterAccessor.getWebAppLocale());
        this.__init(servletConfig);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (!this.__authenticate(httpServletRequest, httpServletResponse)) {
            return;
        }
        try {
            IContext iContext = this.__getContext(httpServletRequest, httpServletResponse);
            if (iContext.getBean().getException() != null) {
                this.__handleNonSoapException(httpServletRequest, httpServletResponse, iContext.getBean().getException());
            } else {
                this.__doGet(iContext);
            }
        }
        catch (BirtException birtException) {
            this.__handleNonSoapException(httpServletRequest, httpServletResponse, (Exception)((Object)birtException));
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        String string;
        if (!this.__authenticate(httpServletRequest, httpServletResponse)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = httpServletRequest.getParameterMap().keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (string == null || !string.startsWith("__")) continue;
            object = ParameterAccessor.urlEncode(ParameterAccessor.getParameter(httpServletRequest, string), "UTF-8");
            stringBuffer.append("&" + string + "=" + (String)object);
        }
        string = httpServletRequest.getRequestURL().toString();
        if (ParameterAccessor.getBaseURL() != null) {
            string = ParameterAccessor.getBaseURL() + httpServletRequest.getContextPath() + httpServletRequest.getServletPath();
        }
        if (httpServletRequest.getQueryString() != null) {
            string = string + "?" + httpServletRequest.getQueryString() + stringBuffer.toString();
        } else {
            stringBuffer.deleteCharAt(0);
            string = string + "?" + stringBuffer.toString();
        }
        httpServletRequest.setAttribute("SoapURL", (Object)string);
        object = null;
        try {
            object = this.__getContext(httpServletRequest, httpServletResponse);
        }
        catch (BirtException birtException) {
            this.__handleNonSoapException(httpServletRequest, httpServletResponse, (Exception)((Object)birtException));
            return;
        }
        try {
            this.__doPost((IContext)object);
            String string2 = httpServletRequest.getHeader("request-type");
            if ("soap".equalsIgnoreCase(string2)) {
                super.doPost(httpServletRequest, httpServletResponse);
            } else {
                this.doGet(httpServletRequest, httpServletResponse);
            }
        }
        catch (BirtException birtException) {
            birtException.printStackTrace();
        }
    }
}

