/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.taglib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.eclipse.birt.report.model.api.util.ParameterValidationUtil;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.BirtReportServiceFactory;
import org.eclipse.birt.report.service.ParameterDataTypeConverter;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.ParameterDefinition;
import org.eclipse.birt.report.service.api.ParameterGroupDefinition;
import org.eclipse.birt.report.service.api.ParameterSelectionChoice;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.taglib.RequesterTag;
import org.eclipse.birt.report.taglib.component.ParamDefField;
import org.eclipse.birt.report.taglib.component.ViewerField;
import org.eclipse.birt.report.taglib.util.BirtTagUtil;
import org.eclipse.birt.report.utility.BirtUtility;
import org.eclipse.birt.report.utility.DataUtil;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class ParamDefTag
extends BodyTagSupport {
    private static final long serialVersionUID = -1255870121526790060L;
    private ParamDefField param;
    private RequesterTag requesterTag;
    private ViewerField viewer;
    private ParameterDefinition paramDef;
    private InputOptions options;
    private boolean isLocale = false;
    private Locale locale;
    private String pattern;
    private String valueString;
    private List valueStringList;
    private String displayTextString;
    private String groupObjName;
    private static final String IMPORT_FILES_ATTR = "IMPORT_FILES_FLAG";

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.param = new ParamDefField();
    }

    public int doEndTag() throws JspException {
        try {
            if (this.__validate()) {
                this.requesterTag = (RequesterTag)TagSupport.findAncestorWithClass((Tag)this, (Class)RequesterTag.class);
                if (this.requesterTag != null) {
                    this.viewer = this.requesterTag.viewer;
                    if (this.viewer.isCustom()) {
                        this.__beforeEndTag();
                        this.__process();
                    }
                }
            }
        }
        catch (Exception exception) {
            this.__handleException(exception);
        }
        return super.doEndTag();
    }

    protected boolean __validate() throws Exception {
        if (!this.param.validate()) {
            return false;
        }
        Pattern pattern = Pattern.compile("^\\w+$");
        Matcher matcher = pattern.matcher(this.param.getId());
        if (!matcher.find()) {
            throw new JspTagException(BirtResources.getMessage("birt.viewer.taglib.INVALID_ATTR_ID"));
        }
        if (this.pageContext.findAttribute(this.param.getId()) != null) {
            throw new JspTagException(BirtResources.getMessage("birt.viewer.taglib.ATTR_ID_DUPLICATE"));
        }
        return true;
    }

    protected void __beforeEndTag() {
        this.pageContext.setAttribute(this.param.getId(), (Object)this.param.getName());
    }

    protected void __process() throws Exception {
        Object[] objectArray;
        Object object;
        Object object2;
        if (this.viewer == null) {
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
        this.locale = BirtTagUtil.getLocale(httpServletRequest, this.viewer.getLocale());
        this.options = new InputOptions();
        this.options.setOption("request", httpServletRequest);
        this.options.setOption("locale", this.locale);
        this.options.setOption("rtl", Boolean.valueOf(this.viewer.getRtl()));
        Collection collection = this.viewer.getParameterDefList();
        if (collection == null) {
            BirtReportServiceFactory.getReportService().setContext(this.pageContext.getServletContext(), this.options);
            object2 = BirtTagUtil.getDesignHandle(httpServletRequest, this.viewer);
            this.viewer.setReportDesignHandle((IViewerReportDesignHandle)object2);
            collection = BirtReportServiceFactory.getReportService().getParameterDefinitions((IViewerReportDesignHandle)object2, this.options, false);
            this.viewer.setParameterDefList(collection);
        }
        this.paramDef = BirtUtility.findParameterDefinition(collection, this.param.getName());
        if (this.paramDef == null) {
            return;
        }
        object2 = ParameterDataTypeConverter.ConvertDataType(this.paramDef.getDataType());
        this.pattern = this.param.getPattern();
        if (this.pattern == null) {
            this.pattern = this.paramDef.getPattern();
        }
        if ("true".equalsIgnoreCase(this.param.getIsLocale())) {
            this.isLocale = true;
        }
        if (this.param.getValue() != null) {
            if (this.param.getValue() instanceof String) {
                object = DataUtil.validateWithPattern((String)object2, this.pattern, (String)this.param.getValue(), this.locale, this.isLocale);
                if (this.paramDef.isMultiValue()) {
                    this.param.setValue(new Object[]{object});
                } else {
                    this.param.setValue(object);
                }
            } else if (this.paramDef.isMultiValue() && this.param.getValue() instanceof String[]) {
                object = (String[])this.param.getValue();
                objectArray = new Object[((String[])object).length];
                for (int i = 0; i < ((Object[])object).length; ++i) {
                    Object object3;
                    objectArray[i] = object3 = DataUtil.validateWithPattern((String)object2, this.pattern, (String)object[i], this.locale, this.isLocale);
                }
                this.param.setValue(objectArray);
            }
        } else {
            object = BirtReportServiceFactory.getReportService().getParameterDefaultValue(this.viewer.getReportDesignHandle(), this.param.getName(), this.options);
            if (this.paramDef.isMultiValue()) {
                this.param.setValue(new Object[]{object});
            } else {
                this.param.setValue(object);
            }
        }
        if (this.paramDef.isMultiValue()) {
            this.valueStringList = new ArrayList();
            object = (Object[])this.param.getValue();
            if (object != null) {
                for (int i = 0; i < ((Object[])object).length; ++i) {
                    String string = DataUtil.getDisplayValue(object[i]);
                    this.valueStringList.add(string);
                }
            }
        } else {
            this.valueString = DataUtil.getDisplayValue(this.param.getValue());
            if (this.valueString == null) {
                this.valueString = "";
            }
        }
        this.displayTextString = this.param.getDisplayText();
        if (this.displayTextString == null && (object = this.param.getValue()) != null) {
            if (object instanceof Object[]) {
                objectArray = object;
                object = objectArray.length > 0 ? objectArray[0] : null;
            }
            this.displayTextString = ParameterValidationUtil.getDisplayValue((String)object2, (String)this.pattern, (Object)object, (Locale)this.locale);
        }
        if (this.displayTextString == null) {
            this.displayTextString = "";
        }
        if (this.param.getTitle() == null) {
            this.param.setTitle(this.displayTextString);
        }
        this.requesterTag.addParameter(this.param.getName(), this.param.getValue());
        if (this.paramDef.isHidden()) {
            this.__handleHidden();
        } else {
            switch (this.paramDef.getControlType()) {
                case 0: {
                    this.__handleTextBox();
                    break;
                }
                case 1: {
                    this.__handleListBox();
                    break;
                }
                case 2: {
                    this.__handleRadioButton();
                    break;
                }
                case 3: {
                    this.__handleCheckBox();
                    break;
                }
            }
        }
    }

    protected void __handleHidden() throws Exception {
        JspWriter jspWriter = this.pageContext.getOut();
        String string = ParameterAccessor.htmlEncode(this.param.getId());
        String string2 = ParameterAccessor.htmlEncode(this.param.getName());
        boolean bl = this.param.getValue() == null;
        jspWriter.write("<input type=\"hidden\" ");
        jspWriter.write(" id=\"" + string + "\" ");
        if (!bl) {
            jspWriter.write(" name=\"" + string2 + "\" ");
            jspWriter.write(" value=\"" + ParameterAccessor.htmlEncode(this.valueString) + "\" ");
        }
        jspWriter.write(" >\n");
        String string3 = string + "_displayText";
        String string4 = "__isdisplay__" + string2;
        jspWriter.write("<input type=\"hidden\" ");
        jspWriter.write(" id=\"" + string3 + "\" ");
        if (!bl) {
            jspWriter.write(" name=\"" + string4 + "\" ");
            jspWriter.write(" value=\"" + ParameterAccessor.htmlEncode(this.displayTextString) + "\" ");
        }
        jspWriter.write(" >\n");
    }

    protected void __handleGeneralDefinition() throws Exception {
        JspWriter jspWriter = this.pageContext.getOut();
        if (this.param.getTitle() != null) {
            jspWriter.write(" title=\"" + this.param.getTitle() + "\" ");
        }
        if (this.param.getCssClass() != null) {
            jspWriter.write(" class=\"" + this.param.getCssClass() + "\" ");
        }
        if (this.param.getStyle() != null) {
            jspWriter.write(" style=\"" + this.param.getStyle() + "\" ");
        }
    }

    protected void __handleTextBox() throws Exception {
        String string;
        JspWriter jspWriter = this.pageContext.getOut();
        String string2 = ParameterAccessor.htmlEncode(this.param.getId());
        String string3 = ParameterAccessor.htmlEncode(this.param.getName());
        boolean bl = this.param.getValue() == null;
        String string4 = string2 + "_displayText";
        String string5 = "__isdisplay__" + string3;
        jspWriter.write("<input type=\"hidden\" ");
        jspWriter.write(" id=\"" + string4 + "\" ");
        if (this.paramDef.isRequired() || !bl) {
            jspWriter.write(" name=\"" + string5 + "\" ");
            jspWriter.write(" value=\"" + ParameterAccessor.htmlEncode(this.displayTextString) + "\" ");
        }
        jspWriter.write(" >\n");
        String string6 = string2 + "_value";
        jspWriter.write("<input type=\"hidden\" ");
        jspWriter.write(" id=\"" + string6 + "\" ");
        jspWriter.write(" name=\"" + string3 + "\" ");
        jspWriter.write(" value=\"" + ParameterAccessor.htmlEncode(this.valueString) + "\" ");
        jspWriter.write(" >\n");
        String string7 = string2 + "_islocale";
        jspWriter.write("<input type=\"hidden\" id=\"" + string7 + "\" value=\"" + string3 + "\" >\n");
        String string8 = string2 + "_pattern";
        String string9 = string3 + "_format";
        if (this.param.getPattern() != null) {
            jspWriter.write("<input type = 'hidden' id=\"" + string8 + "\" \n");
            jspWriter.write(" value=\"" + ParameterAccessor.htmlEncode(this.param.getPattern()) + "\">\n");
        }
        jspWriter.write("\n<script language=\"JavaScript\">\n");
        jspWriter.write("function handleParam" + string2 + "( )\n");
        jspWriter.write("{\n");
        jspWriter.write("var inputCtl = document.getElementById(\"" + string2 + "\");\n");
        jspWriter.write("var valCtl = document.getElementById(\"" + string6 + "\");\n");
        jspWriter.write("var displayCtl = document.getElementById(\"" + string4 + "\");\n");
        jspWriter.write("var localeCtl = document.getElementById(\"" + string7 + "\");\n");
        jspWriter.write("var patternCtl = document.getElementById(\"" + string8 + "\");\n");
        jspWriter.write("displayCtl.value=inputCtl.value;\n");
        jspWriter.write("valCtl.value=inputCtl.value;\n");
        jspWriter.write("localeCtl.name='__islocale';\n");
        jspWriter.write("if( patternCtl ) patternCtl.name=\"" + string9 + "\";\n");
        jspWriter.write("}\n");
        jspWriter.write("</script>\n");
        String string10 = string = this.paramDef.concealValue() ? "PASSWORD" : "TEXT";
        if (this.paramDef.isRequired()) {
            jspWriter.write("<input type=\"" + string + "\" ");
            jspWriter.write(" id=\"" + string2 + "\" ");
            this.__handleGeneralDefinition();
            jspWriter.write(" value=\"" + ParameterAccessor.htmlEncode(this.displayTextString) + "\" ");
            jspWriter.write(" onchange=\"handleParam" + string2 + "( )\"");
            jspWriter.write(" >\n");
        } else {
            String string11 = string2 + "_null";
            String string12 = string2 + "_radio_input";
            String string13 = string2 + "_radio_null";
            jspWriter.write("\n<script language=\"JavaScript\">\n");
            jspWriter.write("function switchParam" + string2 + "( flag )\n");
            jspWriter.write("{\n");
            jspWriter.write("var inputCtl = document.getElementById(\"" + string2 + "\");\n");
            jspWriter.write("var displayCtl = document.getElementById(\"" + string4 + "\");\n");
            jspWriter.write("var nullCtl = document.getElementById(\"" + string11 + "\");\n");
            jspWriter.write("var radioTextCtl = document.getElementById(\"" + string12 + "\");\n");
            jspWriter.write("var radioNullCtl = document.getElementById(\"" + string13 + "\");\n");
            jspWriter.write("if( flag ) \n");
            jspWriter.write("{\n");
            jspWriter.write("\tradioTextCtl.checked=true;\n");
            jspWriter.write("\tradioNullCtl.checked=false;\n");
            jspWriter.write("\tinputCtl.disabled=false;\n");
            jspWriter.write("\tnullCtl.name='';\n");
            jspWriter.write("\tdisplayCtl.name='" + string5 + "';\n");
            jspWriter.write("}\n");
            jspWriter.write("else\n");
            jspWriter.write("{\n");
            jspWriter.write("\tradioTextCtl.checked=false;\n");
            jspWriter.write("\tradioNullCtl.checked=true;\n");
            jspWriter.write("\tinputCtl.disabled=true;\n");
            jspWriter.write("\tnullCtl.name='__isnull';\n");
            jspWriter.write("\tdisplayCtl.name='';\n");
            jspWriter.write("}\n");
            jspWriter.write("}\n");
            jspWriter.write("</script>\n");
            jspWriter.write("<input type=\"hidden\" value=\"" + string3 + "\" id=\"" + string11 + "\"");
            if (bl) {
                jspWriter.write(" name=\"__isnull\"");
            }
            jspWriter.write(" >\n");
            jspWriter.write("<input type=\"radio\" id=\"" + string12 + "\" ");
            jspWriter.write(" onclick=\"switchParam" + string2 + "( true )\"");
            if (!bl) {
                jspWriter.write(" checked ");
            }
            jspWriter.write(" >\n");
            jspWriter.write("<input type=\"" + string + "\" ");
            jspWriter.write(" id=\"" + string2 + "\" ");
            this.__handleGeneralDefinition();
            jspWriter.write(" value=\"" + ParameterAccessor.htmlEncode(this.displayTextString) + "\" ");
            jspWriter.write(" onchange=\"handleParam" + string2 + "( )\"");
            if (bl) {
                jspWriter.write(" disabled = 'true' ");
            }
            jspWriter.write(" >\n");
            jspWriter.write("<input type=\"radio\" id=\"" + string13 + "\" ");
            jspWriter.write(" onclick=\"switchParam" + string2 + "( false )\"");
            if (bl) {
                jspWriter.write(" checked ");
            }
            jspWriter.write(" >");
            jspWriter.write("<label id=\"" + string13 + "_label" + "\"");
            jspWriter.write(" title=\"Null Value\"");
            jspWriter.write(" for=\"" + string13 + "\">");
            jspWriter.write("Null Value");
            jspWriter.write("</label>");
            jspWriter.write("</input>\n");
        }
    }

    protected void __handleListBox() throws Exception {
        if (this.paramDef.getGroup() != null && this.paramDef.getGroup().cascade()) {
            Object object;
            JspWriter jspWriter = this.pageContext.getOut();
            if (this.pageContext.findAttribute(IMPORT_FILES_ATTR) == null) {
                object = "/webcontent/";
                object = this.viewer.getBaseURL() != null ? this.viewer.getBaseURL() + (String)object : ((HttpServletRequest)this.pageContext.getRequest()).getContextPath() + (String)object;
                jspWriter.write("\n<LINK REL=\"stylesheet\" HREF=\"" + (String)object + "birt/styles/style.css\" TYPE=\"text/css\">\n");
                jspWriter.write("\n<script src=\"" + (String)object + "birt/ajax/lib/prototype.js\" type=\"text/javascript\"></script>\n");
                jspWriter.write("<script src=\"" + (String)object + "birt/ajax/utility/Debug.js\" type=\"text/javascript\"></script>\n");
                jspWriter.write("<script src=\"" + (String)object + "birt/ajax/utility/Constants.js\" type=\"text/javascript\"></script>\n");
                jspWriter.write("<script src=\"" + (String)object + "birt/ajax/utility/BirtUtility.js\" type=\"text/javascript\"></script>\n");
                jspWriter.write("<script src=\"" + (String)object + "birt/ajax/utility/BirtPosition.js\" type=\"text/javascript\"></script>\n");
                jspWriter.write("<script src=\"" + (String)object + "birt/ajax/core/BirtSoapRequest.js\" type=\"text/javascript\"></script>\n");
                jspWriter.write("<script src=\"" + (String)object + "birt/ajax/core/BirtEvent.js\" type=\"text/javascript\"></script>\n");
                jspWriter.write("<script src=\"" + (String)object + "birt/ajax/taglib/CascadingParameter.js\" type=\"text/javascript\"></script>\n");
                jspWriter.write("<script src=\"" + (String)object + "birt/ajax/taglib/ParameterGroup.js\" type=\"text/javascript\"></script>\n");
                jspWriter.write("<script src=\"" + (String)object + "birt/ajax/taglib/ParameterDefinition.js\" type=\"text/javascript\"></script>\n");
                jspWriter.write("<script src=\"" + (String)object + "birt/ajax/taglib/SoapResponseHelper.js\" type=\"text/javascript\"></script>\n");
                jspWriter.write("<script src=\"" + (String)object + "birt/ajax/taglib/ProgressBar.js\" type=\"text/javascript\"></script>\n");
                this.__createProgressBar((String)object);
                jspWriter.write("<script language=\"JavaScript\">\n");
                jspWriter.write("var progressBar = new ProgressBar( \"progressBar\",\"mask\" );");
                jspWriter.write("</script>\n");
                this.pageContext.setAttribute(IMPORT_FILES_ATTR, (Object)Boolean.TRUE);
            }
            this.groupObjName = "group_" + this.viewer.getId() + "_" + this.paramDef.getGroup().getName();
            if (this.pageContext.findAttribute(this.groupObjName) == null) {
                jspWriter.write("<script  language=\"JavaScript\">var " + this.groupObjName + " = new ParameterGroup( );</script>\n");
                this.pageContext.setAttribute(this.groupObjName, (Object)Boolean.TRUE);
            }
            object = this.getParameterSelectionListForCascadingGroup();
            this.__handleCommonListBox((Collection)object);
            this.__handleCascadingListBox();
        } else {
            Collection collection = BirtReportServiceFactory.getReportService().getParameterSelectionList(this.viewer.getReportDesignHandle(), this.options, this.param.getName());
            if (this.paramDef.isMultiValue()) {
                this.__handleMultiListBox(collection);
            } else {
                this.__handleCommonListBox(collection);
            }
        }
    }

    protected void __createProgressBar(String string) throws Exception {
        JspWriter jspWriter = this.pageContext.getOut();
        jspWriter.write("<DIV ID=\"mask\" STYLE=\"display:none;position:absolute;z-index:200\">\n");
        jspWriter.write("</DIV>\n");
        jspWriter.write("<DIV ID=\"progressBar\" STYLE=\"display:none;position:absolute;z-index:300\">\n");
        jspWriter.write("<TABLE WIDTH=\"250px\" CLASS=\"birtviewer_progressbar\" CELLSPACING=\"10px\">\n");
        jspWriter.write("\t<TR>\n");
        jspWriter.write("\t\t<TD ALIGN=\"center\">\n");
        jspWriter.write("\t\t\t<B>" + BirtResources.getMessage("birt.viewer.progressbar.prompt") + "</B>\n");
        jspWriter.write("\t\t</TD>\n");
        jspWriter.write("\t</TR>\n");
        jspWriter.write("\t<TR>\n");
        jspWriter.write("\t\t<TD ALIGN=\"center\">\n");
        jspWriter.write("\t\t\t<IMG SRC=\"" + string + "birt/images/Loading.gif\" ALT=\"Progress Bar Image\"/>\n");
        jspWriter.write("\t\t</TD>\n");
        jspWriter.write("\t</TR>\n");
        jspWriter.write("\t<TR>\n");
        jspWriter.write("\t\t<TD ALIGN=\"center\">\n");
        jspWriter.write("\t\t\t<DIV ID=\"cancelTaskButton\" STYLE=\"display:block\">\n");
        jspWriter.write("\t\t\t\t<TABLE WIDTH=\"100%\">\n");
        jspWriter.write("\t\t\t\t\t<TR>\n");
        jspWriter.write("\t\t\t\t\t\t<TD ALIGN=\"center\">\n");
        jspWriter.write("\t\t\t\t\t\t\t<INPUT TYPE=\"BUTTON\" VALUE=\"" + BirtResources.getMessage("birt.viewer.dialog.cancel") + "\" \n");
        jspWriter.write("\t\t\t\t\t\t\t\t\tTITLE=\"" + BirtResources.getMessage("birt.viewer.dialog.cancel") + "\" \n");
        jspWriter.write("\t\t\t\t\t\t\t\t\tCLASS=\"birtviewer_progressbar_button\"/>\n");
        jspWriter.write("\t\t\t\t\t\t</TD>\n");
        jspWriter.write("\t\t\t\t\t</TR>\n");
        jspWriter.write("\t\t\t\t</TABLE>\n");
        jspWriter.write("\t\t\t</DIV>\n");
        jspWriter.write("\t\t</TD>\n");
        jspWriter.write("\t</TR>\n");
        jspWriter.write("</TABLE>\n");
        jspWriter.write("</DIV>\n");
        jspWriter.write("<INPUT TYPE=\"HIDDEN\" ID=\"taskid\" VALUE=''/>\n");
    }

    protected void __handleMultiListBox(Collection collection) throws Exception {
        JspWriter jspWriter = this.pageContext.getOut();
        String string = ParameterAccessor.htmlEncode(this.param.getId());
        String string2 = ParameterAccessor.htmlEncode(this.param.getName());
        String string3 = string + "_container";
        String string4 = "__isdisplay__" + string2;
        jspWriter.write("\n<script language=\"JavaScript\">\n");
        jspWriter.write("function handleParam" + string + "( oCtl )\n");
        jspWriter.write("{\n");
        jspWriter.write("  if( !oCtl ) return;\n");
        jspWriter.write("  var container = document.getElementById(\"" + string3 + "\");\n");
        jspWriter.write(" while( container.childNodes.length > 0)\n");
        jspWriter.write("{\n");
        jspWriter.write("  container.removeChild(container.firstChild);\n");
        jspWriter.write("}\n");
        jspWriter.write("\n");
        jspWriter.write("  var options = oCtl.options;\n");
        jspWriter.write("  for( var i = 0; i < options.length; i++ )\n");
        jspWriter.write("  {\n");
        jspWriter.write("    if( !options[i].selected ) continue;\n");
        jspWriter.write("\n");
        jspWriter.write("    var text = options[i].text;\n");
        jspWriter.write("    var value = options[i].value;\n");
        jspWriter.write("\n");
        jspWriter.write("  if( value == '' && text == 'Null Value')\n");
        jspWriter.write("    {\n");
        jspWriter.write("      var oInput = document.createElement( 'input' );\n");
        jspWriter.write("      oInput.type = 'hidden';\n");
        jspWriter.write("      oInput.name = '__isnull';\n");
        jspWriter.write("      oInput.value = \"" + string2 + "\";\n");
        jspWriter.write("      container.appendChild( oInput );\n");
        jspWriter.write("    }\n");
        jspWriter.write("\n");
        jspWriter.write("    var oInput = document.createElement( 'input' );\n");
        jspWriter.write("    oInput.type = 'hidden';\n");
        jspWriter.write("    oInput.name = \"" + string2 + "\";\n");
        jspWriter.write("    oInput.value = value;\n");
        jspWriter.write("    container.appendChild( oInput );\n");
        jspWriter.write("\n");
        jspWriter.write("    var oInput = document.createElement( 'input' );\n");
        jspWriter.write("    oInput.type = 'hidden';\n");
        jspWriter.write("    oInput.name = \"" + string4 + "\";\n");
        jspWriter.write("    oInput.value = text;\n");
        jspWriter.write("    container.appendChild( oInput );\n");
        jspWriter.write("  }\n");
        if (this.isLocale) {
            jspWriter.write("\n");
            jspWriter.write("  var oInput = document.createElement( 'input' );\n");
            jspWriter.write("  oInput.type = 'hidden';\n");
            jspWriter.write("  oInput.name = \"__islocale\";\n");
            jspWriter.write("  oInput.value = \"" + string2 + "\";\n");
            jspWriter.write("  container.appendChild( oInput );\n");
        }
        jspWriter.write("}\n");
        jspWriter.write("</script>\n");
        String string5 = "handleParam" + string + "( this )";
        jspWriter.write("<div id=\"" + string3 + "\" style=\"display:none;\"></div>");
        jspWriter.write("<select ");
        jspWriter.write(" id=\"" + string + "\"");
        this.__handleGeneralDefinition();
        jspWriter.write(" onchange=\"" + string5 + "\"");
        jspWriter.write(" multiple='true'");
        jspWriter.write(" >\n");
        if (!this.paramDef.isRequired()) {
            jspWriter.write("<option value='' ");
            if (DataUtil.contain(this.valueStringList, "")) {
                jspWriter.write(" selected ");
            }
            jspWriter.write("></option>\n");
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string6;
            ParameterSelectionChoice parameterSelectionChoice = (ParameterSelectionChoice)iterator.next();
            Object object = parameterSelectionChoice.getValue();
            try {
                object = DataUtil.convert(object, this.paramDef.getDataType());
            }
            catch (Exception exception) {
                object = null;
            }
            if ((string6 = DataUtil.getDisplayValue(object)) == null) continue;
            String string7 = parameterSelectionChoice.getLabel();
            if (string7 == null || string7.length() <= 0) {
                string7 = ParameterValidationUtil.getDisplayValue(null, (String)this.pattern, (Object)object, (Locale)this.locale);
            }
            string7 = string7 != null ? string7 : "";
            jspWriter.write("<option value=\"" + ParameterAccessor.htmlEncode(string6) + "\"");
            if (DataUtil.contain(this.valueStringList, string6)) {
                jspWriter.write(" selected");
            }
            jspWriter.write(">");
            jspWriter.write(ParameterAccessor.htmlEncode(string7));
            jspWriter.write("</option>\n");
        }
        if (!this.paramDef.isRequired()) {
            jspWriter.write("<option value=''");
            if (DataUtil.contain(this.valueStringList, null)) {
                jspWriter.write(" selected");
            }
            jspWriter.write(" >");
            jspWriter.write("Null Value</option>\n");
        }
        jspWriter.write("</select>\n");
        jspWriter.write("\n<script language=\"JavaScript\">\n");
        jspWriter.write("var selectCtl = document.getElementById(\"" + string + "\");\n");
        jspWriter.write("if( selectCtl.options.length > 8 )\n");
        jspWriter.write("  selectCtl.size = 8;\n");
        jspWriter.write("else\n");
        jspWriter.write("  selectCtl.size = selectCtl.options.length;\n");
        jspWriter.write("handleParam" + string + "( selectCtl );\n");
        jspWriter.write("</script>\n");
    }

    protected void __handleCommonListBox(Collection collection) throws Exception {
        Object object;
        Object object2;
        Object object3;
        JspWriter jspWriter = this.pageContext.getOut();
        String string = ParameterAccessor.htmlEncode(this.param.getId());
        String string2 = ParameterAccessor.htmlEncode(this.param.getName());
        String string3 = string + "_displayText";
        String string4 = "__isdisplay__" + string2;
        boolean bl = false;
        boolean bl2 = this.param.getValue() == null;
        String string5 = string + "_value";
        String string6 = string + "_null";
        String string7 = string + "_radio_select";
        String string8 = string + "_radio_input";
        String string9 = string + "_input";
        String string10 = string + "_islocale";
        String string11 = string + "_pattern";
        String string12 = string2 + "_format";
        if (!this.paramDef.mustMatch()) {
            jspWriter.write("\n<script language=\"JavaScript\">\n");
            jspWriter.write("function updateParam" + string + "( flag )\n");
            jspWriter.write("{\n");
            jspWriter.write("var radioSelectCtl = document.getElementById(\"" + string7 + "\");\n");
            jspWriter.write("if( radioSelectCtl ) radioSelectCtl.checked = flag;\n");
            jspWriter.write("var radioTextCtl = document.getElementById(\"" + string8 + "\");\n");
            jspWriter.write("if( radioTextCtl ) radioTextCtl.checked = !flag;\n");
            jspWriter.write("var selectCtl = document.getElementById(\"" + string + "\");\n");
            jspWriter.write("if( selectCtl ) selectCtl.disabled = !flag;\n");
            jspWriter.write("var inputCtl = document.getElementById(\"" + string9 + "\");\n");
            jspWriter.write("if( inputCtl ) inputCtl.disabled = flag;\n");
            jspWriter.write("var localeCtl = document.getElementById(\"" + string10 + "\");\n");
            jspWriter.write("if( localeCtl )\n");
            jspWriter.write("{\n");
            jspWriter.write("  if( flag )\n");
            jspWriter.write("    localeCtl.name = '';\n");
            jspWriter.write("  else\n");
            jspWriter.write("    localeCtl.name = \"__islocale\";\n");
            jspWriter.write("}\n");
            jspWriter.write("if( flag )\n");
            jspWriter.write("{\n");
            jspWriter.write("  if( selectCtl.selectedIndex >= 0 )\n");
            jspWriter.write("    handleParam" + string + "( selectCtl.options[selectCtl.selectedIndex] );\n");
            jspWriter.write("  else\n");
            jspWriter.write("  {\n");
            jspWriter.write("    var nullCtl = document.getElementById(\"" + string6 + "\");\n");
            jspWriter.write("    if( nullCtl ) nullCtl.name=\"__isnull\";\n");
            jspWriter.write("    var valCtl = document.getElementById(\"" + string5 + "\");\n");
            jspWriter.write("    if( valCtl ) valCtl.name = '';\n");
            jspWriter.write("    if( valCtl ) valCtl.value = '';\n");
            jspWriter.write("    var displayCtl = document.getElementById(\"" + string3 + "\");\n");
            jspWriter.write("    if( displayCtl ) displayCtl.value = '';\n");
            jspWriter.write("    if( displayCtl ) displayCtl.name = '';\n");
            jspWriter.write("  }\n");
            jspWriter.write("}\n");
            jspWriter.write("else\n");
            jspWriter.write("{\n");
            jspWriter.write("  handleTextParam" + string + "( );\n");
            jspWriter.write("}\n");
            jspWriter.write("}\n");
            jspWriter.write("function handleTextParam" + string + "( )\n");
            jspWriter.write("{\n");
            jspWriter.write("var inputCtl = document.getElementById(\"" + string9 + "\");\n");
            jspWriter.write("var valCtl = document.getElementById(\"" + string5 + "\");\n");
            jspWriter.write("if( valCtl ) valCtl.name = \"" + string2 + "\";\n");
            jspWriter.write("if( valCtl ) valCtl.value = inputCtl.value;\n");
            jspWriter.write("var displayCtl = document.getElementById(\"" + string3 + "\");\n");
            jspWriter.write("if( displayCtl ) displayCtl.name = \"" + string4 + "\";\n");
            jspWriter.write("if( displayCtl ) displayCtl.value = inputCtl.value;\n");
            jspWriter.write("var nullCtl = document.getElementById(\"" + string6 + "\");\n");
            jspWriter.write("if( nullCtl ) nullCtl.name='';\n");
            jspWriter.write("var localeCtl = document.getElementById(\"" + string10 + "\");\n");
            jspWriter.write("if( localeCtl ) localeCtl.name = \"__islocale\";\n");
            jspWriter.write("}\n");
            jspWriter.write("function changeTextParam" + string + "( )\n");
            jspWriter.write("{\n");
            jspWriter.write("var patternCtl = document.getElementById(\"" + string11 + "\");\n");
            jspWriter.write("if( patternCtl ) patternCtl.name = \"" + string12 + "\";\n");
            jspWriter.write("  handleTextParam" + string + "( );\n");
            jspWriter.write("}\n");
            jspWriter.write("</script>\n");
        }
        jspWriter.write("\n<script language=\"JavaScript\">\n");
        jspWriter.write("function handleParam" + string + "( option )\n");
        jspWriter.write("{\n");
        jspWriter.write("if( !option ) return;\n");
        jspWriter.write("var valCtl = document.getElementById(\"" + string5 + "\");\n");
        jspWriter.write("var displayCtl = document.getElementById(\"" + string3 + "\");\n");
        jspWriter.write("var nullCtl = document.getElementById(\"" + string6 + "\");\n");
        jspWriter.write("var label = option.text;\n");
        jspWriter.write("var value = option.value;\n");
        jspWriter.write("if( label == \"Null Value\")\n");
        jspWriter.write("{\n");
        jspWriter.write("  if( nullCtl ) nullCtl.name=\"__isnull\";\n");
        jspWriter.write("  if( valCtl ) valCtl.name = '';\n");
        jspWriter.write("  if( valCtl ) valCtl.value = '';\n");
        jspWriter.write("  if( displayCtl ) displayCtl.value = '';\n");
        jspWriter.write("  if( displayCtl ) displayCtl.name = '';\n");
        jspWriter.write("}\n");
        jspWriter.write("else\n");
        jspWriter.write("{\n");
        jspWriter.write("  if( nullCtl ) nullCtl.name='';\n");
        jspWriter.write("  if( valCtl ) valCtl.name = \"" + string2 + "\";\n");
        jspWriter.write("  if( valCtl ) valCtl.value = value;\n");
        jspWriter.write("  if( displayCtl ) displayCtl.name = \"" + string4 + "\";\n");
        jspWriter.write("  if( displayCtl ) displayCtl.value = label;\n");
        jspWriter.write("}\n");
        jspWriter.write("}\n");
        jspWriter.write("</script>\n");
        String string13 = "handleParam" + string + "( this.options[this.selectedIndex] )";
        if (!this.paramDef.mustMatch()) {
            object3 = "updateParam" + string + "( true )";
            jspWriter.write("<input type=\"radio\" ");
            jspWriter.write(" id=\"" + string7 + "\"");
            jspWriter.write(" onclick=\"" + (String)object3 + "\"");
            jspWriter.write(" >\n");
        }
        jspWriter.write("<select ");
        jspWriter.write(" id=\"" + string + "\"");
        this.__handleGeneralDefinition();
        jspWriter.write(" onchange=\"" + string13 + "\"");
        jspWriter.write(" >\n");
        if (!this.paramDef.isRequired()) {
            jspWriter.write("<option value='' ");
            if (this.param.getValue() != null && DataUtil.getString(this.param.getValue()).length() <= 0) {
                jspWriter.write(" selected ");
                bl = true;
            }
            jspWriter.write("></option>\n");
        }
        object3 = collection.iterator();
        while (object3.hasNext()) {
            String string14;
            object2 = (ParameterSelectionChoice)object3.next();
            object = ((ParameterSelectionChoice)object2).getValue();
            try {
                object = DataUtil.convert(object, this.paramDef.getDataType());
            }
            catch (Exception exception) {
                object = null;
            }
            if ((string14 = DataUtil.getDisplayValue(object)) == null) continue;
            String string15 = ((ParameterSelectionChoice)object2).getLabel();
            if (string15 == null || string15.length() <= 0) {
                string15 = ParameterValidationUtil.getDisplayValue(null, (String)this.pattern, (Object)object, (Locale)this.locale);
            }
            string15 = string15 != null ? string15 : "";
            jspWriter.write("<option value=\"" + ParameterAccessor.htmlEncode(string14) + "\"");
            if (string14.equals(DataUtil.getDisplayValue(this.param.getValue()))) {
                bl = true;
                jspWriter.write(" selected");
                if (this.param.getDisplayText() == null) {
                    this.displayTextString = string15;
                } else {
                    string15 = this.param.getDisplayText();
                }
            }
            jspWriter.write(">");
            jspWriter.write(ParameterAccessor.htmlEncode(string15));
            jspWriter.write("</option>\n");
        }
        object3 = null;
        if (!bl) {
            object2 = BirtReportServiceFactory.getReportService().getParameterDefaultValue(this.viewer.getReportDesignHandle(), this.param.getName(), this.options);
            if (object2 == null) {
                bl2 = true;
            } else {
                bl2 = false;
                object3 = DataUtil.getDisplayValue(object2);
                if (this.valueString.equalsIgnoreCase((String)object3) || this.paramDef.mustMatch()) {
                    if (object3 != null) {
                        this.valueString = object3;
                    }
                    if ((object = ParameterValidationUtil.getDisplayValue(null, (String)this.pattern, (Object)object2, (Locale)this.locale)) != null) {
                        this.displayTextString = object;
                    }
                    jspWriter.write("<option ");
                    jspWriter.write(" value=\"" + ParameterAccessor.htmlEncode(this.valueString) + "\" ");
                    jspWriter.write(" selected >");
                    jspWriter.write(ParameterAccessor.htmlEncode(this.displayTextString) + "</option>\n");
                    bl = true;
                }
            }
        }
        if (!this.paramDef.isRequired()) {
            jspWriter.write("<option value=''");
            if (bl2) {
                jspWriter.write(" selected");
            }
            jspWriter.write(" >");
            jspWriter.write("Null Value</option>\n");
            bl = true;
        }
        jspWriter.write("</select>\n");
        if (!this.paramDef.mustMatch()) {
            jspWriter.write("<input type = 'hidden' ");
            jspWriter.write(" id=\"" + string10 + "\" ");
            jspWriter.write(" value=\"" + string2 + "\" ");
            jspWriter.write(" >\n");
            if (this.param.getPattern() != null) {
                jspWriter.write("<input type = 'hidden' id=\"" + string11 + "\"");
                jspWriter.write(" value=\"" + ParameterAccessor.htmlEncode(this.param.getPattern()) + "\">\n");
            }
            object2 = "updateParam" + string + "( false );";
            jspWriter.write("<input type=\"radio\" ");
            jspWriter.write(" id=\"" + string8 + "\"");
            jspWriter.write(" onclick=\"" + (String)object2 + "\"");
            jspWriter.write(" >\n");
            jspWriter.write("<input type=\"text\" ");
            jspWriter.write(" id=\"" + string9 + "\"");
            if (!bl) {
                jspWriter.write(" value=\"" + ParameterAccessor.htmlEncode(this.displayTextString) + "\"");
            }
            jspWriter.write(" onchange=\"changeTextParam" + string + "( )\"");
            jspWriter.write(" >\n");
            jspWriter.write("<script language=\"JavaScript\">updateParam" + string + "(" + bl + ");</script>\n");
        }
        jspWriter.write("<input type=\"hidden\" ");
        jspWriter.write(" id=\"" + string3 + "\" ");
        if (!bl2) {
            jspWriter.write(" name=\"" + string4 + "\" ");
            jspWriter.write(" value=\"" + ParameterAccessor.htmlEncode(this.displayTextString) + "\" ");
        }
        jspWriter.write(" >\n");
        jspWriter.write("<input type=\"hidden\" ");
        jspWriter.write(" id=\"" + string5 + "\" ");
        if (!bl2) {
            jspWriter.write(" name=\"" + string2 + "\" ");
            jspWriter.write(" value=\"" + ParameterAccessor.htmlEncode(this.valueString) + "\" ");
        }
        jspWriter.write(" >\n");
        if (!this.paramDef.isRequired()) {
            jspWriter.write("<input type=\"hidden\" value=\"" + string2 + "\" id=\"" + string6 + "\"");
            if (bl2) {
                jspWriter.write(" name=\"__isnull\"");
            }
            jspWriter.write(" >\n");
        }
        if (!bl && this.paramDef.mustMatch()) {
            jspWriter.write("\n<script language=\"JavaScript\">\n");
            jspWriter.write("var selectCtl = document.getElementById(\"" + string + "\");\n");
            jspWriter.write("if( selectCtl.selectedIndex >= 0 )\n");
            jspWriter.write("{\n");
            if (object3 != null) {
                jspWriter.write("  selectCtl.value = \"" + (String)object3 + "\";\n");
            }
            jspWriter.write("  handleParam" + string + "( selectCtl.options[selectCtl.selectedIndex] );\n");
            jspWriter.write("}\n");
            jspWriter.write("</script>\n");
        }
    }

    protected void __handleCascadingListBox() throws Exception {
        String string = ParameterAccessor.htmlEncode(this.param.getId());
        String string2 = ParameterAccessor.htmlEncode(this.param.getName());
        String string3 = string + "_input";
        JspWriter jspWriter = this.pageContext.getOut();
        jspWriter.write("\n<script language=\"JavaScript\">\n");
        jspWriter.write("var param = new ParameterDefinition(\"" + string + "\",\"" + string2 + "\");\n");
        jspWriter.write("param.setRequired(" + this.paramDef.isRequired() + ");\n");
        jspWriter.write(this.groupObjName + ".addParameter( param );\n");
        jspWriter.write("</script>\n");
        ParameterGroupDefinition parameterGroupDefinition = this.paramDef.getGroup();
        int n = parameterGroupDefinition.getParameters().indexOf(this.paramDef);
        if (n == parameterGroupDefinition.getParameterCount() - 1) {
            return;
        }
        String string4 = "cas" + string;
        String string5 = "names_" + string;
        jspWriter.write("\n<script language=\"JavaScript\">\n");
        jspWriter.write("var " + string5 + " = new Array( " + (n + 2) + " );\n");
        for (int i = 0; i < n + 2; ++i) {
            ParameterDefinition parameterDefinition = (ParameterDefinition)parameterGroupDefinition.getParameters().get(i);
            jspWriter.write(string5 + "[" + i + "] = \"" + ParameterAccessor.htmlEncode(parameterDefinition.getName()) + "\";\n");
        }
        jspWriter.write("var " + string4 + " = new CascadingParameter( \"" + this.viewer.getId() + "\", param, " + string5 + ", " + this.groupObjName + " );\n");
        jspWriter.write("var selectCtl = document.getElementById(\"" + string + "\");\n");
        jspWriter.write("selectCtl.onchange = function( ) { \n");
        jspWriter.write("var selectCtl = document.getElementById(\"" + string + "\");\n");
        jspWriter.write("handleParam" + string + "( selectCtl.options[selectCtl.selectedIndex] );\n");
        jspWriter.write("progressBar.setHandler(" + string4 + ");\n");
        jspWriter.write(string4 + ".process( ); };\n");
        jspWriter.write("var inputCtl = document.getElementById(\"" + string3 + "\");\n");
        jspWriter.write("if( inputCtl )\n");
        jspWriter.write("{\n");
        jspWriter.write("inputCtl.onchange = function( ) { \n");
        jspWriter.write("handleTextParam" + string + "( );\n");
        jspWriter.write("progressBar.setHandler(" + string4 + ");\n");
        jspWriter.write(string4 + ".process( ); };\n");
        jspWriter.write("}\n");
        jspWriter.write("</script>\n");
    }

    private Collection getParameterSelectionListForCascadingGroup() throws ReportServiceException {
        ParameterGroupDefinition parameterGroupDefinition = this.paramDef.getGroup();
        int n = parameterGroupDefinition.getParameters().indexOf(this.paramDef);
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            ParameterDefinition parameterDefinition = (ParameterDefinition)parameterGroupDefinition.getParameters().get(i);
            String string = parameterDefinition.getName();
            objectArray[i] = this.requesterTag.getParameters().get(string);
        }
        return BirtReportServiceFactory.getReportService().getSelectionListForCascadingGroup(this.viewer.getReportDesignHandle(), parameterGroupDefinition.getName(), objectArray, this.options);
    }

    protected void __handleRadioButton() throws Exception {
        Collection collection = BirtReportServiceFactory.getReportService().getParameterSelectionList(this.viewer.getReportDesignHandle(), this.options, this.param.getName());
        if (collection == null || collection.size() <= 0) {
            return;
        }
        JspWriter jspWriter = this.pageContext.getOut();
        String string = ParameterAccessor.htmlEncode(this.param.getId());
        String string2 = ParameterAccessor.htmlEncode(this.param.getName());
        String string3 = string + "_displayText";
        String string4 = "__isdisplay__" + string2;
        String string5 = string + "_null";
        String string6 = string + "_radio_null";
        String string7 = string + "_radio";
        String string8 = string + "_value";
        boolean bl = false;
        jspWriter.write("\n<script language=\"JavaScript\">\n");
        jspWriter.write("function handleParam" + string + "( e )\n");
        jspWriter.write("{\n");
        jspWriter.write("var obj;\n");
        jspWriter.write("if( window.event )\n");
        jspWriter.write("{\n");
        jspWriter.write("  obj = window.event.srcElement;\n");
        jspWriter.write("}\n");
        jspWriter.write("else\n");
        jspWriter.write("{\n");
        jspWriter.write("  if( e ) obj = e.target;\n");
        jspWriter.write("}\n");
        jspWriter.write("if( !obj ) return;\n");
        jspWriter.write("var valCtl = document.getElementById(\"" + string8 + "\");\n");
        jspWriter.write("var displayCtl = document.getElementById(\"" + string3 + "\");\n");
        jspWriter.write("var nullCtl = document.getElementById(\"" + string5 + "\");\n");
        jspWriter.write("if( obj.id == \"" + string6 + "\")\n");
        jspWriter.write("{\n");
        jspWriter.write("  if( nullCtl ) nullCtl.name=\"__isnull\";\n");
        jspWriter.write("  valCtl.name = '';\n");
        jspWriter.write("  valCtl.value = '';\n");
        jspWriter.write("  displayCtl.value = '';\n");
        jspWriter.write("  displayCtl.name = '';\n");
        jspWriter.write("}\n");
        jspWriter.write("else\n");
        jspWriter.write("{\n");
        jspWriter.write("  if( nullCtl ) nullCtl.name='';\n");
        jspWriter.write("  valCtl.name = \"" + string2 + "\";\n");
        jspWriter.write("  valCtl.value = obj.value;\n");
        jspWriter.write("  var labelCtl = document.getElementById( obj.id + \"_label\");\n");
        jspWriter.write("  displayCtl.value = labelCtl.innerHTML;\n");
        jspWriter.write("  displayCtl.name = \"" + string4 + "\";\n");
        jspWriter.write("}\n");
        jspWriter.write("}\n");
        jspWriter.write("</script>\n");
        String string9 = "handleParam" + string + "( event )";
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string10;
            ParameterSelectionChoice parameterSelectionChoice = (ParameterSelectionChoice)iterator.next();
            Object object = parameterSelectionChoice.getValue();
            try {
                object = DataUtil.convert(object, this.paramDef.getDataType());
            }
            catch (Exception exception) {
                object = null;
            }
            if ((string10 = DataUtil.getDisplayValue(object)) == null) continue;
            String string11 = parameterSelectionChoice.getLabel();
            if (string11 == null || string11.length() <= 0) {
                string11 = ParameterValidationUtil.getDisplayValue(null, (String)this.pattern, (Object)object, (Locale)this.locale);
            }
            string11 = string11 != null ? ParameterAccessor.htmlEncode(string11) : "";
            String string12 = string + "_" + n;
            jspWriter.write("<input type=\"radio\" ");
            jspWriter.write(" name=\"" + string7 + "\"");
            jspWriter.write(" id=\"" + string12 + "\"");
            this.__handleGeneralDefinition();
            jspWriter.write(" value=\"" + ParameterAccessor.htmlEncode(string10) + "\"");
            jspWriter.write(" onclick=\"" + string9 + "\"");
            if (string10.equalsIgnoreCase(DataUtil.getDisplayValue(this.param.getValue()))) {
                bl = true;
                jspWriter.write(" checked");
                if (this.param.getDisplayText() == null) {
                    this.displayTextString = string11;
                } else {
                    string11 = this.param.getDisplayText();
                }
            }
            jspWriter.write(" >");
            jspWriter.write("<label id=\"" + string12 + "_label" + "\"");
            jspWriter.write(" title=\"" + string11 + "\"");
            jspWriter.write(" for=\"" + string12 + "\">");
            jspWriter.write(string11);
            jspWriter.write("</label>");
            jspWriter.write("</input>\n");
            ++n;
        }
        if (!this.paramDef.isRequired()) {
            boolean bl2 = this.param.getValue() == null;
            jspWriter.write("<input type=\"hidden\" value=\"" + string2 + "\" id=\"" + string5 + "\"");
            if (bl2) {
                jspWriter.write(" name=\"__isnull\"");
            }
            jspWriter.write(" >\n");
            jspWriter.write("<input type=\"radio\" id=\"" + string6 + "\" ");
            jspWriter.write(" name=\"" + string7 + "\"");
            jspWriter.write(" onclick=\"" + string9 + "\"");
            if (bl2) {
                jspWriter.write(" checked ");
            }
            jspWriter.write(" >\n");
            jspWriter.write("<label id=\"" + string6 + "_label" + "\"");
            jspWriter.write(" title=\"Null Value\"");
            jspWriter.write(" for=\"" + string6 + "\">");
            jspWriter.write("Null Value");
            jspWriter.write("</label>");
            jspWriter.write("</input>");
        }
        jspWriter.write("<input type=\"hidden\" ");
        jspWriter.write(" id=\"" + string3 + "\" ");
        if (bl) {
            jspWriter.write(" name=\"" + string4 + "\" ");
            jspWriter.write(" value=\"" + ParameterAccessor.htmlEncode(this.displayTextString) + "\" ");
        }
        jspWriter.write(" >\n");
        jspWriter.write("<input type=\"hidden\" ");
        jspWriter.write(" id=\"" + string8 + "\" ");
        if (bl) {
            jspWriter.write(" name=\"" + string2 + "\" ");
            jspWriter.write(" value=\"" + ParameterAccessor.htmlEncode(this.valueString) + "\" ");
        }
        jspWriter.write(" >\n");
    }

    protected void __handleCheckBox() throws Exception {
        JspWriter jspWriter = this.pageContext.getOut();
        String string = ParameterAccessor.htmlEncode(this.param.getId());
        String string2 = ParameterAccessor.htmlEncode(this.param.getName());
        Boolean bl = (Boolean)this.param.getValue();
        boolean bl2 = bl != null ? bl : false;
        String string3 = string + "_value";
        jspWriter.write("<input type=\"hidden\" ");
        jspWriter.write(" id=\"" + string3 + "\" ");
        jspWriter.write(" name=\"" + string2 + "\" ");
        jspWriter.write(" value=\"" + ParameterAccessor.htmlEncode(this.valueString) + "\" ");
        jspWriter.write(" >\n");
        String string4 = "document.getElementById('" + string3 + "')";
        String string5 = "document.getElementById('" + string + "')";
        String string6 = "var value = 'false';if( " + string5 + ".checked ) value='true';" + string4 + ".value = value;";
        jspWriter.write("<input type=\"checkbox\" ");
        if (this.param.getId() != null) {
            jspWriter.write(" id=\"" + string + "\"");
        }
        this.__handleGeneralDefinition();
        jspWriter.write(" onclick=\"" + string6 + "\"");
        if (bl2) {
            jspWriter.write(" checked ");
        }
        jspWriter.write(" >");
    }

    protected void __handleException(Exception exception) throws JspException {
        JspWriter jspWriter = this.pageContext.getOut();
        try {
            jspWriter.write("<font color='red'>");
            jspWriter.write(exception.getMessage());
            jspWriter.write("</font>");
        }
        catch (IOException iOException) {
            throw new JspException((Throwable)iOException);
        }
    }

    public void setId(String string) {
        this.param.setId(string);
    }

    public void setName(String string) {
        this.param.setName(string);
    }

    public void setPattern(String string) {
        this.param.setPattern(string);
    }

    public void setValue(Object object) {
        this.param.setValue(object);
    }

    public void setDisplayText(String string) {
        this.param.setDisplayText(string);
    }

    public void setIsLocale(String string) {
        this.param.setIsLocale(string);
    }

    public void setTitle(String string) {
        this.param.setTitle(string);
    }

    public void setCssClass(String string) {
        this.param.setCssClass(string);
    }

    public void setStyle(String string) {
        this.param.setStyle(string);
    }
}

