/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.taglib;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.service.BirtReportServiceFactory;
import org.eclipse.birt.report.service.ReportEngineService;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.taglib.AbstractViewerTag;
import org.eclipse.birt.report.taglib.component.ParameterField;
import org.eclipse.birt.report.taglib.util.BirtTagUtil;
import org.eclipse.birt.report.utility.BirtUtility;
import org.eclipse.birt.report.utility.DataUtil;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class ReportTag
extends AbstractViewerTag {
    private static final long serialVersionUID = -5017824486972742042L;
    private String outputFormat;
    private IViewerReportDesignHandle reportDesignHandle;
    private InputOptions options;

    public void __process() throws Exception {
        boolean bl = true;
        if ("div".equalsIgnoreCase(this.viewer.getReportContainer())) {
            bl = false;
        }
        this.outputFormat = BirtTagUtil.getFormat(this.viewer.getFormat());
        if (!this.outputFormat.equalsIgnoreCase("html")) {
            bl = true;
        }
        if (bl) {
            this.__processWithIFrame();
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
        this.options = new InputOptions();
        this.options.setOption("request", httpServletRequest);
        this.options.setOption("locale", this.locale);
        this.options.setOption("rtl", Boolean.valueOf(this.viewer.getRtl()));
        this.options.setOption("isMasterPageContent", Boolean.valueOf(this.viewer.getAllowMasterPage()));
        this.options.setOption("svgFlag", Boolean.valueOf(this.viewer.getSvg()));
        this.options.setOption("format", this.outputFormat);
        this.options.setOption("isDesigner", new Boolean(false));
        this.options.setOption("servletPath", "/preview");
        BirtReportServiceFactory.getReportService().setContext(this.pageContext.getServletContext(), this.options);
        this.reportDesignHandle = BirtTagUtil.getDesignHandle(httpServletRequest, this.viewer);
        if (this.viewer.isHostPage()) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)this.pageContext.getResponse();
            this.__handleOutputReport((OutputStream)httpServletResponse.getOutputStream());
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.__handleOutputReport(byteArrayOutputStream);
            String string = byteArrayOutputStream.toString();
            JspWriter jspWriter = this.pageContext.getOut();
            jspWriter.write(this.__handleStyle(string));
            jspWriter.write(this.__handleScript(string));
            jspWriter.write("<div id='" + this.viewer.getId() + "'" + this.__handleDivAppearance() + ">\n");
            jspWriter.write("<div class='" + this.__handleBodyStyle(string) + "'>\n");
            jspWriter.write(this.__handleBody(string) + "\n");
            jspWriter.write("</div>\n");
            jspWriter.write("</div>\n");
        }
    }

    private void __processWithIFrame() throws Exception {
        if (this.viewer.isHostPage()) {
            this.__handleIFrame(this.viewer.createURI("preview"), null);
        } else {
            this.__handleIFrame(this.viewer.createURI("preview"), this.viewer.getId());
        }
    }

    protected String __handleDivAppearance() {
        String string = " style='";
        if (this.viewer.getPosition() != null) {
            string = string + "position:" + this.viewer.getPosition() + ";";
        }
        if (this.viewer.getHeight() >= 0) {
            string = string + "height:" + this.viewer.getHeight() + "px;";
        }
        if (this.viewer.getWidth() >= 0) {
            string = string + "width:" + this.viewer.getWidth() + "px;";
        }
        if (this.viewer.getTop() != null) {
            string = string + "top:" + this.viewer.getTop() + "px;";
        }
        if (this.viewer.getLeft() != null) {
            string = string + "left:" + this.viewer.getLeft() + "px;";
        }
        if ("yes".equalsIgnoreCase(this.viewer.getScrolling())) {
            string = string + "overflow:scroll";
        } else if ("auto".equalsIgnoreCase(this.viewer.getScrolling())) {
            string = string + "overflow:auto";
        }
        if (this.viewer.getStyle() != null) {
            string = string + this.viewer.getStyle() + ";";
        }
        string = string + "' ";
        return string;
    }

    protected String __handleStyle(String string) throws Exception {
        String string2 = "";
        if (string == null) {
            return string2;
        }
        Pattern pattern = Pattern.compile("<\\s*style[^\\>]*\\>", 2);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            int n = matcher.end();
            int n2 = string.toLowerCase().indexOf("</style>", n);
            string2 = string2 + string.substring(n + 1, n2) + "\n";
        }
        string2 = string2.replaceAll(".style", ".style" + this.viewer.getId());
        string2 = "<style type=\"text/css\">\n" + string2 + "\n</style>\n";
        return string2;
    }

    protected String __handleBodyStyle(String string) {
        String string2 = "";
        if (string == null) {
            return string2;
        }
        Pattern pattern = Pattern.compile("<\\s*body([^\\>]*)\\>", 2);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            for (int i = 1; i < matcher.groupCount() + 1; ++i) {
                Pattern pattern2;
                Matcher matcher2;
                String string3 = matcher.group(i);
                if (string3 == null || !(matcher2 = (pattern2 = Pattern.compile("class\\s*=\\s*\"([^\"]+)\"", 2)).matcher(string3.trim())).find()) continue;
                string2 = matcher2.group(1).trim();
                break;
            }
        }
        string2 = string2.replaceAll("style", "style" + this.viewer.getId());
        return string2;
    }

    protected String __handleScript(String string) {
        int n;
        int n2;
        String string2 = "";
        if (string == null) {
            return string2;
        }
        String string3 = this.__handleHead(string);
        if (string3 == null) {
            return string2;
        }
        Pattern pattern = Pattern.compile("<\\s*!--");
        Matcher matcher = pattern.matcher(string3);
        while (matcher.find()) {
            n2 = matcher.start();
            n = string3.indexOf("-->", n2);
            if (n <= 0) continue;
            String string4 = string3.substring(0, n2);
            String string5 = string3.substring(n + 3);
            string3 = string4 + string5;
        }
        pattern = Pattern.compile("<\\s*script[^\\>]*\\>", 2);
        matcher = pattern.matcher(string3);
        while (matcher.find()) {
            n2 = matcher.start();
            n = string3.toLowerCase().indexOf("</script>", n2);
            if (n <= 0) continue;
            string2 = string2 + string3.substring(n2, n + 9) + "\n";
        }
        return string2;
    }

    protected String __handleHead(String string) {
        if (string == null) {
            return "";
        }
        String string2 = "";
        try {
            Pattern pattern = Pattern.compile("<\\s*head[^\\>]*\\>", 2);
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                int n = matcher.end();
                int n2 = string.toLowerCase().indexOf("</head>");
                string2 = string.substring(n + 1, n2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    protected String __handleBody(String string) {
        String string2 = string;
        if (string == null) {
            return "";
        }
        try {
            Pattern pattern = Pattern.compile("<\\s*body[^\\>]*\\>", 2);
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                int n = matcher.end();
                int n2 = string.toLowerCase().indexOf("</body>");
                string2 = string.substring(n + 1, n2);
            }
        }
        catch (Exception exception) {
            string2 = string;
        }
        string2 = string2.replaceAll("class=\"style", "class=\"style" + this.viewer.getId());
        return string2;
    }

    protected void __handleOutputReport(OutputStream outputStream) throws Exception {
        ReportEngineService.getInstance().setMaxRows(this.viewer.getMaxRowsOfRecords());
        if (this.viewer.isDocumentInUrl()) {
            this.__renderDocument(outputStream);
        } else {
            this.__renderReport(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __renderDocument(OutputStream outputStream) throws Exception {
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
        String string = ParameterAccessor.getReportDocument(httpServletRequest, this.viewer.getReportDocument(), false);
        IReportDocument iReportDocument = ReportEngineService.getInstance().openReportDocument(null, string, BirtTagUtil.getModuleOptions(this.viewer));
        try {
            Locale locale = (Locale)this.options.getOption("locale");
            String string2 = (String)this.options.getOption("format");
            Boolean bl = (Boolean)this.options.getOption("isMasterPageContent");
            boolean bl2 = bl == null ? false : bl;
            Boolean bl3 = (Boolean)this.options.getOption("isMasterPageContent");
            boolean bl4 = bl3 == null ? false : bl3;
            Boolean bl5 = (Boolean)this.options.getOption("rtl");
            String string3 = (String)this.options.getOption("servletPath");
            if (this.viewer.getReportletId() != null) {
                ReportEngineService.getInstance().renderReportlet(outputStream, httpServletRequest, iReportDocument, this.viewer.getReportletId(), string2, bl2, bl4, null, locale, bl5, string3);
            } else {
                ReportEngineService.getInstance().renderReport(outputStream, httpServletRequest, iReportDocument, string2, this.viewer.getPageNum(), this.viewer.getPageRange(), bl2, bl4, null, locale, bl5, string3);
            }
        }
        finally {
            if (iReportDocument != null) {
                iReportDocument.close();
            }
        }
    }

    private void __renderReport(OutputStream outputStream) throws Exception {
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
        Locale locale = (Locale)this.options.getOption("locale");
        Boolean bl = (Boolean)this.options.getOption("isMasterPageContent");
        Boolean bl2 = (Boolean)this.options.getOption("svgFlag");
        String string = (String)this.options.getOption("format");
        Boolean bl3 = (Boolean)this.options.getOption("rtl");
        String string2 = (String)this.options.getOption("servletPath");
        IReportRunnable iReportRunnable = (IReportRunnable)this.reportDesignHandle.getDesignObject();
        String string3 = ParameterAccessor.htmlDecode(BirtUtility.getTitleFromDesign(this.reportDesignHandle));
        Map map = this.__handleParameters(this.reportDesignHandle, null);
        Collection collection = this.getReportService().getParameterDefinitions(this.reportDesignHandle, this.options, false);
        Map map2 = BirtUtility.getDisplayTexts(collection, null, (HttpServletRequest)this.pageContext.getRequest());
        ReportEngineService.getInstance().runAndRenderReport(httpServletRequest, iReportRunnable, outputStream, string, locale, bl3, map, bl, bl2, Boolean.TRUE, null, null, map2, string2, string3);
    }

    protected Map __handleParameters(IViewerReportDesignHandle iViewerReportDesignHandle, Map hashMap) throws Exception {
        List list;
        if (hashMap == null) {
            hashMap = new HashMap<String, Object>();
        }
        if ((list = BirtUtility.getParameterList(iViewerReportDesignHandle)) == null) {
            return hashMap;
        }
        Map map = this.viewer.getParameters();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object e = iterator.next();
            if (!(e instanceof ScalarParameterHandle)) continue;
            ScalarParameterHandle scalarParameterHandle = (ScalarParameterHandle)e;
            boolean bl = "multi-value".equalsIgnoreCase(scalarParameterHandle.getParamType());
            String string = scalarParameterHandle.getName();
            ParameterField parameterField = (ParameterField)map.get(string);
            if (parameterField != null) {
                object = parameterField.getValue();
                if (object == null) {
                    hashMap.put(string, null);
                    continue;
                }
                if (!(object instanceof String)) {
                    if (bl) {
                        Object[] objectArray = object instanceof Object[] ? (Object[])object : new Object[]{object};
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (objectArray[i] == null || !(objectArray[i] instanceof String)) continue;
                            objectArray[i] = this.getParameterValue(scalarParameterHandle, parameterField, (String)objectArray[i]);
                        }
                        hashMap.put(string, objectArray);
                        continue;
                    }
                    hashMap.put(string, object);
                    continue;
                }
                Object object2 = this.getParameterValue(scalarParameterHandle, parameterField, (String)object);
                if (bl) {
                    hashMap.put(string, new Object[]{object2});
                    continue;
                }
                hashMap.put(string, object2);
                continue;
            }
            object = this.getReportService().getParameterDefaultValue(iViewerReportDesignHandle, string, this.options);
            hashMap.put(string, object);
        }
        return hashMap;
    }

    private Object getParameterValue(ScalarParameterHandle scalarParameterHandle, ParameterField parameterField, String string) throws Exception {
        String string2 = scalarParameterHandle.getDataType();
        if ("string".equalsIgnoreCase(string2)) {
            return string;
        }
        String string3 = parameterField.getPattern();
        if (string3 == null || string3.length() <= 0) {
            string3 = scalarParameterHandle.getPattern();
        }
        return DataUtil.validate(scalarParameterHandle.getDataType(), string3, string, this.locale, parameterField.isLocale());
    }

    protected IViewerReportService getReportService() {
        return BirtReportServiceFactory.getReportService();
    }

    public void setReportContainer(String string) {
        this.viewer.setReportContainer(string);
    }
}

