/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.taglib.util;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.exception.ViewerException;
import org.eclipse.birt.report.service.BirtViewerReportDesignHandle;
import org.eclipse.birt.report.service.ReportEngineService;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.taglib.component.ViewerField;
import org.eclipse.birt.report.utility.BirtUtility;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class BirtTagUtil {
    public static String convertBooleanValue(String string) {
        boolean bl = Boolean.valueOf(string);
        return String.valueOf(bl);
    }

    public static boolean convertToBoolean(String string) {
        if (string == null) {
            return false;
        }
        return Boolean.valueOf(string);
    }

    public static String getFormat(String string) {
        if (string == null || string.length() <= 0) {
            return "html";
        }
        if (string.equalsIgnoreCase("htm")) {
            return "html";
        }
        return string;
    }

    public static Locale getLocale(HttpServletRequest httpServletRequest, String string) {
        Locale locale = null;
        locale = ParameterAccessor.getLocaleFromString(string);
        if (locale == null) {
            locale = httpServletRequest.getLocale();
        }
        if (locale == null) {
            locale = ParameterAccessor.webAppLocale;
        }
        return locale;
    }

    public static String createAbsolutePath(String string) {
        if (string != null && string.trim().length() > 0 && ParameterAccessor.isRelativePath(string)) {
            return ParameterAccessor.workingFolder + File.separator + string;
        }
        return string;
    }

    public static IViewerReportDesignHandle getDesignHandle(HttpServletRequest httpServletRequest, ViewerField viewerField) throws Exception {
        IReportDocument iReportDocument;
        if (viewerField == null) {
            return null;
        }
        BirtViewerReportDesignHandle birtViewerReportDesignHandle = null;
        IReportRunnable iReportRunnable = null;
        String string = ParameterAccessor.getReport(httpServletRequest, viewerField.getReportDesign());
        String string2 = ParameterAccessor.getReportDocument(httpServletRequest, viewerField.getReportDocument(), false);
        boolean bl = ParameterAccessor.isValidFilePath(viewerField.getReportDocument());
        if (string2 != null && bl && (iReportDocument = ReportEngineService.getInstance().openReportDocument(string, string2, BirtTagUtil.getModuleOptions(viewerField))) != null) {
            viewerField.setDocumentInUrl(true);
            iReportRunnable = iReportDocument.getReportRunnable();
            iReportDocument.close();
        }
        if (iReportRunnable == null) {
            if (string2 != null && string == null) {
                if (bl) {
                    throw new ViewerException("birt.viewer.generalException.DOCUMENT_FILE_ERROR", new String[]{string2});
                }
                throw new ViewerException("birt.viewer.generalException.DOCUMENT_ACCESS_ERROR", new String[]{string2});
            }
            if (!ParameterAccessor.isValidFilePath(viewerField.getReportDesign())) {
                throw new ViewerException("birt.viewer.generalException.REPORT_ACCESS_ERROR", new String[]{string});
            }
            iReportRunnable = BirtUtility.getRunnableFromDesignFile(httpServletRequest, string, BirtTagUtil.getModuleOptions(viewerField));
            if (iReportRunnable == null) {
                throw new ViewerException("birt.viewer.generalException.REPORT_FILE_ERROR", new String[]{string});
            }
        }
        if (iReportRunnable != null) {
            birtViewerReportDesignHandle = new BirtViewerReportDesignHandle("rptRunnableObject", iReportRunnable);
        }
        return birtViewerReportDesignHandle;
    }

    public static Map getModuleOptions(ViewerField viewerField) {
        if (viewerField == null) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = viewerField.getResourceFolder();
        if (string == null || string.trim().length() <= 0) {
            string = ParameterAccessor.birtResourceFolder;
        }
        hashMap.put("resourceFolder", string);
        hashMap.put("semanticCheck", Boolean.FALSE);
        return hashMap;
    }
}

