/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.utility;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.exception.CoreException;
import org.eclipse.birt.report.model.api.metadata.ValidationValueException;
import org.eclipse.birt.report.model.api.util.ParameterValidationUtil;

public class DataUtil {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static String getString(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static String trimString(String string) {
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    public static String trimSepEnd(String string) {
        if ((string = DataUtil.trimString(string)).endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String trimSepFirst(String string) {
        if ((string = DataUtil.trimString(string)).startsWith(File.separator)) {
            string = string.substring(1, string.length());
        }
        return string;
    }

    private static String getDefaultDateFormat(String string) {
        String string2 = null;
        if ("dateTime".equalsIgnoreCase(string)) {
            string2 = "MM/dd/yyyy hh:mm:ss.SSS a";
        } else if ("date".equalsIgnoreCase(string)) {
            string2 = "MM/dd/yyyy";
        } else if ("time".equalsIgnoreCase(string)) {
            string2 = "hh:mm:ss a";
        }
        return string2;
    }

    public static Object validate(String string, String string2, String string3, Locale locale, boolean bl) throws ValidationValueException {
        Object object = null;
        if (string3 == null) {
            return object;
        }
        object = bl ? DataUtil.validateWithLocale(string, string2, string3, locale) : ParameterValidationUtil.validate((String)string, (String)DataUtil.getDefaultDateFormat(string), (String)string3);
        return object;
    }

    public static Object validateWithPattern(String string, String string2, String string3, Locale locale, boolean bl) throws ValidationValueException {
        Object object = null;
        if (string3 == null) {
            return object;
        }
        if (bl) {
            object = DataUtil.validateWithLocale(string, string2, string3, locale);
        } else {
            if (string2 == null) {
                string2 = DataUtil.getDefaultDateFormat(string);
            }
            object = ParameterValidationUtil.validate((String)string, (String)string2, (String)string3);
        }
        return object;
    }

    public static Object validateWithLocale(String string, String string2, String string3, Locale locale) throws ValidationValueException {
        Object object = null;
        if (string3 == null) {
            return object;
        }
        try {
            if (string2 == null) {
                if ("date".equalsIgnoreCase(string)) {
                    string2 = "Long Date";
                } else if ("time".equalsIgnoreCase(string)) {
                    string2 = "Medium Time";
                } else if ("dateTime".equalsIgnoreCase(string)) {
                    string2 = "Unformatted";
                }
            }
            object = ParameterValidationUtil.validate((String)string, (String)string2, (String)string3, (Locale)locale);
        }
        catch (Exception exception) {
            object = ParameterValidationUtil.validate((String)string, (String)DataUtil.getDefaultDateFormat(string), (String)string3);
        }
        return object;
    }

    public static String getDisplayValue(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Float || object instanceof Double || object instanceof BigDecimal || object instanceof com.ibm.icu.math.BigDecimal) {
            return object.toString();
        }
        return ParameterValidationUtil.getDisplayValue((Object)object);
    }

    public static String getCSVDisplayValue(Object object) throws BirtException {
        if (object == null) {
            return null;
        }
        if (object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof BigDecimal || object instanceof com.ibm.icu.math.BigDecimal) {
            return object.toString();
        }
        return DataTypeUtil.toString((Object)object);
    }

    public static Object convert(Object object, int n) throws BirtException {
        if (object == null) {
            return null;
        }
        if (n == 0) {
            return object;
        }
        switch (n) {
            case 6: {
                return DataTypeUtil.toInteger((Object)object);
            }
            case 3: {
                return DataTypeUtil.toBigDecimal((Object)object);
            }
            case 5: {
                return DataTypeUtil.toBoolean((Object)object);
            }
            case 4: {
                return DataTypeUtil.toDate((Object)object);
            }
            case 2: {
                return DataTypeUtil.toDouble((Object)object);
            }
            case 1: {
                return DataTypeUtil.toString((Object)object);
            }
            case 7: {
                return DataTypeUtil.toSqlDate((Object)object);
            }
            case 8: {
                return DataTypeUtil.toSqlTime((Object)object);
            }
        }
        throw new CoreException("Invalid type.");
    }

    public static String toUTF8(byte[] byArray) {
        if (!$assertionsDisabled && byArray == null) {
            throw new AssertionError();
        }
        String string = null;
        try {
            string = new String(byArray, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public static String getOdaTypeName(int n) {
        switch (n) {
            case 4: {
                return "INT";
            }
            case 6: 
            case 8: {
                return "DOUBLE";
            }
            case 12: {
                return "STRING";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 2: 
            case 3: {
                return "BIGDECIMAL";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
        }
        return "STRING";
    }

    public static boolean contain(List list, String string) {
        if (list == null) {
            return false;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e == null ? string == null : e instanceof String && ((String)e).equals(string))) continue;
            return true;
        }
        return false;
    }

    static {
        $assertionsDisabled = !DataUtil.class.desiredAssertionStatus();
    }
}

