/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.engine.emitter.excel.Data;
import org.eclipse.birt.report.engine.emitter.excel.ExcelUtil;
import org.eclipse.birt.report.engine.emitter.excel.GroupInfo;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;

public class TableBinding {
    private ComputedColumn[] computedColumns = new ComputedColumn[0];
    private DataItemDesign[] dataItemDesigns = new DataItemDesign[0];
    private String[] columnExpressions = new String[0];
    private Map dataItemDesign2DataList = new HashMap();

    public TableBinding(List cols) {
        if (cols == null) {
            return;
        }
        this.computedColumns = new ComputedColumn[cols.size()];
        int i = 0;
        while (i < this.computedColumns.length) {
            this.computedColumns[i] = (ComputedColumn)cols.get(i);
            if (this.computedColumns[i].getAggregateOn() == null) {
                this.computedColumns[i].setAggregateOn("Table");
            }
            ++i;
        }
        this.dataItemDesigns = new DataItemDesign[this.computedColumns.length];
    }

    public void dump(Map unsolvedDatas) {
        Iterator it = this.dataItemDesign2DataList.entrySet().iterator();
        while (it.hasNext()) {
            List x = (List)it.next().getValue();
            int i = 0;
            while (i < x.size()) {
                unsolvedDatas.put(x.get(i), x.get(i));
                ++i;
            }
        }
        this.dataItemDesign2DataList.clear();
    }

    public void add2DataList(Object design, Data data) {
        Data d = (Data)data.clone();
        d.style = null;
        d.span = null;
        ArrayList<Data> x = (ArrayList<Data>)this.dataItemDesign2DataList.get(design);
        if (x == null) {
            x = new ArrayList<Data>();
            x.add(d);
            this.dataItemDesign2DataList.put(design, x);
        } else {
            x.add(d);
        }
    }

    public boolean isAggregateData(Object data) {
        int i = 0;
        while (i < this.dataItemDesigns.length) {
            if (this.dataItemDesigns[i] == data) {
                return this.computedColumns[i].getExpression().startsWith("Total");
            }
            ++i;
        }
        return false;
    }

    public String[] getColumnExpression() {
        if (this.columnExpressions.length == 0) {
            this.columnExpressions = new String[this.computedColumns.length];
            int i = 0;
            while (i < this.columnExpressions.length) {
                this.columnExpressions[i] = this.computedColumns[i].getExpression();
                ++i;
            }
        }
        return this.columnExpressions;
    }

    public int getDataItemDesignIndex(Object data) {
        int i = 0;
        while (i < this.dataItemDesigns.length) {
            if (this.dataItemDesigns[i] == data) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void compute(GroupInfo root) {
        int i = 0;
        while (i < this.dataItemDesigns.length) {
            Object o = this.dataItemDesign2DataList.get(this.dataItemDesigns[i]);
            if (o != null) {
                List groupDatas = (List)o;
                String expression = this.computedColumns[i].getExpression();
                if (ExcelUtil.isValidExp(expression, this.columnExpressions)) {
                    int j = 0;
                    while (j < groupDatas.size()) {
                        Data d = (Data)groupDatas.get(j);
                        try {
                            List ps = root.getByGroup(this.computedColumns[i].getAggregateOn(), ExcelUtil.getColumnOfExp(expression), j);
                            d.txt = ExcelUtil.createFormula(d.txt.toString(), expression, ps);
                            d.setNotTxtData();
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public boolean tryBind(DataItemDesign data) {
        String columnName = (String)data.getHandle().getElement().getProperty(null, "resultSetColumn");
        if (columnName == null) {
            return false;
        }
        int i = 0;
        while (i < this.computedColumns.length) {
            if (this.computedColumns[i].getName().equals(columnName)) {
                this.dataItemDesigns[i] = data;
                return true;
            }
            ++i;
        }
        return false;
    }
}

