/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script;

import com.ibm.icu.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

public class DateTimeSpan {
    protected static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.core.script.DateTimeSpan");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.core.script.DateTimeSpan");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    private DateTimeSpan() {
    }

    public static int years(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return 0;
        }
        if (!DateTimeSpan.validateDateArgus(startDate, endDate)) {
            return -DateTimeSpan.years(endDate, startDate);
        }
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDate);
        int startYear = startCal.get(1) - 1900;
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endDate);
        int endYear = endCal.get(1) - 1900;
        if (!$assertionsDisabled && endYear < startYear) {
            throw new AssertionError();
        }
        int spanYear = endYear - startYear;
        startCal.add(1, spanYear);
        startDate = startCal.getTime();
        endDate = endCal.getTime();
        if (startDate.compareTo(endDate) > 0) {
            --spanYear;
        }
        return spanYear;
    }

    public static int months(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return 0;
        }
        if (!DateTimeSpan.validateDateArgus(startDate, endDate)) {
            return -DateTimeSpan.months(endDate, startDate);
        }
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDate);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endDate);
        int startMonth = startCal.get(1) * 12 + startCal.get(2);
        int endMonth = endCal.get(1) * 12 + endCal.get(2);
        int spanMonth = endMonth - startMonth;
        startCal.add(2, spanMonth);
        if (startCal.getTime().compareTo(endCal.getTime()) > 0) {
            --spanMonth;
        }
        return spanMonth;
    }

    public static int days(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return 0;
        }
        if (!DateTimeSpan.validateDateArgus(startDate, endDate)) {
            return -DateTimeSpan.days(endDate, startDate);
        }
        long diff = endDate.getTime() - startDate.getTime();
        return new Long(diff / 86400000L).intValue();
    }

    public static int hours(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return 0;
        }
        if (!DateTimeSpan.validateDateArgus(startDate, endDate)) {
            return -DateTimeSpan.hours(endDate, startDate);
        }
        long diff = endDate.getTime() - startDate.getTime();
        return new Long(diff / 3600000L).intValue();
    }

    public static int minutes(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return 0;
        }
        if (!DateTimeSpan.validateDateArgus(startDate, endDate)) {
            return -DateTimeSpan.minutes(endDate, startDate);
        }
        long diff = endDate.getTime() - startDate.getTime();
        return new Long(diff / 60000L).intValue();
    }

    public static int seconds(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return 0;
        }
        if (!DateTimeSpan.validateDateArgus(startDate, endDate)) {
            return -DateTimeSpan.seconds(endDate, startDate);
        }
        long diff = endDate.getTime() - startDate.getTime();
        return new Long(diff / 1000L).intValue();
    }

    public static Date addDate(Date startDate, int years, int months, int days) {
        Calendar startCal = Calendar.getInstance();
        Date firstDate = startDate;
        startCal.setTime(firstDate);
        startCal.add(1, years);
        startCal.add(2, months);
        startCal.add(5, days);
        return startCal.getTime();
    }

    public static Date addTime(Date startDate, int hours, int minutes, int seconds) {
        Calendar startCal = Calendar.getInstance();
        Date firstDate = startDate;
        startCal.setTime(firstDate);
        startCal.add(11, hours);
        startCal.add(12, minutes);
        startCal.add(13, seconds);
        return startCal.getTime();
    }

    public static Date subDate(Date startDate, int years, int months, int days) {
        Calendar startCal = Calendar.getInstance();
        Date firstDate = startDate;
        startCal.setTime(firstDate);
        return DateTimeSpan.addDate(startDate, -years, -months, -days);
    }

    public static Date subTime(Date startDate, int hours, int minutes, int seconds) {
        return DateTimeSpan.addTime(startDate, -hours, -minutes, -seconds);
    }

    private static boolean validateDateArgus(Date start, Date end) {
        return start.compareTo(end) <= 0;
    }
}

