/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.birt.core.archive.compound.ArchiveConstants;
import org.eclipse.birt.core.archive.compound.Block;
import org.eclipse.birt.core.archive.compound.BlockManagerEventAdapter;

public class BlockManager
implements ArchiveConstants {
    static int totalCacheSize = 0;
    BlockManagerEventAdapter eventAdapter;
    int poolSize;
    final int blockSize;
    HashMap blocks;
    Block firstBlock;
    Block lastBlock;

    public BlockManager(BlockManagerEventAdapter adapter) {
        this(adapter, 4096);
    }

    BlockManager(BlockManagerEventAdapter adapter, int blockSize) {
        this.eventAdapter = adapter;
        this.blockSize = blockSize;
        this.poolSize = 1024;
        this.blocks = new HashMap(this.poolSize);
        this.firstBlock = null;
        this.lastBlock = null;
    }

    int getCacheSize() {
        return this.poolSize * this.blockSize;
    }

    public void setCacheSize(int cacheSize) {
        int blockCount = cacheSize / this.blockSize;
        if (blockCount <= 2) {
            blockCount = 2;
        }
        this.poolSize = blockCount;
    }

    int getUsedCache() {
        return this.blocks.size() * this.blockSize;
    }

    void reset() {
        BlockManager.increaseTotalCacheSize(-this.blocks.size() * this.blockSize);
        this.blocks.clear();
        this.firstBlock = null;
        this.lastBlock = null;
    }

    static synchronized void increaseTotalCacheSize(int size) {
        totalCacheSize += size;
    }

    public void flush() throws IOException {
        if (this.eventAdapter != null) {
            Block block = this.firstBlock;
            while (block != null) {
                this.eventAdapter.flush(block);
                block = block.next;
            }
        }
    }

    public Block getBlock(int id) throws IOException {
        if (this.firstBlock == null) {
            Block block = new Block(this.blockSize);
            BlockManager.increaseTotalCacheSize(this.blockSize);
            block.id = id;
            block.prev = null;
            block.next = null;
            this.firstBlock = this.lastBlock = block;
            this.blocks.put(new Integer(id), block);
            if (this.eventAdapter != null) {
                this.eventAdapter.refresh(block);
            }
            return block;
        }
        if (id == this.firstBlock.id) {
            return this.firstBlock;
        }
        Block block = (Block)this.blocks.get(new Integer(id));
        if (block == null) {
            if (this.blocks.size() >= this.poolSize) {
                block = this.lastBlock;
                this.lastBlock = this.lastBlock.prev;
                this.lastBlock.next = null;
                this.blocks.remove(new Integer(block.id));
                if (this.eventAdapter != null) {
                    this.eventAdapter.flush(block);
                }
                block.reset();
            } else {
                block = new Block(this.blockSize);
                BlockManager.increaseTotalCacheSize(this.blockSize);
            }
            block.id = id;
            this.blocks.put(new Integer(id), block);
            if (this.eventAdapter != null) {
                this.eventAdapter.refresh(block);
            }
        } else {
            block.prev.next = block.next;
            if (this.lastBlock != block) {
                block.next.prev = block.prev;
            } else {
                this.lastBlock = block.prev;
            }
        }
        block.prev = null;
        block.next = this.firstBlock;
        this.firstBlock.prev = block;
        this.firstBlock = block;
        return block;
    }
}

