/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocListener;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Graphic;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Meta;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Section;
import com.lowagie.text.StringCompare;
import com.lowagie.text.Table;
import com.lowagie.text.Watermark;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.MultiColumnText;
import com.lowagie.text.pdf.PageResources;
import com.lowagie.text.pdf.PdfAcroForm;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfCell;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfFileSpecification;
import com.lowagie.text.pdf.PdfFont;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLine;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPage;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageLabels;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTable;
import com.lowagie.text.pdf.PdfTextArray;
import com.lowagie.text.pdf.PdfTransition;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.PdfXConformanceException;
import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

class PdfDocument
extends Document
implements DocListener {
    static final String hangingPunctuation = ".,;:'";
    private PdfWriter writer;
    private PdfInfo info = new PdfInfo();
    private boolean firstPageEvent = true;
    private boolean isParagraph = true;
    private PdfLine line = null;
    private float indentLeft = 0.0f;
    private float indentRight = 0.0f;
    private float listIndentLeft = 0.0f;
    private int alignment = 0;
    private PdfContentByte text;
    private PdfContentByte graphics;
    private ArrayList lines = new ArrayList();
    private float leading = 0.0f;
    private float currentHeight = 0.0f;
    private float indentTop = 0.0f;
    private float indentBottom = 0.0f;
    private boolean pageEmpty = true;
    private int textEmptySize;
    protected Rectangle nextPageSize = null;
    protected HashMap thisBoxSize = new HashMap();
    protected HashMap boxSize = new HashMap();
    protected PageResources pageResources;
    private Image imageWait = null;
    private float imageEnd = -1.0f;
    private float imageIndentLeft = 0.0f;
    private float imageIndentRight = 0.0f;
    private ArrayList annotations;
    private ArrayList delayedAnnotations = new ArrayList();
    PdfAcroForm acroForm;
    private PdfOutline rootOutline;
    private PdfOutline currentOutline;
    private PdfAction currentAction = null;
    private TreeMap localDestinations = new TreeMap(new StringCompare());
    private ArrayList documentJavaScript = new ArrayList();
    private int viewerPreferences = 0;
    private String openActionName;
    private PdfAction openActionAction;
    private PdfDictionary additionalActions;
    private PdfPageLabels pageLabels;
    private boolean isNewpage = false;
    private float paraIndent = 0.0f;
    protected float nextMarginLeft;
    protected float nextMarginRight;
    protected float nextMarginTop;
    protected float nextMarginBottom;
    protected int duration = -1;
    protected PdfTransition transition = null;
    protected PdfDictionary pageAA = null;
    private boolean strictImageSequence = false;
    private int lastElementType = -1;

    public PdfDocument() throws DocumentException {
        this.addProducer();
        this.addCreationDate();
    }

    public void addWriter(PdfWriter pdfWriter) throws DocumentException {
        if (this.writer == null) {
            this.writer = pdfWriter;
            this.acroForm = new PdfAcroForm(pdfWriter);
            return;
        }
        throw new DocumentException("You can only add a writer to a PdfDocument once.");
    }

    public boolean setPageSize(Rectangle rectangle) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        this.nextPageSize = new Rectangle(rectangle);
        return true;
    }

    public void setHeader(HeaderFooter headerFooter) {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.setHeader(headerFooter);
    }

    public void resetHeader() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.resetHeader();
    }

    public void setFooter(HeaderFooter headerFooter) {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.setFooter(headerFooter);
    }

    public void resetFooter() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.resetFooter();
    }

    public void resetPageCount() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.resetPageCount();
    }

    public void setPageCount(int n) {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.setPageCount(n);
    }

    public boolean add(Watermark watermark) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        this.watermark = watermark;
        return true;
    }

    public void removeWatermark() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        this.watermark = null;
    }

    public boolean setMargins(float f, float f2, float f3, float f4) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        this.nextMarginLeft = f;
        this.nextMarginRight = f2;
        this.nextMarginTop = f3;
        this.nextMarginBottom = f4;
        return true;
    }

    protected PdfArray rotateAnnotations() {
        PdfArray pdfArray = new PdfArray();
        int n = this.pageSize.getRotation() % 360;
        int n2 = this.writer.getCurrentPageNumber();
        int n3 = 0;
        while (n3 < this.annotations.size()) {
            PdfAnnotation pdfAnnotation = (PdfAnnotation)this.annotations.get(n3);
            int n4 = pdfAnnotation.getPlaceInPage();
            if (n4 > n2) {
                this.delayedAnnotations.add(pdfAnnotation);
            } else {
                Object object;
                if (pdfAnnotation.isForm()) {
                    if (!pdfAnnotation.isUsed() && (object = pdfAnnotation.getTemplates()) != null) {
                        this.acroForm.addFieldTemplates((HashMap)object);
                    }
                    if (((PdfFormField)(object = (PdfFormField)pdfAnnotation)).getParent() == null) {
                        this.acroForm.addDocumentField(((PdfAnnotation)object).getIndirectReference());
                    }
                }
                if (pdfAnnotation.isAnnotation()) {
                    pdfArray.add(pdfAnnotation.getIndirectReference());
                    if (!pdfAnnotation.isUsed()) {
                        object = (PdfRectangle)pdfAnnotation.get(PdfName.RECT);
                        switch (n) {
                            case 90: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(this.pageSize.top() - ((PdfRectangle)object).bottom(), ((PdfRectangle)object).left(), this.pageSize.top() - ((PdfRectangle)object).top(), ((PdfRectangle)object).right()));
                                break;
                            }
                            case 180: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(this.pageSize.right() - ((PdfRectangle)object).left(), this.pageSize.top() - ((PdfRectangle)object).bottom(), this.pageSize.right() - ((PdfRectangle)object).right(), this.pageSize.top() - ((PdfRectangle)object).top()));
                                break;
                            }
                            case 270: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(((PdfRectangle)object).bottom(), this.pageSize.right() - ((PdfRectangle)object).left(), ((PdfRectangle)object).top(), this.pageSize.right() - ((PdfRectangle)object).right()));
                            }
                        }
                    }
                }
                if (!pdfAnnotation.isUsed()) {
                    pdfAnnotation.setUsed();
                    try {
                        this.writer.addToBody((PdfObject)pdfAnnotation, pdfAnnotation.getIndirectReference());
                    }
                    catch (IOException iOException) {
                        throw new ExceptionConverter(iOException);
                    }
                }
            }
            ++n3;
        }
        return pdfArray;
    }

    public boolean newPage() throws DocumentException {
        PdfArray pdfArray;
        this.lastElementType = -1;
        this.isNewpage = true;
        if (this.writer.getDirectContent().size() == 0 && this.writer.getDirectContentUnder().size() == 0 && (this.pageEmpty || this.writer != null && this.writer.isPaused())) {
            return false;
        }
        PdfPageEvent pdfPageEvent = this.writer.getPageEvent();
        if (pdfPageEvent != null) {
            pdfPageEvent.onEndPage(this.writer, this);
        }
        super.newPage();
        this.imageIndentLeft = 0.0f;
        this.imageIndentRight = 0.0f;
        this.flushLines();
        this.pageResources.addDefaultColorDiff(this.writer.getDefaultColorspace());
        PdfDictionary pdfDictionary = this.pageResources.getResources();
        if (this.writer.getPDFXConformance() != 0) {
            if (this.thisBoxSize.containsKey("art") && this.thisBoxSize.containsKey("trim")) {
                throw new PdfXConformanceException("Only one of ArtBox or TrimBox can exist in the page.");
            }
            if (!this.thisBoxSize.containsKey("art") && !this.thisBoxSize.containsKey("trim")) {
                if (this.thisBoxSize.containsKey("crop")) {
                    this.thisBoxSize.put("trim", this.thisBoxSize.get("crop"));
                } else {
                    this.thisBoxSize.put("trim", new PdfRectangle(this.pageSize, this.pageSize.getRotation()));
                }
            }
        }
        int n = this.pageSize.getRotation();
        PdfPage pdfPage = new PdfPage(new PdfRectangle(this.pageSize, n), this.thisBoxSize, pdfDictionary, n);
        if (this.transition != null) {
            pdfPage.put(PdfName.TRANS, this.transition.getTransitionDictionary());
            this.transition = null;
        }
        if (this.duration > 0) {
            pdfPage.put(PdfName.DUR, new PdfNumber(this.duration));
            this.duration = 0;
        }
        if (this.pageAA != null) {
            try {
                pdfPage.put(PdfName.AA, this.writer.addToBody(this.pageAA).getIndirectReference());
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
            this.pageAA = null;
        }
        if (this.annotations.size() > 0 && (pdfArray = this.rotateAnnotations()).size() != 0) {
            pdfPage.put(PdfName.ANNOTS, pdfArray);
        }
        if (!this.open || this.close) {
            throw new PdfException("The document isn't open.");
        }
        if (this.text.size() > this.textEmptySize) {
            this.text.endText();
        } else {
            this.text = null;
        }
        this.writer.add(pdfPage, new PdfContents(this.writer.getDirectContentUnder(), this.graphics, this.text, this.writer.getDirectContent(), this.pageSize));
        this.initPage();
        this.isNewpage = false;
        return true;
    }

    public void open() {
        if (!this.open) {
            super.open();
            this.writer.open();
            this.currentOutline = this.rootOutline = new PdfOutline(this.writer);
        }
        try {
            this.initPage();
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    void outlineTree(PdfOutline pdfOutline) throws IOException {
        pdfOutline.setIndirectReference(this.writer.getPdfIndirectReference());
        if (pdfOutline.parent() != null) {
            pdfOutline.put(PdfName.PARENT, pdfOutline.parent().indirectReference());
        }
        ArrayList arrayList = pdfOutline.getKids();
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            this.outlineTree((PdfOutline)arrayList.get(n2));
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                ((PdfOutline)arrayList.get(n2)).put(PdfName.PREV, ((PdfOutline)arrayList.get(n2 - 1)).indirectReference());
            }
            if (n2 < n - 1) {
                ((PdfOutline)arrayList.get(n2)).put(PdfName.NEXT, ((PdfOutline)arrayList.get(n2 + 1)).indirectReference());
            }
            ++n2;
        }
        if (n > 0) {
            pdfOutline.put(PdfName.FIRST, ((PdfOutline)arrayList.get(0)).indirectReference());
            pdfOutline.put(PdfName.LAST, ((PdfOutline)arrayList.get(n - 1)).indirectReference());
        }
        n2 = 0;
        while (n2 < n) {
            PdfOutline pdfOutline2 = (PdfOutline)arrayList.get(n2);
            this.writer.addToBody((PdfObject)pdfOutline2, pdfOutline2.indirectReference());
            ++n2;
        }
    }

    void writeOutlines() throws IOException {
        if (this.rootOutline.getKids().size() == 0) {
            return;
        }
        this.outlineTree(this.rootOutline);
        this.writer.addToBody((PdfObject)this.rootOutline, this.rootOutline.indirectReference());
    }

    void traverseOutlineCount(PdfOutline pdfOutline) {
        ArrayList arrayList = pdfOutline.getKids();
        PdfOutline pdfOutline2 = pdfOutline.parent();
        if (arrayList.size() == 0) {
            if (pdfOutline2 != null) {
                pdfOutline2.setCount(pdfOutline2.getCount() + 1);
            }
        } else {
            int n = 0;
            while (n < arrayList.size()) {
                this.traverseOutlineCount((PdfOutline)arrayList.get(n));
                ++n;
            }
            if (pdfOutline2 != null) {
                if (pdfOutline.isOpen()) {
                    pdfOutline2.setCount(pdfOutline.getCount() + pdfOutline2.getCount() + 1);
                } else {
                    pdfOutline2.setCount(pdfOutline2.getCount() + 1);
                    pdfOutline.setCount(-pdfOutline.getCount());
                }
            }
        }
    }

    void calculateOutlineCount() {
        if (this.rootOutline.getKids().size() == 0) {
            return;
        }
        this.traverseOutlineCount(this.rootOutline);
    }

    public void close() {
        if (this.close) {
            return;
        }
        try {
            this.newPage();
            if (this.imageWait != null) {
                this.newPage();
            }
            if (this.annotations.size() > 0) {
                throw new RuntimeException(String.valueOf(this.annotations.size()) + " annotations had invalid placement pages.");
            }
            PdfPageEvent pdfPageEvent = this.writer.getPageEvent();
            if (pdfPageEvent != null) {
                pdfPageEvent.onCloseDocument(this.writer, this);
            }
            super.close();
            this.writer.addLocalDestinations(this.localDestinations);
            this.calculateOutlineCount();
            this.writeOutlines();
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        this.writer.close();
    }

    PageResources getPageResources() {
        return this.pageResources;
    }

    void addPTable(PdfPTable pdfPTable) throws DocumentException {
        ColumnText columnText = new ColumnText(this.writer.getDirectContent());
        if (this.currentHeight > 0.0f) {
            Paragraph paragraph = new Paragraph();
            paragraph.setLeading(0.0f);
            columnText.addElement(paragraph);
        }
        columnText.addElement(pdfPTable);
        boolean bl = pdfPTable.isHeadersInEvent();
        pdfPTable.setHeadersInEvent(true);
        int n = 0;
        while (true) {
            columnText.setSimpleColumn(this.indentLeft(), this.indentBottom(), this.indentRight(), this.indentTop() - this.currentHeight);
            int n2 = columnText.go();
            if ((n2 & 1) != 0) {
                this.text.moveText(0.0f, columnText.getYLine() - this.indentTop() + this.currentHeight);
                this.currentHeight = this.indentTop() - columnText.getYLine();
                break;
            }
            n = this.indentTop() - this.currentHeight == columnText.getYLine() ? ++n : 0;
            if (n == 3) {
                this.add(new Paragraph("ERROR: Infinite table loop"));
                break;
            }
            this.newPage();
        }
        pdfPTable.setHeadersInEvent(bl);
    }

    PdfTable getPdfTable(Table table, boolean bl) {
        return new PdfTable(table, this.indentLeft(), this.indentRight(), this.indentTop() - this.currentHeight, bl);
    }

    boolean breakTableIfDoesntFit(PdfTable pdfTable) throws DocumentException {
        pdfTable.updateRowAdditions();
        if (!pdfTable.hasToFitPageTable() && pdfTable.bottom() <= this.indentBottom) {
            this.add(pdfTable, true);
            return true;
        }
        return false;
    }

    private void add(PdfTable pdfTable, boolean bl) throws DocumentException {
        boolean bl2;
        this.flushLines();
        float f = this.indentTop();
        float f2 = this.currentHeight;
        PdfContentByte pdfContentByte = new PdfContentByte(this.writer);
        boolean bl3 = pdfTable.hasToFitPageTable() ? pdfTable.bottom() < this.indentBottom() : (bl2 = false);
        if (this.pageEmpty) {
            bl2 = false;
        }
        boolean bl4 = pdfTable.hasToFitPageCells();
        ArrayList arrayList = pdfTable.getCells();
        ArrayList arrayList2 = pdfTable.getHeaderCells();
        if (arrayList2.size() > 0 && (arrayList.size() == 0 || arrayList.get(0) != arrayList2.get(0))) {
            ArrayList arrayList3 = new ArrayList(arrayList.size() + arrayList2.size());
            arrayList3.addAll(arrayList2);
            arrayList3.addAll(arrayList);
            arrayList = arrayList3;
        }
        while (!arrayList.isEmpty()) {
            float f3;
            int n;
            PdfCell pdfCell;
            float f4 = 0.0f;
            boolean bl5 = false;
            int n2 = 0;
            boolean bl6 = false;
            Object object = arrayList.listIterator();
            while (object.hasNext() && !bl2) {
                pdfCell = (PdfCell)object.next();
                if (bl4) {
                    if (!pdfCell.isHeader()) {
                        if (pdfCell.getGroupNumber() != n2) {
                            boolean bl7 = true;
                            n2 = pdfCell.getGroupNumber();
                            int n3 = 0;
                            while (pdfCell.getGroupNumber() == n2 && bl7 && object.hasNext()) {
                                if (pdfCell.bottom() < this.indentBottom()) {
                                    bl7 = false;
                                }
                                pdfCell = (PdfCell)object.next();
                                ++n3;
                            }
                            if (!bl7) break;
                            int n4 = n3;
                            while (n4 >= 0) {
                                pdfCell = (PdfCell)object.previous();
                                --n4;
                            }
                        }
                    } else if (!bl6) {
                        bl6 = true;
                        boolean bl8 = true;
                        int n5 = 0;
                        float f5 = pdfCell.top();
                        while (pdfCell.isHeader() && bl8 && object.hasNext()) {
                            if (f5 - pdfCell.bottom(0.0f) > this.indentTop() - this.currentHeight - this.indentBottom()) {
                                bl8 = false;
                            }
                            pdfCell = (PdfCell)object.next();
                            ++n5;
                        }
                        n2 = pdfCell.getGroupNumber();
                        while (pdfCell.getGroupNumber() == n2 && bl8 && object.hasNext()) {
                            if ((double)(f5 - pdfCell.bottom(0.0f)) > (double)(this.indentTop() - this.currentHeight - this.indentBottom()) - 10.0) {
                                bl8 = false;
                            }
                            pdfCell = (PdfCell)object.next();
                            ++n5;
                        }
                        n = n5;
                        while (n >= 0) {
                            pdfCell = (PdfCell)object.previous();
                            --n;
                        }
                        if (!bl8) {
                            while (pdfCell.isHeader()) {
                                object.remove();
                                pdfCell = (PdfCell)object.next();
                            }
                            break;
                        }
                    }
                }
                this.lines = pdfCell.getLines(f, this.indentBottom());
                if (this.lines != null && this.lines.size() > 0) {
                    bl5 = true;
                    pdfContentByte.rectangle(pdfCell.rectangle(f, this.indentBottom()));
                    f4 = Math.max(pdfCell.bottom(), this.indentBottom());
                    float f6 = pdfCell.top(f - f2);
                    this.text.moveText(0.0f, f6);
                    f3 = this.flushLines() - f6;
                    this.text.moveText(0.0f, f3);
                    if (f2 + f3 > this.currentHeight) {
                        this.currentHeight = f2 + f3;
                    }
                }
                ArrayList arrayList4 = pdfCell.getImages(f, this.indentBottom());
                Iterator iterator = arrayList4.iterator();
                while (iterator.hasNext()) {
                    bl5 = true;
                    Image image = (Image)iterator.next();
                    this.addImage(this.graphics, image, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                }
                if (!pdfCell.mayBeRemoved()) continue;
                object.remove();
            }
            bl2 = false;
            if (bl5) {
                object = new Rectangle(pdfTable);
                ((Rectangle)object).setBorder(pdfTable.border());
                ((Rectangle)object).setBorderWidth(pdfTable.borderWidth());
                ((Rectangle)object).setBorderColor(pdfTable.borderColor());
                ((Rectangle)object).setBackgroundColor(pdfTable.backgroundColor());
                ((Rectangle)object).setGrayFill(pdfTable.grayFill());
                PdfContentByte pdfContentByte2 = this.writer.getDirectContentUnder();
                pdfContentByte2.rectangle(((Rectangle)object).rectangle(this.top(), this.indentBottom()));
                pdfContentByte2.add(pdfContentByte);
                ((Rectangle)object).setGrayFill(0.0f);
                ((Rectangle)object).setBackgroundColor(null);
                pdfContentByte2.rectangle(((Rectangle)object).rectangle(this.top(), this.indentBottom()));
            }
            pdfContentByte = new PdfContentByte(null);
            if (arrayList.isEmpty()) continue;
            this.graphics.setLineWidth(pdfTable.borderWidth());
            if (bl5 && (pdfTable.border() & 2) == 2) {
                object = pdfTable.borderColor();
                if (object != null) {
                    this.graphics.setColorStroke((Color)object);
                }
                this.graphics.moveTo(pdfTable.left(), Math.max(pdfTable.bottom(), this.indentBottom()));
                this.graphics.lineTo(pdfTable.right(), Math.max(pdfTable.bottom(), this.indentBottom()));
                this.graphics.stroke();
                if (object != null) {
                    this.graphics.resetRGBColorStroke();
                }
            }
            this.pageEmpty = false;
            float f7 = f4;
            this.newPage();
            float f8 = 0.0f;
            boolean bl9 = false;
            if (this.currentHeight > 0.0f) {
                f8 = 6.0f;
                this.currentHeight += f8;
                bl9 = true;
                this.newLine();
                this.flushLines();
                this.indentTop = this.currentHeight - this.leading;
                this.currentHeight = 0.0f;
            } else {
                this.flushLines();
            }
            int n6 = arrayList2.size();
            if (n6 > 0) {
                pdfCell = (PdfCell)arrayList2.get(0);
                float f9 = pdfCell.top(0.0f);
                int n7 = 0;
                while (n7 < n6) {
                    pdfCell = (PdfCell)arrayList2.get(n7);
                    pdfCell.setTop(this.indentTop() - f9 + pdfCell.top(0.0f));
                    pdfCell.setBottom(this.indentTop() - f9 + pdfCell.bottom(0.0f));
                    f = pdfCell.bottom();
                    pdfContentByte.rectangle(pdfCell.rectangle(this.indentTop(), this.indentBottom()));
                    ArrayList arrayList5 = pdfCell.getImages(this.indentTop(), this.indentBottom());
                    Iterator iterator = arrayList5.iterator();
                    while (iterator.hasNext()) {
                        bl5 = true;
                        Image image = (Image)iterator.next();
                        this.addImage(this.graphics, image, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                    }
                    this.lines = pdfCell.getLines(this.indentTop(), this.indentBottom());
                    float f10 = pdfCell.top(this.indentTop());
                    this.text.moveText(0.0f, f10 - f8);
                    f3 = this.flushLines() - f10 + f8;
                    this.text.moveText(0.0f, f3);
                    ++n7;
                }
                this.currentHeight = this.indentTop() - f + pdfTable.cellspacing();
                this.text.moveText(0.0f, f - this.indentTop() - this.currentHeight);
            } else if (bl9) {
                f = this.indentTop();
                this.text.moveText(0.0f, -pdfTable.cellspacing());
            }
            f2 = this.currentHeight - f8;
            n6 = Math.min(arrayList.size(), pdfTable.columns());
            n = 0;
            while (n < n6) {
                float f11;
                float f12;
                pdfCell = (PdfCell)arrayList.get(n);
                if (pdfCell.top(-pdfTable.cellspacing()) > f4 && (f12 = f - f7 + pdfCell.bottom()) > f - (f11 = pdfCell.remainingHeight())) {
                    f7 += f12 - (f - f11);
                }
                ++n;
            }
            n6 = arrayList.size();
            pdfTable.setTop(this.indentTop());
            pdfTable.setBottom(f - f7 + pdfTable.bottom(pdfTable.cellspacing()));
            n = 0;
            while (n < n6) {
                pdfCell = (PdfCell)arrayList.get(n);
                float f13 = f - f7 + pdfCell.top(-pdfTable.cellspacing());
                if (f13 > this.indentTop() - this.currentHeight) {
                    f13 = this.indentTop() - this.currentHeight;
                }
                float f14 = f13 - pdfCell.height();
                pdfCell.setTop(f13);
                pdfCell.setBottom(f14);
                ++n;
            }
            if (bl) break;
        }
        float f15 = pdfTable.top() - pdfTable.bottom();
        this.currentHeight = f2 + f15;
        this.text.moveText(0.0f, -f15);
        this.pageEmpty = false;
    }

    public boolean add(Element element) throws DocumentException {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        try {
            switch (element.type()) {
                case 0: {
                    this.info.addkey(((Meta)element).name(), ((Meta)element).content());
                    break;
                }
                case 1: {
                    this.info.addTitle(((Meta)element).content());
                    break;
                }
                case 2: {
                    this.info.addSubject(((Meta)element).content());
                    break;
                }
                case 3: {
                    this.info.addKeywords(((Meta)element).content());
                    break;
                }
                case 4: {
                    this.info.addAuthor(((Meta)element).content());
                    break;
                }
                case 7: {
                    this.info.addCreator(((Meta)element).content());
                    break;
                }
                case 5: {
                    this.info.addProducer();
                    break;
                }
                case 6: {
                    this.info.addCreationDate();
                    break;
                }
                case 10: {
                    PdfChunk pdfChunk;
                    if (this.line == null) {
                        this.carriageReturn();
                    }
                    PdfChunk pdfChunk2 = new PdfChunk((Chunk)element, this.currentAction);
                    while ((pdfChunk = this.line.add(pdfChunk2)) != null) {
                        this.carriageReturn();
                        pdfChunk2 = pdfChunk;
                    }
                    this.pageEmpty = false;
                    if (!pdfChunk2.isAttribute("NEWPAGE")) break;
                    this.newPage();
                    break;
                }
                case 17: {
                    Anchor anchor = (Anchor)element;
                    String string = anchor.reference();
                    this.leading = anchor.leading();
                    if (string != null) {
                        this.currentAction = new PdfAction(string);
                    }
                    element.process(this);
                    this.currentAction = null;
                    break;
                }
                case 29: {
                    if (this.line == null) {
                        this.carriageReturn();
                    }
                    Annotation annotation = (Annotation)element;
                    switch (annotation.annotationType()) {
                        case 1: {
                            this.annotations.add(new PdfAnnotation(this.writer, annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury(), new PdfAction((URL)annotation.attributes().get(Annotation.URL))));
                            break;
                        }
                        case 2: {
                            this.annotations.add(new PdfAnnotation(this.writer, annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury(), new PdfAction((String)annotation.attributes().get(Annotation.FILE))));
                            break;
                        }
                        case 3: {
                            this.annotations.add(new PdfAnnotation(this.writer, annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury(), new PdfAction((String)annotation.attributes().get(Annotation.FILE), (String)annotation.attributes().get(Annotation.DESTINATION))));
                            break;
                        }
                        case 7: {
                            boolean[] blArray = (boolean[])annotation.attributes().get(Annotation.PARAMETERS);
                            String string = (String)annotation.attributes().get(Annotation.FILE);
                            String string2 = (String)annotation.attributes().get(Annotation.MIMETYPE);
                            PdfFileSpecification pdfFileSpecification = blArray[0] ? PdfFileSpecification.fileEmbedded(this.writer, string, string, null) : PdfFileSpecification.fileExtern(this.writer, string);
                            PdfAnnotation pdfAnnotation = PdfAnnotation.createScreen(this.writer, new Rectangle(annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury()), string, pdfFileSpecification, string2, blArray[1]);
                            this.annotations.add(pdfAnnotation);
                            break;
                        }
                        case 4: {
                            this.annotations.add(new PdfAnnotation(this.writer, annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury(), new PdfAction((String)annotation.attributes().get(Annotation.FILE), (Integer)annotation.attributes().get(Annotation.PAGE))));
                            break;
                        }
                        case 5: {
                            this.annotations.add(new PdfAnnotation(this.writer, annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury(), new PdfAction((Integer)annotation.attributes().get(Annotation.NAMED))));
                            break;
                        }
                        case 6: {
                            this.annotations.add(new PdfAnnotation(this.writer, annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury(), new PdfAction((String)annotation.attributes().get(Annotation.APPLICATION), (String)annotation.attributes().get(Annotation.PARAMETERS), (String)annotation.attributes().get(Annotation.OPERATION), (String)annotation.attributes().get(Annotation.DEFAULTDIR))));
                            break;
                        }
                        default: {
                            PdfAnnotation pdfAnnotation = new PdfAnnotation(this.writer, annotation.llx(this.indentRight() - this.line.widthLeft()), annotation.lly(this.indentTop() - this.currentHeight), annotation.urx(this.indentRight() - this.line.widthLeft() + 20.0f), annotation.ury(this.indentTop() - this.currentHeight - 20.0f), new PdfString(annotation.title()), new PdfString(annotation.content()));
                            this.annotations.add(pdfAnnotation);
                        }
                    }
                    this.pageEmpty = false;
                    break;
                }
                case 11: {
                    this.leading = ((Phrase)element).leading();
                    element.process(this);
                    break;
                }
                case 12: {
                    Object object;
                    Paragraph paragraph = (Paragraph)element;
                    float f = paragraph.spacingBefore();
                    if (f != 0.0f) {
                        this.leading = f;
                        this.carriageReturn();
                        if (!this.pageEmpty) {
                            object = new Chunk(" ");
                            ((Chunk)object).process(this);
                            this.carriageReturn();
                        }
                    }
                    this.alignment = paragraph.alignment();
                    this.leading = paragraph.leading();
                    this.carriageReturn();
                    if (this.currentHeight + this.line.height() + this.leading > this.indentTop() - this.indentBottom()) {
                        this.newPage();
                    }
                    this.indentLeft += paragraph.indentationLeft();
                    this.indentRight += paragraph.indentationRight();
                    this.carriageReturn();
                    this.paraIndent += paragraph.indentationLeft();
                    object = this.writer.getPageEvent();
                    if (object != null && this.isParagraph) {
                        object.onParagraph(this.writer, this, this.indentTop() - this.currentHeight);
                    }
                    if (paragraph.getKeepTogether()) {
                        Table table = new Table(1, 1);
                        table.setOffset(0.0f);
                        table.setBorder(0);
                        table.setWidth(100.0f);
                        table.setTableFitsPage(true);
                        Cell cell = new Cell(paragraph);
                        cell.setBorder(0);
                        cell.setHorizontalAlignment(paragraph.alignment());
                        table.addCell(cell);
                        this.add(table);
                        break;
                    }
                    element.process(this);
                    this.paraIndent -= paragraph.indentationLeft();
                    float f2 = paragraph.spacingAfter();
                    if (f2 != 0.0f) {
                        this.leading = f2;
                        this.carriageReturn();
                        if (this.currentHeight + this.line.height() + this.leading < this.indentTop() - this.indentBottom()) {
                            Chunk chunk = new Chunk(" ");
                            chunk.process(this);
                            this.carriageReturn();
                        }
                        this.leading = paragraph.leading();
                    }
                    if (object != null && this.isParagraph) {
                        object.onParagraphEnd(this.writer, this, this.indentTop() - this.currentHeight);
                    }
                    this.alignment = 0;
                    this.indentLeft -= paragraph.indentationLeft();
                    this.indentRight -= paragraph.indentationRight();
                    this.carriageReturn();
                    break;
                }
                case 13: 
                case 16: {
                    boolean bl;
                    Section section = (Section)element;
                    boolean bl2 = bl = section.title() != null;
                    if (section.isChapter()) {
                        this.newPage();
                    } else {
                        this.newLine();
                    }
                    if (bl) {
                        PdfOutline pdfOutline;
                        float f = this.indentTop() - this.currentHeight;
                        int n = this.pageSize.getRotation();
                        if (n == 90 || n == 180) {
                            f = this.pageSize.height() - f;
                        }
                        PdfDestination pdfDestination = new PdfDestination(2, f);
                        while (this.currentOutline.level() >= section.depth()) {
                            this.currentOutline = this.currentOutline.parent();
                        }
                        this.currentOutline = pdfOutline = new PdfOutline(this.currentOutline, pdfDestination, section.getBookmarkTitle(), section.isBookmarkOpen());
                    }
                    this.carriageReturn();
                    this.indentLeft += section.indentationLeft();
                    this.indentRight += section.indentationRight();
                    PdfPageEvent pdfPageEvent = this.writer.getPageEvent();
                    if (pdfPageEvent != null) {
                        if (element.type() == 16) {
                            pdfPageEvent.onChapter(this.writer, this, this.indentTop() - this.currentHeight, section.title());
                        } else {
                            pdfPageEvent.onSection(this.writer, this, this.indentTop() - this.currentHeight, section.depth(), section.title());
                        }
                    }
                    if (bl) {
                        this.isParagraph = false;
                        this.add(section.title());
                        this.isParagraph = true;
                    }
                    this.indentLeft += section.indentation();
                    element.process(this);
                    this.indentLeft -= section.indentationLeft() + section.indentation();
                    this.indentRight -= section.indentationRight();
                    if (pdfPageEvent == null) break;
                    if (element.type() == 16) {
                        pdfPageEvent.onChapterEnd(this.writer, this, this.indentTop() - this.currentHeight);
                        break;
                    }
                    pdfPageEvent.onSectionEnd(this.writer, this, this.indentTop() - this.currentHeight);
                    break;
                }
                case 14: {
                    List list = (List)element;
                    this.listIndentLeft += list.indentationLeft();
                    this.indentRight += list.indentationRight();
                    element.process(this);
                    this.listIndentLeft -= list.indentationLeft();
                    this.indentRight -= list.indentationRight();
                    break;
                }
                case 15: {
                    ListItem listItem = (ListItem)element;
                    float f = listItem.spacingBefore();
                    if (f != 0.0f) {
                        this.leading = f;
                        this.carriageReturn();
                        if (!this.pageEmpty) {
                            Chunk chunk = new Chunk(" ");
                            chunk.process(this);
                            this.carriageReturn();
                        }
                    }
                    this.alignment = listItem.alignment();
                    this.listIndentLeft += listItem.indentationLeft();
                    this.indentRight += listItem.indentationRight();
                    this.leading = listItem.leading();
                    this.carriageReturn();
                    this.line.setListItem(listItem);
                    element.process(this);
                    float f3 = listItem.spacingAfter();
                    if (f3 != 0.0f) {
                        this.leading = f3;
                        this.carriageReturn();
                        if (this.currentHeight + this.line.height() + this.leading < this.indentTop() - this.indentBottom()) {
                            Chunk chunk = new Chunk(" ");
                            chunk.process(this);
                            this.carriageReturn();
                        }
                        this.leading = listItem.leading();
                    }
                    this.carriageReturn();
                    this.listIndentLeft -= listItem.indentationLeft();
                    this.indentRight -= listItem.indentationRight();
                    break;
                }
                case 30: {
                    Rectangle rectangle = (Rectangle)element;
                    this.graphics.rectangle(rectangle);
                    this.pageEmpty = false;
                    break;
                }
                case 23: {
                    PdfPTable pdfPTable = (PdfPTable)element;
                    if (pdfPTable.size() <= pdfPTable.getHeaderRows()) break;
                    this.ensureNewLine();
                    this.flushLines();
                    this.addPTable(pdfPTable);
                    this.pageEmpty = false;
                    break;
                }
                case 40: {
                    this.ensureNewLine();
                    this.flushLines();
                    MultiColumnText multiColumnText = (MultiColumnText)element;
                    float f = multiColumnText.write(this.writer.getDirectContent(), this, this.indentTop() - this.currentHeight);
                    this.currentHeight += f;
                    this.text.moveText(0.0f, -1.0f * f);
                    this.pageEmpty = false;
                    break;
                }
                case 22: {
                    PdfTable pdfTable;
                    if (element instanceof PdfTable) {
                        pdfTable = (PdfTable)element;
                        pdfTable.updateRowAdditions();
                    } else if (element instanceof Table) {
                        float f = ((Table)element).getOffset();
                        if (Float.isNaN(f)) {
                            f = this.leading;
                        }
                        this.carriageReturn();
                        this.lines.add(new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, f));
                        this.currentHeight += f;
                        pdfTable = this.getPdfTable((Table)element, false);
                    } else {
                        return false;
                    }
                    this.add(pdfTable, false);
                    break;
                }
                case 32: 
                case 34: 
                case 35: {
                    this.carriageReturn();
                    this.add((Image)element);
                    break;
                }
                case 39: {
                    Graphic graphic = (Graphic)element;
                    graphic.processAttributes(this.indentLeft(), this.indentBottom(), this.indentRight(), this.indentTop(), this.indentTop() - this.currentHeight);
                    this.graphics.add(graphic);
                    this.pageEmpty = false;
                    break;
                }
                default: {
                    return false;
                }
            }
            this.lastElementType = element.type();
            return true;
        }
        catch (Exception exception) {
            throw new DocumentException(exception);
        }
    }

    private void addImage(PdfContentByte pdfContentByte, Image image, float f, float f2, float f3, float f4, float f5, float f6) throws DocumentException {
        Annotation annotation = image.annotation();
        if (image.hasAbsolutePosition()) {
            pdfContentByte.addImage(image);
            if (annotation != null) {
                annotation.setDimensions(image.absoluteX(), image.absoluteY(), image.absoluteX() + image.scaledWidth(), image.absoluteY() + image.scaledHeight());
                this.add(annotation);
            }
        } else {
            pdfContentByte.addImage(image, f, f2, f3, f4, f5, f6);
            if (annotation != null) {
                annotation.setDimensions(f5, f6, f5 + image.scaledWidth(), f6 + image.scaledHeight());
                this.add(annotation);
            }
        }
    }

    private void add(Image image) throws PdfException, DocumentException {
        if (image.hasAbsolutePosition()) {
            this.addImage(this.graphics, image, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            this.pageEmpty = false;
            return;
        }
        if (this.currentHeight != 0.0f && this.indentTop() - this.currentHeight - image.scaledHeight() < this.indentBottom()) {
            if (!this.strictImageSequence && this.imageWait == null) {
                this.imageWait = image;
                return;
            }
            this.newPage();
            if (this.currentHeight != 0.0f && this.indentTop() - this.currentHeight - image.scaledHeight() < this.indentBottom()) {
                this.imageWait = image;
                return;
            }
        }
        this.pageEmpty = false;
        if (image == this.imageWait) {
            this.imageWait = null;
        }
        boolean bl = (image.alignment() & 4) == 4 && (image.alignment() & 1) != 1;
        boolean bl2 = (image.alignment() & 8) == 8;
        float f = this.leading / 2.0f;
        if (bl) {
            f += this.leading;
        }
        float f2 = this.indentTop() - this.currentHeight - image.scaledHeight() - f;
        float[] fArray = image.matrix();
        float f3 = this.indentLeft() - fArray[4];
        if ((image.alignment() & 2) == 2) {
            f3 = this.indentRight() - image.scaledWidth() - fArray[4];
        }
        if ((image.alignment() & 1) == 1) {
            f3 = this.indentLeft() + (this.indentRight() - this.indentLeft() - image.scaledWidth()) / 2.0f - fArray[4];
        }
        if (image.hasAbsoluteX()) {
            f3 = image.absoluteX();
        }
        this.addImage(this.graphics, image, fArray[0], fArray[1], fArray[2], fArray[3], f3, f2 - fArray[5]);
        if (bl) {
            if (this.imageEnd < 0.0f || this.imageEnd < this.currentHeight + image.scaledHeight() + f) {
                this.imageEnd = this.currentHeight + image.scaledHeight() + f;
            }
            if ((image.alignment() & 2) == 2) {
                this.imageIndentRight += image.scaledWidth() + image.indentationLeft();
            } else {
                this.imageIndentLeft += image.scaledWidth() + image.indentationRight();
            }
        }
        if (!bl && !bl2) {
            this.currentHeight += image.scaledHeight() + f;
            this.flushLines();
            this.text.moveText(0.0f, -(image.scaledHeight() + f));
            this.newLine();
        }
    }

    private void initPage() throws DocumentException {
        float f;
        float f2;
        float f3;
        float f4;
        Object object;
        this.annotations = this.delayedAnnotations;
        this.delayedAnnotations = new ArrayList();
        this.pageResources = new PageResources();
        this.writer.resetContent();
        ++this.pageN;
        float f5 = this.leading;
        int n = this.alignment;
        if (this.marginMirroring && (this.getPageNumber() & 1) == 0) {
            this.marginRight = this.nextMarginLeft;
            this.marginLeft = this.nextMarginRight;
        } else {
            this.marginLeft = this.nextMarginLeft;
            this.marginRight = this.nextMarginRight;
        }
        this.marginTop = this.nextMarginTop;
        this.marginBottom = this.nextMarginBottom;
        this.imageEnd = -1.0f;
        this.imageIndentRight = 0.0f;
        this.imageIndentLeft = 0.0f;
        this.graphics = new PdfContentByte(this.writer);
        this.text = new PdfContentByte(this.writer);
        this.text.beginText();
        this.text.moveText(this.left(), this.top());
        this.textEmptySize = this.text.size();
        this.text.reset();
        this.text.beginText();
        this.leading = 16.0f;
        this.indentBottom = 0.0f;
        this.indentTop = 0.0f;
        this.currentHeight = 0.0f;
        this.pageSize = this.nextPageSize;
        this.thisBoxSize = new HashMap(this.boxSize);
        if (this.pageSize.backgroundColor() != null || this.pageSize.hasBorders() || this.pageSize.borderColor() != null || this.pageSize.grayFill() > 0.0f) {
            this.add(this.pageSize);
        }
        if (this.watermark != null) {
            object = this.watermark.matrix();
            this.addImage(this.graphics, this.watermark, object[0], object[1], object[2], object[3], this.watermark.offsetX() - object[4], this.watermark.offsetY() - object[5]);
        }
        if (this.footer != null) {
            float f6 = this.indentLeft;
            f4 = this.indentRight;
            f3 = this.listIndentLeft;
            f2 = this.imageIndentLeft;
            f = this.imageIndentRight;
            this.indentRight = 0.0f;
            this.indentLeft = 0.0f;
            this.listIndentLeft = 0.0f;
            this.imageIndentLeft = 0.0f;
            this.imageIndentRight = 0.0f;
            this.footer.setPageNumber(this.pageN);
            this.leading = this.footer.paragraph().leading();
            this.add(this.footer.paragraph());
            this.indentBottom = this.currentHeight;
            this.text.moveText(this.left(), this.indentBottom());
            this.flushLines();
            this.text.moveText(-this.left(), -this.bottom());
            this.footer.setTop(this.bottom(this.currentHeight));
            this.footer.setBottom(this.bottom() - 0.75f * this.leading);
            this.footer.setLeft(this.left());
            this.footer.setRight(this.right());
            this.graphics.rectangle(this.footer);
            this.indentBottom = this.currentHeight + this.leading * 2.0f;
            this.currentHeight = 0.0f;
            this.indentLeft = f6;
            this.indentRight = f4;
            this.listIndentLeft = f3;
            this.imageIndentLeft = f2;
            this.imageIndentRight = f;
        }
        this.text.moveText(this.left(), this.top());
        if (this.header != null) {
            float f7 = this.indentLeft;
            f4 = this.indentRight;
            f3 = this.listIndentLeft;
            f2 = this.imageIndentLeft;
            f = this.imageIndentRight;
            this.indentRight = 0.0f;
            this.indentLeft = 0.0f;
            this.listIndentLeft = 0.0f;
            this.imageIndentLeft = 0.0f;
            this.imageIndentRight = 0.0f;
            this.header.setPageNumber(this.pageN);
            this.leading = this.header.paragraph().leading();
            this.text.moveText(0.0f, this.leading);
            this.add(this.header.paragraph());
            this.newLine();
            this.indentTop = this.currentHeight - this.leading;
            this.header.setTop(this.top() + this.leading);
            this.header.setBottom(this.indentTop() + this.leading * 2.0f / 3.0f);
            this.header.setLeft(this.left());
            this.header.setRight(this.right());
            this.graphics.rectangle(this.header);
            this.flushLines();
            this.currentHeight = 0.0f;
            this.indentLeft = f7;
            this.indentRight = f4;
            this.listIndentLeft = f3;
            this.imageIndentLeft = f2;
            this.imageIndentRight = f;
        }
        this.pageEmpty = true;
        try {
            if (this.imageWait != null) {
                this.add(this.imageWait);
                this.imageWait = null;
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        this.leading = f5;
        this.alignment = n;
        this.carriageReturn();
        object = this.writer.getPageEvent();
        if (object != null) {
            if (this.firstPageEvent) {
                object.onOpenDocument(this.writer, this);
            }
            object.onStartPage(this.writer, this);
        }
        this.firstPageEvent = false;
    }

    private void carriageReturn() throws DocumentException {
        if (this.lines == null) {
            this.lines = new ArrayList();
        }
        if (this.line != null) {
            if (this.currentHeight + this.line.height() + this.leading < this.indentTop() - this.indentBottom()) {
                if (this.line.size() > 0) {
                    this.currentHeight += this.line.height();
                    this.lines.add(this.line);
                    this.pageEmpty = false;
                }
            } else {
                this.newPage();
            }
        }
        if (this.imageEnd > -1.0f && this.currentHeight > this.imageEnd) {
            this.imageEnd = -1.0f;
            this.imageIndentRight = 0.0f;
            this.imageIndentLeft = 0.0f;
        }
        this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
    }

    private void newLine() throws DocumentException {
        this.lastElementType = -1;
        this.carriageReturn();
        if (this.lines != null && this.lines.size() > 0) {
            this.lines.add(this.line);
            this.currentHeight += this.line.height();
        }
        this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
    }

    private float flushLines() throws DocumentException {
        if (this.lines == null) {
            return 0.0f;
        }
        boolean bl = false;
        if (this.line != null && this.line.size() > 0) {
            this.lines.add(this.line);
            this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
            bl = true;
        }
        if (this.lines.size() == 0) {
            return 0.0f;
        }
        Object[] objectArray = new Object[2];
        PdfFont pdfFont = null;
        float f = 0.0f;
        Float f2 = new Float(0.0f);
        objectArray[1] = f2;
        Iterator iterator = this.lines.iterator();
        while (iterator.hasNext()) {
            PdfLine pdfLine = (PdfLine)iterator.next();
            if (this.isNewpage && bl) {
                bl = false;
                this.text.moveText(pdfLine.indentLeft() - this.indentLeft() + this.listIndentLeft + this.paraIndent, -pdfLine.height());
            } else {
                this.text.moveText(pdfLine.indentLeft() - this.indentLeft() + this.listIndentLeft, -pdfLine.height());
            }
            if (pdfLine.listSymbol() != null) {
                Object object;
                PdfChunk pdfChunk = pdfLine.listSymbol();
                this.text.moveText(-pdfLine.listIndent(), 0.0f);
                if (pdfChunk.font().compareTo(pdfFont) != 0) {
                    pdfFont = pdfChunk.font();
                    this.text.setFontAndSize(pdfFont.getFont(), pdfFont.size());
                }
                if (pdfChunk.color() != null) {
                    object = pdfChunk.color();
                    this.text.setColorFill((Color)object);
                    this.text.showText(pdfChunk.toString());
                    this.text.resetRGBColorFill();
                } else if (pdfChunk.isImage()) {
                    object = pdfChunk.getImage();
                    float[] fArray = ((Image)object).matrix();
                    float f3 = this.text.getXTLM();
                    float f4 = this.text.getYTLM();
                    fArray[4] = f3 + pdfChunk.getImageOffsetX() - fArray[4];
                    fArray[5] = f4 + pdfChunk.getImageOffsetY() - fArray[5];
                    this.addImage(this.graphics, (Image)object, fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                } else {
                    this.text.showText(pdfChunk.toString());
                }
                this.text.moveText(pdfLine.listIndent(), 0.0f);
            }
            objectArray[0] = pdfFont;
            this.writeLineToContent(pdfLine, this.text, this.graphics, objectArray, this.writer.getSpaceCharRatio());
            pdfFont = (PdfFont)objectArray[0];
            f += pdfLine.height();
            if (this.indentLeft() - this.listIndentLeft == pdfLine.indentLeft()) continue;
            this.text.moveText(this.indentLeft() - pdfLine.indentLeft() - this.listIndentLeft, 0.0f);
        }
        this.lines = new ArrayList();
        return f;
    }

    PdfInfo getInfo() {
        return this.info;
    }

    PdfCatalog getCatalog(PdfIndirectReference pdfIndirectReference) {
        PdfCatalog pdfCatalog = this.rootOutline.getKids().size() > 0 ? new PdfCatalog(pdfIndirectReference, this.rootOutline.indirectReference(), this.writer) : new PdfCatalog(pdfIndirectReference, this.writer);
        if (this.openActionName != null) {
            PdfAction pdfAction = this.getLocalGotoAction(this.openActionName);
            pdfCatalog.setOpenAction(pdfAction);
        } else if (this.openActionAction != null) {
            pdfCatalog.setOpenAction(this.openActionAction);
        }
        if (this.additionalActions != null) {
            pdfCatalog.setAdditionalActions(this.additionalActions);
        }
        if (this.pageLabels != null) {
            pdfCatalog.setPageLabels(this.pageLabels);
        }
        pdfCatalog.addNames(this.localDestinations, this.documentJavaScript, this.writer);
        pdfCatalog.setViewerPreferences(this.viewerPreferences);
        if (this.acroForm.isValid()) {
            try {
                pdfCatalog.setAcroForm(this.writer.addToBody(this.acroForm).getIndirectReference());
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
        }
        return pdfCatalog;
    }

    float bottom(Table table) {
        float f = this.currentHeight > 0.0f ? this.indentTop() - this.currentHeight - 2.0f * this.leading : this.indentTop();
        PdfTable pdfTable = this.getPdfTable(table, false);
        return pdfTable.bottom();
    }

    boolean fitsPage(PdfPTable pdfPTable, float f) {
        if (!pdfPTable.isLockedWidth()) {
            float f2 = (this.indentRight() - this.indentLeft()) * pdfPTable.getWidthPercentage() / 100.0f;
            pdfPTable.setTotalWidth(f2);
        }
        this.ensureNewLine();
        return pdfPTable.getTotalHeight() <= this.indentTop() - this.currentHeight - this.indentBottom() - f;
    }

    public float getVerticalPosition(boolean bl) {
        if (bl) {
            this.ensureNewLine();
        }
        return this.top() - this.currentHeight - this.indentTop;
    }

    private void ensureNewLine() {
        try {
            if (this.lastElementType == 11 || this.lastElementType == 10) {
                this.newLine();
                this.flushLines();
            }
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    private float indentLeft() {
        return this.left(this.indentLeft + this.listIndentLeft + this.imageIndentLeft);
    }

    private float indentRight() {
        return this.right(this.indentRight + this.imageIndentRight);
    }

    private float indentTop() {
        return this.top(this.indentTop);
    }

    float indentBottom() {
        return this.bottom(this.indentBottom);
    }

    void addOutline(PdfOutline pdfOutline, String string) {
        this.localDestination(string, pdfOutline.getPdfDestination());
    }

    public PdfAcroForm getAcroForm() {
        return this.acroForm;
    }

    public PdfOutline getRootOutline() {
        return this.rootOutline;
    }

    void writeLineToContent(PdfLine pdfLine, PdfContentByte pdfContentByte, PdfContentByte pdfContentByte2, Object[] objectArray, float f) throws DocumentException {
        float f2;
        float f3;
        boolean bl;
        PdfFont pdfFont = (PdfFont)objectArray[0];
        float f4 = ((Float)objectArray[1]).floatValue();
        float f5 = 0.0f;
        float f6 = 1.0f;
        float f7 = Float.NaN;
        float f8 = 0.0f;
        float f9 = 0.0f;
        int n = pdfLine.numberOfSpaces();
        int n2 = pdfLine.toString().length();
        boolean bl2 = bl = pdfLine.hasToBeJustified() && (n != 0 || n2 > 1);
        if (bl) {
            if (pdfLine.isNewlineSplit() && pdfLine.widthLeft() >= f4 * (f * (float)n + (float)n2 - 1.0f)) {
                if (pdfLine.isRTL()) {
                    pdfContentByte.moveText(pdfLine.widthLeft() - f4 * (f * (float)n + (float)n2 - 1.0f), 0.0f);
                }
                f8 = f * f4;
                f9 = f4;
            } else {
                char c;
                String string;
                float f10 = pdfLine.widthLeft();
                PdfChunk pdfChunk = pdfLine.getChunk(pdfLine.size() - 1);
                if (pdfChunk != null && (string = pdfChunk.toString()).length() > 0 && hangingPunctuation.indexOf(c = string.charAt(string.length() - 1)) >= 0) {
                    f3 = f10;
                    f5 = (f10 += pdfChunk.font().width(c) * 0.4f) - f3;
                }
                f2 = f10 / (f * (float)n + (float)n2 - 1.0f);
                f8 = f * f2;
                f9 = f2;
                f4 = f2;
            }
        }
        int n3 = pdfLine.getLastStrokeChunk();
        int n4 = 0;
        float f11 = f2 = pdfContentByte.getXTLM();
        f3 = pdfContentByte.getYTLM();
        boolean bl3 = false;
        Iterator iterator = pdfLine.iterator();
        while (iterator.hasNext()) {
            int n5;
            float f12;
            Object object;
            Object object2;
            Object object3;
            float f13;
            PdfChunk pdfChunk = (PdfChunk)iterator.next();
            Color color = pdfChunk.color();
            f6 = 1.0f;
            if (n4 <= n3) {
                f13 = bl ? pdfChunk.getWidthCorrected(f9, f8) : pdfChunk.width();
                if (pdfChunk.isStroked()) {
                    float[] fArray;
                    Object object4;
                    float f14;
                    object3 = pdfLine.getChunk(n4 + 1);
                    if (pdfChunk.isAttribute("UNDERLINE")) {
                        f14 = f4;
                        if (object3 != null && ((PdfChunk)object3).isAttribute("UNDERLINE")) {
                            f14 = 0.0f;
                        }
                        if (object3 == null) {
                            f14 += f5;
                        }
                        object4 = (Object[][])pdfChunk.getAttribute("UNDERLINE");
                        object2 = null;
                        int n6 = 0;
                        while (n6 < ((Object[][])object4).length) {
                            object = object4[n6];
                            object2 = (Color)object[0];
                            fArray = (float[])object[1];
                            if (object2 == null) {
                                object2 = color;
                            }
                            if (object2 != null) {
                                pdfContentByte2.setColorStroke((Color)object2);
                            }
                            f12 = pdfChunk.font().size();
                            pdfContentByte2.setLineWidth(fArray[0] + f12 * fArray[1]);
                            float f15 = fArray[2] + f12 * fArray[3];
                            n5 = (int)fArray[4];
                            if (n5 != 0) {
                                pdfContentByte2.setLineCap(n5);
                            }
                            pdfContentByte2.moveTo(f2, f3 + f15);
                            pdfContentByte2.lineTo(f2 + f13 - f14, f3 + f15);
                            pdfContentByte2.stroke();
                            if (object2 != null) {
                                pdfContentByte2.resetGrayStroke();
                            }
                            if (n5 != 0) {
                                pdfContentByte2.setLineCap(0);
                            }
                            ++n6;
                        }
                        pdfContentByte2.setLineWidth(1.0f);
                    }
                    if (pdfChunk.isAttribute("ACTION")) {
                        f14 = f4;
                        if (object3 != null && ((PdfChunk)object3).isAttribute("ACTION")) {
                            f14 = 0.0f;
                        }
                        if (object3 == null) {
                            f14 += f5;
                        }
                        pdfContentByte.addAnnotation(new PdfAnnotation(this.writer, f2, f3, f2 + f13 - f14, f3 + pdfChunk.font().size(), (PdfAction)pdfChunk.getAttribute("ACTION")));
                    }
                    if (pdfChunk.isAttribute("REMOTEGOTO")) {
                        f14 = f4;
                        if (object3 != null && ((PdfChunk)object3).isAttribute("REMOTEGOTO")) {
                            f14 = 0.0f;
                        }
                        if (object3 == null) {
                            f14 += f5;
                        }
                        object4 = (Object[])pdfChunk.getAttribute("REMOTEGOTO");
                        object2 = (String)object4[0];
                        if (object4[1] instanceof String) {
                            this.remoteGoto((String)object2, (String)object4[1], f2, f3, f2 + f13 - f14, f3 + pdfChunk.font().size());
                        } else {
                            this.remoteGoto((String)object2, (Integer)object4[1], f2, f3, f2 + f13 - f14, f3 + pdfChunk.font().size());
                        }
                    }
                    if (pdfChunk.isAttribute("LOCALGOTO")) {
                        f14 = f4;
                        if (object3 != null && ((PdfChunk)object3).isAttribute("LOCALGOTO")) {
                            f14 = 0.0f;
                        }
                        if (object3 == null) {
                            f14 += f5;
                        }
                        this.localGoto((String)pdfChunk.getAttribute("LOCALGOTO"), f2, f3, f2 + f13 - f14, f3 + pdfChunk.font().size());
                    }
                    if (pdfChunk.isAttribute("LOCALDESTINATION")) {
                        f14 = f4;
                        if (object3 != null && ((PdfChunk)object3).isAttribute("LOCALDESTINATION")) {
                            f14 = 0.0f;
                        }
                        if (object3 == null) {
                            f14 += f5;
                        }
                        this.localDestination((String)pdfChunk.getAttribute("LOCALDESTINATION"), new PdfDestination(0, f2, f3 + pdfChunk.font().size(), 0.0f));
                    }
                    if (pdfChunk.isAttribute("GENERICTAG")) {
                        f14 = f4;
                        if (object3 != null && ((PdfChunk)object3).isAttribute("GENERICTAG")) {
                            f14 = 0.0f;
                        }
                        if (object3 == null) {
                            f14 += f5;
                        }
                        object4 = new Rectangle(f2, f3, f2 + f13 - f14, f3 + pdfChunk.font().size());
                        object2 = this.writer.getPageEvent();
                        if (object2 != null) {
                            object2.onGenericTag(this.writer, this, (Rectangle)object4, (String)pdfChunk.getAttribute("GENERICTAG"));
                        }
                    }
                    if (pdfChunk.isAttribute("BACKGROUND")) {
                        f14 = f4;
                        if (object3 != null && ((PdfChunk)object3).isAttribute("BACKGROUND")) {
                            f14 = 0.0f;
                        }
                        if (object3 == null) {
                            f14 += f5;
                        }
                        float f16 = pdfChunk.font().size();
                        float f17 = pdfChunk.font().getFont().getFontDescriptor(1, f16);
                        float f18 = pdfChunk.font().getFont().getFontDescriptor(3, f16);
                        object = (Object[])pdfChunk.getAttribute("BACKGROUND");
                        pdfContentByte2.setColorFill((Color)object[0]);
                        fArray = (float[])object[1];
                        pdfContentByte2.rectangle(f2 - fArray[0], f3 + f18 - fArray[1] + pdfChunk.getTextRise(), f13 - f14 + fArray[0] + fArray[2], f17 - f18 + fArray[1] + fArray[3]);
                        pdfContentByte2.fill();
                        pdfContentByte2.setGrayFill(0.0f);
                    }
                    if (pdfChunk.isAttribute("PDFANNOTATION")) {
                        f14 = f4;
                        if (object3 != null && ((PdfChunk)object3).isAttribute("PDFANNOTATION")) {
                            f14 = 0.0f;
                        }
                        if (object3 == null) {
                            f14 += f5;
                        }
                        float f19 = pdfChunk.font().size();
                        float f20 = pdfChunk.font().getFont().getFontDescriptor(1, f19);
                        float f21 = pdfChunk.font().getFont().getFontDescriptor(3, f19);
                        object = PdfFormField.shallowDuplicate((PdfAnnotation)pdfChunk.getAttribute("PDFANNOTATION"));
                        ((PdfDictionary)object).put(PdfName.RECT, new PdfRectangle(f2, f3 + f21, f2 + f13 - f14, f3 + f20));
                        pdfContentByte.addAnnotation((PdfAnnotation)object);
                    }
                    float[] fArray2 = (float[])pdfChunk.getAttribute("SKEW");
                    Float f22 = (Float)pdfChunk.getAttribute("HSCALE");
                    if (fArray2 != null || f22 != null) {
                        float f23 = 0.0f;
                        float f24 = 0.0f;
                        if (fArray2 != null) {
                            f23 = fArray2[0];
                            f24 = fArray2[1];
                        }
                        if (f22 != null) {
                            f6 = f22.floatValue();
                        }
                        pdfContentByte.setTextMatrix(f6, f23, f24, 1.0f, f2, f3);
                    }
                    if (pdfChunk.isImage()) {
                        Image image = pdfChunk.getImage();
                        float[] fArray3 = image.matrix();
                        fArray3[4] = f2 + pdfChunk.getImageOffsetX() - fArray3[4];
                        fArray3[5] = f3 + pdfChunk.getImageOffsetY() - fArray3[5];
                        this.addImage(pdfContentByte2, image, fArray3[0], fArray3[1], fArray3[2], fArray3[3], fArray3[4], fArray3[5]);
                        pdfContentByte.moveText(f2 + f4 + image.scaledWidth() - pdfContentByte.getXTLM(), 0.0f);
                    }
                }
                f2 += f13;
                ++n4;
            }
            if (pdfChunk.font().compareTo(pdfFont) != 0) {
                pdfFont = pdfChunk.font();
                pdfContentByte.setFontAndSize(pdfFont.getFont(), pdfFont.size());
            }
            f13 = 0.0f;
            object3 = (Object[])pdfChunk.getAttribute("TEXTRENDERMODE");
            int n7 = 0;
            float f25 = 1.0f;
            object2 = null;
            Float f26 = (Float)pdfChunk.getAttribute("SUBSUPSCRIPT");
            if (object3 != null) {
                n7 = (Integer)object3[0] & 3;
                if (n7 != 0) {
                    pdfContentByte.setTextRenderingMode(n7);
                }
                if (n7 == 1 || n7 == 2) {
                    f25 = ((Float)object3[1]).floatValue();
                    if (f25 != 1.0f) {
                        pdfContentByte.setLineWidth(f25);
                    }
                    if ((object2 = (Color)object3[2]) == null) {
                        object2 = color;
                    }
                    if (object2 != null) {
                        pdfContentByte.setColorStroke((Color)object2);
                    }
                }
            }
            if (f26 != null) {
                f13 = f26.floatValue();
            }
            if (color != null) {
                pdfContentByte.setColorFill(color);
            }
            if (f13 != 0.0f) {
                pdfContentByte.setTextRise(f13);
            }
            if (pdfChunk.isImage()) {
                bl3 = true;
            } else if (bl && n > 0 && pdfChunk.isSpecialEncoding()) {
                int n8;
                if (f6 != f7) {
                    f7 = f6;
                    pdfContentByte.setWordSpacing(f8 / f6);
                    pdfContentByte.setCharacterSpacing(f9 / f6);
                }
                if ((n8 = ((String)(object = pdfChunk.toString())).indexOf(32)) < 0) {
                    pdfContentByte.showText(pdfChunk.toString());
                } else {
                    f12 = -f8 * 1000.0f / pdfChunk.font.size() / f6;
                    PdfTextArray pdfTextArray = new PdfTextArray(((String)object).substring(0, n8));
                    n5 = n8;
                    while ((n8 = ((String)object).indexOf(32, n5 + 1)) >= 0) {
                        pdfTextArray.add(f12);
                        pdfTextArray.add(((String)object).substring(n5, n8));
                        n5 = n8;
                    }
                    pdfTextArray.add(f12);
                    pdfTextArray.add(((String)object).substring(n5));
                    pdfContentByte.showText(pdfTextArray);
                }
            } else {
                if (bl && f6 != f7) {
                    f7 = f6;
                    pdfContentByte.setWordSpacing(f8 / f6);
                    pdfContentByte.setCharacterSpacing(f9 / f6);
                }
                pdfContentByte.showText(pdfChunk.toString());
            }
            if (f13 != 0.0f) {
                pdfContentByte.setTextRise(0.0f);
            }
            if (color != null) {
                pdfContentByte.resetRGBColorFill();
            }
            if (n7 != 0) {
                pdfContentByte.setTextRenderingMode(0);
            }
            if (object2 != null) {
                pdfContentByte.resetRGBColorStroke();
            }
            if (f25 != 1.0f) {
                pdfContentByte.setLineWidth(1.0f);
            }
            if (!pdfChunk.isAttribute("SKEW") && !pdfChunk.isAttribute("HSCALE")) continue;
            bl3 = true;
            pdfContentByte.setTextMatrix(f2, f3);
        }
        if (bl) {
            pdfContentByte.setWordSpacing(0.0f);
            pdfContentByte.setCharacterSpacing(0.0f);
            if (pdfLine.isNewlineSplit()) {
                f4 = 0.0f;
            }
        }
        if (bl3) {
            pdfContentByte.moveText(f11 - pdfContentByte.getXTLM(), 0.0f);
        }
        objectArray[0] = pdfFont;
        objectArray[1] = new Float(f4);
    }

    void localGoto(String string, float f, float f2, float f3, float f4) {
        PdfAction pdfAction = this.getLocalGotoAction(string);
        this.annotations.add(new PdfAnnotation(this.writer, f, f2, f3, f4, pdfAction));
    }

    PdfAction getLocalGotoAction(String string) {
        PdfAction pdfAction;
        Object[] objectArray = (Object[])this.localDestinations.get(string);
        if (objectArray == null) {
            objectArray = new Object[3];
        }
        if (objectArray[0] == null) {
            if (objectArray[1] == null) {
                objectArray[1] = this.writer.getPdfIndirectReference();
            }
            pdfAction = new PdfAction((PdfIndirectReference)objectArray[1]);
            objectArray[0] = pdfAction;
            this.localDestinations.put(string, objectArray);
        } else {
            pdfAction = (PdfAction)objectArray[0];
        }
        return pdfAction;
    }

    boolean localDestination(String string, PdfDestination pdfDestination) {
        Object[] objectArray = (Object[])this.localDestinations.get(string);
        if (objectArray == null) {
            objectArray = new Object[3];
        }
        if (objectArray[2] != null) {
            return false;
        }
        objectArray[2] = pdfDestination;
        this.localDestinations.put(string, objectArray);
        pdfDestination.addPage(this.writer.getCurrentPage());
        return true;
    }

    void remoteGoto(String string, String string2, float f, float f2, float f3, float f4) {
        this.annotations.add(new PdfAnnotation(this.writer, f, f2, f3, f4, new PdfAction(string, string2)));
    }

    void remoteGoto(String string, int n, float f, float f2, float f3, float f4) {
        this.writer.addAnnotation(new PdfAnnotation(this.writer, f, f2, f3, f4, new PdfAction(string, n)));
    }

    public void setViewerPreferences(int n) {
        this.viewerPreferences |= n;
    }

    void setAction(PdfAction pdfAction, float f, float f2, float f3, float f4) {
        this.writer.addAnnotation(new PdfAnnotation(this.writer, f, f2, f3, f4, pdfAction));
    }

    void setOpenAction(String string) {
        this.openActionName = string;
        this.openActionAction = null;
    }

    void setOpenAction(PdfAction pdfAction) {
        this.openActionAction = pdfAction;
        this.openActionName = null;
    }

    void addAdditionalAction(PdfName pdfName, PdfAction pdfAction) {
        if (this.additionalActions == null) {
            this.additionalActions = new PdfDictionary();
        }
        this.additionalActions.put(pdfName, pdfAction);
    }

    void setPageLabels(PdfPageLabels pdfPageLabels) {
        this.pageLabels = pdfPageLabels;
    }

    void addJavaScript(PdfAction pdfAction) {
        if (pdfAction.get(PdfName.JS) == null) {
            throw new RuntimeException("Only JavaScript actions are allowed.");
        }
        try {
            this.documentJavaScript.add(this.writer.addToBody(pdfAction).getIndirectReference());
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    void setCropBoxSize(Rectangle rectangle) {
        this.setBoxSize("crop", rectangle);
    }

    void setBoxSize(String string, Rectangle rectangle) {
        if (rectangle == null) {
            this.boxSize.remove(string);
        } else {
            this.boxSize.put(string, new PdfRectangle(rectangle));
        }
    }

    void addCalculationOrder(PdfFormField pdfFormField) {
        this.acroForm.addCalculationOrder(pdfFormField);
    }

    void setSigFlags(int n) {
        this.acroForm.setSigFlags(n);
    }

    void addFormFieldRaw(PdfFormField pdfFormField) {
        this.annotations.add(pdfFormField);
        ArrayList arrayList = pdfFormField.getKids();
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                this.addFormFieldRaw((PdfFormField)arrayList.get(n));
                ++n;
            }
        }
    }

    void addAnnotation(PdfAnnotation pdfAnnotation) {
        this.pageEmpty = false;
        if (pdfAnnotation.isForm()) {
            PdfFormField pdfFormField = (PdfFormField)pdfAnnotation;
            if (pdfFormField.getParent() == null) {
                this.addFormFieldRaw(pdfFormField);
            }
        } else {
            this.annotations.add(pdfAnnotation);
        }
    }

    void setDuration(int n) {
        this.duration = n > 0 ? n : -1;
    }

    void setTransition(PdfTransition pdfTransition) {
        this.transition = pdfTransition;
    }

    void setPageAction(PdfName pdfName, PdfAction pdfAction) {
        if (this.pageAA == null) {
            this.pageAA = new PdfDictionary();
        }
        this.pageAA.put(pdfName, pdfAction);
    }

    boolean isStrictImageSequence() {
        return this.strictImageSequence;
    }

    void setStrictImageSequence(boolean bl) {
        this.strictImageSequence = bl;
    }

    void setPageEmpty(boolean bl) {
        this.pageEmpty = bl;
    }

    public void clearTextWrap() throws DocumentException {
        super.clearTextWrap();
        float f = this.imageEnd - this.currentHeight;
        if (this.line != null) {
            f += this.line.height();
        }
        if (this.imageEnd > -1.0f && f > 0.0f) {
            this.carriageReturn();
            this.currentHeight += f;
        }
    }

    ArrayList getDocumentJavaScript() {
        return this.documentJavaScript;
    }

    public boolean setMarginMirroring(boolean bl) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        return super.setMarginMirroring(bl);
    }

    public static class PdfInfo
    extends PdfDictionary {
        PdfInfo() {
            this.addProducer();
            this.addCreationDate();
        }

        PdfInfo(String string, String string2, String string3) {
            this();
            this.addTitle(string2);
            this.addSubject(string3);
            this.addAuthor(string);
        }

        void addTitle(String string) {
            this.put(PdfName.TITLE, new PdfString(string, "UnicodeBig"));
        }

        void addSubject(String string) {
            this.put(PdfName.SUBJECT, new PdfString(string, "UnicodeBig"));
        }

        void addKeywords(String string) {
            this.put(PdfName.KEYWORDS, new PdfString(string, "UnicodeBig"));
        }

        void addAuthor(String string) {
            this.put(PdfName.AUTHOR, new PdfString(string, "UnicodeBig"));
        }

        void addCreator(String string) {
            this.put(PdfName.CREATOR, new PdfString(string, "UnicodeBig"));
        }

        void addProducer() {
            this.put(PdfName.PRODUCER, new PdfString(PdfDocument.getVersion()));
        }

        void addCreationDate() {
            PdfDate pdfDate = new PdfDate();
            this.put(PdfName.CREATIONDATE, pdfDate);
            this.put(PdfName.MODDATE, pdfDate);
        }

        void addkey(String string, String string2) {
            if (string.equals("Producer") || string.equals("CreationDate")) {
                return;
            }
            this.put(new PdfName(string), new PdfString(string2, "UnicodeBig"));
        }
    }

    static class PdfCatalog
    extends PdfDictionary {
        PdfWriter writer;

        PdfCatalog(PdfIndirectReference pdfIndirectReference, PdfWriter pdfWriter) {
            super(CATALOG);
            this.writer = pdfWriter;
            this.put(PdfName.PAGES, pdfIndirectReference);
        }

        PdfCatalog(PdfIndirectReference pdfIndirectReference, PdfIndirectReference pdfIndirectReference2, PdfWriter pdfWriter) {
            super(CATALOG);
            this.writer = pdfWriter;
            this.put(PdfName.PAGES, pdfIndirectReference);
            this.put(PdfName.PAGEMODE, PdfName.USEOUTLINES);
            this.put(PdfName.OUTLINES, pdfIndirectReference2);
        }

        void addNames(TreeMap treeMap, ArrayList arrayList, PdfWriter pdfWriter) {
            if (treeMap.size() == 0 && arrayList.size() == 0) {
                return;
            }
            try {
                String[] stringArray;
                PdfDictionary pdfDictionary = new PdfDictionary();
                if (treeMap.size() > 0) {
                    stringArray = new PdfArray();
                    Object object = treeMap.keySet().iterator();
                    while (object.hasNext()) {
                        String string = (String)object.next();
                        Object[] objectArray = (Object[])treeMap.get(string);
                        PdfIndirectReference pdfIndirectReference = (PdfIndirectReference)objectArray[1];
                        stringArray.add(new PdfString(string));
                        stringArray.add(pdfIndirectReference);
                    }
                    object = new PdfDictionary();
                    ((PdfDictionary)object).put(PdfName.NAMES, (PdfObject)stringArray);
                    pdfDictionary.put(PdfName.DESTS, pdfWriter.addToBody((PdfObject)object).getIndirectReference());
                }
                if (arrayList.size() > 0) {
                    stringArray = new String[arrayList.size()];
                    int n = 0;
                    while (n < stringArray.length) {
                        stringArray[n] = Integer.toHexString(n);
                        ++n;
                    }
                    Arrays.sort(stringArray, new StringCompare());
                    PdfArray pdfArray = new PdfArray();
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        pdfArray.add(new PdfString(stringArray[n2]));
                        pdfArray.add((PdfIndirectReference)arrayList.get(n2));
                        ++n2;
                    }
                    PdfDictionary pdfDictionary2 = new PdfDictionary();
                    pdfDictionary2.put(PdfName.NAMES, pdfArray);
                    pdfDictionary.put(PdfName.JAVASCRIPT, pdfWriter.addToBody(pdfDictionary2).getIndirectReference());
                }
                this.put(PdfName.NAMES, pdfWriter.addToBody(pdfDictionary).getIndirectReference());
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
        }

        void setViewerPreferences(int n) {
            PdfReader.setViewerPreferences(n, this);
        }

        void setOpenAction(PdfAction pdfAction) {
            this.put(PdfName.OPENACTION, pdfAction);
        }

        void setAdditionalActions(PdfDictionary pdfDictionary) {
            try {
                this.put(PdfName.AA, this.writer.addToBody(pdfDictionary).getIndirectReference());
            }
            catch (Exception exception) {
                new ExceptionConverter(exception);
            }
        }

        void setPageLabels(PdfPageLabels pdfPageLabels) {
            this.put(PdfName.PAGELABELS, pdfPageLabels.getDictionary());
        }

        void setAcroForm(PdfObject pdfObject) {
            this.put(PdfName.ACROFORM, pdfObject);
        }
    }
}

