/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.mapping.Binding;
import gnu.mapping.Constraint;
import gnu.mapping.Environment;
import gnu.mapping.Named;
import gnu.mapping.WrappedException;
import java.lang.reflect.Field;

public class ClassMemberConstraint
extends Constraint {
    ClassType type;
    String name;
    Field rfield;

    public ClassMemberConstraint(ClassType classType, String string) {
        this.type = classType;
        this.name = string;
    }

    public ClassMemberConstraint(Class clazz, String string) {
        this.type = (ClassType)Type.make(clazz);
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public ClassType getDeclaringClass() {
        return this.type;
    }

    public ClassMemberConstraint(Field field) {
        this.rfield = field;
        this.name = field.getName();
    }

    void setup() {
        if (this.rfield == null) {
            Class clazz = this.type.getReflectClass();
            try {
                this.rfield = clazz.getField(this.name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
    }

    public Object get(Binding binding) {
        this.setup();
        try {
            return this.rfield.get(Constraint.getValue(binding));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new WrappedException(illegalAccessException);
        }
    }

    public void set(Binding binding, Object object2) {
        this.setup();
        try {
            this.rfield.set(Constraint.getValue(binding), object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new WrappedException(illegalAccessException);
        }
    }

    public static void define(String string, Object object2, String string2) {
        ClassMemberConstraint.define(string, object2, string2, Environment.getCurrent());
    }

    public static void define(String string, Object object2, String string2, Environment environment) {
        Binding binding;
        Binding binding2 = binding = environment.getBinding(string);
        synchronized (binding2) {
            Constraint.setValue(binding, object2);
            Constraint.setConstraint(binding, new ClassMemberConstraint(object2.getClass(), string2));
        }
    }

    public static void define(String string, Object object2, Field field, Environment environment) {
        if ((field.getModifiers() & 0x10) != 0) {
            try {
                Object object3 = field.get(object2);
                if (object3 instanceof Binding) {
                    environment.addBinding((Binding)object3);
                    return;
                }
                if (object3 instanceof Named) {
                    string = ((Named)object3).getName();
                }
                string = string.intern();
                environment.define(string, object3);
                return;
            }
            catch (Exception exception) {
                throw new WrappedException("error accessing field " + field, exception);
            }
        }
        string = string.intern();
        Binding binding = new Binding(string);
        Constraint.setValue(binding, object2);
        Constraint.setConstraint(binding, new ClassMemberConstraint(field));
        environment.addBinding(binding);
    }

    public static void defineAll(Object object2, Environment environment) {
        Class<?> clazz = object2.getClass();
        Field[] fieldArray = clazz.getFields();
        int n = fieldArray.length;
        while (--n >= 0) {
            Field field = fieldArray[n];
            ClassMemberConstraint.define(field.getName(), object2, field, environment);
        }
    }
}

