/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.lists.CharSequence;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.SimpleVector;
import gnu.lists.Strings;
import gnu.mapping.OutPort;
import gnu.mapping.Printable;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class SFormat {
    public String format(Object object2) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        this.format(object2, new OutPort(charArrayWriter));
        return charArrayWriter.toString();
    }

    public StringBuffer format(Object object2, StringBuffer stringBuffer) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        this.format(object2, new OutPort(charArrayWriter));
        stringBuffer.append(charArrayWriter.toCharArray());
        return stringBuffer;
    }

    public void format(Object object2, PrintWriter printWriter) {
        SFormat.print(object2, printWriter);
    }

    public static boolean printReadable(Writer writer) {
        return writer instanceof OutPort && ((OutPort)writer).printReadable;
    }

    public static void print(Object object2, PrintWriter printWriter) {
        if (object2 instanceof Printable) {
            ((Printable)object2).print(printWriter);
        } else if (object2 instanceof Boolean) {
            printWriter.print((Boolean)object2 != false ? "#t" : "#f");
        } else if (object2 == null) {
            printWriter.print("#!null");
        } else if (object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object2;
            printWriter.print('[');
            int n = 0;
            while (n < objectArray.length) {
                if (n > 0) {
                    printWriter.print(' ');
                }
                SFormat.print(objectArray[n], printWriter);
                ++n;
            }
            printWriter.print(']');
        } else if (object2 instanceof LList) {
            printWriter.print('(');
            boolean bl = true;
            while (object2 instanceof Pair) {
                if (!bl) {
                    printWriter.print(' ');
                }
                bl = false;
                Pair pair = (Pair)object2;
                SFormat.print(pair.car, printWriter);
                object2 = pair.cdr;
            }
            if (object2 != LList.Empty) {
                printWriter.print(" . ");
                SFormat.print(object2, printWriter);
            }
            printWriter.print(')');
        } else if (object2 instanceof CharSequence) {
            if (SFormat.printReadable(printWriter)) {
                Strings.printQuoted((CharSequence)object2, printWriter, 0);
            } else {
                printWriter.print(object2);
            }
        } else if (object2 instanceof SimpleVector) {
            SimpleVector simpleVector = (SimpleVector)object2;
            String string = simpleVector.getTag();
            int n = simpleVector.size;
            printWriter.print('#');
            if (string != null) {
                printWriter.print(string);
            }
            printWriter.print('(');
            int n2 = 0;
            while (n2 < n) {
                if (n2 > 0) {
                    printWriter.print(' ');
                }
                SFormat.print(simpleVector.get(n2), printWriter);
                ++n2;
            }
            printWriter.print(')');
        } else if (object2 instanceof int[]) {
            int[] nArray = (int[])object2;
            printWriter.print('[');
            int n = 0;
            while (n < nArray.length) {
                if (n > 0) {
                    printWriter.print(' ');
                }
                printWriter.print(nArray[n]);
                ++n;
            }
            printWriter.print(']');
        } else {
            printWriter.print(object2);
        }
    }
}

