/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Section;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.field.RtfField;
import com.lowagie.text.rtf.field.RtfTOCEntry;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfSection
extends RtfElement {
    protected RtfParagraph title = null;
    protected ArrayList items = new ArrayList();

    public RtfSection(RtfDocument rtfDocument, Section section) {
        super(rtfDocument);
        try {
            Object object;
            Object object2;
            if (section.title() != null) {
                this.title = (RtfParagraph)rtfDocument.getMapper().mapElement(section.title());
            }
            if (this.document.getAutogenerateTOCEntries()) {
                Element element;
                object2 = new StringBuffer();
                object = section.title().iterator();
                while (object.hasNext()) {
                    element = (Element)object.next();
                    if (element.type() != 10) continue;
                    ((StringBuffer)object2).append(((Chunk)element).content());
                }
                if (((StringBuffer)object2).toString().trim().length() > 0) {
                    element = new RtfTOCEntry(((StringBuffer)object2).toString(), section.title().font());
                    ((RtfField)element).setRtfDocument(this.document);
                    this.items.add(element);
                }
            }
            object2 = section.iterator();
            while (object2.hasNext()) {
                object = rtfDocument.getMapper().mapElement((Element)object2.next());
                if (object == null) continue;
                this.items.add(object);
            }
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
        }
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (this.title != null) {
                byteArrayOutputStream.write(this.title.write());
                byteArrayOutputStream.write(RtfParagraph.PARAGRAPH);
            }
            int n = 0;
            while (n < this.items.size()) {
                byteArrayOutputStream.write(((RtfBasicElement)this.items.get(n)).write());
                ++n;
            }
            byteArrayOutputStream.write(RtfParagraph.PARAGRAPH);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void setInTable(boolean bl) {
        super.setInTable(bl);
        int n = 0;
        while (n < this.items.size()) {
            ((RtfBasicElement)this.items.get(n)).setInTable(bl);
            ++n;
        }
    }

    public void setInHeader(boolean bl) {
        super.setInHeader(bl);
        int n = 0;
        while (n < this.items.size()) {
            ((RtfBasicElement)this.items.get(n)).setInHeader(bl);
            ++n;
        }
    }
}

