/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.SortComparator;

class FieldCacheImpl
implements FieldCache {
    private static final FieldCache.IntParser INT_PARSER = new FieldCache.IntParser(){

        public int parseInt(String value) {
            return Integer.parseInt(value);
        }
    };
    private static final FieldCache.FloatParser FLOAT_PARSER = new FieldCache.FloatParser(){

        public float parseFloat(String value) {
            return Float.parseFloat(value);
        }
    };
    final Map cache = new WeakHashMap();

    FieldCacheImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object lookup(IndexReader reader, String field, int type) {
        Entry entry = new Entry(field, type);
        FieldCacheImpl fieldCacheImpl = this;
        synchronized (fieldCacheImpl) {
            HashMap readerCache = (HashMap)this.cache.get(reader);
            if (readerCache == null) {
                return null;
            }
            return readerCache.get(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object lookup(IndexReader reader, String field, Object comparer) {
        Entry entry = new Entry(field, comparer);
        FieldCacheImpl fieldCacheImpl = this;
        synchronized (fieldCacheImpl) {
            HashMap readerCache = (HashMap)this.cache.get(reader);
            if (readerCache == null) {
                return null;
            }
            return readerCache.get(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object store(IndexReader reader, String field, int type, Object value) {
        Entry entry = new Entry(field, type);
        FieldCacheImpl fieldCacheImpl = this;
        synchronized (fieldCacheImpl) {
            HashMap<Entry, Object> readerCache = (HashMap<Entry, Object>)this.cache.get(reader);
            if (readerCache == null) {
                readerCache = new HashMap<Entry, Object>();
                this.cache.put(reader, readerCache);
            }
            return readerCache.put(entry, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object store(IndexReader reader, String field, Object comparer, Object value) {
        Entry entry = new Entry(field, comparer);
        FieldCacheImpl fieldCacheImpl = this;
        synchronized (fieldCacheImpl) {
            HashMap<Entry, Object> readerCache = (HashMap<Entry, Object>)this.cache.get(reader);
            if (readerCache == null) {
                readerCache = new HashMap<Entry, Object>();
                this.cache.put(reader, readerCache);
            }
            return readerCache.put(entry, value);
        }
    }

    public int[] getInts(IndexReader reader, String field) throws IOException {
        return this.getInts(reader, field, INT_PARSER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getInts(IndexReader reader, String field, FieldCache.IntParser parser) throws IOException {
        Object ret = this.lookup(reader, field = field.intern(), parser);
        if (ret == null) {
            int[] retArray = new int[reader.maxDoc()];
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field, ""));
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != field) {
                    } else {
                        int termval = parser.parseInt(term.text());
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = termval;
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            this.store(reader, field, parser, (Object)retArray);
            return retArray;
        }
        return (int[])ret;
    }

    public float[] getFloats(IndexReader reader, String field) throws IOException {
        return this.getFloats(reader, field, FLOAT_PARSER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] getFloats(IndexReader reader, String field, FieldCache.FloatParser parser) throws IOException {
        Object ret = this.lookup(reader, field = field.intern(), parser);
        if (ret == null) {
            float[] retArray = new float[reader.maxDoc()];
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field, ""));
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != field) {
                    } else {
                        float termval = parser.parseFloat(term.text());
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = termval;
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            this.store(reader, field, parser, (Object)retArray);
            return retArray;
        }
        return (float[])ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getStrings(IndexReader reader, String field) throws IOException {
        Object ret = this.lookup(reader, field = field.intern(), 3);
        if (ret == null) {
            String[] retArray = new String[reader.maxDoc()];
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field, ""));
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != field) {
                    } else {
                        String termval = term.text();
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = termval;
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            this.store(reader, field, 3, (Object)retArray);
            return retArray;
        }
        return (String[])ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldCache.StringIndex getStringIndex(IndexReader reader, String field) throws IOException {
        Object ret = this.lookup(reader, field = field.intern(), -1);
        if (ret == null) {
            int[] retArray = new int[reader.maxDoc()];
            String[] mterms = new String[reader.maxDoc() + 1];
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field, ""));
            int t = 0;
            mterms[t++] = null;
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != field) {
                    } else {
                        if (t >= mterms.length) {
                            throw new RuntimeException("there are more terms than documents in field \"" + field + "\", but it's impossible to sort on " + "tokenized fields");
                        }
                        mterms[t] = term.text();
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = t;
                        }
                        ++t;
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            if (t == 0) {
                mterms = new String[1];
            } else if (t < mterms.length) {
                String[] terms = new String[t];
                System.arraycopy(mterms, 0, terms, 0, t);
                mterms = terms;
            }
            FieldCache.StringIndex value = new FieldCache.StringIndex(retArray, mterms);
            this.store(reader, field, -1, (Object)value);
            return value;
        }
        return (FieldCache.StringIndex)ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAuto(IndexReader reader, String field) throws IOException {
        Object ret;
        block11: {
            ret = this.lookup(reader, field = field.intern(), 2);
            if (ret == null) {
                TermEnum enumerator = reader.terms(new Term(field, ""));
                try {
                    Term term = enumerator.term();
                    if (term == null) {
                        throw new RuntimeException("no terms in field " + field + " - cannot determine sort type");
                    }
                    if (term.field() == field) {
                        String termtext = term.text().trim();
                        try {
                            Integer.parseInt(termtext);
                            ret = this.getInts(reader, field);
                        }
                        catch (NumberFormatException nfe1) {
                            try {
                                Float.parseFloat(termtext);
                                ret = this.getFloats(reader, field);
                            }
                            catch (NumberFormatException nfe2) {
                                ret = this.getStringIndex(reader, field);
                            }
                        }
                        if (ret != null) {
                            this.store(reader, field, 2, ret);
                        }
                        break block11;
                    }
                    throw new RuntimeException("field \"" + field + "\" does not appear to be indexed");
                }
                finally {
                    enumerator.close();
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Comparable[] getCustom(IndexReader reader, String field, SortComparator comparator) throws IOException {
        Object ret = this.lookup(reader, field = field.intern(), comparator);
        if (ret == null) {
            Comparable[] retArray = new Comparable[reader.maxDoc()];
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field, ""));
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != field) {
                    } else {
                        Comparable termval = comparator.getComparable(term.text());
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = termval;
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            this.store(reader, field, comparator, (Object)retArray);
            return retArray;
        }
        return (Comparable[])ret;
    }

    static class Entry {
        final String field;
        final int type;
        final Object custom;

        Entry(String field, int type) {
            this.field = field.intern();
            this.type = type;
            this.custom = null;
        }

        Entry(String field, Object custom) {
            this.field = field.intern();
            this.type = 9;
            this.custom = custom;
        }

        public boolean equals(Object o) {
            if (o instanceof Entry) {
                Entry other = (Entry)o;
                if (other.field == this.field && other.type == this.type && (other.custom == null ? this.custom == null : other.custom.equals(this.custom))) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.field.hashCode() ^ this.type ^ (this.custom == null ? 0 : this.custom.hashCode());
        }
    }
}

