/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;

public class Label {
    Label next;
    int position = -1;
    int spring_position;
    int[] fixups;
    int[] wide_fixups;

    public final boolean defined() {
        return this.position >= 0;
    }

    public Label(Method method) {
        this(method.code);
    }

    public Label(CodeAttr codeAttr) {
        if (codeAttr.labels != null) {
            this.next = codeAttr.labels.next;
            codeAttr.labels.next = this;
        } else {
            codeAttr.labels = this;
        }
    }

    private final void relocate_fixups(CodeAttr codeAttr, int n) {
        if (this.fixups == null) {
            return;
        }
        int n2 = this.fixups.length;
        while (--n2 >= 0) {
            int n3 = this.fixups[n2];
            if (n3 < 0) continue;
            byte[] byArray = codeAttr.getCode();
            int n4 = byArray[n3] << 8 | byArray[n3 + 1] & 0xFF;
            if ((n4 += n) < Short.MIN_VALUE || n4 >= 32768) {
                throw new Error("overflow in label fixup");
            }
            byArray[n3] = (byte)(n4 >> 8);
            byArray[n3 + 1] = (byte)n4;
        }
        if (this != codeAttr.labels) {
            codeAttr.reorder_fixups();
        }
        this.fixups = null;
    }

    static final void relocate_wide(CodeAttr codeAttr, int n, int n2) {
        if (n >= 0) {
            byte[] byArray = codeAttr.getCode();
            int n3 = (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
            byArray[n] = (byte)((n3 += n2) >> 24);
            byArray[n + 1] = (byte)(n3 >> 16);
            byArray[n + 2] = (byte)(n3 >> 8);
            byArray[n + 3] = (byte)n3;
        }
    }

    public void define(CodeAttr codeAttr) {
        int n;
        codeAttr.unreachable_here = false;
        if (this.position >= 0) {
            throw new Error("label definition more than once");
        }
        this.position = codeAttr.PC;
        int n2 = this.position - 3;
        if (codeAttr.readPC <= n2 && this.fixups != null && this.wide_fixups == null && n2 > 0 && codeAttr.getCode()[n2] == -89) {
            ++n2;
            n = this.fixups.length;
            while (--n >= 0) {
                if (this.fixups[n] == n2) break;
            }
            if (n >= 0) {
                this.position -= 3;
                codeAttr.PC = this.position;
                this.fixups[n] = -1;
            }
        }
        codeAttr.readPC = this.position;
        this.relocate_fixups(codeAttr, this.position);
        if (this.wide_fixups != null) {
            n = this.wide_fixups.length;
            while (--n >= 0) {
                Label.relocate_wide(codeAttr, this.wide_fixups[n], this.position);
            }
            this.wide_fixups = null;
        }
    }

    void emit_spring(CodeAttr codeAttr) {
        codeAttr.reserve(8);
        if (!codeAttr.unreachable_here) {
            codeAttr.put1(167);
            codeAttr.put2(6);
        }
        this.spring_position = codeAttr.PC;
        this.relocate_fixups(codeAttr, this.spring_position);
        codeAttr.put1(200);
        this.emit_wide(codeAttr, this.spring_position);
        codeAttr.readPC = codeAttr.PC;
    }

    private void add_fixup(CodeAttr codeAttr) {
        int n = codeAttr.PC;
        if (this.fixups == null) {
            this.fixups = new int[2];
            this.fixups[0] = n;
            this.fixups[1] = -1;
        } else {
            int n2 = this.fixups.length;
            int n3 = 0;
            while (n3 < n2 && this.fixups[n3] >= 0) {
                ++n3;
            }
            if (n3 == n2) {
                int[] nArray = new int[2 * this.fixups.length];
                System.arraycopy(this.fixups, 0, nArray, 0, this.fixups.length);
                n3 = nArray.length;
                do {
                    nArray[--n3] = -1;
                } while (n3 > n2);
                this.fixups = nArray;
            }
            if (n < this.fixups[0]) {
                this.fixups[n3] = this.fixups[0];
                this.fixups[0] = n;
            } else {
                this.fixups[n3] = n;
            }
        }
        if (this != codeAttr.labels && (codeAttr.labels.fixups == null || n < codeAttr.labels.fixups[0])) {
            codeAttr.reorder_fixups();
        }
    }

    private void add_wide_fixup(int n) {
        if (this.wide_fixups == null) {
            this.wide_fixups = new int[2];
            this.wide_fixups[0] = n;
            this.wide_fixups[1] = -1;
            return;
        }
        int n2 = 0;
        while (n2 < this.wide_fixups.length) {
            if (this.wide_fixups[n2] < 0) {
                this.wide_fixups[n2] = n;
                return;
            }
            ++n2;
        }
        int[] nArray = new int[2 * this.wide_fixups.length];
        System.arraycopy(this.wide_fixups, 0, nArray, 0, this.wide_fixups.length);
        nArray[this.wide_fixups.length] = n;
        n2 = this.wide_fixups.length;
        while (++n2 < nArray.length) {
            nArray[n2] = -1;
        }
        this.wide_fixups = nArray;
    }

    public boolean hasFixups() {
        return this.fixups != null || this.wide_fixups != null;
    }

    public void emit(CodeAttr codeAttr) {
        int n;
        int n2 = n = 1 - codeAttr.PC;
        if (this.defined()) {
            if ((n2 += this.position) < Short.MIN_VALUE) {
                if (this.spring_position >= 0 && this.spring_position + n >= Short.MIN_VALUE) {
                    n2 = this.spring_position + n;
                } else {
                    this.add_fixup(codeAttr);
                    n2 = n;
                }
            }
        } else {
            this.add_fixup(codeAttr);
        }
        codeAttr.put2(n2);
    }

    public void emit_wide(CodeAttr codeAttr, int n) {
        int n2 = -n;
        if (this.defined()) {
            n2 += this.position;
        } else {
            this.add_wide_fixup(codeAttr.PC);
        }
        codeAttr.put4(n2);
    }
}

