/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.Parser;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.kawa.reflect.SlotGet;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;
import gnu.mapping.Printable;
import java.io.PrintWriter;
import kawa.standard.convert;

public abstract class Expression
implements Printable {
    String filename;
    int position;
    public static final Expression[] noExpressions = new Expression[0];
    protected int flags;
    protected static final int NEXT_AVAIL_FLAG = 1;

    public Object eval(Environment environment) {
        throw new RuntimeException("internal error - " + this.getClass() + ".eval called");
    }

    public void eval(Environment environment, CallContext callContext) {
        Object object2 = this.eval(environment);
        callContext.writeValue(object2);
    }

    public final void print(PrintWriter printWriter) {
        if (printWriter instanceof OutPort) {
            this.print((OutPort)printWriter);
        } else {
            OutPort outPort = new OutPort(printWriter);
            this.print(outPort);
            outPort.flush();
        }
    }

    public abstract void print(OutPort var1);

    public abstract void compile(Compilation var1, Target var2);

    public final void compileWithPosition(Compilation compilation, Target target) {
        int n = this.getLine();
        if (n > 0) {
            compilation.method.compile_linenumber(n);
            this.compileNotePosition(compilation, target);
        } else {
            this.compile(compilation, target);
        }
    }

    public final void compileNotePosition(Compilation compilation, Target target) {
        String string = compilation.filename;
        int n = compilation.position;
        compilation.filename = this.filename;
        compilation.position = this.position;
        this.compile(compilation, target);
        compilation.filename = string;
        compilation.position = n;
    }

    public final void compile(Compilation compilation, Type type) {
        this.compile(compilation, StackTarget.getInstance(type));
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkExpression(this);
    }

    protected void walkChildren(ExpWalker expWalker) {
    }

    public static Expression makeWhile(Object object2, Object object3, Parser parser) {
        Expression[] expressionArray = new Expression[1];
        LetExp letExp = new LetExp(expressionArray);
        String string = "%do%loop";
        Declaration declaration = letExp.addDeclaration(string);
        ApplyExp applyExp = new ApplyExp(new ReferenceExp(declaration), noExpressions);
        LambdaExp lambdaExp = new LambdaExp();
        parser.push(lambdaExp);
        lambdaExp.body = new IfExp(parser.parse(object2), new BeginExp(parser.parse(object3), applyExp), QuoteExp.voidExp);
        lambdaExp.setName(string);
        parser.pop(lambdaExp);
        expressionArray[0] = lambdaExp;
        declaration.noteValue(lambdaExp);
        letExp.setBody(new ApplyExp(new ReferenceExp(declaration), noExpressions));
        return letExp;
    }

    public static Expression makeCoercion(Expression expression, Expression expression2) {
        Expression[] expressionArray = new Expression[]{expression2, expression};
        QuoteExp quoteExp = new QuoteExp(convert.getInstance());
        return new ApplyExp(quoteExp, expressionArray);
    }

    public static Expression makeCoercion(Expression expression, Type type) {
        return Expression.makeCoercion(expression, new QuoteExp(type));
    }

    public static Expression makeGetField(Expression expression, String string) {
        Expression[] expressionArray = new Expression[]{expression, new QuoteExp(string)};
        return new ApplyExp(SlotGet.field, expressionArray);
    }

    public final void setFile(String string) {
        this.filename = string;
    }

    public final void setLine(int n, int n2) {
        this.position = (n << 12) + n2;
    }

    public final void setLine(int n) {
        this.setLine(n, 0);
    }

    public final String getFile() {
        return this.filename;
    }

    public final int getLine() {
        return this.position >> 12;
    }

    public final int getColumn() {
        return this.position & 0xFFF;
    }

    public Type getType() {
        return Type.pointer_type;
    }

    public void setFlag(boolean bl, int n) {
        this.flags = bl ? (this.flags |= n) : (this.flags &= ~n);
    }

    public void setFlag(int n) {
        this.flags |= n;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean getFlag(int n) {
        return (this.flags & n) != 0;
    }
}

