/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.BlockExp;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.QuoteExp;
import gnu.expr.Target;
import gnu.mapping.OutPort;

public class ExitExp
extends Expression {
    BlockExp block;
    Expression result;

    public ExitExp(Expression expression, BlockExp blockExp) {
        this.result = expression;
        this.block = blockExp;
    }

    public ExitExp(BlockExp blockExp) {
        this.result = QuoteExp.voidExp;
        this.block = blockExp;
    }

    public void compile(Compilation compilation, Target target) {
        CodeAttr codeAttr = compilation.getCode();
        Expression expression = this.result == null ? QuoteExp.voidExp : this.result;
        expression.compileWithPosition(compilation, this.block.subTarget);
        codeAttr.emitGoto(this.block.exitLabel);
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkExitExp(this);
    }

    protected void walkChildren(ExpWalker expWalker) {
        this.result = this.result.walk(expWalker);
    }

    public void print(OutPort outPort) {
        outPort.startLogicalBlock("(Exit", false, ")");
        if (this.block == null || this.block.label == null) {
            outPort.print("<unknown>");
        } else {
            outPort.print(this.block.label.getName());
        }
        if (this.result != null) {
            outPort.writeSpaceLinear();
            this.result.print(outPort);
        }
        outPort.endLogicalBlock(")");
    }

    public Type getType() {
        return Type.neverReturnsType;
    }
}

