/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml;

import gnu.lists.Consumable;
import gnu.lists.Consumer;
import java.io.PrintWriter;

public class XMLPrinter
implements Consumer {
    PrintWriter out;
    boolean inAttribute = false;
    private static final int WORD = -2;
    int prev;

    public XMLPrinter(PrintWriter printWriter) {
        this.out = printWriter;
    }

    protected static final boolean isWordChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '-' || c == '+';
    }

    public void writeRaw(String string) {
        this.out.write(string);
    }

    public void writeChar(int n) {
        if (this.prev == -2 && XMLPrinter.isWordChar((char)n)) {
            this.out.print(' ');
        }
        if (n == 60) {
            this.out.print("&lt;");
        } else if (n == 62) {
            this.out.print("&gt;");
        } else if (n == 38) {
            this.out.print("&amp;");
        } else if (n == 34 && this.inAttribute) {
            this.out.print("&quot;");
        } else {
            this.out.print((char)n);
        }
        this.prev = n;
    }

    private void startWord() {
        if (this.prev == -2 || XMLPrinter.isWordChar((char)this.prev)) {
            this.out.print(' ');
        }
        this.prev = -2;
    }

    public void writeBoolean(boolean bl) {
        this.startWord();
        this.out.print(bl);
    }

    public void writeFloat(float f) {
        this.startWord();
        this.out.print(f);
    }

    public void writeDouble(double d) {
        this.startWord();
        this.out.print(d);
    }

    public void writeInt(int n) {
        this.startWord();
        this.out.print(n);
    }

    public void writeLong(long l) {
        this.startWord();
        this.out.print(l);
    }

    public void beginGroup(String string, Object object2) {
        this.out.print('<');
        this.out.print(string);
    }

    public void endGroup(String string) {
        this.out.print("</");
        this.out.print(string);
        this.out.print('>');
        this.prev = 62;
    }

    public void beginAttribute(String string, Object object2) {
        if (this.inAttribute) {
            this.out.print('\"');
        }
        this.inAttribute = true;
        this.out.print(' ');
        this.out.print(string);
        this.out.print("=\"");
        this.prev = 32;
    }

    public void endAttributes() {
        if (this.inAttribute) {
            this.out.print('\"');
        }
        this.inAttribute = false;
        this.out.print('>');
        this.prev = 32;
    }

    public void writeObject(Object object2) {
        if (object2 instanceof Consumable) {
            ((Consumable)object2).consume(this);
        } else {
            this.startWord();
            this.out.print(object2);
        }
    }

    public boolean ignoring() {
        return false;
    }

    public void writeChars(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.writeChar(string.charAt(n2));
            ++n2;
        }
    }

    public void write(char[] cArray, int n, int n2) {
        int n3;
        if (n2 <= 0) {
            return;
        }
        int n4 = this.prev;
        if (this.prev == -2) {
            n3 = cArray[n++];
            this.writeChar(n3);
            n4 = n3;
            --n2;
        }
        int n5 = n + n2;
        int n6 = 0;
        while (n < n5) {
            if ((n4 = (n3 = cArray[n++])) >= 65536 || n4 == 60 || n4 == 62 || n4 == 38 || n4 == 34 && this.inAttribute) {
                if (n6 > 0) {
                    this.out.write(cArray, n - 1 - n6, n6);
                }
                this.writeChar(n3);
                n6 = 0;
                continue;
            }
            ++n6;
        }
        if (n6 > 0) {
            this.out.write(cArray, n5 - n6, n6);
        }
    }
}

