/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.jsp.JspException;
import org.apache.taglibs.standard.resources.Resources;

public class Util {
    private static final String REQUEST = "request";
    private static final String SESSION = "session";
    private static final String APPLICATION = "application";
    private static final String DEFAULT = "default";
    private static final String SHORT = "short";
    private static final String MEDIUM = "medium";
    private static final String LONG = "long";
    private static final String FULL = "full";

    public static int getScope(String scope) {
        int ret = 1;
        if (REQUEST.equalsIgnoreCase(scope)) {
            ret = 2;
        } else if (SESSION.equalsIgnoreCase(scope)) {
            ret = 3;
        } else if (APPLICATION.equalsIgnoreCase(scope)) {
            ret = 4;
        }
        return ret;
    }

    public static int getStyle(String style, String errCode) throws JspException {
        int ret = 2;
        if (style != null) {
            if (DEFAULT.equalsIgnoreCase(style)) {
                ret = 2;
            } else if (SHORT.equalsIgnoreCase(style)) {
                ret = 3;
            } else if (MEDIUM.equalsIgnoreCase(style)) {
                ret = 2;
            } else if (LONG.equalsIgnoreCase(style)) {
                ret = 1;
            } else if (FULL.equalsIgnoreCase(style)) {
                ret = 0;
            } else {
                throw new JspException(Resources.getMessage(errCode, style));
            }
        }
        return ret;
    }

    public static String escapeXml(String input) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (c == '&') {
                sb.append("&amp;");
            } else if (c == '<') {
                sb.append("&lt;");
            } else if (c == '>') {
                sb.append("&gt;");
            } else if (c == '\"') {
                sb.append("&#034;");
            } else if (c == '\'') {
                sb.append("&#039;");
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String getContentTypeAttribute(String input, String name) {
        int end;
        int begin;
        int index = input.toUpperCase().indexOf(name.toUpperCase());
        if (index == -1) {
            return null;
        }
        index += name.length();
        if ((index = input.indexOf(61, index)) == -1) {
            return null;
        }
        if ((input = input.substring(++index).trim()).charAt(0) == '\"') {
            begin = 1;
            end = input.indexOf(34, begin);
            if (end == -1) {
                return null;
            }
        } else {
            begin = 0;
            end = input.indexOf(59);
            if (end == -1) {
                end = input.indexOf(32);
            }
            if (end == -1) {
                end = input.length();
            }
        }
        return input.substring(begin, end).trim();
    }

    public static String URLEncode(String s, String enc) {
        if (s == null) {
            return "null";
        }
        if (enc == null) {
            enc = "UTF-8";
        }
        StringBuffer out = new StringBuffer(s.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)buf, enc);
        }
        catch (UnsupportedEncodingException ex) {
            writer = new OutputStreamWriter(buf);
        }
        int i = 0;
        while (i < s.length()) {
            block12: {
                char c = s.charAt(i);
                if (c == ' ') {
                    out.append('+');
                } else if (Util.isSafeChar(c)) {
                    out.append(c);
                } else {
                    try {
                        writer.write(c);
                        writer.flush();
                    }
                    catch (IOException e) {
                        buf.reset();
                        break block12;
                    }
                    byte[] ba = buf.toByteArray();
                    int j = 0;
                    while (j < ba.length) {
                        out.append('%');
                        out.append(Character.forDigit(ba[j] >> 4 & 0xF, 16));
                        out.append(Character.forDigit(ba[j] & 0xF, 16));
                        ++j;
                    }
                    buf.reset();
                }
            }
            ++i;
        }
        return out.toString();
    }

    private static boolean isSafeChar(int c) {
        if (c >= 97 && c <= 122) {
            return true;
        }
        if (c >= 65 && c <= 90) {
            return true;
        }
        if (c >= 48 && c <= 57) {
            return true;
        }
        return c == 45 || c == 95 || c == 46 || c == 33 || c == 126 || c == 42 || c == 39 || c == 40 || c == 41;
    }
}

