/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;

public final class FuzzyTermEnum
extends FilteredTermEnum {
    private static final int TYPICAL_LONGEST_WORD_IN_INDEX = 19;
    private int[][] d;
    private float similarity;
    private boolean endEnum = false;
    private Term searchTerm = null;
    private final String field;
    private final String text;
    private final String prefix;
    private final float minimumSimilarity;
    private final float scale_factor;
    private final int[] maxDistances = new int[19];

    public FuzzyTermEnum(IndexReader reader, Term term) throws IOException {
        this(reader, term, 0.5f, 0);
    }

    public FuzzyTermEnum(IndexReader reader, Term term, float minSimilarity) throws IOException {
        this(reader, term, minSimilarity, 0);
    }

    public FuzzyTermEnum(IndexReader reader, Term term, float minSimilarity, int prefixLength) throws IOException {
        if (minSimilarity >= 1.0f) {
            throw new IllegalArgumentException("minimumSimilarity cannot be greater than or equal to 1");
        }
        if (minSimilarity < 0.0f) {
            throw new IllegalArgumentException("minimumSimilarity cannot be less than 0");
        }
        if (prefixLength < 0) {
            throw new IllegalArgumentException("prefixLength cannot be less than 0");
        }
        this.minimumSimilarity = minSimilarity;
        this.scale_factor = 1.0f / (1.0f - this.minimumSimilarity);
        this.searchTerm = term;
        this.field = this.searchTerm.field();
        int fullSearchTermLength = this.searchTerm.text().length();
        int realPrefixLength = prefixLength > fullSearchTermLength ? fullSearchTermLength : prefixLength;
        this.text = this.searchTerm.text().substring(realPrefixLength);
        this.prefix = this.searchTerm.text().substring(0, realPrefixLength);
        this.initializeMaxDistances();
        this.d = this.initDistanceArray();
        this.setEnum(reader.terms(new Term(this.searchTerm.field(), this.prefix)));
    }

    protected final boolean termCompare(Term term) {
        if (this.field == term.field() && term.text().startsWith(this.prefix)) {
            String target = term.text().substring(this.prefix.length());
            this.similarity = this.similarity(target);
            return this.similarity > this.minimumSimilarity;
        }
        this.endEnum = true;
        return false;
    }

    public final float difference() {
        return (this.similarity - this.minimumSimilarity) * this.scale_factor;
    }

    public final boolean endEnum() {
        return this.endEnum;
    }

    private static final int min(int a, int b, int c) {
        int t = a < b ? a : b;
        return t < c ? t : c;
    }

    private final int[][] initDistanceArray() {
        return new int[this.text.length() + 1][19];
    }

    private final synchronized float similarity(String target) {
        int m = target.length();
        int n = this.text.length();
        if (n == 0) {
            return this.prefix.length() == 0 ? 0.0f : 1.0f - (float)m / (float)this.prefix.length();
        }
        if (m == 0) {
            return this.prefix.length() == 0 ? 0.0f : 1.0f - (float)n / (float)this.prefix.length();
        }
        int maxDistance = this.getMaxDistance(m);
        if (maxDistance < Math.abs(m - n)) {
            return 0.0f;
        }
        if (this.d[0].length <= m) {
            this.growDistanceArray(m);
        }
        int i = 0;
        while (i <= n) {
            this.d[i][0] = i;
            ++i;
        }
        int j = 0;
        while (j <= m) {
            this.d[0][j] = j;
            ++j;
        }
        i = 1;
        while (i <= n) {
            int bestPossibleEditDistance = m;
            char s_i = this.text.charAt(i - 1);
            int j2 = 1;
            while (j2 <= m) {
                this.d[i][j2] = s_i != target.charAt(j2 - 1) ? FuzzyTermEnum.min(this.d[i - 1][j2], this.d[i][j2 - 1], this.d[i - 1][j2 - 1]) + 1 : FuzzyTermEnum.min(this.d[i - 1][j2] + 1, this.d[i][j2 - 1] + 1, this.d[i - 1][j2 - 1]);
                bestPossibleEditDistance = Math.min(bestPossibleEditDistance, this.d[i][j2]);
                ++j2;
            }
            if (i > maxDistance && bestPossibleEditDistance > maxDistance) {
                return 0.0f;
            }
            ++i;
        }
        return 1.0f - (float)this.d[n][m] / (float)(this.prefix.length() + Math.min(n, m));
    }

    private void growDistanceArray(int m) {
        int i = 0;
        while (i < this.d.length) {
            this.d[i] = new int[m + 1];
            ++i;
        }
    }

    private final int getMaxDistance(int m) {
        return m < this.maxDistances.length ? this.maxDistances[m] : this.calculateMaxDistance(m);
    }

    private void initializeMaxDistances() {
        int i = 0;
        while (i < this.maxDistances.length) {
            this.maxDistances[i] = this.calculateMaxDistance(i);
            ++i;
        }
    }

    private int calculateMaxDistance(int m) {
        return (int)((1.0f - this.minimumSimilarity) * (float)(Math.min(this.text.length(), m) + this.prefix.length()));
    }

    public void close() throws IOException {
        super.close();
    }
}

