/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.document;

import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfPageSetting
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] PAGE_WIDTH = "\\paperw".getBytes();
    private static final byte[] PAGE_HEIGHT = "\\paperh".getBytes();
    private static final byte[] MARGIN_LEFT = "\\margl".getBytes();
    private static final byte[] MARGIN_RIGHT = "\\margr".getBytes();
    private static final byte[] MARGIN_TOP = "\\margt".getBytes();
    private static final byte[] MARGIN_BOTTOM = "\\margb".getBytes();
    private static final byte[] LANDSCAPE = "\\lndscpsxn".getBytes();
    private static final byte[] SECTION_PAGE_WIDTH = "\\pgwsxn".getBytes();
    private static final byte[] SECTION_PAGE_HEIGHT = "\\pghsxn".getBytes();
    private int pageWidth = 11906;
    private int pageHeight = 16840;
    private int marginLeft = 1800;
    private int marginRight = 1800;
    private int marginTop = 1440;
    private int marginBottom = 1440;
    private boolean landscape = false;

    public RtfPageSetting(RtfDocument rtfDocument) {
        super(rtfDocument);
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(PAGE_WIDTH);
            byteArrayOutputStream.write(this.intToByteArray(this.pageWidth));
            byteArrayOutputStream.write(PAGE_HEIGHT);
            byteArrayOutputStream.write(this.intToByteArray(this.pageHeight));
            byteArrayOutputStream.write(MARGIN_LEFT);
            byteArrayOutputStream.write(this.intToByteArray(this.marginLeft));
            byteArrayOutputStream.write(MARGIN_RIGHT);
            byteArrayOutputStream.write(this.intToByteArray(this.marginRight));
            byteArrayOutputStream.write(MARGIN_TOP);
            byteArrayOutputStream.write(this.intToByteArray(this.marginTop));
            byteArrayOutputStream.write(MARGIN_BOTTOM);
            byteArrayOutputStream.write(this.intToByteArray(this.marginBottom));
            byteArrayOutputStream.write(10);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] writeSectionDefinition() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (this.landscape) {
                byteArrayOutputStream.write(LANDSCAPE);
                byteArrayOutputStream.write(SECTION_PAGE_WIDTH);
                byteArrayOutputStream.write(this.intToByteArray(this.pageWidth));
                byteArrayOutputStream.write(SECTION_PAGE_HEIGHT);
                byteArrayOutputStream.write(this.intToByteArray(this.pageHeight));
                byteArrayOutputStream.write(10);
            } else {
                byteArrayOutputStream.write(SECTION_PAGE_WIDTH);
                byteArrayOutputStream.write(this.intToByteArray(this.pageWidth));
                byteArrayOutputStream.write(SECTION_PAGE_HEIGHT);
                byteArrayOutputStream.write(this.intToByteArray(this.pageHeight));
                byteArrayOutputStream.write(10);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public int getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(int n) {
        this.marginBottom = n;
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(int n) {
        this.marginLeft = n;
    }

    public int getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(int n) {
        this.marginRight = n;
    }

    public int getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(int n) {
        this.marginTop = n;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(int n) {
        this.pageHeight = n;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(int n) {
        this.pageWidth = n;
    }

    public void setPageSize(Rectangle rectangle) {
        if (!this.guessFormat(rectangle, false)) {
            this.pageWidth = (int)((double)rectangle.width() * 20.0);
            this.pageHeight = (int)((double)rectangle.height() * 20.0);
            this.landscape = this.pageWidth > this.pageHeight;
        }
    }

    private boolean guessFormat(Rectangle rectangle, boolean bl) {
        if (bl) {
            rectangle = rectangle.rotate();
        }
        if (this.rectEquals(rectangle, PageSize.A3)) {
            this.pageWidth = 16837;
            this.pageHeight = 23811;
            this.landscape = bl;
            return true;
        }
        if (this.rectEquals(rectangle, PageSize.A4)) {
            this.pageWidth = 11907;
            this.pageHeight = 16840;
            this.landscape = bl;
            return true;
        }
        if (this.rectEquals(rectangle, PageSize.A5)) {
            this.pageWidth = 8391;
            this.pageHeight = 11907;
            this.landscape = bl;
            return true;
        }
        if (this.rectEquals(rectangle, PageSize.A6)) {
            this.pageWidth = 5959;
            this.pageHeight = 8420;
            this.landscape = bl;
            return true;
        }
        if (this.rectEquals(rectangle, PageSize.B4)) {
            this.pageWidth = 14570;
            this.pageHeight = 20636;
            this.landscape = bl;
            return true;
        }
        if (this.rectEquals(rectangle, PageSize.B5)) {
            this.pageWidth = 10319;
            this.pageHeight = 14572;
            this.landscape = bl;
            return true;
        }
        if (this.rectEquals(rectangle, PageSize.HALFLETTER)) {
            this.pageWidth = 7927;
            this.pageHeight = 12247;
            this.landscape = bl;
            return true;
        }
        if (this.rectEquals(rectangle, PageSize.LETTER)) {
            this.pageWidth = 12242;
            this.pageHeight = 15842;
            this.landscape = bl;
            return true;
        }
        if (this.rectEquals(rectangle, PageSize.LEGAL)) {
            this.pageWidth = 12252;
            this.pageHeight = 20163;
            this.landscape = bl;
            return true;
        }
        if (!bl && this.guessFormat(rectangle, true)) {
            int n = this.pageWidth;
            this.pageWidth = this.pageHeight;
            this.pageHeight = n;
            return true;
        }
        return false;
    }

    private boolean rectEquals(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle.width() == rectangle2.width() && rectangle.height() == rectangle2.height();
    }
}

